/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbjm.formplugin.web.job;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FloatingDirection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.control.events.SearchClickEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hbjm.business.domain.repository.JobClassScmRepository;
import kd.hrmp.hbjm.business.domain.repository.JobFamilyScmRepository;
import kd.hrmp.hbjm.business.domain.repository.JobScmRepository;
import kd.hrmp.hbjm.business.domain.repository.JobSeqScmRepository;
import kd.hrmp.hbjm.business.ext.JobTreeSortServiceExt;

public class JobTreeListPlugin
extends StandardTreeListPlugin {
    private static final String FILTER_CONDITION = "id";
    private static final String SPLIT = "#";
    private static final char SPLIT_CHAR = '#';
    private static final String BTNTREEFILTER = "btntreefilter";
    private static final String SEARCH = "searchap";
    private static final String TREE_VIEW = "treeview";
    private String orderCondition = "";

    public void setFilter(SetFilterEvent event) {
        List filters = event.getQFilters();
        QFilter permissionFilter = this.buildScmPermissionFilter();
        if (permissionFilter == null) {
            permissionFilter = new QFilter("1", "!=", (Object)1);
        }
        filters.add(permissionFilter);
        event.setQFilters(filters);
        super.setFilter(event);
    }

    public void registerListener(EventObject evt) {
        this.addClickListeners(new String[]{BTNTREEFILTER});
        Search search = (Search)this.getView().getControl(SEARCH);
        if (null != search) {
            search.addEnterListener((SearchEnterListener)this);
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        SearchClickEvent searchClickEvent = args.getSearchClickEvent();
        QFilter org = searchClickEvent.getQFilter("useorg.id");
        if (Objects.nonNull(org)) {
            String useOrg = this.getPageCache().get("useOrg");
            String value = String.valueOf(org.getValue());
            this.getPageCache().put("useOrg", value);
            if (HRStringUtils.equals((String)value, (String)useOrg)) {
                return;
            }
            this.getTreeModel().setCurrentNodeId((Object)"01010");
            this.getTreeListView().refreshTreeView();
        }
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        if (HRStringUtils.equals((String)BTNTREEFILTER, (String)control.getKey().toLowerCase(Locale.ROOT))) {
            this.showTreeFilterDialog();
        }
    }

    private void showTreeFilterDialog() {
        FormShowParameter formShowParameter = new FormShowParameter();
        OpenStyle openStyle = formShowParameter.getOpenStyle();
        openStyle.setShowType(ShowType.Floating);
        openStyle.setFloatingDirection(FloatingDirection.BottomCenter);
        openStyle.setTargetKey(BTNTREEFILTER);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "treefilteroperation"));
        formShowParameter.setFormId(this.getShowFilterDialogPage());
        String chkShowDisable = this.getPageCache().get("chkshowdisable");
        formShowParameter.setCustomParam("chkshowdisable", (Object)chkShowDisable);
        this.getView().showForm(formShowParameter);
    }

    protected String getShowFilterDialogPage() {
        return "hbjm_jobclassfilterdialog";
    }

    public void refreshNode(RefreshNodeEvent evt) {
        evt.setChildNodes(this.loadTreeNodeById(evt.getNodeId().toString()).getChildren());
        String matchNodesCacheKey = this.getView().getPageId() + "_matchNodes";
        if (HRStringUtils.isNotEmpty((String)matchNodesCacheKey)) {
            IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
            pageCache.put(matchNodesCacheKey, "");
        }
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent evt) {
        String nodeId = (String)evt.getNodeId();
        QFilter treeFilter = this.buildFilter(nodeId, FILTER_CONDITION);
        if (null != treeFilter) {
            evt.addQFilter(treeFilter);
        }
        evt.setCancel(true);
    }

    public void initializeTree(EventObject evt) {
        TreeView treeView = (TreeView)this.getControl(TREE_VIEW);
        TreeView.TreeState treeState = treeView.getTreeState();
        Map focusNode = treeState.getFocusNode();
        if (null != focusNode) {
            this.getView().getFormShowParameter().setCustomParam(FILTER_CONDITION, focusNode.get(FILTER_CONDITION));
        }
        TreeNode root = this.loadTreeNodeById("01010");
        this.getTreeModel().setRoot(root);
    }

    public void afterBindData(EventObject e) {
        if (Objects.isNull(this.getTreeModel().getCurrentNodeId())) {
            TreeNode root = this.getTreeModel().getRoot();
            if (Objects.isNull(root)) {
                return;
            }
            List children = root.getChildren();
            String id = Objects.isNull(children) || children.isEmpty() || Objects.isNull(children.get(0)) ? root.getId() : ((TreeNode)children.get(0)).getId();
            this.getTreeModel().setCurrentNodeId((Object)id);
            this.getTreeListView().refresh();
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection rows = super.getData(start, limit);
                if (!rows.isEmpty()) {
                    JobTreeListPlugin.this.jobclassNameHandeler(rows);
                }
                return rows;
            }
        });
    }

    private void jobclassNameHandeler(DynamicObjectCollection rows) {
        if (rows.size() == 0 || !((DynamicObject)rows.get(0)).containsProperty("jobclass")) {
            return;
        }
        for (DynamicObject row : rows) {
            String name;
            String jobclassid = row.getString("jobclass.id");
            if (StringUtils.isEmpty((CharSequence)jobclassid)) continue;
            StringBuilder pathStr = new StringBuilder();
            pathStr.append("01010").append('#').append('1').append(row.getString("jobscm.id")).append('#').append('2').append(row.getString("jobseq.id")).append('#').append('3').append(row.getString("jobfamily.id")).append('#');
            String jobClassPathFlag = pathStr.toString();
            pathStr.append("4").append(row.getString("jobclass.id"));
            TreeNode root = this.getTreeModel().getRoot();
            List childPath = root.getChildPathNodes(pathStr.toString());
            if (childPath.size() <= 0 || !StringUtils.isNotEmpty((CharSequence)(name = childPath.stream().filter(treeNode -> treeNode.getId().contains(jobClassPathFlag)).map(treeNode -> treeNode.getText()).collect(Collectors.joining("-"))))) continue;
            row.set("jobclass.name", (Object)name);
        }
    }

    private TreeNode loadTreeNodeById(String nodeId) {
        TreeNode root = new TreeNode("", nodeId, ResManager.loadKDString((String)"\u5168\u90e8\u65b9\u6848", (String)"JobTreeListPlugin_0", (String)"hrmp-hbjm-formplugin", (Object[])new Object[0]));
        root.setIsOpened(true);
        if (HRStringUtils.isEmpty((String)nodeId)) {
            return root;
        }
        Long userId = this.getUerIdWithPermission();
        Boolean isShowDisable = this.getIsShowDisableValue();
        HashMap<String, TreeNode> treeMaps = new HashMap<String, TreeNode>();
        treeMaps.put(root.getId(), root);
        ArrayList<Long> scmLists = new ArrayList<Long>(1);
        ArrayList<Long> seqLists = new ArrayList<Long>(1);
        ArrayList<Long> familyLists = new ArrayList<Long>(1);
        String[] nodes = nodeId.split(SPLIT);
        this.initOrderContition();
        switch (nodes[nodes.length - 1].substring(0, 1)) {
            case "0": {
                this.buildScmTreeNode(isShowDisable, treeMaps);
                break;
            }
            case "1": {
                scmLists.add(Long.valueOf(nodes[1].substring(1)));
                this.buildSeqTreeNode(scmLists, isShowDisable, treeMaps);
                break;
            }
            case "2": {
                scmLists.add(Long.valueOf(nodes[1].substring(1)));
                seqLists.add(Long.valueOf(nodes[2].substring(1)));
                this.buildFamilyTreeNode(scmLists, seqLists, isShowDisable, treeMaps);
                break;
            }
            case "3": 
            case "4": {
                scmLists.add(Long.valueOf(nodes[1].substring(1)));
                seqLists.add(Long.valueOf(nodes[2].substring(1)));
                familyLists.add(Long.valueOf(nodes[3].substring(1)));
                this.buildClassTreeNode(scmLists, seqLists, familyLists, isShowDisable, treeMaps);
            }
        }
        return root;
    }

    private List<Long> getSelectedOrgIdByCache() {
        FormShowParameter formShowParameter;
        LinkedList<Long> ids = new LinkedList<Long>();
        String formId = this.getView().getFormShowParameter().getFormId();
        if ((HRStringUtils.equals((String)formId, (String)"hbjm_jobtreelistf7") || HRStringUtils.equals((String)formId, (String)"hbjm_hisjobtreelistf7")) && (formShowParameter = this.getView().getFormShowParameter()) instanceof ListShowParameter) {
            ListShowParameter parameter = (ListShowParameter)formShowParameter;
            List useOrgIds = parameter.getUseOrgIds();
            Long orgId = parameter.getUseOrgId();
            if (!CollectionUtils.isEmpty((Collection)useOrgIds)) {
                ids.addAll(useOrgIds);
            }
            if (orgId != 0L) {
                ids.add(orgId);
            }
            return ids;
        }
        String useOrg = this.getPageCache().get("useOrg");
        if (HRStringUtils.isEmpty((String)useOrg)) {
            String createOrg = this.getPageCache().get("createOrg");
            this.getPageCache().put("useOrg", createOrg);
            useOrg = createOrg;
        }
        return Arrays.stream((Objects.isNull(useOrg) ? "" : useOrg).replace("[", "").replace("]", "").split(",")).filter(HRStringUtils::isNotEmpty).map(value -> Long.parseLong(value.trim())).collect(Collectors.toList());
    }

    private void buildScmTreeNode(Boolean isShowDisable, HashMap<String, TreeNode> treeMaps) {
        DynamicObject[] jobScmDys = this.getBuildScmData();
        if (HRObjectUtils.isEmpty((Object)jobScmDys)) {
            return;
        }
        ArrayList<Long> ids = new ArrayList<Long>(jobScmDys.length);
        String parentId = "01010";
        TreeNode root = treeMaps.get(parentId);
        String parentV = parentId + SPLIT + "1";
        Boolean isFirst = Boolean.TRUE;
        for (DynamicObject dy : jobScmDys) {
            String id = parentV + dy.getString(FILTER_CONDITION);
            TreeNode child = null;
            if ("0".equals(dy.getString("enable"))) {
                StringBuilder name = new StringBuilder(dy.getString("name"));
                name.append(ResManager.loadKDString((String)"(\u5df2\u7981\u7528)", (String)"JobTreeListPlugin_1", (String)"hrmp-hbjm-formplugin", (Object[])new Object[0]));
                child = new TreeNode(parentId, id, name.toString());
            } else {
                child = new TreeNode(parentId, id, dy.getString("name"));
            }
            if (isFirst.booleanValue()) {
                child.setIsOpened(true);
                isFirst = Boolean.FALSE;
            }
            treeMaps.put(id, child);
            root.addChild(child);
            ids.add(dy.getLong(FILTER_CONDITION));
        }
        this.buildSeqTreeNode(ids, isShowDisable, treeMaps);
    }

    private void buildSeqTreeNode(List<Long> jobScmId, Boolean isShowDisable, HashMap<String, TreeNode> treeMaps) {
        DynamicObject[] jobScmDys = JobSeqScmRepository.getInstance().queryJObSeqScmByScmId(jobScmId, isShowDisable, this.orderCondition);
        if (HRObjectUtils.isEmpty((Object)jobScmDys)) {
            return;
        }
        ArrayList<Long> ids = new ArrayList<Long>(jobScmDys.length);
        String parentIdV = "01010#1";
        for (DynamicObject dy : jobScmDys) {
            String parentId = parentIdV + dy.getString("jobscm");
            TreeNode parentTree = treeMaps.get(parentId);
            String parentV = parentId + SPLIT + "2";
            String id = parentV + dy.getString("jobseq");
            TreeNode child = null;
            if ("0".equals(dy.getString("jobseq.enable"))) {
                StringBuilder name = new StringBuilder(dy.getString("jobseq.name"));
                name.append(ResManager.loadKDString((String)"(\u5df2\u7981\u7528)", (String)"JobTreeListPlugin_1", (String)"hrmp-hbjm-formplugin", (Object[])new Object[0]));
                child = new TreeNode(parentId, id, name.toString());
            } else {
                child = new TreeNode(parentId, id, dy.getString("jobseq.name"));
            }
            treeMaps.put(id, child);
            parentTree.addChild(child);
            ids.add(dy.getLong("jobseq"));
        }
        this.buildFamilyTreeNode(jobScmId, ids, isShowDisable, treeMaps);
    }

    private void buildFamilyTreeNode(List<Long> jobScmId, List<Long> jobSeqId, Boolean isShowDisable, HashMap<String, TreeNode> treeMaps) {
        DynamicObject[] jobScmDys = JobFamilyScmRepository.getInstance().queryJObFamilyScmByScmId(jobScmId, jobSeqId, isShowDisable, this.orderCondition);
        if (HRObjectUtils.isEmpty((Object)jobScmDys)) {
            return;
        }
        ArrayList<Long> ids = new ArrayList<Long>(jobScmDys.length);
        for (DynamicObject dy : jobScmDys) {
            StringBuilder sb = new StringBuilder();
            sb.append("01010").append('#').append('1').append(dy.getString("jobscm")).append('#').append('2').append(dy.getString("jobseq"));
            String parentId = sb.toString();
            TreeNode parentTree = treeMaps.get(parentId);
            if (Objects.isNull(parentTree)) continue;
            String parentV = parentId + SPLIT + "3";
            String id = parentV + dy.getString("jobfamily");
            TreeNode child = null;
            if ("0".equals(dy.getString("jobfamily.enable"))) {
                StringBuilder name = new StringBuilder(dy.getString("jobfamily.name"));
                name.append(ResManager.loadKDString((String)"(\u5df2\u7981\u7528)", (String)"JobTreeListPlugin_1", (String)"hrmp-hbjm-formplugin", (Object[])new Object[0]));
                child = new TreeNode(parentId, id, name.toString());
            } else {
                child = new TreeNode(parentId, id, dy.getString("jobfamily.name"));
            }
            treeMaps.put(id, child);
            parentTree.addChild(child);
            ids.add(dy.getLong("jobfamily"));
        }
        this.buildClassTreeNode(jobScmId, jobSeqId, ids, isShowDisable, treeMaps);
    }

    private void buildClassTreeNode(List<Long> jobScmId, List<Long> jobSeqId, List<Long> jobFamilyId, Boolean isShowDisable, HashMap<String, TreeNode> treeMaps) {
        DynamicObject[] jobScmDys = JobClassScmRepository.getInstance().queryJobClassScm(jobScmId, jobSeqId, jobFamilyId, isShowDisable, this.orderCondition);
        if (HRObjectUtils.isEmpty((Object)jobScmDys)) {
            return;
        }
        HashMap<String, ArrayList<String>> treeCache = new HashMap<String, ArrayList<String>>();
        for (DynamicObject dy : jobScmDys) {
            ArrayList<String> childCache;
            StringBuilder sb = new StringBuilder();
            sb.append("01010").append('#').append('1').append(dy.getString("jobscm")).append('#').append('2').append(dy.getString("jobfamily.jobseq")).append('#').append('3').append(dy.getString("jobfamily"));
            String id = sb + SPLIT + "4" + dy.getString("jobclass");
            String parentId = dy.getLong("jobclass.parent") != 0L ? sb.append('#').append('4').append(dy.getString("jobclass.parent")).toString() : sb.toString();
            TreeNode child = null;
            if ("0".equals(dy.getString("jobclass.enable"))) {
                StringBuilder name = new StringBuilder(dy.getString("jobclass.name"));
                name.append(ResManager.loadKDString((String)"(\u5df2\u7981\u7528)", (String)"JobTreeListPlugin_1", (String)"hrmp-hbjm-formplugin", (Object[])new Object[0]));
                child = new TreeNode(parentId, id, name.toString());
            } else {
                child = new TreeNode(parentId, id, dy.getString("jobclass.name"));
            }
            TreeNode parentTree = treeMaps.get(parentId);
            treeMaps.putIfAbsent(id, child);
            if (Objects.isNull(parentTree)) {
                childCache = (ArrayList<String>)treeCache.get(parentId);
                if (Objects.isNull(childCache)) {
                    childCache = new ArrayList<String>();
                    treeCache.put(parentId, childCache);
                }
                childCache.add(id);
            } else {
                parentTree.addChild(child);
            }
            childCache = (List)treeCache.get(id);
            if (Objects.isNull(childCache)) continue;
            for (String cache : childCache) {
                TreeNode treeNode = treeMaps.get(cache);
                child.addChild(treeNode);
            }
            treeCache.remove(id);
        }
    }

    private QFilter buildFilter(String nodeId, String filterCondition) {
        QFilter qFilter = null;
        if (null != nodeId && !HRStringUtils.isEmpty((String)nodeId)) {
            String[] split = nodeId.split(SPLIT);
            String lastNodeId = split[split.length - 1];
            Long scmId = 0L;
            if (split.length > 1) {
                scmId = Long.valueOf(split[1].substring(1));
            }
            String nodeLayer = lastNodeId.substring(0, 1);
            ArrayList<Long> ids = new ArrayList<Long>();
            ids.add(Long.valueOf(lastNodeId.substring(1)));
            switch (nodeLayer) {
                case "1": {
                    qFilter = new QFilter("jobscm.id", "=", (Object)scmId);
                    break;
                }
                case "2": {
                    qFilter = new QFilter("jobseq.id", "in", ids);
                    qFilter.and(new QFilter("jobscm.id", "=", (Object)scmId));
                    break;
                }
                case "3": {
                    qFilter = new QFilter("jobfamily.id", "in", ids);
                    qFilter.and(new QFilter("jobscm.id", "=", (Object)scmId));
                    break;
                }
                case "4": {
                    qFilter = this.buildClassChildFilter(scmId, Long.valueOf(split[2].substring(1)), Long.valueOf(split[3].substring(1)), ids);
                    qFilter.and(new QFilter("jobscm.id", "=", (Object)scmId));
                    break;
                }
            }
        }
        return qFilter;
    }

    private QFilter buildScmPermissionFilter() {
        DynamicObject[] dynamicObjects = this.getBuildScmData();
        if (HRObjectUtils.isEmpty((Object)dynamicObjects)) {
            return null;
        }
        List ids = Arrays.stream(dynamicObjects).map(dy -> dy.getLong(FILTER_CONDITION)).collect(Collectors.toList());
        return new QFilter("jobscm.id", "in", ids);
    }

    private QFilter buildClassChildFilter(Long jobScmId, Long jobSeqId, Long jobFamilyId, List<Long> ids) {
        Boolean isShowDisable = this.getIsShowDisableValue();
        DynamicObject[] jobClassScmDys = JobClassScmRepository.getInstance().queryJobClassScm(jobScmId, jobSeqId, jobFamilyId, isShowDisable);
        if (!HRObjectUtils.isEmpty((Object)jobClassScmDys)) {
            Map<Integer, List<DynamicObject>> jobClassLevel = Arrays.stream(jobClassScmDys).map(dy -> dy.getDynamicObject("jobclass")).collect(Collectors.groupingBy(dy -> dy.getInt("jobclasslevel")));
            for (int i = 2; i <= jobClassLevel.size(); ++i) {
                List<DynamicObject> dynamicObjects = jobClassLevel.get(i);
                if (Objects.isNull(dynamicObjects)) continue;
                for (DynamicObject dy2 : dynamicObjects) {
                    if (!ids.contains(dy2.getLong("parent.id"))) continue;
                    ids.add(dy2.getLong(FILTER_CONDITION));
                }
            }
        }
        return new QFilter("jobclass.id", "in", ids);
    }

    private Boolean getIsShowDisableValue() {
        Boolean isShowDisable = Boolean.FALSE;
        Boolean isShowDisableParam = (Boolean)this.getView().getFormShowParameter().getCustomParam("chkshowdisable");
        if (null != isShowDisableParam) {
            this.getPageCache().put("chkshowdisable", String.valueOf(isShowDisableParam));
            isShowDisable = isShowDisableParam;
        } else {
            String cacheShowDisable = this.getPageCache().get("chkshowdisable");
            isShowDisable = Boolean.parseBoolean(cacheShowDisable);
        }
        return isShowDisable;
    }

    private Long getUerIdWithPermission() {
        String isIgnoreIsolate = (String)this.getView().getFormShowParameter().getCustomParam("isIgnoreIsolate");
        if (Objects.isNull(isIgnoreIsolate) || !Boolean.parseBoolean(isIgnoreIsolate)) {
            return RequestContext.get().getCurrUserId();
        }
        return 0L;
    }

    protected DynamicObject[] getBuildScmData() {
        Long userId = this.getUerIdWithPermission();
        DynamicObject[] dynamicObjects = JobScmRepository.getInstance().queryJobScm(userId, this.getSelectedOrgIdByCache(), this.getIsShowDisableValue(), this.orderCondition);
        return dynamicObjects;
    }

    private void initOrderContition() {
        this.orderCondition = JobTreeSortServiceExt.getInstance().getJobTreeAndJobClassTreeSortCondition();
    }
}

