/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbjm.formplugin.web.jobclass;

import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;

public class JobClassEdit
extends HRDataBaseEdit
implements BeforeF7SelectListener {
    private static final String JOBSEQ = "jobseq";
    private static final String JOBFAMILY = "jobfamily";
    private static final String PARENT = "parent";

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName;
        switch (propertyName = e.getProperty().getName()) {
            case "jobseq": {
                this.changeJobSeq();
                break;
            }
            case "jobfamily": {
                this.changeJobFamily();
                break;
            }
            case "parent": {
                this.changeParent();
                break;
            }
        }
    }

    private void changeJobSeq() {
        DynamicObject jobSeqObject = (DynamicObject)this.getView().getModel().getValue(JOBSEQ);
        if (jobSeqObject != null) {
            this.getView().setEnable(Boolean.TRUE, new String[]{JOBFAMILY});
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{JOBFAMILY});
            this.getView().setEnable(Boolean.FALSE, new String[]{PARENT});
        }
        this.changeBaseData(JOBSEQ);
    }

    private void changeJobFamily() {
        DynamicObject jobFamilyObject = (DynamicObject)this.getView().getModel().getValue(JOBFAMILY);
        if (jobFamilyObject != null) {
            this.getView().setEnable(Boolean.TRUE, new String[]{PARENT});
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{PARENT});
        }
        this.changeBaseData(JOBFAMILY);
    }

    private void changeParent() {
        Integer classLevel = this.getModel().getDataEntity().getInt("parent.jobclasslevel");
        this.getModel().setValue("jobclasslevel", (Object)(classLevel + 1));
    }

    private void changeBaseData(String flag) {
        switch (flag) {
            case "jobseq": {
                this.getView().getModel().setValue(JOBFAMILY, null);
                this.getView().getModel().setValue(PARENT, null);
                break;
            }
            case "jobfamily": {
                this.getView().getModel().setValue(PARENT, null);
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String fieldKey = evt.getProperty().getName();
        QFilter qFilter = null;
        if (HRStringUtils.equals((String)fieldKey, (String)JOBFAMILY)) {
            qFilter = this.buildJobFamilyFilter();
        } else if (HRStringUtils.equals((String)fieldKey, (String)PARENT)) {
            qFilter = this.buildJobClassFilter();
        }
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        showParameter.getListFilterParameter().setFilter(qFilter);
        Long jobFamilyId = this.getModel().getDataEntity().getLong("jobfamily.id");
        if (HRStringUtils.equals((String)fieldKey, (String)PARENT) && !ObjectUtils.isEmpty((Object)jobFamilyId)) {
            showParameter.getShowParameter().setCustomParam("selectedJobFamilyId", (Object)jobFamilyId);
        }
    }

    private QFilter buildJobFamilyFilter() {
        DynamicObject jobSeqObject = (DynamicObject)this.getView().getModel().getValue(JOBSEQ);
        QFilter qFilter = jobSeqObject != null ? new QFilter(JOBSEQ, "in", jobSeqObject.get("id")) : new QFilter(JOBSEQ, "in", (Object)"");
        return qFilter;
    }

    private QFilter buildJobClassFilter() {
        DynamicObject jobSeq = (DynamicObject)this.getView().getModel().getValue(JOBSEQ);
        QFilter qFilter = new QFilter(JOBSEQ, "=", (Object)jobSeq.getLong("id"));
        DynamicObject jobFamilyObject = (DynamicObject)this.getView().getModel().getValue(JOBFAMILY);
        if (jobFamilyObject != null) {
            qFilter.and(JOBFAMILY, "=", jobFamilyObject.get("id"));
        } else {
            qFilter.and(JOBFAMILY, "=", (Object)"");
        }
        return qFilter;
    }

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        BasedataEdit jobFamilyEdit = (BasedataEdit)this.getView().getControl(JOBFAMILY);
        jobFamilyEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit parentEdit = (BasedataEdit)this.getView().getControl(PARENT);
        parentEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeBindData(EventObject e) {
        String enable = this.getModel().getDataEntity().getString("enable");
        if (HRStringUtils.equals((String)"1", (String)enable)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{JOBSEQ});
        }
        this.getView().setEnable(Boolean.FALSE, new String[]{JOBFAMILY});
        if (HRStringUtils.isEmpty((String)this.getModel().getDataEntity().getString("number"))) {
            this.getView().setEnable(Boolean.FALSE, new String[]{PARENT});
        }
    }

    public void afterImportData(ImportDataEventArgs e) {
        DynamicObject jobFamily;
        DynamicObject ob = this.getModel().getDataEntity();
        DynamicObject jobSeq = ob.getDynamicObject(JOBSEQ);
        if (ObjectUtils.isEmpty((Object)jobSeq) && !ObjectUtils.isEmpty((Object)(jobFamily = ob.getDynamicObject(JOBFAMILY)))) {
            ob.set(JOBSEQ, jobFamily.get(JOBSEQ));
        }
        super.afterImportData(e);
    }
}

