/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbjm.formplugin.web.jobclass;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FloatingDirection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.control.events.SearchClickEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hbjm.business.domain.repository.JobClassRepository;
import kd.hrmp.hbjm.business.domain.repository.JobClassTreeQueryRepository;
import kd.hrmp.hbjm.business.ext.JobTreeSortServiceExt;
import kd.hrmp.hbjm.business.utils.JobTreeBuildUtil;
import kd.hrmp.hbjm.common.util.JobClassTreeUtil;

public class JobClassTreeListPluginPlus
extends StandardTreeListPlugin {
    private static final Log log = LogFactory.getLog(JobClassTreeListPluginPlus.class);
    private static final String SPLIT = "#";
    private static final String ROOT_ID = "01010";
    private static final String BTNTREEFILTER = "btntreefilter";
    private static final String FILTER_CONDITION = "id";
    private static final String TBL_NEW = "tblnew";
    private static final String CALLBACK = "callback";
    private String orderCondition = "";

    public void initializeTree(EventObject evt) {
        TreeView treeView = (TreeView)this.getControl("treeview");
        TreeView.TreeState treeState = treeView.getTreeState();
        Map focusNode = treeState.getFocusNode();
        if (null != focusNode) {
            this.getView().getFormShowParameter().setCustomParam(FILTER_CONDITION, focusNode.get(FILTER_CONDITION));
        }
        TreeNode root = this.loadAllTreeNodes();
        this.getTreeModel().setCurrentNodeId((Object)root.getId());
        this.getTreeModel().setRoot(root);
    }

    public void refreshNode(RefreshNodeEvent evt) {
        TreeNode root = this.loadAllTreeNodes();
        this.getTreeModel().setRoot(root);
        String nodeId = evt.getNodeId().toString();
        if (HRStringUtils.equals((String)ROOT_ID, (String)nodeId)) {
            evt.setChildNodes(root.getChildren());
        } else {
            TreeNode evtTreeNode = this.getTreeModel().getRoot().getTreeNode(nodeId, 100);
            if (!Objects.isNull(evtTreeNode)) {
                evt.setChildNodes(evtTreeNode.getChildren());
            }
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        if (HRStringUtils.equals((String)evt.getItemKey(), (String)TBL_NEW)) {
            evt.setCancel(true);
            BaseShowParameter baseShowParameter = new BaseShowParameter();
            baseShowParameter.setFormId("hbjm_jobclasshr");
            baseShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            baseShowParameter.setStatus(OperationStatus.ADDNEW);
            baseShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALLBACK));
            String useOrgID = this.getPageCache().get("createOrg");
            baseShowParameter.setCustomParam("useorgId", (Object)useOrgID);
            String nodeId = (String)this.treeListView.getTreeModel().getCurrentNodeId();
            if (StringUtils.isNotEmpty((CharSequence)nodeId)) {
                String nodeLayer = nodeId.substring(0, 1);
                if (Integer.parseInt(nodeLayer) > 8) {
                    nodeId = this.getTreeModel().getRoot().getTreeNode(nodeId, 100).getParentid();
                }
                baseShowParameter = this.setCustomParamForBaseShowParameter(baseShowParameter, nodeId);
            }
            this.getView().showForm((FormShowParameter)baseShowParameter);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey = args.getOperateKey();
        if (HRStringUtils.equals((String)operateKey, (String)"enable") || HRStringUtils.equals((String)operateKey, (String)"disable") || HRStringUtils.equals((String)operateKey, (String)"his_disable") || HRStringUtils.equals((String)operateKey, (String)"delete") || HRStringUtils.equals((String)operateKey, (String)"refresh")) {
            OperationResult operationResult = args.getOperationResult();
            boolean success = false;
            if (operationResult != null) {
                success = operationResult.isSuccess();
            }
            if (success) {
                this.refreshCurrNode();
            }
        }
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent evt) {
        String nodeId = (String)evt.getNodeId();
        QFilter treeFilter = this.buildFilter(nodeId, FILTER_CONDITION);
        if (null != treeFilter) {
            evt.addQFilter(treeFilter);
        }
        evt.setCancel(true);
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTNTREEFILTER});
        Search search = (Search)this.getView().getControl("searchap");
        if (null != search) {
            search.addEnterListener((SearchEnterListener)this);
        }
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        if (HRStringUtils.equals((String)BTNTREEFILTER, (String)control.getKey().toLowerCase(Locale.ROOT))) {
            this.showTreeFilterDialog();
        }
    }

    private void showTreeFilterDialog() {
        FormShowParameter formShowParameter = new FormShowParameter();
        OpenStyle openStyle = formShowParameter.getOpenStyle();
        openStyle.setShowType(ShowType.Floating);
        openStyle.setFloatingDirection(FloatingDirection.BottomCenter);
        openStyle.setTargetKey(BTNTREEFILTER);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "treefilteroperation"));
        formShowParameter.setFormId("hbjm_jobclassfilterdialog");
        String chkShowDisable = this.getPageCache().get("chkshowdisable");
        formShowParameter.setCustomParam("chkshowdisable", (Object)chkShowDisable);
        this.getView().showForm(formShowParameter);
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        SearchClickEvent searchClickEvent = args.getSearchClickEvent();
        QFilter org = searchClickEvent.getQFilter("useorg.id");
        if (Objects.nonNull(org)) {
            String useOrg = this.getPageCache().get("useOrg");
            String value = String.valueOf(org.getValue());
            this.getPageCache().put("useOrg", value);
            if (HRStringUtils.equals((String)value, (String)useOrg)) {
                return;
            }
            this.getTreeModel().setCurrentNodeId((Object)ROOT_ID);
            this.getTreeListView().refreshTreeView();
        }
    }

    private TreeNode loadAllTreeNodes() {
        this.initOrderContition();
        log.info("JobClassTreeListPluginPlus loadAllTreeNodes start");
        Object[] jobSeqs = this.getBuildJobSeqData();
        log.info("JobClassTreeListPluginPlus loadAllTreeNodes jobSeqs ", jobSeqs);
        String rootId = this.buildFullNodeId("0", "1010");
        TreeNode root = new TreeNode("", rootId, ResManager.loadKDString((String)"\u5168\u90e8\u5e8f\u5217", (String)"JobClassTreeListPlugin_0", (String)"hrmp-hbjm-formplugin", (Object[])new Object[0]));
        if (ObjectUtils.isEmpty((Object[])jobSeqs)) {
            return root;
        }
        Object[] jobfamilys = this.getBuildJobfamilyData();
        log.info("JobClassTreeListPluginPlus loadAllTreeNodes jobfamilys ", jobfamilys);
        DynamicObject[] jobClassDys = this.getBuildJobClassData();
        root = this.buildTree(root, (DynamicObject[])jobSeqs, (DynamicObject[])jobfamilys, jobClassDys);
        root.setIsOpened(true);
        return root;
    }

    private TreeNode buildTree(TreeNode root, DynamicObject[] jobSeqs, DynamicObject[] jobfamilys, DynamicObject[] jobClassDys) {
        HashMap<String, TreeNode> treeNodes = new HashMap<String, TreeNode>();
        treeNodes.put("1010", root);
        if (!ObjectUtils.isEmpty((Object[])jobClassDys)) {
            List jobClassDysSorted = Arrays.stream(jobClassDys).sorted(Comparator.comparing(jobclass -> jobclass.getInt("jobclasslevel"))).collect(Collectors.toList());
            for (DynamicObject classDy : jobClassDysSorted) {
                DynamicObject classSeq = classDy.getDynamicObject("jobseq");
                if (ObjectUtils.isEmpty((Object)classSeq)) continue;
                Long classSeqId = classSeq.getLong(FILTER_CONDITION);
                JobTreeBuildUtil.appendNode(treeNodes, (String)"1010", (String)String.valueOf(classSeqId), parentNode -> {
                    String name = classSeq.getString("name");
                    if ("0".equals(classSeq.getString("enable"))) {
                        name = name + this.getDiabledSign();
                    }
                    String currentNodeId = this.buildFullNodeId("1", String.valueOf(classSeqId));
                    TreeNode node = new TreeNode(parentNode.getId(), currentNodeId, name);
                    return node;
                });
                DynamicObject classFamily = classDy.getDynamicObject("jobfamily");
                if (ObjectUtils.isEmpty((Object)classFamily)) continue;
                Long classFamilyId = classFamily.getLong(FILTER_CONDITION);
                JobTreeBuildUtil.appendNode(treeNodes, (String)String.valueOf(classSeqId), (String)String.valueOf(classFamilyId), parentNode -> {
                    String name = classFamily.getString("name");
                    if ("0".equals(classFamily.getString("enable"))) {
                        name = name + this.getDiabledSign();
                    }
                    String currentNodeId = this.buildFullNodeId("2", String.valueOf(classFamilyId));
                    TreeNode node = new TreeNode(parentNode.getId(), currentNodeId, name);
                    return node;
                });
                Long parentId = classDy.getLong("parent.id");
                if (parentId == null || parentId == 0L) {
                    parentId = classDy.getLong("jobfamily.id");
                }
                Long id = classDy.getLong(FILTER_CONDITION);
                JobTreeBuildUtil.appendNode(treeNodes, (String)String.valueOf(parentId), (String)String.valueOf(id), parentNode -> {
                    String name = classDy.getString("name");
                    if ("0".equals(classDy.getString("enable"))) {
                        name = name + this.getDiabledSign();
                    }
                    String currentNodeId = this.buildFullNodeId("3", String.valueOf(id));
                    TreeNode node = new TreeNode(parentNode.getId(), currentNodeId, name);
                    return node;
                });
            }
        }
        if (!ObjectUtils.isEmpty((Object[])jobfamilys)) {
            for (DynamicObject family : jobfamilys) {
                DynamicObject seq = family.getDynamicObject("jobseq");
                if (ObjectUtils.isEmpty((Object)seq)) continue;
                Long seqId = seq.getLong(FILTER_CONDITION);
                JobTreeBuildUtil.appendNode(treeNodes, (String)"1010", (String)String.valueOf(seqId), parentNode -> {
                    String name = seq.getString("name");
                    if ("0".equals(seq.getString("enable"))) {
                        name = name + this.getDiabledSign();
                    }
                    String currentNodeId = this.buildFullNodeId("1", String.valueOf(seqId));
                    TreeNode node = new TreeNode(parentNode.getId(), currentNodeId, name);
                    return node;
                });
                Long familyId = family.getLong(FILTER_CONDITION);
                JobTreeBuildUtil.appendNode(treeNodes, (String)String.valueOf(seqId), (String)String.valueOf(familyId), parentNode -> {
                    String name = family.getString("name");
                    if ("0".equals(family.getString("enable"))) {
                        name = name + this.getDiabledSign();
                    }
                    String currentNodeId = this.buildFullNodeId("2", String.valueOf(familyId));
                    TreeNode node = new TreeNode(parentNode.getId(), currentNodeId, name);
                    return node;
                });
            }
        }
        for (DynamicObject seq : jobSeqs) {
            Long seqId = seq.getLong(FILTER_CONDITION);
            JobTreeBuildUtil.appendNode(treeNodes, (String)"1010", (String)String.valueOf(seqId), parentNode -> {
                String name = seq.getString("name");
                if ("0".equals(seq.getString("enable"))) {
                    name = name + this.getDiabledSign();
                }
                String currentNodeId = this.buildFullNodeId("1", String.valueOf(seqId));
                TreeNode node = new TreeNode(parentNode.getId(), currentNodeId, name);
                return node;
            });
        }
        return (TreeNode)treeNodes.get("1010");
    }

    private String buildFullNodeId(String sign, String currentId) {
        return sign + currentId;
    }

    private String getDiabledSign() {
        String sign = ResManager.loadKDString((String)"(\u5df2\u7981\u7528)", (String)"JobClassTreeListPlugin_1", (String)"hrmp-hbjm-formplugin", (Object[])new Object[0]);
        return sign;
    }

    protected DynamicObject[] getBuildJobSeqData() {
        Long userId = RequestContext.get().getCurrUserId();
        DynamicObject[] jobfamilys = JobClassTreeQueryRepository.getInstance().queryJobSeq(userId, this.getSelectedOrgIdByCache(), this.getIsShowDisableValue(), this.orderCondition);
        return jobfamilys;
    }

    protected DynamicObject[] getBuildJobfamilyData() {
        Long userId = RequestContext.get().getCurrUserId();
        DynamicObject[] jobfamilys = JobClassTreeQueryRepository.getInstance().queryJobFamily(userId, this.getSelectedOrgIdByCache(), this.getIsShowDisableValue(), this.orderCondition);
        return jobfamilys;
    }

    protected DynamicObject[] getBuildJobClassData() {
        Long userId = RequestContext.get().getCurrUserId();
        DynamicObject[] jobClassDys = JobClassTreeQueryRepository.getInstance().queryJobClass(userId, this.getSelectedOrgIdByCache(), this.getIsShowDisableValue(), this.orderCondition);
        return jobClassDys;
    }

    protected Boolean getIsShowDisableValue() {
        Boolean isShowDisable = Boolean.FALSE;
        Boolean isShowDisableParam = (Boolean)this.getView().getFormShowParameter().getCustomParam("chkshowdisable");
        if (null != isShowDisableParam) {
            this.getPageCache().put("chkshowdisable", String.valueOf(isShowDisableParam));
            isShowDisable = isShowDisableParam;
        } else {
            String cacheShowDisable = this.getPageCache().get("chkshowdisable");
            isShowDisable = Boolean.parseBoolean(cacheShowDisable);
        }
        return isShowDisable;
    }

    protected List<Long> getSelectedOrgIdByCache() {
        List<Object> useOrglong;
        FormShowParameter formShowParameter;
        String formId = this.getView().getFormShowParameter().getFormId();
        if ("hbjm_jobclasstreelistf7".equals(formId) && (formShowParameter = this.getView().getFormShowParameter()) instanceof ListShowParameter) {
            List useOrgIds = ((ListShowParameter)formShowParameter).getUseOrgIds();
            return !CollectionUtils.isEmpty((Collection)useOrgIds) ? useOrgIds : Lists.newArrayList((Object[])new Long[]{((ListShowParameter)formShowParameter).getUseOrgId()});
        }
        String useOrg = this.getPageCache().get("useOrg");
        if (HRStringUtils.isEmpty((String)useOrg)) {
            String createOrg = this.getPageCache().get("createOrg");
            this.getPageCache().put("useOrg", createOrg);
            return Lists.newArrayList((Object[])new Long[]{HRStringUtils.isEmpty((String)createOrg) ? 0L : Long.parseLong(createOrg)});
        }
        if (useOrg.startsWith("[")) {
            String[] useOrgs = useOrg.substring(1, useOrg.toCharArray().length - 1).split(",");
            useOrglong = Arrays.stream(useOrgs).map(useOrgstr -> Long.valueOf(useOrgstr.trim())).collect(Collectors.toList());
        } else {
            useOrglong = Lists.newArrayList((Object[])new Long[]{Long.valueOf(useOrg)});
        }
        return useOrglong;
    }

    private QFilter buildFilter(String nodeId, String filterCondition) {
        Long userId = RequestContext.get().getCurrUserId();
        QFilter qFilter = null;
        if (null != nodeId && !HRStringUtils.isEmpty((String)nodeId)) {
            String[] split = nodeId.split(SPLIT);
            String lastNodeId = split[split.length - 1];
            Long seqId = 0L;
            if (split.length > 1) {
                seqId = Long.valueOf(split[1].substring(1));
            }
            String nodeLayer = lastNodeId.substring(0, 1);
            ArrayList<Long> ids = new ArrayList<Long>();
            ids.add(Long.valueOf(lastNodeId.substring(1)));
            switch (nodeLayer) {
                case "0": {
                    qFilter = JobClassRepository.getInstance().getClassFilter(userId, this.getIsShowDisableValue());
                    break;
                }
                case "1": {
                    qFilter = this.buildJobFilter(seqId, ids, filterCondition, "jobseq.id");
                    break;
                }
                case "2": {
                    qFilter = this.buildJobFilter(seqId, ids, filterCondition, "jobfamily.id");
                    break;
                }
                default: {
                    String strId = nodeId.substring(1, nodeId.length());
                    qFilter = new QFilter("parent", "=", (Object)Long.parseLong(strId));
                    qFilter.or(new QFilter(FILTER_CONDITION, "=", (Object)Long.parseLong(strId)));
                    qFilter.and(JobClassRepository.getInstance().getClassFilter(userId, this.getIsShowDisableValue()));
                }
            }
        }
        return qFilter;
    }

    private QFilter buildJobFilter(Long seqId, List<Long> ids, String filterCondition, String field) {
        List longs = JobClassRepository.getInstance().queryJobId(seqId, ids, field, this.getIsShowDisableValue());
        return new QFilter(filterCondition, "in", (Object)longs);
    }

    private void refreshCurrNode() {
        String currentNodeId = (String)this.getTreeModel().getCurrentNodeId();
        TreeNode rootNode = this.getTreeModel().getRoot();
        TreeNode currentTreeNode = rootNode.getTreeNode(currentNodeId, 100);
        this.getTreeModel().setCurrentNodeId((Object)ROOT_ID);
        this.getTreeListView().refreshTreeView();
        TreeNode afterFreshCurTreeNode = this.getTreeModel().getRoot().getTreeNode(currentNodeId, 100);
        if (Objects.isNull(afterFreshCurTreeNode)) {
            String parentId = currentTreeNode.getParentid();
            TreeNode parentTreeNode = rootNode.getTreeNode(parentId, 100);
            this.getTreeListView().getTreeView().focusNode(parentTreeNode);
            this.getTreeListView().getTreeView().treeNodeClick(parentTreeNode.getParentid(), parentTreeNode.getId());
            parentTreeNode.setIsOpened(true);
            JobClassTreeUtil.setNodeExpend((TreeNode)parentTreeNode, (TreeNode)rootNode);
        } else {
            this.getTreeListView().getTreeView().focusNode(currentTreeNode);
            this.getTreeListView().getTreeView().treeNodeClick(currentTreeNode.getParentid(), currentTreeNode.getId());
            currentTreeNode.setIsOpened(true);
            JobClassTreeUtil.setNodeExpend((TreeNode)currentTreeNode, (TreeNode)rootNode);
        }
    }

    private BaseShowParameter setCustomParamForBaseShowParameter(BaseShowParameter baseShowParameter, String nodeId) {
        if (null != nodeId && !HRStringUtils.isEmpty((String)nodeId)) {
            HashMap<String, Object> cusParamMap = new HashMap<String, Object>();
            String nodeLayer = nodeId.substring(0, 1);
            Long nodeLayerId = Long.valueOf(nodeId.substring(1, nodeId.length()));
            switch (nodeLayer) {
                case "0": {
                    break;
                }
                case "1": {
                    cusParamMap.put("jobseq", nodeLayerId);
                    break;
                }
                case "2": {
                    HRBaseServiceHelper jobFamilyHelper = new HRBaseServiceHelper("hbjm_jobfamilyhr");
                    QFilter jobFamilyFilter = new QFilter(FILTER_CONDITION, "=", (Object)nodeLayerId);
                    DynamicObject jobFamilyObj = jobFamilyHelper.queryOne("id, jobseq", new QFilter[]{jobFamilyFilter});
                    cusParamMap.put("jobseq", jobFamilyObj.get("jobseq.id"));
                    cusParamMap.put("jobfamily", nodeLayerId);
                    cusParamMap.put("parent", nodeLayerId);
                    cusParamMap.put("number", jobFamilyObj.getString("number"));
                    break;
                }
                default: {
                    HRBaseServiceHelper jobSubClassHelper = new HRBaseServiceHelper("hbjm_jobclasshr");
                    QFilter jobSubClassFilter = new QFilter(FILTER_CONDITION, "=", (Object)nodeLayerId);
                    DynamicObject jobSubClassObj = jobSubClassHelper.queryOne("id, parent, jobfamily, jobseq,jobclasslevel", new QFilter[]{jobSubClassFilter});
                    cusParamMap.put("jobseq", jobSubClassObj.get("jobseq.id"));
                    cusParamMap.put("jobfamily", jobSubClassObj.get("jobfamily.id"));
                    cusParamMap.put("jobclasslevel", jobSubClassObj.getInt("jobclasslevel") + 1);
                    cusParamMap.put("parent", nodeLayerId);
                    cusParamMap.put("number", jobSubClassObj.getString("number"));
                }
            }
            cusParamMap.put("layer", nodeLayer);
            baseShowParameter.setCustomParam("cusParam", cusParamMap);
        }
        return baseShowParameter;
    }

    private void initOrderContition() {
        this.orderCondition = JobTreeSortServiceExt.getInstance().getJobTreeAndJobClassTreeSortCondition();
    }

    public String getOrderCondition() {
        return this.orderCondition;
    }
}

