/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbjm.formplugin.web.jobgradescm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.mvc.list.ListDataProvider;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.hrmp.hbjm.business.domain.repository.JobGradeScmRepository;

public class JobGradeScmList
extends HRDataBaseList {
    private Map<Long, String> concatenatedDetailMap = null;

    public void setFilter(SetFilterEvent evt) {
        String order = evt.getOrderBy();
        if (null != order && order.contains("jobgradedetail")) {
            evt.setOrderBy(null);
        }
        evt.setOrderBy("createorg asc,enable desc,number desc");
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection rows = super.getData(start, limit);
                if (rows.isEmpty()) {
                    return rows;
                }
                ArrayList<Long> rowIds = new ArrayList<Long>();
                for (DynamicObject row : rows) {
                    rowIds.add(row.getLong("id"));
                }
                if (!rowIds.isEmpty()) {
                    JobGradeScmList.this.concatenatedDetailMap = JobGradeScmList.this.getConcatenatedDetail(rowIds);
                }
                return rows;
            }
        });
    }

    public void packageData(PackageDataEvent evt) {
        super.packageData(evt);
        if (evt.getSource() instanceof AbstractColumnDesc) {
            AbstractColumnDesc columnDesc = (AbstractColumnDesc)evt.getSource();
            switch (columnDesc.getFieldKey()) {
                case "jobgradedetail": {
                    this.evtSetFormatValue(evt, this.concatenatedDetailMap);
                    break;
                }
            }
        }
    }

    private void evtSetFormatValue(PackageDataEvent evt, Map<Long, String> maps) {
        Long rowId = evt.getRowData().getLong("id");
        if (null != maps && null != rowId && null != maps.get(rowId)) {
            evt.setFormatValue((Object)maps.get(rowId));
        }
    }

    private Map<Long, String> getConcatenatedDetail(List<Long> rowIds) {
        Object[] jobGradeObjArrays = JobGradeScmRepository.getInstance().queryJobGradeScmByrowIds(rowIds);
        if (null != jobGradeObjArrays && !HRArrayUtils.isEmpty((Object[])jobGradeObjArrays)) {
            this.concatenatedDetailMap = new HashMap<Long, String>();
            for (Object jobGradeObj : jobGradeObjArrays) {
                Long id = jobGradeObj.getLong("id");
                DynamicObjectCollection jobGradeDetailCol = jobGradeObj.getDynamicObjectCollection("entryentity");
                if (null == jobGradeDetailCol || jobGradeDetailCol.isEmpty()) continue;
                StringBuilder concatenatedName = new StringBuilder();
                this.appendParams(jobGradeDetailCol, concatenatedName);
                this.concatenatedDetailMap.put(id, concatenatedName.toString());
            }
            return this.concatenatedDetailMap;
        }
        return null;
    }

    private void appendParams(DynamicObjectCollection jobGradeDetailCol, StringBuilder concatenatedName) {
        HashMap<String, String> jobGradeDetailmap = new HashMap<String, String>(2);
        for (DynamicObject dynamicObject : jobGradeDetailCol) {
            String seq = dynamicObject.getString("jobgrade_seq");
            String name = dynamicObject.getString("jobgrade_name");
            jobGradeDetailmap.put(seq, name);
        }
        ArrayList seqs = new ArrayList(jobGradeDetailmap.keySet());
        Collections.sort(seqs);
        boolean bool = false;
        for (String seq : seqs) {
            if (bool) {
                concatenatedName.append(", ");
            } else {
                bool = true;
            }
            concatenatedName.append((String)jobGradeDetailmap.get(seq));
        }
    }
}

