/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbjm.formplugin.web.jobgradescm;

import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterMoveEntryEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hrmp.hbjm.formplugin.web.common.JobGradeAndLevelScmUtil;

public class JobGradeScmPlugin
extends HRDataBaseEdit {
    public void beforeBindData(EventObject eventObject) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (entryEntity.size() > 1) {
            entryEntity.sort((Comparator)new Comparator<DynamicObject>(){

                @Override
                public int compare(DynamicObject o1, DynamicObject o2) {
                    return o1.getInt("jobgrade_seq") - o2.getInt("jobgrade_seq");
                }
            });
        }
        this.getModel().setDataChanged(false);
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        String pageStatue = this.getPageCache().get("pageStatus");
        if (HRStringUtils.equals((String)"view", (String)pageStatue)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"new_entry"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"delete_entry"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"insert_entry"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"moveup_entry"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"movedown_entry"});
        }
    }

    public void propertyChanged(PropertyChangedArgs evt) {
        String propertyName;
        super.propertyChanged(evt);
        switch (propertyName = evt.getProperty().getName()) {
            case "jobgrade_number": {
                this.checkJobGradeNumber();
                break;
            }
            case "jobgrade_name": {
                this.checkJobGradeName();
                break;
            }
            case "jobgrade_seq": {
                this.checkAndmoveSeq(evt.getChangeSet()[0]);
                break;
            }
        }
    }

    public void afterMoveEntryUp(AfterMoveEntryEventArgs eventArgs) {
        this.moveSeq();
    }

    public void afterMoveEntryDown(AfterMoveEntryEventArgs e) {
        this.moveSeq();
    }

    private void moveSeq() {
        DynamicObjectCollection entryEntity = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        List seq = entryEntity.stream().map(entry -> entry.getInt("jobgrade_seq")).collect(Collectors.toList());
        Collections.sort(seq);
        for (int i = 0; i < entryEntity.size(); ++i) {
            ((DynamicObject)entryEntity.get(i)).set("jobgrade_seq", seq.get(i));
            this.getView().updateView("jobgrade_seq", i);
        }
    }

    private void checkAndmoveSeq(ChangeData changeData) {
        DynamicObjectCollection entryEntity = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        this.getModel().deleteEntryRow("entryentity", changeData.getRowIndex());
        String msg = JobGradeAndLevelScmUtil.checkAndmoveSeq(changeData, entryEntity, "jobgrade_seq");
        if (msg != null) {
            this.getView().showErrorNotification(msg);
        }
        this.getView().updateView("entryentity");
    }

    private void checkJobGradeNumber() {
        DynamicObjectCollection entryEntity;
        String jobGradeNumber = (String)this.getModel().getValue("jobgrade_number");
        String msg = JobGradeAndLevelScmUtil.checkJobGradeOrLevelNumber(jobGradeNumber, entryEntity = this.getModel().getEntryEntity("entryentity"), "jobgrade_number");
        if (msg != null) {
            this.getView().showErrorNotification(msg);
        }
    }

    private void checkJobGradeName() {
        OrmLocaleValue jobGradeName = (OrmLocaleValue)this.getModel().getValue("jobgrade_name");
        Set lcSet = jobGradeName.keySet();
        Iterator lcIterator = lcSet.iterator();
        while (lcIterator.hasNext()) {
            if (!"NULL".equals(jobGradeName.getItem((String)lcIterator.next()))) continue;
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u804c\u7b49\u540d\u79f0\u4e0d\u80fd\u4e3a\u201cNULL\u201d\u3002", (String)"JobGradeScmPlugin_1", (String)"hrmp-hbjm-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        String msg = JobGradeAndLevelScmUtil.checkJobGradeOrLevelName(jobGradeName, entryEntity, "jobgrade_name");
        if (msg != null) {
            this.getView().showErrorNotification(msg);
        }
    }

    public void afterAddRow(AfterAddRowEventArgs eventArgs) {
        if (eventArgs.getInsertRow() > 0) {
            int seq = (Integer)this.getModel().getValue("jobgrade_seq", eventArgs.getInsertRow() - 1) + 1;
            int size = this.getModel().getEntryEntity("entryentity").size();
            if (!this.validateSeqLegal(eventArgs.getInsertRow(), seq, size)) {
                this.getModel().deleteEntryRow("entryentity", eventArgs.getInsertRow());
                this.getView().updateView("entryentity");
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u63d2\u5165\u540e\u5206\u5f55\u7684\u804c\u7b49\u987a\u5e8f\u7801\u4e0d\u80fd\u8d85\u8fc7\u201c99999\u201d\uff0c\u8bf7\u8c03\u6574\u987a\u5e8f\u7801\u3002", (String)"JobGradeScmPlugin_3", (String)"hrmp-hbjm-formplugin", (Object[])new Object[0]));
            } else {
                this.insertEntry(eventArgs.getInsertRow(), seq, size);
            }
        }
    }

    private boolean validateSeqLegal(int insertRow, int seq, int size) {
        while (insertRow + 1 < size && seq == (Integer)this.getModel().getValue("jobgrade_seq", insertRow + 1)) {
            if (++seq > 99999) {
                return false;
            }
            this.validateSeqLegal(++insertRow, seq, size);
        }
        return true;
    }

    private void insertEntry(int insertRow, int seq, int size) {
        this.getModel().beginInit();
        this.getModel().setValue("jobgrade_seq", (Object)seq, insertRow);
        this.getView().updateView("jobgrade_seq", insertRow);
        this.modifyEntrySeq(insertRow, size);
        this.getModel().endInit();
    }

    private void modifyEntrySeq(int insertRow, int size) {
        int insertSeq = (Integer)this.getModel().getValue("jobgrade_seq", insertRow);
        while (insertRow + 1 < size && insertSeq == (Integer)this.getModel().getValue("jobgrade_seq", insertRow + 1)) {
            this.getModel().setValue("jobgrade_seq", (Object)(++insertSeq), insertRow + 1);
            this.getView().updateView("jobgrade_seq", insertRow + 1);
            this.modifyEntrySeq(++insertRow, size);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        switch (afterDoOperationEventArgs.getOperateKey()) {
            case "newentry": {
                this.newEntry();
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "newentry": {
                this.valideNewEntry(args);
                break;
            }
        }
    }

    private void valideNewEntry(BeforeDoOperationEventArgs args) {
        int lastButOneSeq;
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        int size = entryEntity.size();
        if (size >= 1 && (lastButOneSeq = ((DynamicObject)entryEntity.get(size - 1)).getInt("jobgrade_seq")) >= 99999) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u804c\u7b49\u987a\u5e8f\u7801\u4e0d\u80fd\u8d85\u8fc7\u201c99999\u201d\u3002", (String)"JobGradeScmPlugin_2", (String)"hrmp-hbjm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    private void newEntry() {
        this.getModel().beginInit();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        int size = entryEntity.size();
        if (size > 1) {
            int lastButOneSeq = ((DynamicObject)entryEntity.get(size - 2)).getInt("jobgrade_seq");
            if (lastButOneSeq >= 99999) {
                this.getModel().deleteEntryRow("entryentity", size - 1);
                this.getView().updateView("entryentity");
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u804c\u7b49\u987a\u5e8f\u7801\u4e0d\u80fd\u8d85\u8fc7\u201c99999\u201d\u3002", (String)"JobGradeScmPlugin_2", (String)"hrmp-hbjm-formplugin", (Object[])new Object[0]));
            } else {
                this.getModel().setValue("jobgrade_seq", (Object)(++lastButOneSeq), size - 1);
                this.getView().updateView("jobgrade_seq", size - 1);
            }
        }
        this.getModel().endInit();
    }
}

