/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbjm.formplugin.web.jobscm;

import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.hrmp.hbjm.business.domain.repository.JobScmRepository;

public class JobScmListPlugin
extends HRDataBaseList {
    private static final Log logger = LogFactory.getLog(JobScmListPlugin.class);

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (formOperate.getOperateKey()) {
            case "donothing_new": {
                this.linkToScm(null, OperationStatus.EDIT, false);
                break;
            }
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        if ("bos_listf7".equals(this.getView().getFormShowParameter().getFormId())) {
            return;
        }
        IListView listView = (IListView)this.getView();
        Long pkId = (Long)listView.getFocusRowPkId();
        String fieldName = args.getHyperLinkClickEvent().getFieldName();
        if (StringUtils.equals((CharSequence)fieldName, (CharSequence)"name")) {
            args.setCancel(true);
            Long userId = RequestContext.get().getCurrUserId();
            boolean hasViewPerm = PermissionServiceHelper.hasSpecificPerm((long)userId, (String)"hjm", (String)"hbjm_jobscmhr", (String)"47150e89000000ac");
            boolean hasModifyPerm = PermissionServiceHelper.hasSpecificPerm((long)userId, (String)"hjm", (String)"hbjm_jobscmhr", (String)"4715a0df000000ac");
            DynamicObject jobscm = JobScmRepository.getInstance().queryBaseInfoById(pkId);
            if (hasViewPerm) {
                boolean isEnabled = "1".equals(jobscm.getString("enable"));
                logger.info("JobScmListPlugin#billListHyperLinkClick.isEnabled={},hasModifyPerm={}", (Object)isEnabled, (Object)hasModifyPerm);
                this.linkToScm(pkId, OperationStatus.VIEW, isEnabled && hasModifyPerm);
            } else {
                String msg = ResManager.loadKDString((String)"\u65e0\u201c\u804c\u4f4d\u4f53\u7cfb\u65b9\u6848\u201d\u7684\u201c\u67e5\u770b\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"JobScmListPlugin_2", (String)"hrmp-hbjm-formplugin", (Object[])new Object[0]);
                this.getView().showErrorNotification(msg);
            }
        }
    }

    private void linkToScm(Long pkId, OperationStatus oper, boolean hasUpdatePerm) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.setFormId("hjm_jobscmview");
        formShowParameter.setStatus(oper);
        formShowParameter.setCustomParam("hasUpdatePerm", (Object)hasUpdatePerm);
        formShowParameter.setCustomParam("pkId", (Object)pkId);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "hjm_jobscmview"));
        formShowParameter.setCustomParam("useorgId", (Object)this.getPageCache().get("createOrg"));
        if (this.getView().getFormShowParameter().getCustomParam("unitTest") != null) {
            return;
        }
        this.getView().showForm(formShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (StringUtils.equals((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)"hjm_jobscmview") && closedCallBackEvent.getReturnData() != null) {
            boolean result = (Boolean)closedCallBackEvent.getReturnData();
            if (result) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"JobScmListPlugin_0", (String)"hrmp-hbjm-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25", (String)"JobScmListPlugin_1", (String)"hrmp-hbjm-formplugin", (Object[])new Object[0]));
            }
            ((ListView)this.getView()).refresh();
        }
    }

    public void setFilter(SetFilterEvent setFilterEvent) {
        super.setFilter(setFilterEvent);
        String commonOrderBy = "createorg.number,number asc";
        setFilterEvent.setOrderBy(commonOrderBy);
    }
}

