/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.common.constants.org;

import com.google.common.collect.Lists;
import java.util.List;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ITreeModel;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.TreeView;
import kd.bos.list.ITreeListView;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;

public class OrgTreeSearchParam {
    private boolean searchById;
    private String searchText;
    private IFormView formView;
    private TreeView treeView;
    private ITreeModel treeModel;
    private String rootNodeCacheKey;
    private List<Long> orgRangeList;
    @Deprecated
    private List<QFilter> orgFilterList = Lists.newArrayList();
    @Deprecated
    private List<QFilter> orgStructureFilterList = Lists.newArrayList();
    private boolean clickNode;
    private IPageCache pageCache;
    private TreeNode rootNode;
    private boolean queryBeforeExpend;
    private List<String> checkNodeIds = Lists.newArrayList();
    private Long searchIdVal;

    public OrgTreeSearchParam(String searchText, ListView listView) {
        this.searchText = searchText;
        this.formView = listView;
        this.initParam(listView);
    }

    public OrgTreeSearchParam(Long searchIdVal, ListView listView) {
        this.searchIdVal = searchIdVal;
        this.formView = listView;
        this.initParam(listView);
    }

    public OrgTreeSearchParam(ListView listView) {
        this.formView = listView;
        this.initParam(listView);
    }

    private void initParam(ListView listView) {
        if (listView != null) {
            this.pageCache = listView.getPageCache();
            ITreeListView treeListView = listView.getTreeListView();
            if (treeListView != null) {
                if (this.treeView == null) {
                    this.treeView = treeListView.getTreeView();
                }
                this.treeModel = treeListView.getTreeModel();
            }
        }
    }

    public boolean isSearchById() {
        return this.searchById;
    }

    public void setSearchById(boolean searchById) {
        this.searchById = searchById;
    }

    public String getSearchText() {
        return this.searchText;
    }

    public void setSearchText(String searchText) {
        this.searchText = searchText;
    }

    public IFormView getFormView() {
        return this.formView;
    }

    public void setFormView(IFormView formView) {
        this.formView = formView;
    }

    public TreeView getTreeView() {
        return this.treeView;
    }

    public void setTreeView(TreeView treeView) {
        this.treeView = treeView;
    }

    public String getRootNodeCacheKey() {
        return this.rootNodeCacheKey;
    }

    public void setRootNodeCacheKey(String rootNodeCacheKey) {
        this.rootNodeCacheKey = rootNodeCacheKey;
    }

    public TreeNode getRootNode() {
        if (this.treeModel != null) {
            return this.treeModel.getRoot();
        }
        if (StringUtils.isBlank((CharSequence)this.rootNodeCacheKey)) {
            return this.rootNode;
        }
        String rootNodeCache = this.getPageCache().get(this.rootNodeCacheKey);
        return StringUtils.isNotBlank((CharSequence)rootNodeCache) ? (TreeNode)SerializationUtils.fromJsonString((String)rootNodeCache, TreeNode.class) : null;
    }

    public List<Long> getOrgRangeList() {
        return this.orgRangeList;
    }

    public void setOrgRangeList(List<Long> orgRangeList) {
        this.orgRangeList = orgRangeList;
    }

    @Deprecated
    public List<QFilter> getOrgFilterList() {
        return this.orgFilterList;
    }

    @Deprecated
    public void setOrgFilterList(List<QFilter> orgFilterList) {
        this.orgFilterList = orgFilterList;
    }

    @Deprecated
    public List<QFilter> getOrgStructureFilterList() {
        return this.orgStructureFilterList;
    }

    @Deprecated
    public void setOrgStructureFilterList(List<QFilter> orgStructureFilterList) {
        this.orgStructureFilterList = orgStructureFilterList;
    }

    public boolean isClickNode() {
        return this.clickNode;
    }

    public void setClickNode(boolean clickNode) {
        this.clickNode = clickNode;
    }

    public IPageCache getPageCache() {
        return this.pageCache;
    }

    void setPageCache(IPageCache pageCache) {
        this.pageCache = pageCache;
    }

    boolean isQueryBeforeExpend() {
        return this.queryBeforeExpend;
    }

    void setQueryBeforeExpend(boolean queryBeforeExpend) {
        this.queryBeforeExpend = queryBeforeExpend;
    }

    public List<String> getCheckNodeIds() {
        return this.checkNodeIds;
    }

    public ITreeModel getTreeModel() {
        return this.treeModel;
    }

    public void setTreeModel(ITreeModel treeModel) {
        this.treeModel = treeModel;
    }

    public void setRootNode(TreeNode rootNode) {
        this.rootNode = rootNode;
    }

    public void setCheckNodeIds(List<String> checkNodeIds) {
        this.checkNodeIds = checkNodeIds;
    }

    public Long getSearchIdVal() {
        return this.searchIdVal;
    }

    public void setSearchIdVal(Long searchIdVal) {
        this.searchIdVal = searchIdVal;
    }
}

