/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.common.econtract;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.tempfile.TempFileCacheDownloadable;
import kd.bos.context.RequestContext;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.fileservice.enums.PreviewParams;
import kd.bos.fileservice.extension.FileServiceExtFactory;
import kd.bos.fileservice.preview.PreviewServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.FileNameUtils;
import kd.bos.util.StringUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;

public class HRWordUtils {
    private static final Pattern TEXT_PTN = Pattern.compile("\\$\\{[^}]*?\\}");
    private static final Log LOGGER = LogFactory.getLog(HRWordUtils.class);

    public static StringBuffer getStringFormWord(XWPFDocument document) {
        StringBuffer stringBuffer = null;
        if (!HRObjectUtils.isEmpty(document)) {
            stringBuffer = new StringBuffer();
            Iterator itPara = document.getParagraphsIterator();
            try {
                while (itPara.hasNext()) {
                    XWPFParagraph paragraph = (XWPFParagraph)itPara.next();
                    List runs = paragraph.getRuns();
                    for (int i = 0; i < runs.size(); ++i) {
                        try {
                            String oneparaString = ((XWPFRun)runs.get(i)).getText(0);
                            stringBuffer.append(oneparaString);
                            continue;
                        }
                        catch (Exception exception) {
                            LOGGER.error("getStringFormWord err", (Throwable)exception);
                        }
                    }
                }
                List tables = document.getTables();
                for (XWPFTable table : tables) {
                    List rows = table.getRows();
                    for (XWPFTableRow row : rows) {
                        List cells = row.getTableCells();
                        for (XWPFTableCell cell : cells) {
                            List cellParagraphs = cell.getParagraphs();
                            for (XWPFParagraph paragraph : cellParagraphs) {
                                List runs = paragraph.getRuns();
                                for (int i = 0; i < runs.size(); ++i) {
                                    try {
                                        String oneparaString = ((XWPFRun)runs.get(i)).getText(0);
                                        stringBuffer.append(oneparaString);
                                        continue;
                                    }
                                    catch (Exception exception) {
                                        LOGGER.error("getStringFormWord err 96", (Throwable)exception);
                                    }
                                }
                            }
                        }
                    }
                }
                return stringBuffer;
            }
            catch (Exception e) {
                LOGGER.error("open file error");
            }
        } else {
            LOGGER.error("file not found");
        }
        return stringBuffer;
    }

    public static Set<String> getAllKeywords(StringBuffer wordStringBuffer) {
        int endIndex;
        int startIndex;
        LinkedHashSet keywordSet = Sets.newLinkedHashSetWithExpectedSize((int)16);
        for (int i = 0; i < wordStringBuffer.length() && (startIndex = wordStringBuffer.indexOf("${", i)) >= 0 && (endIndex = wordStringBuffer.indexOf("}", startIndex)) >= 0; ++i) {
            int nextStartIndex = wordStringBuffer.indexOf("${", startIndex + 1);
            String keyword = nextStartIndex > 0 && nextStartIndex < endIndex ? wordStringBuffer.substring(startIndex, nextStartIndex) : wordStringBuffer.substring(startIndex, endIndex + 1);
            keywordSet.add(keyword);
            i = startIndex;
        }
        return keywordSet;
    }

    public static String replaceWordKeyword(String srcPath, String fileName, String formId, Map<String, String> map, boolean isToPdf, String appId, Object pkId) throws IOException {
        return HRWordUtils.replaceWordKeyword(srcPath, fileName, formId, map, isToPdf, null, appId, pkId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static String replaceWordKeyword(String srcPath, String fileName, String formId, Map<String, String> map, boolean isToPdf, String keyWordDouble, String appId, Object pkId) throws IOException {
        String filePath = "";
        boolean isKeyWordNotEmpty = HRStringUtils.isNotEmpty(keyWordDouble);
        if (isKeyWordNotEmpty) {
            LOGGER.info("replaceWordKeyword keyWordDouble={}", (Object)keyWordDouble);
        }
        ByteArrayOutputStream out = null;
        ByteArrayInputStream bin = null;
        FileService fileService = FileServiceFactory.getAttachmentFileService();
        try {
            String string;
            Throwable throwable;
            XWPFDocument document;
            block26: {
                block27: {
                    document = new XWPFDocument(fileService.getInputStream(srcPath));
                    throwable = null;
                    List docParagraphs = document.getParagraphs();
                    for (XWPFParagraph paragraph : docParagraphs) {
                        HRWordUtils.handleParagraph(paragraph, map, isKeyWordNotEmpty, keyWordDouble);
                    }
                    List tables = document.getTables();
                    for (XWPFTable table : tables) {
                        List rows = table.getRows();
                        for (XWPFTableRow row : rows) {
                            List cells = row.getTableCells();
                            for (XWPFTableCell cell : cells) {
                                List cellParagraphs = cell.getParagraphs();
                                for (XWPFParagraph paragraph : cellParagraphs) {
                                    HRWordUtils.handleParagraph(paragraph, map, isKeyWordNotEmpty, keyWordDouble);
                                }
                            }
                        }
                    }
                    out = new ByteArrayOutputStream();
                    document.write((OutputStream)out);
                    bin = new ByteArrayInputStream(out.toByteArray());
                    filePath = HRWordUtils.uploadFile(bin, fileName, formId, appId, pkId);
                    if (isToPdf) {
                        filePath = HRWordUtils.switchWord2Pdf(filePath, fileService, fileName, formId, appId, pkId);
                    }
                    string = filePath;
                    if (document == null) break block26;
                    if (throwable == null) break block27;
                    try {
                        document.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block26;
                }
                document.close();
            }
            return string;
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (document != null) {
                            if (throwable != null) {
                                try {
                                    document.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                document.close();
                            }
                        }
                        throw throwable4;
                    }
                }
                catch (Exception e) {
                    LOGGER.error("read file error", (Throwable)e);
                }
            }
        }
        finally {
            if (null != out) {
                out.close();
            }
            if (null != bin) {
                bin.close();
            }
        }
        return filePath;
    }

    private static void handleKeyWord(XWPFParagraph paragraph, String strTmp, String keyWordDouble, int index) {
        int startIdx = strTmp.indexOf(keyWordDouble);
        LOGGER.info("handleKeyWord strTmp={},startIdx={},keyWordDouble={}", new Object[]{strTmp, startIdx, keyWordDouble});
        int pos = 0;
        if (startIdx > -1) {
            paragraph.removeRun(index);
            XWPFRun run = paragraph.insertNewRun(index);
            if (startIdx > 0) {
                run.setText(strTmp.substring(0, startIdx), pos++);
            }
            run.setText(keyWordDouble, pos++);
            run.setColor("FFFFFF");
            int endIdx = startIdx + keyWordDouble.length();
            if (strTmp.length() > endIdx + 1) {
                run.setText(strTmp.substring(endIdx), pos++);
            }
        }
    }

    public static String switchWord2Pdf(String url, FileService fileService, String fileName, String formId, String appId, Object pkId) {
        String pathUril = "";
        Map map = PreviewServiceFactory.getPreviewService((FileService)fileService).preview(fileName, url, RequestContext.get().getUserAgent());
        String status = (String)map.get("status");
        if (PreviewParams.PDF_SUCCESS.getEnumName().equals(status) || PreviewParams.NOT_NEED_CHANGE.getEnumName().equals(status)) {
            try (InputStream bin = (InputStream)map.get("result");){
                fileName = FileServiceExtFactory.getAttachFileServiceExt().getRealPath(fileName);
                String pdfName = fileName.substring(0, fileName.lastIndexOf(46)) + ".pdf";
                pathUril = HRWordUtils.uploadFile(bin, pdfName, formId, appId, pkId);
                fileService.delete(url);
            }
            catch (IOException exception) {
                LOGGER.error("get InputSteam error", (Throwable)exception);
            }
        } else {
            LOGGER.error("change word to pdf error, result={}", map.get("result"));
        }
        return pathUril;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XWPFDocument getXWPFDocumentFromUrl(String path, boolean isTempFile) throws IOException {
        XWPFDocument document = null;
        URL url = new URL(path);
        try (InputStream inStream = null;){
            inStream = isTempFile ? HRWordUtils.tempFileUrl(url) : HRWordUtils.attachmentUrl(url);
            XWPFDocument xWPFDocument = document = new XWPFDocument(inStream);
            return xWPFDocument;
        }
        return document;
    }

    private static InputStream attachmentUrl(URL url) throws IOException {
        InputStream inputStream = url.openConnection().getInputStream();
        return inputStream;
    }

    private static InputStream tempFileUrl(URL url) throws MalformedURLException {
        TempFileCacheDownloadable downLoad = (TempFileCacheDownloadable)CacheFactory.getCommonCacheFactory().getTempFileCache();
        String[] queryParams = url.getQuery().split("&");
        HashMap downloadFileParams = Maps.newHashMapWithExpectedSize((int)16);
        for (String queryParam : queryParams) {
            String[] p = queryParam.split("=");
            downloadFileParams.put(p[0], p[1]);
        }
        TempFileCacheDownloadable.Content content = downLoad.get((String)downloadFileParams.get("configKey"), (String)downloadFileParams.get("id"));
        InputStream inStream = content.getInputStream();
        return inStream;
    }

    private static String uploadFile(InputStream bin, String fileName, String formId, String appId, Object pkId) {
        String path = "";
        FileService fileService = FileServiceFactory.getAttachmentFileService();
        RequestContext requestContext = RequestContext.get();
        String pathParam = FileNameUtils.getAttachmentFileName((String)requestContext.getTenantId(), (String)requestContext.getAccountId(), (String)appId, (String)formId, (Object)pkId, (String)fileName);
        FileItem item = new FileItem(fileName, pathParam, bin);
        path = fileService.upload(item);
        return path;
    }

    private static void handleParagraph(XWPFParagraph paragraph, Map<String, String> map, boolean isKeyWordNotEmpty, String keyWordDouble) {
        List runTmp = paragraph.getRuns();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < runTmp.size(); ++i) {
            try {
                String strTmp = ((XWPFRun)runTmp.get(i)).getText(0);
                if (null == strTmp) continue;
                stringBuilder.append(strTmp);
                int start = stringBuilder.indexOf("${");
                int end = stringBuilder.indexOf("}");
                if (start > -1 && end > -1) {
                    String replacement = HRWordUtils.replaceByRegex(map, stringBuilder);
                    ((XWPFRun)runTmp.get(i)).setText(replacement, 0);
                } else if (start > -1) {
                    ((XWPFRun)runTmp.get(i)).setText(stringBuilder.substring(0, start), 0);
                    stringBuilder.delete(0, start);
                } else if (stringBuilder.charAt(stringBuilder.length() - 1) == '$') {
                    ((XWPFRun)runTmp.get(i)).setText("", 0);
                } else {
                    ((XWPFRun)runTmp.get(i)).setText(stringBuilder.toString(), 0);
                    stringBuilder.setLength(0);
                }
                if (!isKeyWordNotEmpty || !strTmp.contains(keyWordDouble)) continue;
                HRWordUtils.handleKeyWord(paragraph, strTmp, keyWordDouble, i);
                continue;
            }
            catch (Exception exception) {
                try {
                    LOGGER.info("handleParagraph text=", (Object)((XWPFRun)runTmp.get(i)).getText(0));
                }
                catch (Exception exception1) {
                    LOGGER.error("handleParagraph exception11 ", (Throwable)exception);
                }
                LOGGER.error("handleParagraph exception ", (Throwable)exception);
            }
        }
        if (stringBuilder.length() != 0) {
            ((XWPFRun)runTmp.get(runTmp.size() - 1)).setText(stringBuilder.toString(), 0);
        }
    }

    private static String getReplacement(Map<String, String> valueMap, String key) {
        if (StringUtils.isEmpty((String)key)) {
            return "";
        }
        String value = valueMap.get(key);
        if (StringUtils.isNotEmpty((String)value)) {
            return value;
        }
        StringBuilder emptyStr = new StringBuilder();
        for (int i = 0; i < key.length(); ++i) {
            emptyStr.append(' ');
        }
        return emptyStr.toString();
    }

    private static String replaceByRegex(Map<String, String> map, StringBuilder remainingText) {
        Matcher matcher = TEXT_PTN.matcher(remainingText);
        int currentIndex = 0;
        while (matcher.find(currentIndex)) {
            String variableStr = matcher.group();
            int start = matcher.start();
            int end = matcher.end();
            int innerStartIndex = variableStr.indexOf("${", 1);
            String replacement = null;
            replacement = innerStartIndex == -1 ? HRWordUtils.getReplacement(map, variableStr) : variableStr.substring(0, innerStartIndex) + HRWordUtils.getReplacement(map, variableStr.substring(innerStartIndex));
            remainingText.replace(start, end, replacement);
            currentIndex = start + replacement.length();
        }
        StringBuilder sb = new StringBuilder(remainingText);
        int secondStartIndex = sb.indexOf("${", currentIndex);
        remainingText.setLength(0);
        if (secondStartIndex > -1 && sb.indexOf("}", secondStartIndex) == -1) {
            String lastText = sb.substring(secondStartIndex);
            remainingText.append(lastText);
            sb.delete(secondStartIndex, sb.length());
        } else if (sb.charAt(sb.length() - 1) == '$') {
            remainingText.append('$');
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }
}

