/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.common.encryptapi;

import com.alibaba.fastjson.JSONObject;
import java.io.Serializable;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.common.encryptapi.HrEncryptMServiceUtils;

public class HrEncryptApiRequest
implements Serializable {
    private static final Log log = LogFactory.getLog(HrEncryptApiRequest.class);
    private static final long serialVersionUID = 5717912452255677480L;
    private String cloudId;
    private String appId;
    private String serviceName;
    private String methodName;
    private Long encryptSchemeId;
    private boolean isEncrypt;
    private Object data;

    public HrEncryptApiRequest() {
    }

    public HrEncryptApiRequest(String cloudId, String appId, String serviceName, String methodName) {
        this.cloudId = cloudId;
        this.appId = appId;
        this.serviceName = serviceName;
        this.methodName = methodName;
        this.initEncryptInfo();
    }

    private void initEncryptInfo() {
        Long systemParamSchemeId = HrEncryptMServiceUtils.getSchemeIdFromSystemParam();
        if (systemParamSchemeId != 0L) {
            this.encryptSchemeId = systemParamSchemeId;
            this.isEncrypt = true;
        }
    }

    public String getCloudId() {
        return this.cloudId;
    }

    public void setCloudId(String cloudId) {
        this.cloudId = cloudId;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public Long getEncryptSchemeId() {
        return this.encryptSchemeId;
    }

    public void setEncryptSchemeId(Long encryptSchemeId) {
        this.encryptSchemeId = encryptSchemeId;
    }

    public Boolean getEncrypt() {
        return this.isEncrypt;
    }

    public void setEncryptData(Object dataObj) {
        if (this.isEncrypt && this.encryptSchemeId != null && this.encryptSchemeId != 0L) {
            if (dataObj == null) {
                return;
            }
            try {
                String dataStr = SerializationUtils.toJsonString((Object)dataObj);
                JSONObject jsonObject = PermissionServiceHelper.encryptData((long)this.encryptSchemeId, (String)dataStr);
                Boolean flag = jsonObject.getBoolean("success");
                if (!flag.booleanValue()) {
                    String message = jsonObject.getString("description");
                    log.error("HrEncryptApiRequest encryptData error :" + message);
                    throw new KDBizException(message);
                }
                this.data = jsonObject.getString("data");
            }
            catch (Exception e) {
                String message = e.getMessage();
                log.error("HrEncryptApiRequest encryptData exception error :" + message);
                throw new KDBizException(message);
            }
        } else {
            this.data = dataObj;
        }
    }

    public Object getDecryptData() {
        if (this.isEncrypt && this.encryptSchemeId != null && this.encryptSchemeId != 0L) {
            Object decryptData;
            if (this.data == null) {
                return null;
            }
            try {
                JSONObject jsonObject = PermissionServiceHelper.decryptData((long)this.encryptSchemeId, (String)this.data.toString());
                Boolean flag = jsonObject.getBoolean("success");
                if (!flag.booleanValue()) {
                    String message = jsonObject.getString("description");
                    log.error("HrEncryptApiRequest decryptData error :" + message);
                    throw new KDBizException(message);
                }
                String dataStr = jsonObject.getString("data");
                decryptData = SerializationUtils.fromJsonString((String)dataStr, Object.class);
            }
            catch (Exception e) {
                String message = e.getMessage();
                log.error("HrEncryptApiRequest decryptData exception error :" + message);
                throw new KDBizException(message);
            }
            return decryptData;
        }
        return this.data;
    }

    public String toString() {
        return "HrEncryptApiRequest{cloudId='" + this.cloudId + '\'' + ", appId='" + this.appId + '\'' + ", serviceName='" + this.serviceName + '\'' + ", methodName='" + this.methodName + '\'' + ", encryptSchemeId=" + this.encryptSchemeId + ", isEncrypt=" + this.isEncrypt + ", data=" + this.data + '}';
    }
}

