/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.common.log;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.logorm.LogORM;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.util.FileNameUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import org.apache.commons.io.FilenameUtils;

public class HRLogExportTask
extends AbstractTask {
    private static final Log LOGGER = LogFactory.getLog(HRLogExportTask.class);
    private static final String SPLIT_CHAR = ",";
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
    private final LogORM logORM = LogORM.create();
    private Random rand = null;

    public void execute(RequestContext requestContext, Map<String, Object> params) throws KDException {
        QFilter[] filters;
        this.feedbackProgress(5, ResManager.loadKDString((String)"\u521b\u5efa\u65e5\u5fd7\u4e0b\u8f7d\u4efb\u52a1", (String)"HRLogExportTask_0", (String)"hrmp-hbp-common", (Object[])new Object[0]), null);
        if (!(params.containsKey("selectFields") && params.containsKey("entityName") && params.containsKey("fileName") && params.containsKey("filterList"))) {
            throw new KDBizException("params miss,selectFields,entityName,filters,fileName");
        }
        String selectFields = (String)params.get("selectFields");
        String entityName = (String)params.get("entityName");
        String objFilters = (String)params.get("filterList");
        if (HRStringUtils.isEmpty(objFilters)) {
            filters = new QFilter[]{};
        } else {
            String[] filterStrs = objFilters.split(SPLIT_CHAR);
            filters = new QFilter[filterStrs.length];
            for (int idx = 0; idx < filterStrs.length; ++idx) {
                filters[idx] = QFilter.fromSerializedString((String)filterStrs[idx].trim());
            }
        }
        String fileName = (String)params.get("fileName");
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("success", "true");
        try {
            String path = this.export(entityName, selectFields, filters, fileName);
            result.put("path", path);
        }
        catch (IOException e) {
            result.put("success", "false");
            LOGGER.error((Throwable)e);
        }
        this.feedbackCustomdata(result);
    }

    private String export(String entityName, String selectFields, QFilter[] filters, String fileName) throws IOException {
        int count = this.logORM.count(entityName, filters);
        LOGGER.info("log message count:" + count);
        String path = count <= 2000 ? this.exportByMem(entityName, selectFields, filters, fileName) : this.exportByTemp(entityName, selectFields, filters, fileName, count);
        this.feedbackProgress(100, ResManager.loadKDString((String)"\u6587\u4ef6\u751f\u6210\u5b8c\u6210\uff0c\u6b63\u5728\u4e0b\u8f7d\u3002", (String)"HRLogExportTask_1", (String)"hrmp-hbp-common", (Object[])new Object[0]), null);
        return path;
    }

    private String exportByTemp(String entityName, String selectFields, QFilter[] filters, String fileName, int count) {
        File zipFile;
        File tempFile;
        FileOutputStream fos = null;
        ZipOutputStream zipOut = null;
        FileInputStream input = null;
        try {
            int temp;
            tempFile = File.createTempFile(FilenameUtils.getName((String)(fileName + sdf.format(new Date()))), ".txt");
            fos = new FileOutputStream(tempFile);
            StringBuilder sb = new StringBuilder();
            sb.append(selectFields).append("\r\n");
            String[] fields = selectFields.split(SPLIT_CHAR);
            int pageSize = 2000;
            for (int offset = 0; offset < count; offset += pageSize) {
                this.feedbackProgress(8 + offset * 50 / count, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u751f\u6210\u65e5\u5fd7\u6587\u4ef6(%1$s/%2$s)", (String)"HRLogExportTask_2", (String)"hrmp-hbp-common", (Object[])new Object[0]), offset, count), null);
                if (filters == null) {
                    LOGGER.error("the filter in exportByTemp is null!");
                    filters = new QFilter[]{};
                }
                DynamicObjectCollection dynObjects = this.logORM.query(entityName, selectFields, filters, pageSize, offset);
                for (DynamicObject dynObject : dynObjects) {
                    for (String field : fields) {
                        sb.append(dynObject.get(field.trim())).append(SPLIT_CHAR);
                    }
                    sb.append("\r\n");
                }
                fos.write(sb.toString().getBytes(StandardCharsets.UTF_8));
                fos.flush();
                sb.setLength(0);
            }
            this.feedbackProgress(60, ResManager.loadKDString((String)"\u65e5\u5fd7\u6587\u4ef6\u5df2\u751f\u6210\uff0c\u538b\u7f29\u6587\u4ef6\u751f\u6210\u6210\u529f\u3002", (String)"HRLogExportTask_3", (String)"hrmp-hbp-common", (Object[])new Object[0]), null);
            zipFile = File.createTempFile(FilenameUtils.getName((String)(fileName + sdf.format(new Date()))), ".zip");
            input = new FileInputStream(tempFile);
            zipOut = new ZipOutputStream(new FileOutputStream(zipFile));
            zipOut.putNextEntry(new ZipEntry(tempFile.getName()));
            zipOut.setComment("hr log file");
            while ((temp = ((InputStream)input).read()) != -1) {
                zipOut.write(temp);
            }
            this.closeFileResources(fos, zipOut, input);
        }
        catch (IOException e) {
            try {
                LOGGER.error((Throwable)e);
                throw new KDBizException("Download file error, IO error.");
            }
            catch (Throwable throwable) {
                this.closeFileResources(fos, zipOut, input);
                throw throwable;
            }
        }
        try {
            this.feedbackProgress(80, ResManager.loadKDString((String)"\u65e5\u5fd7\u6587\u4ef6\u5df2\u751f\u6210\uff0c\u4e0b\u8f7d\u94fe\u63a5\u5df2\u521b\u5efa\u3002", (String)"HRLogExportTask_4", (String)"hrmp-hbp-common", (Object[])new Object[0]), null);
            FileService fs = FileServiceFactory.getAttachmentFileService();
            String string = fs.upload(new FileItem(FilenameUtils.getName((String)fileName) + ".zip", this.getPath(FilenameUtils.getName((String)(fileName + this.getRandom(24))) + ".zip"), (InputStream)new FileInputStream(zipFile)));
            return string;
        }
        catch (FileNotFoundException e) {
            LOGGER.error((Throwable)e);
            throw new KDBizException("Download file error, file not found.");
        }
        finally {
            this.deleteTempFile(tempFile);
            this.deleteTempFile(zipFile);
        }
    }

    private void deleteTempFile(File tempFile) {
        if (tempFile != null && !tempFile.delete()) {
            LOGGER.warn("delete file error!");
        }
    }

    private String getRandom(int len) {
        if (this.rand == null) {
            try {
                this.rand = SecureRandom.getInstanceStrong();
            }
            catch (NoSuchAlgorithmException e) {
                LOGGER.error((Throwable)e);
                return "";
            }
        }
        StringBuilder rs = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            rs.append(this.rand.nextInt(10));
        }
        return rs.toString();
    }

    private void closeFileResources(FileOutputStream fos, ZipOutputStream zipOut, InputStream input) {
        try {
            if (fos != null) {
                fos.close();
            }
        }
        catch (IOException e) {
            LOGGER.error((Throwable)e);
        }
        try {
            if (input != null) {
                input.close();
            }
        }
        catch (IOException e) {
            LOGGER.error((Throwable)e);
        }
        try {
            if (zipOut != null) {
                zipOut.close();
            }
        }
        catch (IOException e) {
            LOGGER.error((Throwable)e);
        }
    }

    private String getPath(String fileName) {
        RequestContext requestContext = RequestContext.getOrCreate();
        String pathParam = FileNameUtils.getAttachmentFileName((String)requestContext.getTenantId(), (String)requestContext.getAccountId(), (String)"hbp", (String)"hbp_hrlogtemplate", (Object)"1", (String)fileName);
        return pathParam;
    }

    /*
     * Exception decompiling
     */
    private String exportByMem(String entityName, String selectFields, QFilter[] filters, String fileName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private ByteArrayInputStream parse(OutputStream out) {
        ByteArrayOutputStream baos = (ByteArrayOutputStream)out;
        return new ByteArrayInputStream(baos.toByteArray());
    }
}

