/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.common.log;

import java.util.concurrent.ConcurrentHashMap;
import kd.hr.hbp.common.log.HRLog;
import kd.hr.hbp.common.log.impl.HRLogORMImpl;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class HRLogFactory {
    private static final ConcurrentHashMap<String, HRLog> logMap = new ConcurrentHashMap();

    private HRLogFactory() {
    }

    public static HRLog getLog(String entityName, String className) {
        return HRLogFactory.getLogInstance(entityName, className);
    }

    public static HRLog getLog(String entityName, Class<?> clazz) {
        return HRLogFactory.getLogInstance(entityName, clazz.getName());
    }

    private static HRLog getLogInstance(String entityName, String className) {
        HRLog hrLogger = logMap.get(entityName + className);
        if (hrLogger == null) {
            hrLogger = new HRLogORMImpl(entityName, className);
            HRLog oldLogger = logMap.putIfAbsent(entityName + className, hrLogger);
            if (oldLogger != null) {
                return oldLogger;
            }
        }
        return hrLogger;
    }
}

