/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.common.log;

import java.io.Serializable;
import java.util.Map;
import kd.sdk.annotation.SdkPublic;
import org.apache.commons.collections.map.CaseInsensitiveMap;

@SdkPublic
public final class HRLogLevel
implements Serializable {
    private static final long serialVersionUID = 9198196511745135719L;
    public final int levelInt;
    public final String levelStr;
    public static final HRLogLevel OFF = new HRLogLevel(Integer.MAX_VALUE, "OFF");
    public static final HRLogLevel ERROR = new HRLogLevel(40000, "ERROR");
    public static final HRLogLevel WARN = new HRLogLevel(30000, "WARN");
    public static final HRLogLevel INFO = new HRLogLevel(20000, "INFO");
    public static final HRLogLevel DEBUG = new HRLogLevel(10000, "DEBUG");
    public static final HRLogLevel TRACE = new HRLogLevel(5000, "TRACE");
    public static final HRLogLevel ALL = new HRLogLevel(Integer.MIN_VALUE, "ALL");
    private static final Map<String, HRLogLevel> levelCaseInsenMap = new CaseInsensitiveMap(8);

    private HRLogLevel(int levelInt, String levelStr) {
        this.levelInt = levelInt;
        this.levelStr = levelStr;
    }

    public static HRLogLevel toLevel(String levelValue, HRLogLevel defaultLevel) {
        return levelValue == null ? defaultLevel : levelCaseInsenMap.getOrDefault(levelValue, defaultLevel);
    }

    public static HRLogLevel toLevel(String levelValue) {
        return HRLogLevel.toLevel(levelValue, INFO);
    }

    static {
        levelCaseInsenMap.put("OFF", OFF);
        levelCaseInsenMap.put("ERROR", ERROR);
        levelCaseInsenMap.put("WARN", WARN);
        levelCaseInsenMap.put("INFO", INFO);
        levelCaseInsenMap.put("DEBUG", DEBUG);
        levelCaseInsenMap.put("TRACE", TRACE);
        levelCaseInsenMap.put("ALL", ALL);
    }
}

