/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.common.log.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.id.ID;
import kd.bos.lang.Lang;
import kd.bos.logorm.LogORM;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.JobForm;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.threads.ThreadPools;
import kd.bos.trace.util.TraceIdUtil;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.hr.hbp.common.log.HRLog;
import kd.hr.hbp.common.log.HRLogLevel;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class HRLogORMImpl
implements HRLog {
    private static final String KEY_LOG_LEVEL = "_kd.hr.log.loglevel";
    private final String entityName;
    private final String className;
    private final LogORM logORM;
    private final HRLogLevel systemLogLevel;

    public HRLogORMImpl(String entityName, String className) {
        this.entityName = entityName;
        this.className = className;
        this.logORM = LogORM.create();
        String tenantId = RequestContext.get().getTenantId();
        String value = System.getProperty(tenantId + KEY_LOG_LEVEL);
        this.systemLogLevel = HRLogLevel.toLevel(value, HRLogLevel.INFO);
    }

    @Override
    public boolean isTraceEnabled() {
        return this.getCurrentHRLogLevel().levelInt <= HRLogLevel.TRACE.levelInt;
    }

    @Override
    public long trace(DynamicObject dynamicObject) {
        return this.insert(dynamicObject, HRLogLevel.TRACE);
    }

    @Override
    public long trace(String message, String processId, String processType) {
        return this.insert(message, processId, processType, HRLogLevel.TRACE);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.getCurrentHRLogLevel().levelInt <= HRLogLevel.DEBUG.levelInt;
    }

    @Override
    public long debug(DynamicObject dynamicObject) {
        return this.insert(dynamicObject, HRLogLevel.DEBUG);
    }

    @Override
    public long debug(String message, String processId, String processType) {
        return this.insert(message, processId, processType, HRLogLevel.DEBUG);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.getCurrentHRLogLevel().levelInt <= HRLogLevel.INFO.levelInt;
    }

    @Override
    public long info(DynamicObject dynamicObject) {
        return this.insert(dynamicObject, HRLogLevel.INFO);
    }

    @Override
    public long info(String message, String processId, String processType) {
        return this.insert(message, processId, processType, HRLogLevel.INFO);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.getCurrentHRLogLevel().levelInt <= HRLogLevel.WARN.levelInt;
    }

    @Override
    public long warn(DynamicObject dynamicObject) {
        return this.insert(dynamicObject, HRLogLevel.WARN);
    }

    @Override
    public long warn(String message, String processId, String processType) {
        return this.insert(message, processId, processType, HRLogLevel.WARN);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.getCurrentHRLogLevel().levelInt <= HRLogLevel.ERROR.levelInt;
    }

    @Override
    public long error(DynamicObject dynamicObject) {
        return this.insert(dynamicObject, HRLogLevel.ERROR);
    }

    @Override
    public long error(String message, String processId, String processType) {
        return this.insert(message, processId, processType, HRLogLevel.ERROR);
    }

    @Override
    public DynamicObject getDynamicObject() {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)this.entityName);
        DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)entityType);
        dynamicObject.getDataEntityType().getPrimaryKey().setValueFast((Object)dynamicObject, (Object)ID.genLongId());
        dynamicObject.set("classname", (Object)this.className);
        return dynamicObject;
    }

    @Override
    public HRLogLevel getCurrentHRLogLevel() {
        long userid = RequestContext.get().getCurrUserId();
        String logLevel = (String)HRAppCache.get("HBSS").get("hrloglevel-" + userid, String.class);
        if (logLevel != null) {
            return HRLogLevel.toLevel(logLevel);
        }
        return this.systemLogLevel;
    }

    @Override
    public DynamicObjectCollection query(String selectFields, QFilter[] filters, int limit, int offset) {
        return this.logORM.query(this.entityName, selectFields, filters, limit, offset);
    }

    @Override
    public DataSet queryDataSet(String selectFields, QFilter[] filters, int limit, int offset) {
        return this.logORM.queryDataSet(this.entityName, selectFields, filters, limit, offset);
    }

    @Override
    public int count(QFilter[] filters) {
        return this.logORM.count(this.entityName, filters);
    }

    private JobInfo getJobInfo(String fileName) {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setRunByLang(Lang.get());
        jobInfo.setAppId("hbp");
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setName(ResManager.loadKDString((String)"\u65e5\u5fd7\u4e0b\u8f7d[%s]", (String)"HRLogORMImpl_1", (String)"hrmp-hbp-common", (Object[])new Object[]{fileName}));
        jobInfo.setTaskClassname("kd.hr.hbp.common.log.HRLogExportTask");
        jobInfo.setId(UUID.randomUUID().toString());
        jobInfo.setRunByUserId(Long.parseLong(RequestContext.get().getUserId()));
        return jobInfo;
    }

    @Override
    public void export(AbstractFormPlugin plugin, String exportActionId, String selectFields, QFilter[] filters, String fileName) {
        if (plugin == null || kd.bos.util.StringUtils.isEmpty((String)exportActionId) || kd.bos.util.StringUtils.isEmpty((String)selectFields) || kd.bos.util.StringUtils.isEmpty((String)fileName)) {
            return;
        }
        JobInfo jobInfo = this.getJobInfo(fileName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("selectFields", selectFields);
        params.put("entityName", this.entityName);
        StringBuilder serialFilter = new StringBuilder();
        if (filters != null && filters.length > 0) {
            Arrays.stream(filters).forEach(obj -> {
                if (serialFilter.length() > 0) {
                    serialFilter.append(",").append(obj.toSerializedString());
                } else {
                    serialFilter.append(obj.toSerializedString());
                }
            });
        }
        params.put("filterList", serialFilter.toString());
        params.put("fileName", fileName);
        jobInfo.setParams(params);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)plugin, exportActionId);
        JobFormInfo jobFormInfo = new JobFormInfo(jobInfo);
        jobFormInfo.setCaption(ResManager.loadKDString((String)"HR\u65e5\u5fd7\u5bfc\u51fa", (String)"HRLogORMImpl_0", (String)"hrmp-hbp-common", (Object[])new Object[0]));
        jobFormInfo.setCloseCallBack(closeCallBack);
        jobFormInfo.setCanBackground(true);
        jobFormInfo.setCanStop(true);
        jobFormInfo.setClickClassName("kd.hr.hbp.common.log.HRLogExportTaskClick");
        JobForm.dispatch((JobFormInfo)jobFormInfo, (IFormView)plugin.getView());
    }

    @Override
    public void exportCallBack(ClosedCallBackEvent closedCallBackEvent, IFormView formView) {
        TaskInfo taskInfo;
        String taskInfoStr;
        Map result;
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData == null) {
            return;
        }
        if (returnData instanceof Map && (result = (Map)returnData).containsKey("taskinfo") && StringUtils.isNotBlank((CharSequence)(taskInfoStr = (String)result.get("taskinfo"))) && (taskInfo = (TaskInfo)SerializationUtils.fromJsonString((String)taskInfoStr, TaskInfo.class)).isTaskEnd()) {
            String data = taskInfo.getData();
            HashMap resultMap = (HashMap)SerializationUtils.fromJsonString((String)data, HashMap.class);
            formView.download(RequestContext.get().getClientFullContextPath() + "/attachment/download.do?path=" + resultMap.get("path"));
        }
    }

    private static List<DynamicObject> objToList(DynamicObject dy) {
        ArrayList list = Lists.newArrayListWithExpectedSize((int)2);
        list.add(dy);
        return list;
    }

    private long insert(DynamicObject dynamicObject, HRLogLevel logLevel) {
        if (dynamicObject != null) {
            long[] logIds;
            if (kd.bos.util.StringUtils.isEmpty((String)dynamicObject.getString("loglevel"))) {
                dynamicObject.set("loglevel", (Object)logLevel.levelStr);
            }
            return (logIds = this.insert(HRLogORMImpl.objToList(dynamicObject))).length > 0 ? logIds[0] : -1L;
        }
        return -1L;
    }

    private long insert(String message, String processId, String processType, HRLogLevel logLevel) {
        long[] logIds;
        DynamicObject dynamicObject = this.getDynamicObject();
        dynamicObject.set("logmessage", (Object)message);
        dynamicObject.set("processid", (Object)processId);
        dynamicObject.set("processtype", (Object)processType);
        if (kd.bos.util.StringUtils.isEmpty((String)dynamicObject.getString("loglevel"))) {
            dynamicObject.set("loglevel", (Object)logLevel.levelStr);
        }
        return (logIds = this.insert(HRLogORMImpl.objToList(dynamicObject))).length > 0 ? logIds[0] : -1L;
    }

    private long[] insert(List<DynamicObject> list) {
        String traceId = HRLogORMImpl.getCurrentTraceIdString();
        String userName = RequestContext.get().getUserName();
        List<Object> finalList = list = list.stream().peek(dy -> {
            if (kd.bos.util.StringUtils.isEmpty((String)dy.getString("logid"))) {
                dy.set("logid", (Object)traceId);
            }
            if (kd.bos.util.StringUtils.isEmpty((String)dy.getString("username"))) {
                dy.set("username", (Object)userName);
            }
        }).collect(Collectors.toList());
        ThreadPools.executeOnce((String)"ThreadForHRLog", () -> this.logORM.insert(finalList));
        long[] results = new long[list.size()];
        for (int idx = 0; idx < list.size(); ++idx) {
            results[idx] = ((DynamicObject)list.get(idx)).getLong("id");
        }
        return results;
    }

    private static String getCurrentTraceIdString() {
        return TraceIdUtil.getCurrentTraceIdString();
    }
}

