/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.common.model.complexobj;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.model.complexobj.HRComplexObjContext;
import kd.hr.hbp.common.model.complexobj.HRComplexObjFieldInfo;
import kd.hr.hbp.common.model.complexobj.HRComplexObjJoinRelation;
import kd.hr.hbp.common.model.complexobj.SortFieldInfo;
import kd.hr.hbp.common.util.HRStringUtils;

public class HRComplexObjContextOptimizer {
    public static void optimize(HRComplexObjContext complexObjContext) {
        if (complexObjContext.getVirtualEntity().booleanValue()) {
            return;
        }
        Set<String> queryUsedEntityAliasSet = HRComplexObjContextOptimizer.getQueryUsedEntityAliasSet(complexObjContext);
        if (queryUsedEntityAliasSet.size() < complexObjContext.getJoinRelationList().size()) {
            List<HRComplexObjJoinRelation> queryUsedJoinRelationList = HRComplexObjContextOptimizer.getQueryUsedJoinRelationList(complexObjContext, queryUsedEntityAliasSet);
            complexObjContext.setJoinRelationList(queryUsedJoinRelationList);
        }
    }

    public static Set<String> getJoinEntityAliasSet(HRComplexObjContext complexObjContext) {
        HashSet entityAliasSet = Sets.newHashSetWithExpectedSize((int)16);
        List<HRComplexObjJoinRelation> srcJoinRelationList = complexObjContext.getJoinRelationList();
        for (HRComplexObjJoinRelation joinRelation : srcJoinRelationList) {
            if (HRStringUtils.isEmpty(joinRelation.getRelEntityLongNumber()) || !Objects.nonNull(joinRelation.getRelEntityAlias())) continue;
            entityAliasSet.add(joinRelation.getRelEntityAlias());
        }
        return entityAliasSet;
    }

    private static Set<String> getQueryUsedEntityAliasSet(HRComplexObjContext complexObjContext) {
        Set<String> joinEntityAliasSet = HRComplexObjContextOptimizer.getJoinEntityAliasSet(complexObjContext);
        HashSet queryUsedEntityPropAliasSet = Sets.newHashSetWithExpectedSize((int)16);
        List<QFilter> qFilterList = complexObjContext.getQfilterList();
        for (QFilter qFilter : qFilterList) {
            String propAlias2 = qFilter.getProperty();
            if (propAlias2.equals("1")) continue;
            HRComplexObjContextOptimizer.getFilterEntitySet(queryUsedEntityPropAliasSet, qFilter, joinEntityAliasSet);
        }
        List<HRComplexObjFieldInfo> complexObjFieldInfoList = complexObjContext.getComplexObjFieldInfoList();
        complexObjFieldInfoList.stream().filter(objFieldInfo -> Objects.nonNull(HRComplexObjContextOptimizer.getJoinEntityPropEntityAlias(objFieldInfo.getAlias(), joinEntityAliasSet))).forEach(fieldInfo -> queryUsedEntityPropAliasSet.add(fieldInfo.getAlias()));
        List<SortFieldInfo> sortFieldInfoList = complexObjContext.getSortFieldInfoList();
        sortFieldInfoList.stream().filter(objFieldInfo -> Objects.nonNull(HRComplexObjContextOptimizer.getJoinEntityPropEntityAlias(objFieldInfo.getFieldAlias(), joinEntityAliasSet))).forEach(sortFieldInfo -> queryUsedEntityPropAliasSet.add(sortFieldInfo.getFieldAlias()));
        Set<String> queryEntityAliasSet = queryUsedEntityPropAliasSet.stream().filter(propAlias -> Objects.nonNull(HRComplexObjContextOptimizer.getJoinEntityPropEntityAlias(propAlias, joinEntityAliasSet))).map(propAlias -> HRComplexObjContextOptimizer.getJoinEntityPropEntityAlias(propAlias, joinEntityAliasSet)).collect(Collectors.toSet());
        complexObjContext.getJoinRelationList().forEach(joinRelation -> {
            if ("InnerJoin".equals(joinRelation.getJoinType())) {
                queryEntityAliasSet.add(joinRelation.getRelEntityAlias());
            }
        });
        return queryEntityAliasSet;
    }

    private static String getJoinEntityPropEntityAlias(String propAlias, Set<String> joinEntityAliasSet) {
        String entityAlias;
        String joinEntityAlias = null;
        if (propAlias.indexOf(".") > 0 && joinEntityAliasSet.contains(entityAlias = propAlias.substring(0, propAlias.indexOf(".")))) {
            joinEntityAlias = entityAlias;
        }
        return joinEntityAlias;
    }

    private static List<HRComplexObjJoinRelation> getQueryUsedJoinRelationList(HRComplexObjContext complexObjContext, Set<String> queryUsedEntityAliasSet) {
        HashMap entityAliasLongNumberMap = Maps.newHashMapWithExpectedSize((int)16);
        List<HRComplexObjJoinRelation> srcJoinRelationList = complexObjContext.getJoinRelationList();
        for (HRComplexObjJoinRelation joinRelation : srcJoinRelationList) {
            if (HRStringUtils.isEmpty(joinRelation.getRelEntityLongNumber()) || !queryUsedEntityAliasSet.contains(joinRelation.getRelEntityAlias())) continue;
            entityAliasLongNumberMap.put(joinRelation.getRelEntityAlias(), joinRelation.getRelEntityLongNumber());
        }
        ArrayList<HRComplexObjJoinRelation> queryUsedJoinRelationList = new ArrayList<HRComplexObjJoinRelation>();
        HashSet longNumberSet = Sets.newHashSetWithExpectedSize((int)16);
        for (Map.Entry<String, String> entry : entityAliasLongNumberMap.entrySet()) {
            for (HRComplexObjJoinRelation joinRelation : srcJoinRelationList) {
                if (!HRComplexObjContextOptimizer.isQueryUsedEntity(joinRelation, entry) || longNumberSet.contains(joinRelation.getRelEntityLongNumber())) continue;
                longNumberSet.add(joinRelation.getRelEntityLongNumber());
                queryUsedJoinRelationList.add(joinRelation);
            }
        }
        return queryUsedJoinRelationList;
    }

    private static boolean isQueryUsedEntity(HRComplexObjJoinRelation joinRelation, Map.Entry<String, String> entry) {
        String relEntityAlias = entry.getKey();
        String relLongNumber = entry.getValue();
        return relEntityAlias.equals(joinRelation.getRelEntityAlias()) || relLongNumber.startsWith(joinRelation.getRelEntityLongNumber() + "!");
    }

    private static void getFilterEntitySet(Set<String> queryEntityPropSet, QFilter qFilter, Set<String> joinEntityAliasSet) {
        for (QFilter.QFilterNest qFilterNest : qFilter.getNests(true)) {
            QFilter subFilter = qFilterNest.getFilter();
            String propEntityAlias = HRComplexObjContextOptimizer.getJoinEntityPropEntityAlias(subFilter.getProperty(), joinEntityAliasSet);
            if (joinEntityAliasSet.contains(propEntityAlias)) {
                queryEntityPropSet.add(subFilter.getProperty());
            }
            HRComplexObjContextOptimizer.getFilterEntitySet(queryEntityPropSet, subFilter, joinEntityAliasSet);
        }
    }
}

