/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.common.model.report;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TimeZone;
import kd.bos.dataentity.resource.ResManager;
import kd.hr.hbp.common.model.report.DayTypeEnum;
import kd.hr.hbp.common.model.report.MonthTypeEnum;
import kd.hr.hbp.common.model.report.QuarterTypeEnum;
import kd.hr.hbp.common.model.report.SplitDateTypeEnum;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class DateTransUtils {
    private static final String YYYY = "yyyy";
    private static final String MM = "MM";
    private static final String YYYY_MM = "yyyy-MM";
    private static final String DD = "dd";
    private static final String MM_DD = "MM-dd";
    private static final String YYYY_MM_DD = "yyyy-MM-dd";
    private static final String QUARTER_KET_PREFIX = "Q";
    public static final Set<String> QUICK_SHOW_ALL_VALUE_SPLIT_TYPE = Sets.newHashSet((Object[])new String[]{SplitDateTypeEnum.SN_QUARTER.getKey(), SplitDateTypeEnum.FN_QUARTER.getKey(), SplitDateTypeEnum.SN_MONTH.getKey(), SplitDateTypeEnum.FN_MONTH.getKey(), SplitDateTypeEnum.SN_DAY.getKey(), SplitDateTypeEnum.FN_DAY.getKey()});

    public static List<String> getAllDate(String type) {
        if (SplitDateTypeEnum.SN_QUARTER.getKey().equals(type)) {
            return QuarterTypeEnum.getAllEnumData(true);
        }
        if (SplitDateTypeEnum.FN_QUARTER.getKey().equals(type)) {
            return QuarterTypeEnum.getAllEnumData(false);
        }
        if (SplitDateTypeEnum.SN_MONTH.getKey().equals(type)) {
            return MonthTypeEnum.getAllEnumData(true);
        }
        if (SplitDateTypeEnum.FN_MONTH.getKey().equals(type)) {
            return MonthTypeEnum.getAllEnumData(false);
        }
        if (SplitDateTypeEnum.SN_DAY.getKey().equals(type)) {
            return DayTypeEnum.getAllEnumData(true);
        }
        if (SplitDateTypeEnum.FN_DAY.getKey().equals(type)) {
            return DayTypeEnum.getAllEnumData(false);
        }
        return Lists.newArrayListWithExpectedSize((int)0);
    }

    public static String transferDate(Date date, String type, TimeZone timeZone) {
        if (date == null || HRStringUtils.isEmpty(type)) {
            return null;
        }
        if (SplitDateTypeEnum.SN_YEAR.getKey().equals(type)) {
            return DateTransUtils.toYear(date, timeZone);
        }
        if (SplitDateTypeEnum.FN_YEAR.getKey().equals(type)) {
            return DateTransUtils.toFullYear(date, timeZone);
        }
        if (SplitDateTypeEnum.SN_QUARTER.getKey().equals(type)) {
            return DateTransUtils.toQuarter(date, timeZone);
        }
        if (SplitDateTypeEnum.FN_QUARTER.getKey().equals(type)) {
            return DateTransUtils.toFullQuarter(date, timeZone);
        }
        if (SplitDateTypeEnum.SN_YEAR_QUARTER.getKey().equals(type)) {
            return DateTransUtils.toYearQuarter(date, timeZone);
        }
        if (SplitDateTypeEnum.FN_YEAR_QUARTER.getKey().equals(type)) {
            return DateTransUtils.toFullYearQuarter(date, timeZone);
        }
        if (SplitDateTypeEnum.SN_MONTH.getKey().equals(type)) {
            return DateTransUtils.toMonth(date, timeZone);
        }
        if (SplitDateTypeEnum.FN_MONTH.getKey().equals(type)) {
            return DateTransUtils.toFullMonth(date, timeZone);
        }
        if (SplitDateTypeEnum.SN_YEAR_MONTH.getKey().equals(type)) {
            return DateTransUtils.toYearMonth(date, timeZone);
        }
        if (SplitDateTypeEnum.FN_YEAR_MONTH.getKey().equals(type)) {
            return DateTransUtils.toFullYearMonth(date, timeZone);
        }
        if (SplitDateTypeEnum.SN_DAY.getKey().equals(type)) {
            return DateTransUtils.toDay(date, timeZone);
        }
        if (SplitDateTypeEnum.FN_DAY.getKey().equals(type)) {
            return DateTransUtils.toFullDay(date, timeZone);
        }
        if (SplitDateTypeEnum.FN_YEAR_MONTH_DAY.getKey().equals(type)) {
            return DateTransUtils.toFullYearMonthDay(date, timeZone);
        }
        return null;
    }

    public static Object transferDateToDbVal(Date date, String type, TimeZone timeZone) {
        if (date == null || HRStringUtils.isEmpty(type)) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        if (SplitDateTypeEnum.SN_YEAR.getKey().equals(type) || SplitDateTypeEnum.FN_YEAR.getKey().equals(type)) {
            return calendar.get(1);
        }
        if (SplitDateTypeEnum.SN_QUARTER.getKey().equals(type) || SplitDateTypeEnum.FN_QUARTER.getKey().equals(type)) {
            return DateTransUtils.getQuarter(calendar);
        }
        if (SplitDateTypeEnum.SN_YEAR_QUARTER.getKey().equals(type) || SplitDateTypeEnum.FN_YEAR_QUARTER.getKey().equals(type)) {
            return calendar.get(1) + "-" + DateTransUtils.getQuarter(calendar);
        }
        if (SplitDateTypeEnum.SN_MONTH.getKey().equals(type) || SplitDateTypeEnum.FN_MONTH.getKey().equals(type)) {
            return calendar.get(2) + 1;
        }
        if (SplitDateTypeEnum.SN_YEAR_MONTH.getKey().equals(type) || SplitDateTypeEnum.FN_YEAR_MONTH.getKey().equals(type)) {
            return DateTransUtils.toYearMonth(date, timeZone);
        }
        if (SplitDateTypeEnum.SN_DAY.getKey().equals(type) || SplitDateTypeEnum.FN_DAY.getKey().equals(type)) {
            return calendar.get(5);
        }
        if (SplitDateTypeEnum.FN_YEAR_MONTH_DAY.getKey().equals(type)) {
            return DateTransUtils.toYearMonthDay(date, timeZone);
        }
        return null;
    }

    public static Object dateDbValFormat(String dateObj, String type) {
        if (Objects.isNull(dateObj) || HRStringUtils.isEmpty(type) || "null".equals(dateObj)) {
            return null;
        }
        if (SplitDateTypeEnum.SN_YEAR.getKey().equals(type)) {
            return dateObj;
        }
        if (SplitDateTypeEnum.FN_YEAR.getKey().equals(type)) {
            return DateTransUtils.getFullYear(dateObj);
        }
        if (SplitDateTypeEnum.SN_QUARTER.getKey().equals(type)) {
            return QUARTER_KET_PREFIX + dateObj;
        }
        if (SplitDateTypeEnum.FN_QUARTER.getKey().equals(type)) {
            return DateTransUtils.getFullQuarter(QUARTER_KET_PREFIX + dateObj);
        }
        if (SplitDateTypeEnum.SN_YEAR_QUARTER.getKey().equals(type)) {
            return dateObj.replace("-", "-Q");
        }
        if (SplitDateTypeEnum.FN_YEAR_QUARTER.getKey().equals(type)) {
            String[] split = dateObj.split("-");
            return DateTransUtils.getFullYear(split[0]) + DateTransUtils.getFullQuarter(QUARTER_KET_PREFIX + split[1]);
        }
        if (SplitDateTypeEnum.SN_MONTH.getKey().equals(type)) {
            int integer = Integer.parseInt(dateObj);
            if (integer < 10) {
                return "0" + dateObj;
            }
            return dateObj;
        }
        if (SplitDateTypeEnum.FN_MONTH.getKey().equals(type)) {
            int integer = Integer.parseInt(dateObj);
            if (integer < 10) {
                dateObj = "0" + dateObj;
            }
            return DateTransUtils.getFullMonth(dateObj);
        }
        if (SplitDateTypeEnum.SN_YEAR_MONTH.getKey().equals(type)) {
            return dateObj;
        }
        if (SplitDateTypeEnum.FN_YEAR_MONTH.getKey().equals(type)) {
            String[] split = dateObj.split("-");
            return DateTransUtils.getFullYear(split[0]) + DateTransUtils.getFullMonth(split[1]);
        }
        if (SplitDateTypeEnum.SN_DAY.getKey().equals(type)) {
            int integer = Integer.parseInt(dateObj);
            if (integer < 10) {
                return "0" + dateObj;
            }
            return dateObj;
        }
        if (SplitDateTypeEnum.FN_DAY.getKey().equals(type)) {
            int integer = Integer.parseInt(dateObj);
            if (integer < 10) {
                dateObj = "0" + dateObj;
            }
            return DateTransUtils.getFullDay(dateObj);
        }
        if (SplitDateTypeEnum.FN_YEAR_MONTH_DAY.getKey().equals(type)) {
            return dateObj;
        }
        return null;
    }

    public static String transferKey(String key, String type) {
        if (HRStringUtils.isEmpty(key) || HRStringUtils.isEmpty(type)) {
            return null;
        }
        if (SplitDateTypeEnum.SN_YEAR.getKey().equals(type)) {
            return key;
        }
        if (SplitDateTypeEnum.FN_YEAR.getKey().equals(type)) {
            return MessageFormat.format(ResManager.loadKDString((String)"{0}\u5e74", (String)"DateTransUtils_01", (String)"hrmp-hbp-common", (Object[])new Object[0]), key);
        }
        if (SplitDateTypeEnum.SN_QUARTER.getKey().equals(type)) {
            return key;
        }
        if (SplitDateTypeEnum.FN_QUARTER.getKey().equals(type)) {
            return QuarterTypeEnum.getEnum(key);
        }
        if (SplitDateTypeEnum.SN_YEAR_QUARTER.getKey().equals(type)) {
            return key;
        }
        if (SplitDateTypeEnum.FN_YEAR_QUARTER.getKey().equals(type)) {
            return key;
        }
        if (SplitDateTypeEnum.SN_MONTH.getKey().equals(type)) {
            return key;
        }
        if (SplitDateTypeEnum.FN_MONTH.getKey().equals(type)) {
            return MonthTypeEnum.getEnum(key);
        }
        if (SplitDateTypeEnum.SN_YEAR_MONTH.getKey().equals(type)) {
            return key;
        }
        if (SplitDateTypeEnum.FN_YEAR_MONTH.getKey().equals(type)) {
            return key;
        }
        if (SplitDateTypeEnum.SN_DAY.getKey().equals(type)) {
            return key;
        }
        if (SplitDateTypeEnum.FN_DAY.getKey().equals(type)) {
            return DayTypeEnum.getEnum(key);
        }
        if (SplitDateTypeEnum.FN_YEAR_MONTH_DAY.getKey().equals(type)) {
            return key;
        }
        return null;
    }

    public static String toYear(Date date, TimeZone timeZone) {
        if (date == null) {
            return null;
        }
        return HRDateTimeUtils.format(date, YYYY, timeZone);
    }

    public static String toFullYear(Date date, TimeZone timeZone) {
        String year = DateTransUtils.toYear(date, timeZone);
        return DateTransUtils.getFullYear(year);
    }

    public static String getFullYear(String year) {
        if (HRStringUtils.isEmpty(year)) {
            return null;
        }
        return MessageFormat.format(ResManager.loadKDString((String)"{0}\u5e74", (String)"DateTransUtils_01", (String)"hrmp-hbp-common", (Object[])new Object[0]), year);
    }

    public static String toMonth(Date date, TimeZone timeZone) {
        if (date == null) {
            return null;
        }
        return HRDateTimeUtils.format(date, MM, timeZone);
    }

    public static String toFullMonth(Date date, TimeZone timeZone) {
        String month = DateTransUtils.toMonth(date, timeZone);
        return DateTransUtils.getFullMonth(month);
    }

    public static String getFullMonth(String month) {
        if (HRStringUtils.isEmpty(month)) {
            return null;
        }
        return MonthTypeEnum.getEnum(month);
    }

    public static String toQuarter(Date date, TimeZone timeZone) {
        QuarterTypeEnum quarter;
        String month = DateTransUtils.toMonth(date, timeZone);
        if (month == null || HRStringUtils.isEmpty(month)) {
            return null;
        }
        switch (month) {
            case "01": 
            case "02": 
            case "03": {
                quarter = QuarterTypeEnum.Q1;
                break;
            }
            case "04": 
            case "05": 
            case "06": {
                quarter = QuarterTypeEnum.Q2;
                break;
            }
            case "07": 
            case "08": 
            case "09": {
                quarter = QuarterTypeEnum.Q3;
                break;
            }
            case "10": 
            case "11": 
            case "12": {
                quarter = QuarterTypeEnum.Q4;
                break;
            }
            default: {
                return null;
            }
        }
        return quarter.getValue();
    }

    public static int getQuarter(Calendar calendar) {
        int month = calendar.get(2) + 1;
        int quarter = month <= 3 ? 1 : (month <= 6 ? 2 : (month <= 9 ? 3 : 4));
        return quarter;
    }

    public static String toFullQuarter(Date date, TimeZone timeZone) {
        String quarter = DateTransUtils.toQuarter(date, timeZone);
        return DateTransUtils.getFullQuarter(quarter);
    }

    public static String getFullQuarter(String quarter) {
        if (HRStringUtils.isEmpty(quarter)) {
            return null;
        }
        return QuarterTypeEnum.getEnum(quarter);
    }

    public static String toYearQuarter(Date date, TimeZone timeZone) {
        String year = DateTransUtils.toYear(date, timeZone);
        String quarter = DateTransUtils.toQuarter(date, timeZone);
        if (HRStringUtils.isEmpty(year) || HRStringUtils.isEmpty(quarter)) {
            return null;
        }
        return year + "-" + quarter;
    }

    public static String toFullYearQuarter(Date date, TimeZone timeZone) {
        String year = DateTransUtils.toFullYear(date, timeZone);
        String quarter = DateTransUtils.toFullQuarter(date, timeZone);
        if (HRStringUtils.isEmpty(year) || HRStringUtils.isEmpty(quarter)) {
            return null;
        }
        return year + quarter;
    }

    public static String toYearMonth(Date date, TimeZone timeZone) {
        if (date == null) {
            return null;
        }
        return HRDateTimeUtils.format(date, YYYY_MM, timeZone);
    }

    public static String toFullYearMonth(Date date, TimeZone timeZone) {
        String year = DateTransUtils.toFullYear(date, timeZone);
        String month = DateTransUtils.toFullMonth(date, timeZone);
        if (HRStringUtils.isEmpty(year) || HRStringUtils.isEmpty(month)) {
            return null;
        }
        return year + month;
    }

    public static String toDay(Date date, TimeZone timeZone) {
        if (date == null) {
            return null;
        }
        return HRDateTimeUtils.format(date, DD, timeZone);
    }

    public static String toFullDay(Date date, TimeZone timeZone) {
        String day = DateTransUtils.toDay(date, timeZone);
        return DateTransUtils.getFullDay(day);
    }

    public static String getFullDay(String day) {
        if (HRStringUtils.isEmpty(day)) {
            return null;
        }
        return DayTypeEnum.getEnum(day);
    }

    public static String toMonthDay(Date date, TimeZone timeZone) {
        if (date == null) {
            return null;
        }
        return HRDateTimeUtils.format(date, MM_DD, timeZone);
    }

    public static String toFullMonthDay(Date date, TimeZone timeZone) {
        String month = DateTransUtils.toFullMonth(date, timeZone);
        String day = DateTransUtils.toFullDay(date, timeZone);
        if (HRStringUtils.isEmpty(month) || HRStringUtils.isEmpty(day)) {
            return null;
        }
        return month + day;
    }

    public static String toYearMonthDay(Date date, TimeZone timeZone) {
        if (date == null) {
            return null;
        }
        return HRDateTimeUtils.format(date, YYYY_MM_DD, timeZone);
    }

    public static String toFullYearMonthDay(Date date, TimeZone timeZone) {
        String year = DateTransUtils.toFullYear(date, timeZone);
        String month = DateTransUtils.toFullMonth(date, timeZone);
        String day = DateTransUtils.toFullDay(date, timeZone);
        if (HRStringUtils.isEmpty(year) || HRStringUtils.isEmpty(month) || HRStringUtils.isEmpty(day)) {
            return null;
        }
        return year + month + day;
    }
}

