/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.common.model.ruleengine;

import java.util.List;
import java.util.Map;
import kd.hr.hbp.common.model.ruleengine.PolicyResult;
import kd.hr.hbp.common.model.ruleengine.RowResult;
import kd.hr.hbp.common.model.ruleengine.RuleResult;
import kd.hr.hbp.common.model.ruleengine.SceneResult;
import kd.hr.hbp.common.util.HRStringUtils;

public class RuleEngineResponseUtils {
    public static SceneResult transferToSceneResult(Map<String, Object> respMap) {
        SceneResult sceneResult = new SceneResult();
        RuleEngineResponseUtils.processBasicInfo(sceneResult, respMap);
        RuleEngineResponseUtils.processPolicyResults(sceneResult, respMap);
        return sceneResult;
    }

    private static void processPolicyResults(SceneResult sceneResult, Map<String, Object> respMap) {
        List policyMapList = (List)respMap.get("policyResults");
        if (policyMapList == null || policyMapList.isEmpty()) {
            return;
        }
        List<PolicyResult> policyResultsVOList = sceneResult.getPolicyResults();
        policyMapList.forEach(policyMap -> {
            PolicyResult policyResultVO = new PolicyResult();
            policyResultVO.setPolicyId(Long.parseLong((String)policyMap.get("policyId")));
            policyResultVO.setPolicyNumber((String)policyMap.get("policyNumber"));
            policyResultVO.setPolicyMode((String)policyMap.get("policyMode"));
            RuleEngineResponseUtils.processSinglePolicyResult(policyResultVO, policyMap);
            policyResultsVOList.add(policyResultVO);
        });
    }

    private static void processSinglePolicyResult(PolicyResult policyResultVO, Map<String, Object> policyMap) {
        List ruleResultsMapList;
        Map defaultResults;
        Map rosterResults = (Map)policyMap.get("rosterResults");
        if (rosterResults != null && !rosterResults.isEmpty()) {
            policyResultVO.setRosterResults(rosterResults);
        }
        if ((defaultResults = (Map)policyMap.get("defaultResults")) != null && !defaultResults.isEmpty()) {
            policyResultVO.setDefaultResults(defaultResults);
        }
        if ((ruleResultsMapList = (List)policyMap.get("ruleResults")) != null && !ruleResultsMapList.isEmpty()) {
            List<RuleResult> ruleResultsVOList = policyResultVO.getRuleResults();
            ruleResultsMapList.forEach(ruleResultsMap -> {
                RuleResult ruleResultVO = new RuleResult();
                ruleResultVO.setRuleDesignId(Long.valueOf((String)ruleResultsMap.get("ruleDesignId")));
                ruleResultVO.setRuleNumber((String)ruleResultsMap.get("ruleNumber"));
                Map matchResults = (Map)ruleResultsMap.get("matchResults");
                if (matchResults != null && !matchResults.isEmpty()) {
                    ruleResultVO.setMatchResults(matchResults);
                }
                ruleResultsVOList.add(ruleResultVO);
            });
        }
    }

    private static void buildFieldResult(List<Map<String, Object>> rowResultMapList, List<RowResult> rowVOList) {
        if (rowResultMapList == null || rowResultMapList.isEmpty()) {
            return;
        }
        rowResultMapList.forEach(resultMap -> {
            RowResult fieldResultVO = new RowResult();
            fieldResultVO.setField((String)resultMap.get("field"));
            fieldResultVO.setEntityType((String)resultMap.get("entityType"));
            fieldResultVO.setFieldType((String)resultMap.get("fieldType"));
            fieldResultVO.setValue((String)resultMap.get("value"));
            rowVOList.add(fieldResultVO);
        });
    }

    private static void processBasicInfo(SceneResult sceneResult, Map<String, Object> respMap) {
        sceneResult.setResponseCode((String)respMap.get("responseCode"));
        sceneResult.setResponseDesc((String)respMap.get("responseDesc"));
        sceneResult.setErrorMsg((String)respMap.get("errorMsg"));
        Object costTime = respMap.get("executeCostTime");
        if (costTime != null) {
            sceneResult.setExecuteCostTime(Long.parseLong(costTime.toString()));
        } else {
            sceneResult.setExecuteCostTime(0L);
        }
        sceneResult.setExecuteStartTime((String)respMap.get("executeStartTime"));
        String serialNumber = (String)respMap.get("serialNumber");
        if (HRStringUtils.isNotEmpty(serialNumber)) {
            sceneResult.setSerialNumber(serialNumber);
        }
    }
}

