/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.common.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.DatePattern;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import org.apache.commons.lang3.StringUtils;

public class DateUtils {
    private static final Log LOGGER = LogFactory.getLog(HRDateTimeUtils.class);
    private static final ThreadLocal<SimpleDateFormat> threadLocal = new ThreadLocal();
    private static final Object object = new Object();

    private DateUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SimpleDateFormat getDateFormat(String pattern) throws RuntimeException {
        SimpleDateFormat dateFormat = threadLocal.get();
        Object object = DateUtils.object;
        synchronized (object) {
            if (dateFormat == null) {
                dateFormat = new SimpleDateFormat(pattern);
                dateFormat.setLenient(false);
                threadLocal.set(dateFormat);
            }
        }
        dateFormat.applyPattern(pattern);
        return dateFormat;
    }

    public static boolean isDate(String date) {
        boolean isDate = false;
        if (date != null && DatePattern.getPattern(date) != null) {
            isDate = true;
        }
        return isDate;
    }

    private static void throwParseException() throws ParseException {
        throw new ParseException("can not understand your format", -1);
    }

    private static String normalize(String dateStr, boolean isDate, boolean isMonth) throws ParseException {
        if (StringUtils.isBlank((CharSequence)dateStr)) {
            return "";
        }
        String[] dateAndTime = dateStr.split(" ");
        int size = dateAndTime.length;
        if (size < 1 || size > 2) {
            DateUtils.throwParseException();
        } else if (isDate && size == 2) {
            DateUtils.throwParseException();
        }
        StringBuilder builder = new StringBuilder();
        String datePart = dateAndTime[0].replaceAll("[/.\\u5e74\\u6708]", "-");
        if (!isMonth) {
            datePart = datePart.replaceAll("\\u65e5", "");
        }
        builder.append(datePart);
        if (size == 2) {
            builder.append(' ');
            String timePart = dateAndTime[1].replaceAll("[-\\u65f6\\u5206]", ":");
            timePart = timePart.replaceAll("\\u79d2", "");
            builder.append(timePart);
        }
        return builder.toString();
    }

    public static Date parseDate2YYYYMM(String dateStr) throws ParseException {
        if (StringUtils.isBlank((CharSequence)dateStr)) {
            return null;
        }
        int length = dateStr.length();
        if (StringUtils.isNumeric((CharSequence)dateStr)) {
            if (length == 6) {
                return DateUtils.parseDate(dateStr, DatePattern.YYYY_MM_PURE);
            }
            throw new ParseException("can not understand your format", -1);
        }
        int indexHyphenFirst = (dateStr = DateUtils.normalize(dateStr, true, true)).indexOf("-");
        if (indexHyphenFirst == 2) {
            return DateUtils.parseDate(dateStr, DatePattern.YY_MM);
        }
        if (indexHyphenFirst == 4) {
            return DateUtils.parseDate(dateStr, DatePattern.YYYY_MM);
        }
        throw new ParseException("can not understand your format", -1);
    }

    public static Date parseDate(String dateStr) throws ParseException {
        if (StringUtils.isBlank((CharSequence)dateStr)) {
            return null;
        }
        int length = dateStr.length();
        if (StringUtils.isNumeric((CharSequence)dateStr)) {
            if (length == 8) {
                return DateUtils.parseDate(dateStr, DatePattern.YYYY_MM_DD_PURE);
            }
            throw new ParseException("can not understand your format", -1);
        }
        int indexHyphenFirst = (dateStr = DateUtils.normalize(dateStr, true, false)).indexOf("-");
        if (indexHyphenFirst == 2) {
            return DateUtils.parseDate(dateStr, DatePattern.YY_MM_DD);
        }
        if (indexHyphenFirst == 4) {
            return DateUtils.parseDate(dateStr, DatePattern.YYYY_MM_DD);
        }
        throw new ParseException("can not understand your format", -1);
    }

    public static Date parseDateTime(String dateStr) throws ParseException {
        if (StringUtils.isBlank((CharSequence)dateStr)) {
            return null;
        }
        int length = dateStr.length();
        if (StringUtils.isNumeric((CharSequence)dateStr)) {
            if (length == 12) {
                return DateUtils.parseDate(dateStr, DatePattern.YYYY_MM_DD_HH_MM_PURE);
            }
            if (length == 14) {
                return DateUtils.parseDate(dateStr, DatePattern.YYYY_MM_DD_HH_MM_SS_PURE);
            }
            if (length == 17) {
                return DateUtils.parseDate(dateStr, DatePattern.YYYY_MM_DD_HH_MM_MS_PURE);
            }
            throw new ParseException("can not understand your format", -1);
        }
        int indexHyphenFirst = (dateStr = DateUtils.normalize(dateStr, false, false)).indexOf("-");
        if (indexHyphenFirst == 2) {
            int indexDot = dateStr.indexOf(".");
            if (indexDot == 17) {
                return DateUtils.parseDate(dateStr, DatePattern.YY_MM_DD_HH_MM_MS);
            }
            if (indexDot > -1) {
                throw new ParseException("can not understand your format", -1);
            }
            return DateUtils.parseDate(dateStr, DatePattern.YY_MM_DD_HH_MM_SS);
        }
        if (indexHyphenFirst == 4) {
            int indexDot = dateStr.indexOf(".");
            if (indexDot == 19) {
                return DateUtils.parseDate(dateStr, DatePattern.YY_MM_DD_HH_MM_MS);
            }
            if (indexDot > -1) {
                throw new ParseException("can not understand your format", -1);
            }
            return DateUtils.parseDate(dateStr, DatePattern.YYYY_MM_DD_HH_MM_SS);
        }
        throw new ParseException("can not understand your format", -1);
    }

    public static Date parseDate(String date, DatePattern datePattern) throws ParseException {
        Date myDate = null;
        if (date != null) {
            myDate = DateUtils.getDateFormat(datePattern.getValue()).parse(date);
        }
        return myDate;
    }

    public static Date stringToDate(String date) {
        return DateUtils.stringToDate(date, DatePattern.YYYY_MM_DD);
    }

    private static Date stringToDate(String date, String datePattern) {
        Date myDate = null;
        if (date != null) {
            try {
                myDate = DateUtils.getDateFormat(datePattern).parse(date);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return myDate;
    }

    public static Date stringToDate(String date, DatePattern datePattern) {
        Date myDate = null;
        if (datePattern != null) {
            myDate = DateUtils.stringToDate(date, datePattern.getValue());
        }
        return myDate;
    }

    public static String dateToString(Date date, String datePattern) {
        String dateString = null;
        if (date != null) {
            try {
                dateString = DateUtils.getDateFormat(datePattern).format(date);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return dateString;
    }

    public static String dateToString(Date date, DatePattern datePattern) {
        String dateString = null;
        if (datePattern != null) {
            dateString = DateUtils.dateToString(date, datePattern.getValue());
        }
        return dateString;
    }

    private static String stringToString(String date, String oldDatePattern, String newDatePattern) {
        return DateUtils.dateToString(DateUtils.stringToDate(date, oldDatePattern), newDatePattern);
    }

    public static String stringToString(String date, DatePattern oldDatePattern, DatePattern newDatePattern) {
        String dateString = null;
        if (oldDatePattern != null && newDatePattern != null) {
            dateString = DateUtils.stringToString(date, oldDatePattern.getValue(), newDatePattern.getValue());
        }
        return dateString;
    }

    public static String getDate(Date date) {
        return DateUtils.dateToString(date, DatePattern.YYYY_MM_DD);
    }

    public static String getTime(Date date) {
        return DateUtils.dateToString(date, DatePattern.HH_MM_SS);
    }

    public static int getIntervalDays(String date, String otherDate) {
        return DateUtils.getIntervalDays(DateUtils.stringToDate(date), DateUtils.stringToDate(otherDate));
    }

    public static int getIntervalDays(Date date, Date otherDate) {
        int num = -1;
        Date dateTmp = DateUtils.stringToDate(DateUtils.getDate(date), DatePattern.YYYY_MM_DD);
        Date otherDateTmp = DateUtils.stringToDate(DateUtils.getDate(otherDate), DatePattern.YYYY_MM_DD);
        if (dateTmp != null && otherDateTmp != null) {
            long time = Math.abs(dateTmp.getTime() - otherDateTmp.getTime());
            num = (int)(time / 86400000L);
        }
        return num;
    }
}

