/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.common.util;

import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.ComboProp;
import kd.bos.exception.KDBizException;
import kd.hr.hbp.common.util.HRDateTimeUtils;

public class HRBaseUtils {
    public static String join(String[] arr, String separator) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < arr.length; ++i) {
            sb.append(arr[i]).append(separator);
        }
        if (sb.length() > 0) {
            return sb.substring(0, sb.lastIndexOf(separator));
        }
        return null;
    }

    public static String join(Collection<Object> arr, String separator) {
        StringBuilder sb = new StringBuilder();
        for (Object obj : arr) {
            sb.append(obj).append(separator);
        }
        if (sb.length() > 0) {
            return sb.substring(0, sb.lastIndexOf(separator));
        }
        return null;
    }

    public static String join(String separator, String ... arr) {
        String[] arrnew = arr;
        return HRBaseUtils.join(arrnew, separator);
    }

    public static Long getPk(Object entity) {
        if (entity instanceof DynamicObject) {
            return (Long)((DynamicObject)entity).getPkValue();
        }
        if (entity instanceof Long) {
            return (Long)entity;
        }
        if (entity instanceof Integer) {
            return Long.valueOf(entity.toString());
        }
        return null;
    }

    public static BigDecimal getBigDecimal(Object obj) {
        if (obj != null && StringUtils.isNotBlank((Object)obj) && !" ".equals(obj)) {
            return new BigDecimal(obj.toString());
        }
        return BigDecimal.ZERO;
    }

    public static DynamicObject copyField(DynamicObject destObj, DynamicObject srcObj, String[] fields) {
        if (destObj != null && srcObj != null && fields != null) {
            for (String field : fields) {
                if (srcObj.get(field) == null) continue;
                destObj.set(field, srcObj.get(field));
            }
        }
        return destObj;
    }

    public static Row queryDataSetOne(DataSet dataSet) {
        Iterator it = dataSet.iterator();
        if (it.hasNext()) {
            return (Row)it.next();
        }
        return null;
    }

    public static Object getAssetBookInfo(DynamicObject assetBook, String property) {
        DynamicObjectCollection coll = assetBook.getDynamicObjectCollection("assetbook_entry");
        if (coll.size() > 0) {
            return ((DynamicObject)coll.get(0)).get(property);
        }
        return null;
    }

    public static String pojo2Json(Object obj) {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            return objectMapper.writeValueAsString(obj);
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
    }

    public static <T> T json2Pojo(Class<T> type, String json) {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            return (T)objectMapper.readValue(json, type);
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
    }

    public static boolean isEmpty(Map<Object, Object> map) {
        return map == null || map.isEmpty();
    }

    public static boolean isEmpty(Collection<Object> collection) {
        return collection == null || collection.size() == 0;
    }

    public static boolean isEmpty(Object[] arr) {
        return arr == null || arr.length == 0;
    }

    public static Map<Object, Object> key2Map(Collection<Object> collection) {
        HashMap<Object, Object> map = new HashMap<Object, Object>(collection.size());
        for (Object value : collection) {
            map.put(value, value);
        }
        return map;
    }

    public static Map<Object, Object> key2Map(Object[] arr) {
        HashMap<Object, Object> map = new HashMap<Object, Object>(arr.length);
        for (Object value : arr) {
            map.put(value, value);
        }
        return map;
    }

    public static List<Object> filter(List<Object> filterList, List<Object> list) {
        ArrayList<Object> retList = new ArrayList<Object>();
        Map<Object, Object> filterMap = HRBaseUtils.key2Map(filterList);
        for (Object obj : list) {
            if (filterMap.containsKey(obj)) continue;
            retList.add(obj);
        }
        return retList;
    }

    public static Object[] filter(Object[] filterArr, Object[] arr) {
        ArrayList<Object> retList = new ArrayList<Object>();
        Map<Object, Object> filterMap = HRBaseUtils.key2Map(filterArr);
        for (Object obj : arr) {
            if (filterMap.containsKey(obj)) continue;
            retList.add(obj);
        }
        return retList.toArray();
    }

    public static String addStringId(String str) {
        return str.concat("_id");
    }

    public static Date getMinEffectDate() {
        try {
            return HRDateTimeUtils.parseDate("1900-01-01");
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static Date getMinStartDate() {
        try {
            return HRDateTimeUtils.parseDate("1900-01-01");
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static Date getMaxLoseEffectDate() {
        try {
            return HRDateTimeUtils.parseDate("2999-12-31");
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static Date getMaxEndDate() {
        try {
            return HRDateTimeUtils.parseDate("2999-12-31");
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static String getComboFieldDisplayValue(DynamicObject dy, String field) {
        IDataEntityProperty dataEntityProperty = (IDataEntityProperty)dy.getDataEntityType().getProperties().get((Object)field);
        String value = dy.getString(field);
        if (dataEntityProperty instanceof ComboProp) {
            List comboList = ((ComboProp)dataEntityProperty).getComboItems();
            for (ValueMapItem combo : comboList) {
                if (!combo.getValue().equals(value)) continue;
                value = combo.getName().getLocaleValue();
                break;
            }
        }
        return value;
    }

    public static void setSysField(DynamicObject dy) {
        HRBaseUtils.setCreateField(dy);
        HRBaseUtils.setModifyField(dy);
    }

    public static void setCreateField(DynamicObject dy) {
        if (HRBaseUtils.getDynamicObjectByField(dy, "creator") == 0L) {
            Long userId = Long.valueOf(RequestContext.get().getUserId());
            dy.set("creator", (Object)userId);
        }
        if (dy.getDate("createtime") == null) {
            dy.set("createtime", (Object)new Date());
        }
    }

    private static Long getDynamicObjectByField(DynamicObject dy, String fieldName) {
        Object obj = dy.get(fieldName);
        if (obj == null) {
            return 0L;
        }
        Long objId = 0L;
        if (obj instanceof DynamicObject) {
            objId = ((DynamicObject)obj).getLong("id");
        } else if (obj instanceof Long) {
            objId = Long.valueOf(obj.toString());
        }
        return objId;
    }

    public static void setModifyField(DynamicObject dy) {
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        dy.set("modifier", (Object)userId);
        dy.set("modifytime", (Object)new Date());
    }

    public static String getNoPermMsg() {
        return ResManager.loadKDString((String)"\u60a8\u65e0\u6743\u9650\u8fdb\u884c\u6b64\u64cd\u4f5c\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u91cd\u65b0\u6388\u6743\u3002", (String)"HRBaseUtils_0", (String)"hrmp-hbp-common", (Object[])new Object[0]);
    }

    public static <T> T map2Bean(Map<String, Object> map, Class<T> clazz) {
        if (map == null) {
            return null;
        }
        Object bean = JSON.parseObject((String)JSON.toJSONString(map), clazz);
        return (T)bean;
    }
}

