/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.common.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;

public class HRCardUtils {
    public static DynamicObject[] loadAllMainPageCardConfig(Long userId, List<Long> cardIds) {
        String selFields = "cardid,config,cardtype";
        DynamicObject[] mainPageCardConfigs = BusinessDataServiceHelper.load((String)"bos_mainpagecardconfig", (String)selFields, (QFilter[])new QFilter[]{new QFilter("user", "=", (Object)userId), new QFilter("cardid", "in", cardIds)});
        return mainPageCardConfigs;
    }

    public static String replaceBackSlach(String layout) {
        while (layout.contains("\\\"")) {
            layout = layout.replaceAll("\\\\\"", "\"");
        }
        return layout;
    }

    public static String getMapEntryStrFromOrmLocaleValue(OrmLocaleValue olv) {
        String mapEntryStr = olv.entrySet().toString();
        return mapEntryStr;
    }

    public static List<Long> getCardIdsFromLayout(String layout) {
        ArrayList<Long> cardIdList = new ArrayList<Long>();
        if (StringUtils.isEmpty((String)layout)) {
            return cardIdList;
        }
        JSONArray jsonArr = JSON.parseArray((String)layout);
        for (Object object : jsonArr) {
            JSONObject jsonObj = (JSONObject)object;
            String cardId = jsonObj.getString("i");
            if (StringUtils.isEmpty((String)cardId)) continue;
            long lCardId = 0L;
            try {
                lCardId = Long.parseLong(cardId);
            }
            catch (Exception e) {
                continue;
            }
            cardIdList.add(lCardId);
        }
        return cardIdList;
    }

    public static long getSuperAdmin() {
        QFilter[] filter = null;
        filter = new QFilter[]{new QFilter("type", "=", (Object)10)};
        DynamicObject[] userObjects = BusinessDataServiceHelper.load((String)"perm_admin", (String)"user.id", (QFilter[])filter);
        if (userObjects.length > 0) {
            return userObjects[0].getLong("user.id");
        }
        return -1L;
    }

    public static DynamicObject loadMainPageLayout(Long userId, boolean isMainPage, String entityId) {
        QFilter[] arrQFilter = null;
        arrQFilter = isMainPage ? new QFilter[]{new QFilter("user", "=", (Object)userId), new QFilter("pagetype", "=", (Object)"main")} : new QFilter[]{new QFilter("user", "=", (Object)userId), new QFilter("bizapp", "=", (Object)entityId), new QFilter("pagetype", "=", (Object)"app")};
        String selFields = "id,layout,user,pagetype";
        DynamicObject userMainPageLayout = null;
        userMainPageLayout = BusinessDataServiceHelper.loadSingle((String)"portal_scheme", (String)selFields, (QFilter[])arrQFilter);
        return userMainPageLayout;
    }

    public static HashMap<String, Object> getLayoutForNewCard(String layout, int width, int height) {
        if (StringUtils.isEmpty((String)layout)) {
            return new HashMap<String, Object>();
        }
        List cardList = (List)SerializationUtils.fromJsonString((String)layout, List.class);
        int maxRow = 0;
        Map cardMap = null;
        for (int rowI = 0; rowI < cardList.size(); ++rowI) {
            cardMap = (Map)cardList.get(rowI);
            maxRow = HRCardUtils.getMaxRow(maxRow, cardMap);
        }
        int[][] gridValue = new int[maxRow + 1][12];
        for (int rowY = 0; rowY < maxRow; ++rowY) {
            for (int rowX = 0; rowX < 12; ++rowX) {
                gridValue[rowY][rowX] = 0;
            }
        }
        HRCardUtils.setCardList(cardList, gridValue);
        if (width > 12 || width < 1) {
            width = 4;
        }
        if (height <= 0 || height > 5) {
            height = 1;
        }
        int xx = -1;
        int yy = -1;
        for (int rowY = 0; rowY < maxRow + 1; ++rowY) {
            for (int rowX = 0; rowX < 12 && rowX <= 12 - width; ++rowX) {
                int sum = HRCardUtils.getSum(width, height, maxRow, gridValue, rowY, rowX);
                if (sum != 0) continue;
                xx = rowX;
                yy = rowY;
                break;
            }
            if (yy > -1) break;
        }
        if (xx == -1) {
            xx = 0;
        }
        if (yy == -1) {
            yy = maxRow + 1;
        }
        return HRCardUtils.getStringObjectHashMap(width, height, xx, yy);
    }

    private static HashMap<String, Object> getStringObjectHashMap(int width, int height, int xx, int yy) {
        HashMap<String, Object> layoutMap = new HashMap<String, Object>();
        layoutMap.put("x", xx);
        layoutMap.put("y", yy);
        layoutMap.put("w", width);
        layoutMap.put("h", height);
        return layoutMap;
    }

    private static int getSum(int width, int height, int maxRow, int[][] gridValue, int rowY, int rowX) {
        int sum = 0;
        for (int wy = rowY; wy < rowY + height; ++wy) {
            if (wy > maxRow) continue;
            for (int wx = rowX; wx < rowX + width; ++wx) {
                if (gridValue[wy][wx] <= 0) continue;
                sum = 1;
                break;
            }
            if (sum > 0) break;
        }
        return sum;
    }

    private static void setCardList(List<Map<String, Object>> cardList, int[][] gridValue) {
        for (int rowI = 0; rowI < cardList.size(); ++rowI) {
            Map<String, Object> cardMap = cardList.get(rowI);
            int valueX = (Integer)cardMap.get("x");
            int valueY = (Integer)cardMap.get("y");
            int ww = (Integer)cardMap.get("w");
            int hh = (Integer)cardMap.get("h");
            for (int indexY = valueY; indexY < valueY + hh; ++indexY) {
                for (int indexX = valueX; indexX < valueX + ww; ++indexX) {
                    gridValue[indexY][indexX] = 1;
                }
            }
        }
    }

    private static int getMaxRow(int maxRow, Map<String, Object> cardMap) {
        int valueY = (Integer)cardMap.get("y");
        int valueH = (Integer)cardMap.get("h");
        if (valueY > maxRow) {
            maxRow = valueY;
        }
        if (valueY + valueH > maxRow + 1) {
            maxRow = valueY + valueH;
        }
        return maxRow;
    }
}

