/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.common.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleDynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.DynamicObjectSerializationBinder;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.LinkEntryType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.AdminDivisionProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.hr.hbp.common.util.HRAssert;
import kd.hr.hbp.common.util.HRHisEntryObjectUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class HRDynamicObjectUtils {
    private static final String LOCALE_ID = "localeId";

    public static void copy(DynamicObject fromObj, DynamicObject toObj) {
        HRDynamicObjectUtils.copy(fromObj, toObj, null, null, false);
    }

    public static void copy(DynamicObject fromObj, DynamicObject toObj, boolean isHisModel) {
        HRDynamicObjectUtils.copy(fromObj, toObj, null, null, isHisModel);
    }

    public static void copy(DynamicObject fromObj, DynamicObject toObj, Set<String> ignoreKeys) {
        HRDynamicObjectUtils.copy(fromObj, toObj, ignoreKeys, null, false);
    }

    public static void copy(DynamicObject fromObj, DynamicObject toObj, Set<String> ignoreKeys, boolean isHisModel) {
        HRDynamicObjectUtils.copy(fromObj, toObj, ignoreKeys, null, isHisModel);
    }

    public static void copy(DynamicObject fromObj, DynamicObject toObj, Map<String, String> transKeyMap) {
        HRDynamicObjectUtils.copy(fromObj, toObj, null, transKeyMap, false);
    }

    public static void copy(DynamicObject fromObj, DynamicObject toObj, Map<String, String> transKeyMap, boolean isHisModel) {
        HRDynamicObjectUtils.copy(fromObj, toObj, null, transKeyMap, isHisModel);
    }

    public static void copy(DynamicObject fromObj, DynamicObject toObj, Set<String> ignoreKeys, Map<String, String> transKeyMap) {
        HRDynamicObjectUtils.copy(fromObj, toObj, ignoreKeys, transKeyMap, false);
    }

    public static void copy(DynamicObject fromObj, DynamicObject toObj, Set<String> ignoreKeys, Map<String, String> transKeyMap, boolean isHisModel) {
        if (fromObj == null || toObj == null) {
            return;
        }
        DataEntityPropertyCollection fromPros = fromObj.getDataEntityType().getProperties();
        if (CollectionUtils.isEmpty((Collection)fromPros)) {
            return;
        }
        DataEntityPropertyCollection toPros = toObj.getDataEntityType().getProperties();
        if (CollectionUtils.isEmpty((Collection)toPros)) {
            return;
        }
        HashSet<String> fromPsSet = new HashSet<String>(fromPros.size());
        for (Object pro : fromPros) {
            fromPsSet.add(String.valueOf(pro.getName()).toLowerCase(Locale.ROOT));
        }
        HashSet<String> toPsSet = new HashSet<String>(fromPros.size());
        for (IDataEntityProperty pro : toPros) {
            toPsSet.add(String.valueOf(pro.getName()).toLowerCase(Locale.ROOT));
        }
        ISimpleProperty primaryKeyObj = toObj.getDataEntityType().getPrimaryKey();
        String primaryKey = "";
        if (primaryKeyObj != null) {
            primaryKey = primaryKeyObj.getName();
        }
        HRDynamicObjectUtils.handletoPros(fromObj, toObj, ignoreKeys, transKeyMap, toPros, fromPsSet, toPsSet, primaryKey, isHisModel);
    }

    private static void handletoPros(DynamicObject fromObj, DynamicObject toObj, Set<String> ignoreKeys, Map<String, String> transKeyMap, DataEntityPropertyCollection toPros, HashSet<String> fromPsSet, HashSet<String> toPsSet, String primaryKey, boolean isHisModel) {
        Object value;
        DynamicObjectType entityType;
        HashMap<String, String> toObjNotExistTransKeyMap = null;
        if (transKeyMap != null) {
            toObjNotExistTransKeyMap = new HashMap<String, String>(transKeyMap);
        }
        for (IDataEntityProperty pro : toPros) {
            String toProName;
            String fromProName = toProName = pro.getName();
            if (transKeyMap != null && Objects.nonNull(transKeyMap.get(fromProName))) {
                toProName = transKeyMap.get(fromProName);
                if (toObjNotExistTransKeyMap != null) {
                    toObjNotExistTransKeyMap.remove(fromProName);
                }
            } else if (ignoreKeys != null && ignoreKeys.contains(toProName)) continue;
            if (!fromPsSet.contains(fromProName) || !toPsSet.contains(toProName)) continue;
            if (toProName.equals(primaryKey)) {
                entityType = toObj.getDynamicObjectType();
                if (HRDynamicObjectUtils.ignoreKeysIsLocale(ignoreKeys, entityType)) continue;
                toObj.set(toProName, null);
                continue;
            }
            value = fromObj.get(fromProName);
            HRDynamicObjectUtils.putObj(toObj, ignoreKeys, transKeyMap, toProName, value, isHisModel);
        }
        if (toObjNotExistTransKeyMap != null && !toObjNotExistTransKeyMap.isEmpty()) {
            for (Map.Entry transEntry : toObjNotExistTransKeyMap.entrySet()) {
                String fromProName = (String)transEntry.getKey();
                String toProName = (String)transEntry.getValue();
                if (!fromPsSet.contains(fromProName) || !toPsSet.contains(toProName)) continue;
                if (toProName.equals(primaryKey)) {
                    entityType = toObj.getDynamicObjectType();
                    if (HRDynamicObjectUtils.ignoreKeysIsLocale(ignoreKeys, entityType)) continue;
                    toObj.set(toProName, null);
                    continue;
                }
                value = fromObj.get(fromProName);
                HRDynamicObjectUtils.putObj(toObj, ignoreKeys, transKeyMap, toProName, value, isHisModel);
            }
        }
    }

    private static void putObj(DynamicObject toObj, Set<String> ignoreKeys, Map<String, String> transKeyMap, String toProName, Object value, boolean isHisModel) {
        if (value instanceof DynamicObjectCollection) {
            if (value instanceof LocaleDynamicObjectCollection) {
                return;
            }
            DynamicObjectCollection formEntity = (DynamicObjectCollection)value;
            DynamicObjectCollection toEntity = toObj.getDynamicObjectCollection(toProName);
            if (toEntity != null) {
                boolean isEntry;
                DynamicObjectType entityType = toEntity.getDynamicObjectType();
                boolean bl = isEntry = entityType instanceof EntryType && !(entityType instanceof LinkEntryType);
                if (isHisModel && isEntry) {
                    HRHisEntryObjectUtils.validateEntry(toEntity);
                    HRHisEntryObjectUtils.entryCopy(formEntity, ignoreKeys, toEntity, HRDynamicObjectUtils.getParentEntityNumber(entityType, toEntity));
                } else {
                    HRDynamicObjectUtils.clearCopy(formEntity, toEntity, ignoreKeys, entityType, transKeyMap);
                }
            }
            toObj.set(toProName, (Object)toEntity);
        } else {
            toObj.set(toProName, value);
        }
    }

    private static void clearCopy(DynamicObjectCollection formEntity, DynamicObjectCollection toEntity, Set<String> ignoreKeys, DynamicObjectType entityType, Map<String, String> transKeyMap) {
        toEntity.clear();
        for (DynamicObject baseEntry : formEntity) {
            DynamicObject newEntry = new DynamicObject(entityType);
            HRDynamicObjectUtils.copy(baseEntry, newEntry, ignoreKeys, transKeyMap);
            toEntity.add((Object)newEntry);
        }
    }

    private static boolean ignoreKeysIsLocale(Set<String> ignoreKeys, DynamicObjectType entityType) {
        if (entityType == null || ignoreKeys == null || ignoreKeys.size() == 0) {
            return false;
        }
        if (!"locale".equals(entityType.getName())) {
            return false;
        }
        for (IDataEntityProperty property : entityType.getProperties()) {
            if (!ignoreKeys.contains(property.getName())) continue;
            return true;
        }
        return false;
    }

    public static Map convertDynamicObjectToMap(DynamicObject dy) throws KDBizException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (dy == null) {
            return map;
        }
        DataEntityPropertyCollection dePros = dy.getDataEntityType().getProperties();
        if (dePros == null || dePros.size() == 0) {
            return map;
        }
        for (IDataEntityProperty pro : dePros) {
            String proName = pro.getName();
            Object value = dy.get(proName);
            if (value instanceof DynamicObject) {
                Map f7Map = HRDynamicObjectUtils.convertDynamicObjectToMap((DynamicObject)value);
                map.put(proName, f7Map);
            }
            if (value instanceof DynamicObjectCollection) {
                ArrayList<Map> entryList = new ArrayList<Map>();
                DynamicObjectCollection dyEntrys = (DynamicObjectCollection)value;
                for (DynamicObject dyEntry : dyEntrys) {
                    Map entryMap = HRDynamicObjectUtils.convertDynamicObjectToMap(dyEntry);
                    entryList.add(entryMap);
                }
                map.put(proName, entryList);
                continue;
            }
            map.put(proName, value);
        }
        return map;
    }

    public static String getQueryFields(DynamicObject dy) {
        if (dy == null) {
            return "";
        }
        DataEntityPropertyCollection pros = dy.getDataEntityType().getProperties();
        if (pros == null || pros.size() == 0) {
            return "";
        }
        StringBuilder queryFieldsStr = new StringBuilder();
        for (IDataEntityProperty pro : pros) {
            String proStr = pro.getName().toLowerCase(Locale.ROOT);
            if (proStr.endsWith("_id") || proStr.endsWith("text")) continue;
            queryFieldsStr.append(proStr).append(',');
        }
        if (queryFieldsStr.length() > 0) {
            queryFieldsStr.delete(queryFieldsStr.length() - 1, queryFieldsStr.length());
        }
        return queryFieldsStr.toString();
    }

    public static boolean equals(DynamicObject obj1, DynamicObject obj2) {
        if (obj1 == obj2) {
            return true;
        }
        if (obj1 == null || obj2 == null) {
            return false;
        }
        return obj1.getLong("id") == obj2.getLong("id");
    }

    public static String getComboFieldDisplayValue(DynamicObject dynamicObject, String field) {
        IDataEntityProperty dataEntityProperty = (IDataEntityProperty)dynamicObject.getDataEntityType().getProperties().get((Object)field);
        String value = dynamicObject.getString(field);
        if (dataEntityProperty instanceof ComboProp) {
            List comboItemList = ((ComboProp)dataEntityProperty).getComboItems();
            for (ValueMapItem comboItem : comboItemList) {
                if (!comboItem.getValue().equals(value)) continue;
                value = comboItem.getName().getLocaleValue();
                break;
            }
        }
        return value;
    }

    public static String getStringValue(DynamicObject dy, String field) {
        Object propObject = dy.getDataEntityType().getProperties().get((Object)field);
        String result = HRObjectUtils.convertObjectToString(dy.get(field));
        if (propObject instanceof AdminDivisionProp && !HRStringUtils.isEmpty(result)) {
            String adminDivision = "";
            long adminDivisionId = Long.parseLong(result);
            QFilter idFilter = new QFilter("id", "=", (Object)adminDivisionId);
            DynamicObject admindivisionDynamic = QueryServiceHelper.queryOne((String)"bd_admindivision", (String)"fullname", (QFilter[])idFilter.toArray());
            String admindivisionFullName = admindivisionDynamic != null ? admindivisionDynamic.getString("fullname") : result;
            String[] admindivisionArray = admindivisionFullName.split("_");
            StringBuilder adminDivisionBuilder = new StringBuilder();
            int length = admindivisionArray.length;
            for (int i = 0; i < length; ++i) {
                adminDivisionBuilder.append(admindivisionArray[i]);
                adminDivisionBuilder.append('/');
            }
            if (adminDivisionBuilder.length() > 0) {
                adminDivision = adminDivisionBuilder.substring(0, adminDivision.length() - 1);
            }
            return adminDivision;
        }
        if (propObject instanceof ComboProp) {
            List comboItems = ((ComboProp)propObject).getComboItems();
            for (ValueMapItem comboItem : comboItems) {
                if (!comboItem.getValue().equals(result)) continue;
                result = comboItem.getName().getLocaleValue();
                break;
            }
        }
        return result;
    }

    private static String getParentEntityNumber(DynamicObjectType entityType, DynamicObjectCollection toEntity) {
        String parentEntityNumber = null;
        if (entityType instanceof EntryType) {
            parentEntityNumber = entityType instanceof SubEntryType ? toEntity.getDynamicObjectType().getParent().getParent().getName() : toEntity.getDynamicObjectType().getParent().getName();
        }
        return parentEntityNumber;
    }

    public static boolean isPropertyExist(DynamicObject dynamicObject, String propertyName) {
        if (Objects.isNull(dynamicObject)) {
            return false;
        }
        DynamicProperty property = dynamicObject.getDynamicObjectType().getProperty(propertyName);
        return Objects.nonNull(property);
    }

    public static DynamicObjectType buildDyObjType(String entityName) {
        HRAssert.notBlank(entityName, "entityName cannot be empty", new Object[0]);
        return new DynamicObjectType(entityName);
    }

    public static DynamicObject createEmptyDyObj(String entityName) {
        return new DynamicObject(HRDynamicObjectUtils.buildDyObjType(entityName));
    }

    public static void assemblyDynToMap(DynamicObject sourceDynObj, Map targetToMap, Map<String, String> fieldMap) {
        if (ObjectUtils.isEmpty(fieldMap)) {
            targetToMap.putAll(HRDynamicObjectUtils.convertDynamicObjectToMap(sourceDynObj));
            return;
        }
        for (Map.Entry<String, String> entry : fieldMap.entrySet()) {
            String fieldName = entry.getKey();
            String fieldValue = entry.getValue();
            if (!StringUtils.isEmpty((CharSequence)fieldValue)) {
                targetToMap.put(fieldValue, sourceDynObj.get(fieldName));
                continue;
            }
            targetToMap.put(fieldName, sourceDynObj.get(fieldName));
        }
    }

    public static List<Map<String, Object>> serializeToMap(DynamicObject[] objects, DynamicObjectType dt) {
        return HRDynamicObjectUtils.serializeToMap(objects, dt, false);
    }

    public static List<Map<String, Object>> serializeToMap(DynamicObject[] objects, DynamicObjectType dt, boolean isSerializeDefaultValue) {
        if (objects == null) {
            return null;
        }
        if (objects.length == 0) {
            return Collections.emptyList();
        }
        DynamicObjectSerializationBinder binder = new DynamicObjectSerializationBinder(dt);
        binder.setOnlyDbProperty(false);
        binder.setSerializeDefaultValue(isSerializeDefaultValue);
        DcJsonSerializer jsr = new DcJsonSerializer((DcBinder)binder);
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(objects.length);
        for (DynamicObject object : objects) {
            Map map = jsr.serializeToMap((Object)object, null);
            list.add(map);
        }
        return list;
    }
}

