/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.common.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntryType;
import kd.bos.entity.LinkEntryType;
import kd.bos.entity.property.BigIntProp;
import kd.bos.exception.KDBizException;
import kd.bos.orm.ORM;
import kd.bos.orm.util.StringUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;

public class HRHisEntryObjectUtils {
    public static void entryCopy(DynamicObjectCollection fromCollection, Set<String> ignoreKeys, DynamicObjectCollection toCollection, String parentEntityNumber) {
        Long entryBoId;
        if (fromCollection == null) {
            return;
        }
        ORM orm = ORM.create();
        DynamicObjectType entityType = fromCollection.getDynamicObjectType();
        String pkFiledName = entityType.getPrimaryKey().getName();
        String entryBoIdFiledName = HRHisEntryObjectUtils.getEntryBoIdFiledName(fromCollection);
        HashMap<Long, DynamicObject> dynamicObjectToMap = new HashMap<Long, DynamicObject>(toCollection.size());
        for (DynamicObject dynamicObject : toCollection) {
            Long entryBoId2 = dynamicObject.getLong(entryBoIdFiledName);
            dynamicObjectToMap.put(entryBoId2, dynamicObject);
        }
        long[] ids = orm.genLongIds(parentEntityNumber, fromCollection.size());
        int index = 0;
        for (DynamicObject dynamicObjectFrom : fromCollection) {
            Object keyValue;
            entryBoId = dynamicObjectFrom.getLong(entryBoIdFiledName);
            if ((entryBoId == null || entryBoId == 0L) && (keyValue = dynamicObjectFrom.getPkValue()) instanceof Long) {
                Long entryBoid;
                Long id = (Long)keyValue;
                if (id == 0L) {
                    id = ids[index];
                    ++index;
                    dynamicObjectFrom.set(pkFiledName, (Object)id);
                }
                if ((entryBoid = Long.valueOf(dynamicObjectFrom.getLong(entryBoIdFiledName))) == 0L) {
                    dynamicObjectFrom.set(entryBoIdFiledName, (Object)id);
                }
            }
            DynamicObject dynamicObjectTo = (DynamicObject)dynamicObjectToMap.get(entryBoId);
            Set<String> fileNameSet = HRHisEntryObjectUtils.getIgnoreKeys(ignoreKeys);
            fileNameSet.add(pkFiledName);
            if (dynamicObjectTo != null) {
                HRDynamicObjectUtils.copy(dynamicObjectFrom, dynamicObjectTo, fileNameSet, true);
                dynamicObjectToMap.remove(entryBoId);
                continue;
            }
            dynamicObjectTo = new DynamicObject(entityType);
            HRDynamicObjectUtils.copy(dynamicObjectFrom, dynamicObjectTo, fileNameSet, true);
            toCollection.add((Object)dynamicObjectTo);
        }
        if (!dynamicObjectToMap.isEmpty()) {
            Iterator dynamicObjectIterator = toCollection.iterator();
            while (dynamicObjectIterator.hasNext()) {
                DynamicObject dynamicObjectTo = (DynamicObject)dynamicObjectIterator.next();
                entryBoId = dynamicObjectTo.getLong(entryBoIdFiledName);
                if (!dynamicObjectToMap.containsKey(entryBoId)) continue;
                dynamicObjectIterator.remove();
            }
        }
    }

    public static String getEntryBoIdFiledName(DynamicObjectCollection fromCollection) {
        if (fromCollection == null) {
            return null;
        }
        DataEntityPropertyCollection dataEntityProperties = fromCollection.getDynamicObjectType().getProperties();
        for (int i = 0; i < dataEntityProperties.size(); ++i) {
            IDataEntityProperty dataEntityProperty = (IDataEntityProperty)dataEntityProperties.get(i);
            String filedName = dataEntityProperty.getName();
            if (StringUtils.isEmpty((Object)filedName) || !filedName.startsWith("entryboid")) continue;
            return filedName;
        }
        return null;
    }

    private static Set<String> getIgnoreKeys(Set<String> ignoreKeys) {
        if (ignoreKeys == null) {
            ignoreKeys = new HashSet<String>();
        }
        ignoreKeys.add("id");
        ignoreKeys.add("createtime");
        ignoreKeys.add("creator");
        ignoreKeys.add("creator_id");
        return ignoreKeys;
    }

    public static void validateEntry(DynamicObjectCollection dynamicObjectCollection) {
        DataEntityPropertyCollection dataEntityProperties = dynamicObjectCollection.getDynamicObjectType().getProperties();
        boolean hasEntryBoId = false;
        int entryBoIdCount = 0;
        for (int i = 0; i < dataEntityProperties.size(); ++i) {
            IDataEntityProperty dataEntityProperty = (IDataEntityProperty)dataEntityProperties.get(i);
            String filedName = dataEntityProperty.getName();
            if (StringUtils.isEmpty((Object)filedName) || !filedName.startsWith("entryboid")) continue;
            hasEntryBoId = true;
            ++entryBoIdCount;
            Object objectType = dynamicObjectCollection.getDynamicObjectType().getProperties().get((Object)filedName);
            if (objectType instanceof BigIntProp) continue;
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5386\u53f2\u6a21\u578b\u4e2d\u5355\u636e\u4f53\u5b57\u6bb5\u201c%s\u201d\u5fc5\u987b\u4e3a\u957f\u6574\u578b\u3002", (String)"HRHisEntryObjectUtils_1", (String)"hrmp-hbp-common", (Object[])new Object[0]), "entryboid"));
        }
        if (!hasEntryBoId) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\u4f53/\u5b50\u5355\u636e\u4f53\u4e2d\u5fc5\u987b\u5305\u542b\u4ee5\u201c%s\u201d\u5f00\u5934\u7684\u5b57\u6bb5\uff0c\u7528\u4e8e\u8bb0\u5f55\u5355\u636e\u4f53/\u5b50\u5355\u636e\u4f53\u7684\u5386\u53f2\u3002", (String)"HRHisEntryObjectUtils_2", (String)"hrmp-hbp-common", (Object[])new Object[0]), "entryboid"));
        }
        if (entryBoIdCount > 1) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5386\u53f2\u6a21\u578b\u4e2d\u5206\u5f55\u4e2d\u5b57\u6bb5\u201c%s\u201d, \u53ea\u80fd\u51fa\u73b0\u4e00\u6b21\u3002", (String)"HRHisEntryObjectUtils_3", (String)"hrmp-hbp-common", (Object[])new Object[0]), new Object[0]));
        }
    }

    public static boolean hasEntryBoId(DynamicObjectCollection dynamicObjectCollection) {
        DataEntityPropertyCollection dataEntityProperties = dynamicObjectCollection.getDynamicObjectType().getProperties();
        for (int i = 0; i < dataEntityProperties.size(); ++i) {
            IDataEntityProperty dataEntityProperty = (IDataEntityProperty)dataEntityProperties.get(i);
            String filedName = dataEntityProperty.getName();
            if (StringUtils.isEmpty((Object)filedName) || !filedName.startsWith("entryboid")) continue;
            return true;
        }
        return false;
    }

    public static void initEntryBoId(DynamicObject[] dynamicObjectsResult, String entityNumber) {
        if (dynamicObjectsResult == null || dynamicObjectsResult.length == 0) {
            return;
        }
        DataEntityPropertyCollection dataEntityPropertyCollection = dynamicObjectsResult[0].getDataEntityType().getProperties();
        int idSize = 0;
        for (DynamicObject dynamicObject : dynamicObjectsResult) {
            for (IDataEntityProperty property : dataEntityPropertyCollection) {
                String entryBoIdFiledName;
                DynamicObjectCollection dynamicObjectCollection;
                DynamicObjectType entityType;
                String proName = property.getName();
                Object value = dynamicObject.get(proName);
                if (!(value instanceof DynamicObjectCollection) || !((entityType = (dynamicObjectCollection = (DynamicObjectCollection)value).getDynamicObjectType()) instanceof EntryType) || entityType instanceof LinkEntryType || (entryBoIdFiledName = HRHisEntryObjectUtils.getEntryBoIdFiledName(dynamicObjectCollection)) == null) continue;
                for (DynamicObject dyEntry : dynamicObjectCollection) {
                    Long entryBoId = dyEntry.getLong(entryBoIdFiledName);
                    if (entryBoId != null && entryBoId != 0L) continue;
                    ++idSize;
                }
            }
        }
        if (idSize == 0) {
            return;
        }
        long[] ids = ORM.create().genLongIds(entityNumber, idSize);
        for (DynamicObject dynamicObject : dynamicObjectsResult) {
            int index = 0;
            for (IDataEntityProperty property : dataEntityPropertyCollection) {
                String entryBoIdFiledName;
                DynamicObjectCollection dynamicObjectCollection;
                DynamicObjectType entityType;
                String proName = property.getName();
                Object value = dynamicObject.get(proName);
                if (!(value instanceof DynamicObjectCollection) || !((entityType = (dynamicObjectCollection = (DynamicObjectCollection)value).getDynamicObjectType()) instanceof EntryType) || entityType instanceof LinkEntryType || (entryBoIdFiledName = HRHisEntryObjectUtils.getEntryBoIdFiledName(dynamicObjectCollection)) == null) continue;
                String pkFiledName = entityType.getPrimaryKey().getName();
                for (DynamicObject dyEntry : dynamicObjectCollection) {
                    Object keyValue;
                    Long entryBoId = dyEntry.getLong(entryBoIdFiledName);
                    if (entryBoId != null && entryBoId != 0L || !((keyValue = dyEntry.getPkValue()) instanceof Long)) continue;
                    Long id = (Long)keyValue;
                    if (id == 0L) {
                        id = ids[index];
                        ++index;
                        dyEntry.set(pkFiledName, (Object)id);
                    }
                    dyEntry.set(entryBoIdFiledName, (Object)id);
                }
            }
        }
    }
}

