/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.common.util;

import java.util.Map;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.ISVInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.ISVServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class HRISVUtils {
    private static final Log logger = LogFactory.getLog(HRISVUtils.class);

    public static void loadISVExtendServiceImplClassName(Map<String, String> serviceMap) {
        ISVInfo isvInfo = ISVServiceHelper.getISVInfo();
        String isvName = isvInfo.getName();
        if (!"kingdee".equals(isvName)) {
            for (Map.Entry<String, String> entry : serviceMap.entrySet()) {
                String className = entry.getValue();
                className = className.replaceFirst("kd\\.", isvName + ".");
                className = className + "Ext";
                try {
                    Thread.currentThread().getContextClassLoader().loadClass(className);
                    serviceMap.put(entry.getKey(), className);
                }
                catch (ClassNotFoundException e) {
                    logger.info("this is a harmless information, not exist the customized class '" + className + "'");
                }
            }
        }
    }

    public static boolean isKingdeeIsv(String appId) {
        AppInfo appInfo = AppMetadataCache.getAppInfo((String)appId);
        return appInfo != null && (StringUtils.isEmpty((CharSequence)appInfo.getIsv()) || "kingdee".equalsIgnoreCase(appInfo.getIsv()));
    }
}

