/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.common.util;

import java.util.Date;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.format.FormatFactory;
import kd.bos.entity.format.FormatObject;
import kd.bos.entity.format.FormatTypes;
import kd.bos.entity.format.IFormat;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.service.InteTimeZone;
import kd.bos.servicehelper.inte.InteServiceHelper;

public class HRInteDateTimeUtil {
    public static String formatDate(String entityNumber, String fieldKey, Date date) {
        BillEntityType type = (BillEntityType)EntityMetadataCache.getDataEntityType((String)entityNumber);
        DateTimeProp property = (DateTimeProp)type.findProperty(fieldKey);
        return HRInteDateTimeUtil.formatDateByFieldProp(property, date, 0L);
    }

    public static String formatDateByFieldProp(DateTimeProp prop, Date date, Long orgId) {
        if (Objects.isNull(date)) {
            return "";
        }
        IFormat format = prop.getRegionType() == FormatTypes.Time.getValue() ? FormatFactory.get((FormatTypes)FormatTypes.Time) : FormatFactory.get((FormatTypes)FormatTypes.Date);
        FormatObject formatObject = InteServiceHelper.getUserFormat((Long)Long.parseLong(RequestContext.get().getUserId()));
        InteTimeZone timeZone = prop.getTimeZone(orgId);
        if (formatObject != null && formatObject.isTimeNotEmpty()) {
            formatObject.getTimeFormat().setTimeArea(timeZone.getTimeArea());
            formatObject.getDateFormat().setTimeArea(timeZone.getTimeArea());
        }
        String formatString = format.getFormat(formatObject).format(date);
        return formatString;
    }
}

