/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.common.util;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public class HRJSONUtils {
    private static final Log logger = LogFactory.getLog(HRJSONUtils.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public static String toString(Object source) throws IOException {
        return HRJSONUtils.toString(source, false);
    }

    public static String toString(Object source, boolean indent) throws IOException {
        try {
            String result;
            if (indent) {
                MAPPER.configure(SerializationFeature.INDENT_OUTPUT, true);
            }
            String string = result = MAPPER.writeValueAsString(source);
            return string;
        }
        catch (IOException e) {
            logger.error("cast source object toString error", (Throwable)e);
            throw e;
        }
        finally {
            if (indent) {
                MAPPER.configure(SerializationFeature.INDENT_OUTPUT, false);
            }
        }
    }

    public static <T> T cast(String source, Class<T> type) throws IOException {
        return HRJSONUtils.cast(source, type, false);
    }

    public static <T> T cast(String source, Class<T> type, boolean ignoreUnkownField) throws IOException {
        try {
            Object result;
            if (ignoreUnkownField) {
                MAPPER.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
            }
            source = Normalizer.normalize(source, Normalizer.Form.NFKC);
            Object object = result = MAPPER.readValue(source, type);
            return (T)object;
        }
        catch (IOException e) {
            logger.error("cast object from source error", (Throwable)e);
            throw e;
        }
        finally {
            if (ignoreUnkownField) {
                MAPPER.enable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
            }
        }
    }

    public static <T> T cast(String source, Class<?> collectionType, Class<?> ... elementType) throws IOException {
        return HRJSONUtils.cast(source, true, collectionType, elementType);
    }

    public static <T> T cast(String source, boolean ignoreUnkownField, Class<?> collectionType, Class<?> ... elementType) throws IOException {
        try {
            Object result;
            if (ignoreUnkownField) {
                MAPPER.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
            }
            JavaType type = HRJSONUtils.getCollectionType(collectionType, elementType);
            Object object = result = MAPPER.readValue(source, type);
            return (T)object;
        }
        catch (IOException e) {
            logger.error("cast object from source error", (Throwable)e);
            throw e;
        }
        finally {
            if (ignoreUnkownField) {
                MAPPER.enable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
            }
        }
    }

    public static JavaType getCollectionType(Class<?> collectionClass, Class<?> ... elementClasses) {
        return MAPPER.getTypeFactory().constructParametricType(collectionClass, (Class[])elementClasses);
    }

    public static String getEmpty() {
        return "{}";
    }

    public static Map convertObjectToMap(Object object) throws IntrospectionException, InvocationTargetException, IllegalAccessException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            PropertyDescriptor[] propertyDescriptors;
            BeanInfo beanInfo = Introspector.getBeanInfo(object.getClass());
            for (PropertyDescriptor property : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
                String key = property.getName();
                Method getter = property.getReadMethod();
                Object value = getter != null ? getter.invoke(object, new Object[0]) : null;
                map.put(key, value);
            }
        }
        catch (IntrospectionException | IllegalAccessException | InvocationTargetException e) {
            logger.error("Operate Failed");
            throw e;
        }
        return map;
    }

    public static Map convertJSONObjectToMap(Object object) throws KDBizException {
        if (object == null) {
            return new HashMap();
        }
        JSONObject jsonObj = JSONObject.fromObject((Object)object);
        return HRJSONUtils.convertJSONMap(jsonObj);
    }

    public static HashMap convertJSONMap(JSONObject jsonObj) throws KDBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Iterator iter = jsonObj.keys();
        String key = null;
        while (iter.hasNext()) {
            key = iter.next().toString();
            Object obj = jsonObj.get(key);
            if (obj == null) {
                result.put(key, null);
                continue;
            }
            if (obj instanceof JSONArray) {
                result.put(key, HRJSONUtils.convertJSONArray((JSONArray)obj));
                continue;
            }
            if (obj instanceof JSONObject) {
                result.put(key, HRJSONUtils.convertJSONMap((JSONObject)obj));
                continue;
            }
            result.put(key, obj);
        }
        return result;
    }

    public static ArrayList convertJSONArray(JSONArray jsonArray) throws KDBizException {
        if (jsonArray == null) {
            return null;
        }
        ArrayList<HashMap> list = new ArrayList<HashMap>();
        int size = jsonArray.size();
        for (int i = 0; i < size; ++i) {
            JSONObject jsonObj = jsonArray.getJSONObject(i);
            list.add(HRJSONUtils.convertJSONMap(jsonObj));
        }
        return list;
    }

    public static Long getLongValOfCustomParam(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Long) {
            return (Long)object;
        }
        return Long.valueOf(String.valueOf(object));
    }
}

