/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.common.util;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.hr.hbp.common.util.HRArrayUtils;

public class HRListUtils {
    public static <T> List<List<T>> splitList(List<T> totalList, int oneListSize) {
        if (Objects.isNull(totalList) || totalList.isEmpty() || oneListSize < 1) {
            return Collections.emptyList();
        }
        int totalSize = totalList.size();
        int count = (totalSize + oneListSize - 1) / oneListSize;
        ArrayList<List<T>> returnList = new ArrayList<List<T>>(count);
        for (int index = 0; index < count; ++index) {
            returnList.add(totalList.subList(index * oneListSize, Math.min((index + 1) * oneListSize, totalSize)));
        }
        return returnList;
    }

    public static <T> String getListInSqlPlaceholder(List<T> list) {
        return list.stream().map(obj -> "?").collect(Collectors.joining(","));
    }

    public static <T> ArrayList<T> toList(T ... values) {
        return (ArrayList)HRListUtils.list(false, values);
    }

    public static <T> List<T> list(boolean isLinked, T ... values) {
        if (HRArrayUtils.isEmpty(values)) {
            return HRListUtils.list(isLinked);
        }
        AbstractList arrayList = isLinked ? new LinkedList() : new ArrayList(values.length);
        Collections.addAll(arrayList, values);
        return arrayList;
    }

    public static <T> List<T> list(boolean isLinked) {
        return isLinked ? new LinkedList() : new ArrayList();
    }

    public static <T> List<T> newArrayList() {
        return new ArrayList(16);
    }

    public static <T> List<T> newArrayList(int initialCapacity) {
        return new ArrayList(initialCapacity);
    }
}

