/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.common.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.hr.hbp.common.util.HRStringUtils;

public class HRMapUtils {
    public static final int DEFAULT_INITIAL_CAPACITY = 16;
    public static final float DEFAULT_LOAD_FACTOR = 0.75f;

    public static final void updateValues(Map<Object, Object> out, Map<Object, Object> in) {
        if (in == out) {
            return;
        }
        if (in == null || out == null) {
            return;
        }
        if (out.isEmpty()) {
            return;
        }
        int size = out.size();
        Map.Entry[] ents = new Map.Entry[size];
        out.entrySet().toArray(ents);
        for (int i = 0; i < size; ++i) {
            Map.Entry ent = ents[i];
            Object inVal = in.get(ent.getKey());
            if (inVal == ent.getValue() || inVal == null && !in.containsKey(ent)) continue;
            ent.setValue(inVal);
        }
    }

    public static final void addNew(Map<Object, Object> out, Map<Object, Object> in) {
        if (in == null || out == null) {
            return;
        }
        int size = in.size();
        if (size == 0) {
            return;
        }
        for (Map.Entry<Object, Object> ent : in.entrySet()) {
            Object key = ent.getKey();
            if (out.containsKey(key)) continue;
            out.put(key, ent.getValue());
        }
    }

    public static final void add(Map<Object, Object> out, Map<Object, Object> in) {
        if (in == null || out == null) {
            return;
        }
        int size = in.size();
        if (size == 0) {
            return;
        }
        Map.Entry[] ents = new Map.Entry[size];
        in.entrySet().toArray(ents);
        for (int i = 0; i < size; ++i) {
            Map.Entry ent = ents[i];
            out.put(ent.getKey(), ent.getValue());
        }
    }

    public static final void addKeyPrefix(Map<Object, Object> in, String prefix, Map<Object, Object> out) {
        if (in == null || out == null) {
            return;
        }
        int size = in.size();
        if (size == 0) {
            return;
        }
        Map.Entry[] ents = new Map.Entry[size];
        in.entrySet().toArray(ents);
        for (int i = 0; i < size; ++i) {
            Map.Entry ent = ents[i];
            out.put(prefix + (String)ent.getKey(), ent.getValue());
        }
    }

    public static final void addKeySuffix(Map<Object, Object> in, String suffix, Map<Object, Object> out) {
        if (in == null || out == null) {
            return;
        }
        int size = in.size();
        if (size == 0) {
            return;
        }
        Map.Entry[] ents = new Map.Entry[size];
        in.entrySet().toArray(ents);
        for (int i = 0; i < size; ++i) {
            Map.Entry ent = ents[i];
            out.put((String)ent.getKey() + suffix, ent.getValue());
        }
    }

    public static final void subKeyPrefix(Map<Object, Object> in, String prefix, Map<Object, Object> out) {
        if (in == null || out == null) {
            return;
        }
        int size = in.size();
        if (size == 0) {
            return;
        }
        int len = prefix.length();
        Map.Entry[] ents = new Map.Entry[size];
        in.entrySet().toArray(ents);
        for (int i = 0; i < size; ++i) {
            Map.Entry ent = ents[i];
            String key = (String)ent.getKey();
            if (!key.startsWith(prefix)) continue;
            out.put(key.substring(len), ent.getValue());
        }
    }

    public static HashMap<String, Object> gather(Map<Object, Object> in, String s, boolean prefix_suffix) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Iterator<Object> keys = in.keySet().iterator();
        Iterator<Object> vals = in.values().iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            Object val = vals.next();
            if (prefix_suffix) {
                if (!key.startsWith(s)) continue;
                map.put(key, val);
                continue;
            }
            if (!key.endsWith(s)) continue;
            map.put(key, val);
        }
        return map;
    }

    public static final void subKeySuffix(Map<Object, Object> in, String suffix, Map<Object, Object> out) {
        if (in == null || out == null) {
            return;
        }
        int size = in.size();
        if (size == 0) {
            return;
        }
        int len = suffix.length();
        Map.Entry[] ents = new Map.Entry[size];
        in.entrySet().toArray(ents);
        for (int i = 0; i < size; ++i) {
            Map.Entry ent = ents[i];
            String key = (String)ent.getKey();
            int pos = key.lastIndexOf(suffix);
            if (pos == -1 || pos + len != key.length()) continue;
            out.put(key.substring(0, pos), ent.getValue());
        }
    }

    public static final boolean equals(Map<Object, Object> map1, Map<Object, Object> map2) {
        if (map1 == map2) {
            return map1 != null;
        }
        if (map1 == null || map2 == null) {
            return false;
        }
        int size = map1.size();
        if (size != map2.size()) {
            return false;
        }
        if (size == 0) {
            return true;
        }
        Map.Entry[] ents = new Map.Entry[size];
        map1.entrySet().toArray(ents);
        for (int i = 0; i < size; ++i) {
            Map.Entry ent = ents[i];
            Object key1 = ent.getKey();
            Object val1 = ent.getValue();
            Object val2 = map2.get(key1);
            if (val2 == null) {
                if (!map2.containsKey(key1)) {
                    return false;
                }
                if (val1 == null) continue;
                return false;
            }
            if (val1 == null) {
                return false;
            }
            if (val2.equals(val1)) continue;
            return false;
        }
        return true;
    }

    public static final void removeNullVals(Map<Object, Object> map) {
        Object[] vals = map.values().toArray(new Object[0]);
        Object[] keys = null;
        for (int i = 0; i < vals.length; ++i) {
            if (vals[i] != null) continue;
            if (keys == null) {
                keys = map.keySet().toArray();
            }
            map.remove(keys[i]);
        }
    }

    public static <K, V> HashMap<K, V> newHashMap() {
        return new HashMap(16);
    }

    public static <K, V> HashMap<K, V> newHashMap(int size, boolean isLinked) {
        int initialCapacity = (int)((float)size / 0.75f) + 1;
        return isLinked ? new LinkedHashMap(initialCapacity) : new HashMap(initialCapacity);
    }

    public static <K, V> HashMap<K, V> newHashMap(int size) {
        return HRMapUtils.newHashMap(size, false);
    }

    public static <K, V> HashMap<K, V> newHashMap(boolean isLinked) {
        return HRMapUtils.newHashMap(16, isLinked);
    }

    public static boolean isEmpty(Map<?, ?> map) {
        return null == map || map.isEmpty();
    }

    public static boolean isOrmLocaleValueEmpty(OrmLocaleValue ormLocaleValue) {
        if (HRMapUtils.isEmpty(ormLocaleValue)) {
            return true;
        }
        for (Map.Entry entry : ormLocaleValue.entrySet()) {
            String value = (String)entry.getValue();
            if (!HRStringUtils.isNotEmpty(value)) continue;
            return false;
        }
        return true;
    }
}

