/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.common.util;

import java.util.Map;
import kd.bos.base.BaseShowParameter;
import kd.bos.base.MobileBaseShowParameter;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.MobileBillShowParameter;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.list.MobileListShowParameter;
import kd.bos.report.ReportShowParameter;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.hr.hbp.common.model.FormModel;
import org.apache.commons.lang.ObjectUtils;

@KSObject
public class HRShowPageUtils {
    public static final String FORM_ID = "formId";
    public static final String TEMPLATE_ID = "templateId";
    public static final String FORM_NAME = "formName";
    public static final String NEED_CALLBACK = "needCallBack";
    public static final String SHOW_TYPE = "showType";
    public static final String FORM_TYPE = "formType";
    public static final String CUSTOM_PARAM = "customParam";
    public static final String LOOKUP = "lookup";
    public static final String LIST_FILTER_PARAMETER = "listFilterParameter";
    public static final String WEB_LIST_TEMPLATE = "bos_list";
    public static final String WEB_TREE_LIST_TEMPLATE = "bos_treelist";
    public static final String TARGET_KEY = "_submaintab_";
    public static final String ISNEED_BAESLIST = "isneedbaselist";

    @KSMethod
    public static String showPage(FormModel formModel, AbstractFormPlugin formPlugin) {
        FormShowParameter formShowParameter = formModel.getFormShowParameter();
        if (formModel.getCallBack().booleanValue()) {
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)formPlugin, formModel.getFormId()));
        }
        formPlugin.getView().showForm(formShowParameter);
        return formShowParameter.getPageId();
    }

    public static void showPage(Map<String, Object> paramMap, AbstractFormPlugin formPlugin) {
        if (paramMap.get(FORM_ID) == null) {
            return;
        }
        String formType = "1";
        if (paramMap.get(FORM_TYPE) != null) {
            formType = (String)paramMap.get(FORM_TYPE);
        }
        switch (formType) {
            case "0": {
                HRShowPageUtils.showWebList(paramMap, formPlugin);
                break;
            }
            case "9": {
                HRShowPageUtils.showWebTreeList(paramMap, formPlugin);
                break;
            }
            case "1": {
                HRShowPageUtils.showWebForm(paramMap, formPlugin);
                break;
            }
            case "2": {
                HRShowPageUtils.showWebBill(paramMap, formPlugin);
                break;
            }
            case "3": {
                HRShowPageUtils.showWebReport(paramMap, formPlugin);
                break;
            }
            case "7": {
                HRShowPageUtils.showWebBase(paramMap, formPlugin);
                break;
            }
            case "4": {
                HRShowPageUtils.showMobileBillList(paramMap, formPlugin);
                break;
            }
            case "5": {
                HRShowPageUtils.showMobileForm(paramMap, formPlugin);
                break;
            }
            case "6": {
                HRShowPageUtils.showMobileBill(paramMap, formPlugin);
                break;
            }
            case "8": {
                HRShowPageUtils.showMobileBase(paramMap, formPlugin);
                break;
            }
            case "10": {
                HRShowPageUtils.showMobileBaseList(paramMap, formPlugin);
                break;
            }
            case "13": {
                HRShowPageUtils.showMobileForm(paramMap, formPlugin);
                break;
            }
        }
    }

    private static void showMobileBase(Map<String, Object> paramMap, AbstractFormPlugin formPlugin) {
        String formId = (String)paramMap.get(FORM_ID);
        MobileBaseShowParameter showParameter = new MobileBaseShowParameter();
        showParameter.setFormId(formId);
        ShowType showType = (ShowType)ObjectUtils.defaultIfNull((Object)paramMap.get(SHOW_TYPE), (Object)ShowType.Floating);
        showParameter.getOpenStyle().setShowType(showType);
        HRShowPageUtils.openPage((FormShowParameter)showParameter, paramMap, formPlugin);
    }

    public static void showMobileBillList(Map<String, Object> paramMap, AbstractFormPlugin formPlugin) {
        String formId = (String)paramMap.get(FORM_ID);
        MobileListShowParameter showParameter = new MobileListShowParameter();
        showParameter.setBillFormId(formId);
        String templateId = "hr_billtemplate";
        if (paramMap.get(TEMPLATE_ID) != null) {
            templateId = (String)paramMap.get(TEMPLATE_ID);
        }
        showParameter.setFormId(templateId);
        ShowType showType = (ShowType)ObjectUtils.defaultIfNull((Object)paramMap.get(SHOW_TYPE), (Object)ShowType.Floating);
        showParameter.getOpenStyle().setShowType(showType);
        Boolean lookup = (Boolean)ObjectUtils.defaultIfNull((Object)paramMap.get(LOOKUP), (Object)Boolean.FALSE);
        if (lookup.booleanValue()) {
            showParameter.setLookUp(true);
        }
        HRShowPageUtils.openPage((FormShowParameter)showParameter, paramMap, formPlugin);
    }

    public static void showMobileBaseList(Map<String, Object> paramMap, AbstractFormPlugin formPlugin) {
        String formId = (String)paramMap.get(FORM_ID);
        MobileListShowParameter showParameter = new MobileListShowParameter();
        showParameter.setBillFormId(formId);
        String templateId = "hr_basetemplate";
        if (paramMap.get(TEMPLATE_ID) != null) {
            templateId = (String)paramMap.get(TEMPLATE_ID);
        }
        showParameter.setFormId(templateId);
        ShowType showType = (ShowType)ObjectUtils.defaultIfNull((Object)paramMap.get(SHOW_TYPE), (Object)ShowType.Floating);
        showParameter.getOpenStyle().setShowType(showType);
        Boolean ifLookUp = (Boolean)ObjectUtils.defaultIfNull((Object)paramMap.get(LOOKUP), (Object)Boolean.FALSE);
        showParameter.setLookUp(ifLookUp.booleanValue());
        HRShowPageUtils.openPage((FormShowParameter)showParameter, paramMap, formPlugin);
    }

    public static void showMobileForm(Map<String, Object> paramMap, AbstractFormPlugin formPlugin) {
        String formId = (String)paramMap.get(FORM_ID);
        MobileFormShowParameter showParameter = new MobileFormShowParameter();
        showParameter.setFormId(formId);
        showParameter.setSendToClient(true);
        ShowType showType = (ShowType)ObjectUtils.defaultIfNull((Object)paramMap.get(SHOW_TYPE), (Object)ShowType.Floating);
        showParameter.getOpenStyle().setShowType(showType);
        String targetKey = (String)ObjectUtils.defaultIfNull((Object)paramMap.get(TARGET_KEY), (Object)TARGET_KEY);
        showParameter.getOpenStyle().setTargetKey(targetKey);
        HRShowPageUtils.openPage((FormShowParameter)showParameter, paramMap, formPlugin);
    }

    public static void showMobileBill(Map<String, Object> paramMap, AbstractFormPlugin formPlugin) {
        String formId = (String)paramMap.get(FORM_ID);
        MobileBillShowParameter showParameter = new MobileBillShowParameter();
        showParameter.setFormId(formId);
        ShowType showType = (ShowType)ObjectUtils.defaultIfNull((Object)paramMap.get(SHOW_TYPE), (Object)ShowType.Floating);
        showParameter.getOpenStyle().setShowType(showType);
        HRShowPageUtils.openPage((FormShowParameter)showParameter, paramMap, formPlugin);
    }

    public static void showWebForm(Map<String, Object> paramMap, AbstractFormPlugin formPlugin) {
        String formId = (String)paramMap.get(FORM_ID);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(formId);
        ShowType showType = (ShowType)ObjectUtils.defaultIfNull((Object)paramMap.get(SHOW_TYPE), (Object)ShowType.NewTabPage);
        showParameter.getOpenStyle().setShowType(showType);
        showParameter.getOpenStyle().setTargetKey(TARGET_KEY);
        HRShowPageUtils.openPage(showParameter, paramMap, formPlugin);
    }

    public static void showWebBill(Map<String, Object> paramMap, AbstractFormPlugin formPlugin) {
        String formId = (String)paramMap.get(FORM_ID);
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId(formId);
        ShowType showType = (ShowType)ObjectUtils.defaultIfNull((Object)paramMap.get(SHOW_TYPE), (Object)ShowType.NewTabPage);
        showParameter.getOpenStyle().setShowType(showType);
        showParameter.getOpenStyle().setTargetKey(TARGET_KEY);
        HRShowPageUtils.openPage((FormShowParameter)showParameter, paramMap, formPlugin);
    }

    public static void showWebTreeList(Map<String, Object> paramMap, AbstractFormPlugin formPlugin) {
        paramMap.put(TEMPLATE_ID, WEB_TREE_LIST_TEMPLATE);
        HRShowPageUtils.showWebList(paramMap, formPlugin);
    }

    public static void showWebList(Map<String, Object> paramMap, AbstractFormPlugin formPlugin) {
        String formId = (String)paramMap.get(FORM_ID);
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setBillFormId(formId);
        String templateId = WEB_LIST_TEMPLATE;
        if (paramMap.get(TEMPLATE_ID) != null) {
            templateId = (String)paramMap.get(TEMPLATE_ID);
        }
        showParameter.setFormId(templateId);
        ShowType showType = (ShowType)ObjectUtils.defaultIfNull((Object)paramMap.get(SHOW_TYPE), (Object)ShowType.NewTabPage);
        showParameter.getOpenStyle().setShowType(showType);
        showParameter.getOpenStyle().setTargetKey(TARGET_KEY);
        Boolean ifLookUp = (Boolean)ObjectUtils.defaultIfNull((Object)paramMap.get(LOOKUP), (Object)Boolean.FALSE);
        showParameter.setLookUp(ifLookUp.booleanValue());
        if (paramMap.get(LIST_FILTER_PARAMETER) != null) {
            showParameter.setListFilterParameter((ListFilterParameter)paramMap.get(LIST_FILTER_PARAMETER));
        }
        HRShowPageUtils.openPage((FormShowParameter)showParameter, paramMap, formPlugin);
    }

    public static void showWebReport(Map<String, Object> paramMap, AbstractFormPlugin formPlugin) {
        String formId = (String)paramMap.get(FORM_ID);
        ReportShowParameter showParameter = new ReportShowParameter();
        showParameter.setFormId(formId);
        ShowType showType = (ShowType)ObjectUtils.defaultIfNull((Object)paramMap.get(SHOW_TYPE), (Object)ShowType.NewTabPage);
        showParameter.getOpenStyle().setShowType(showType);
        showParameter.getOpenStyle().setTargetKey(TARGET_KEY);
        HRShowPageUtils.openPage((FormShowParameter)showParameter, paramMap, formPlugin);
    }

    public static void showWebBase(Map<String, Object> paramMap, AbstractFormPlugin formPlugin) {
        String formId = (String)paramMap.get(FORM_ID);
        BaseShowParameter showParameter = new BaseShowParameter();
        showParameter.setFormId(formId);
        ShowType showType = (ShowType)ObjectUtils.defaultIfNull((Object)paramMap.get(SHOW_TYPE), (Object)ShowType.NewTabPage);
        showParameter.getOpenStyle().setShowType(showType);
        showParameter.getOpenStyle().setTargetKey(TARGET_KEY);
        HRShowPageUtils.openPage((FormShowParameter)showParameter, paramMap, formPlugin);
    }

    public static void showShareDialog(Map<String, Object> paramMap, AbstractFormPlugin formPlugin) {
        String formId = (String)paramMap.get(FORM_ID);
        MobileFormShowParameter showParameter = new MobileFormShowParameter();
        showParameter.setFormId(formId);
        ShowType showType = (ShowType)ObjectUtils.defaultIfNull((Object)paramMap.get(SHOW_TYPE), (Object)ShowType.Modal);
        showParameter.getOpenStyle().setShowType(showType);
        HRShowPageUtils.openPage((FormShowParameter)showParameter, paramMap, formPlugin);
    }

    private static void openPage(FormShowParameter showParameter, Map<String, Object> paramMap, AbstractFormPlugin formPlugin) {
        if (paramMap.get(FORM_NAME) != null) {
            showParameter.setCaption((String)paramMap.get(FORM_NAME));
        }
        Boolean needCallBack = (Boolean)ObjectUtils.defaultIfNull((Object)paramMap.get(NEED_CALLBACK), (Object)Boolean.FALSE);
        String formId = (String)paramMap.get(FORM_ID);
        if (needCallBack.booleanValue()) {
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)formPlugin, formId));
        }
        if (paramMap.get(CUSTOM_PARAM) != null) {
            Map customParam = (Map)paramMap.get(CUSTOM_PARAM);
            showParameter.getCustomParams().putAll(customParam);
        }
        formPlugin.getView().showForm(showParameter);
    }
}

