/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.common.util;

import io.netty.util.CharsetUtil;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRArrayUtils;

public class HRStringUtils {
    private static final Log LOGGER = LogFactory.getLog(HRStringUtils.class);
    public static final String NULL = "null";
    public static final String SPACE = " ";
    public static final char TAB = '\t';
    public static final String EMPTY = "";
    public static final char DOT = '.';
    public static final String DOUBLE_DOT = "..";
    public static final char SLASH = '/';
    public static final char SINGLE_QUOTE = '\'';
    public static final char BACKSLASH = '\\';
    public static final char CR = '\r';
    public static final char LF = '\n';
    public static final String CRLF = "\r\n";
    public static final char UNDERLINE = '_';
    public static final char DASHED = '-';
    public static final char COMMA = ',';
    public static final char DELIM_START = '{';
    public static final char DELIM_END = '}';
    public static final char BRACKET_START = '[';
    public static final char BRACKET_END = ']';
    public static final char COLON = ':';
    public static final char DOUBLE_QUOTES = '\"';
    public static final char AMP = '&';
    public static final String EMPTY_JSON = "{}";
    private static final List<String> SPECIAL_CHAR_LIST = Arrays.asList("+", "-", "/", "*", "\"", "(", ")", "!=", "=", "<", ">", "<=", ">=", " ", ".", "@", "[", "]", " ");
    private static final String[] JAVA_VARIABLE_FORBID_CHAR_ARRAY = new String[]{"+", "-", "/", "*", "(", ")", "=", "<", ">", " ", ".", "@", "!", "#", "|", "%", "^", "&", "-", "`", "\"", "'", "[", "]", "{", "}", "\\", " "};
    public static final int INDEX_NOT_FOUND = -1;
    private static final char[] HEXDIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final String[] JAVA_KEYWORDS = new String[]{"assert", "abstract", "continue", "for", "new", "switch", "boolean", "default", "goto", "null", "synchronized", "break", "do", "if", "package", "this", "byte", "double", "implements", "private", "threadsafe", "byvalue", "else", "import", "protected", "throw", "case", "extends", "instanceof", "public", "transient", "catch", "false", "int", "return", "true", "char", "final", "interface", "short", "try", "class", "finally", "long", "static", "void", "const", "float", "native", "super", "while", "volatile", "strictfp"};
    private static String VOWELS = "AEIOU";
    private static String FRONTV = "EIY";
    private static String VARSON = "CSPTG";
    private static final int SEPERATOR_DEFAULT_SIZE = 9;

    public static String[] split(String lineStr, int seperator) {
        int rowJ;
        if (lineStr == null) {
            return null;
        }
        if ((lineStr = lineStr.trim()).length() == 0) {
            return null;
        }
        if (lineStr.indexOf(seperator) < 0) {
            return new String[]{lineStr};
        }
        ArrayList<String> list = new ArrayList<String>(lineStr.length());
        int rowI = 0;
        while ((rowJ = lineStr.indexOf(seperator, rowI)) >= 0) {
            list.add(lineStr.substring(rowI, rowJ).trim());
            rowI = rowJ + 1;
        }
        list.add(lineStr.substring(rowI).trim());
        return list.toArray(new String[list.size()]);
    }

    public static String[] split(String line, String seperatorStr) {
        int rowJ;
        if (line == null) {
            return null;
        }
        if ((line = line.trim()).length() == 0) {
            return new String[]{EMPTY};
        }
        if (line.indexOf(seperatorStr) < 0) {
            return new String[]{line};
        }
        ArrayList<String> list = new ArrayList<String>(line.length());
        int rowI = 0;
        while ((rowJ = line.indexOf(seperatorStr, rowI)) >= 0) {
            list.add(line.substring(rowI, rowJ).trim());
            rowI = rowJ + 1;
        }
        list.add(line.substring(rowI).trim());
        return list.toArray(new String[list.size()]);
    }

    public static String fixNumber(long nn) {
        return HRStringUtils.fixNumber(nn, 8);
    }

    public static String fixNumber(long nn, int len) {
        char[] chars = new char[len];
        for (int rowI = 0; rowI < len; ++rowI) {
            chars[rowI] = 48;
        }
        return new DecimalFormat(new String(chars)).format(nn);
    }

    public static String fixNumber(int nn) {
        return HRStringUtils.fixNumber((long)nn, 4);
    }

    public static String fixNumber(int nn, int len) {
        return HRStringUtils.fixNumber((long)nn, len);
    }

    public static final boolean isEmpty(String str) {
        return str == null || str.trim().length() == 0;
    }

    public static final boolean isNotEmpty(String str) {
        return !HRStringUtils.isEmpty(str);
    }

    public static boolean equals(String s1, String s2) {
        if (HRStringUtils.isEmpty(s1)) {
            return HRStringUtils.isEmpty(s2);
        }
        return s1.equals(s2);
    }

    public static boolean equalsIgnoreCase(String s1, String s2) {
        if (HRStringUtils.isEmpty(s1)) {
            return HRStringUtils.isEmpty(s2);
        }
        return s1.equalsIgnoreCase(s2);
    }

    public static String numStr4Java(String str, char ch, char c1) {
        if (str == null) {
            return null;
        }
        StringBuilder stringbuffer = new StringBuilder();
        for (int rowI = 0; rowI < str.length(); ++rowI) {
            char c2 = str.charAt(rowI);
            if (c2 == ch) continue;
            if (c2 == c1) {
                stringbuffer.append('.');
                continue;
            }
            stringbuffer.append(c2);
        }
        return stringbuffer.toString();
    }

    public static String takeCommasFromNumStr(String str) {
        if (str == null) {
            return null;
        }
        if (str.indexOf(44) == -1) {
            return str;
        }
        return HRStringUtils.numStr4Java(str, ',', '.');
    }

    public static String[] enumeration2StringArray(Enumeration<String> enumeration, int len) {
        int rowJ = 0;
        String[] as = new String[len];
        while (enumeration.hasMoreElements()) {
            as[rowJ++] = enumeration.nextElement();
        }
        return as;
    }

    public static byte[] chars2bytes(char[] ac) {
        byte[] abyte0 = new byte[ac.length * 2];
        int rowI = 0;
        for (int rowJ = 0; rowJ < ac.length; ++rowJ) {
            char c0 = ac[rowJ];
            char c1 = ac[rowJ];
            abyte0[rowI++] = (byte)(c0 >> 8);
            abyte0[rowI++] = (byte)c1;
        }
        return abyte0;
    }

    public static char[] bytes2chars(byte[] abyte0) throws KDBizException {
        if (abyte0.length % 2 != 0) {
            throw new KDBizException("Cannot convert an odd number of bytes");
        }
        char[] ac = new char[abyte0.length / 2];
        int rowI = 0;
        for (int rowJ = 0; rowJ < ac.length; ++rowJ) {
            byte byte0 = abyte0[rowI++];
            byte byte1 = abyte0[rowI++];
            ac[rowJ] = (char)(byte0 << 8 & 0xFF00 | byte1 & 0xFF);
        }
        return ac;
    }

    public static String padStringWidth(String sb, int in) {
        StringBuffer stringbuffer = null;
        if (sb != null) {
            int rowJ;
            stringbuffer = new StringBuffer(sb);
            stringbuffer.setLength(in);
            for (int rowL = rowJ = sb.length(); rowL < in; ++rowL) {
                stringbuffer.setCharAt(rowL, ' ');
            }
        } else {
            stringbuffer = new StringBuffer(in);
            stringbuffer.setLength(in);
            for (int rowK = 0; rowK < in; ++rowK) {
                stringbuffer.setCharAt(rowK, ' ');
            }
        }
        return stringbuffer.toString();
    }

    public static String padStringWidth(int lenI, int lenJ) {
        return HRStringUtils.padStringWidth(String.valueOf(lenI), lenJ);
    }

    public static String padStringWidth(float fv, int iv) {
        return HRStringUtils.padStringWidth(String.valueOf(fv), iv);
    }

    public static String padStringWidth(long lw, int iw) {
        return HRStringUtils.padStringWidth(String.valueOf(lw), iw);
    }

    public static String padStringWidth(double dw, int iw) {
        return HRStringUtils.padStringWidth(String.valueOf(dw), iw);
    }

    public static String toHexString(long xv, int chars) {
        char[] buf = new char[chars];
        int charPos = chars;
        while (--charPos >= 0) {
            buf[charPos] = HEXDIGITS[(int)(xv & 0xFL)];
            xv >>>= 4;
        }
        return Arrays.toString(buf);
    }

    public static String gbtounicode(String str) {
        try {
            return new String(str.getBytes("8859_1"), "GB2312");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public static String unicodeToGB(String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        try {
            return new String(str.getBytes("GB2312"), "8859_1");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public static String cnulls(Object obj) {
        return HRStringUtils.cnulls(obj, EMPTY);
    }

    public static String cnulls(Object obj, String defaultValue) {
        if (obj == null) {
            return defaultValue;
        }
        return obj.toString();
    }

    public static String cnulls(String str, String defaultValue) {
        if (str == null) {
            return defaultValue;
        }
        return str;
    }

    public static String cnulls(String str) {
        if (str == null) {
            return EMPTY;
        }
        return str;
    }

    public static String formatCurrency(double cy) {
        return NumberFormat.getCurrencyInstance().format(cy);
    }

    public static String formatNumber(double dw, int nw) {
        StringBuilder pattern = new StringBuilder("#,##0");
        if (nw > 0) {
            pattern.append('.');
            for (int rowI = 0; rowI < nw; ++rowI) {
                pattern.append('0');
            }
        }
        return new DecimalFormat(pattern.toString()).format(dw);
    }

    public static int compareToIgnoreCase(String str1, String str2) {
        return str1.toLowerCase(Locale.ROOT).compareTo(str2.toLowerCase(Locale.ROOT));
    }

    public static boolean endsWithIgnoreCase(String str, String suffix) {
        return str.toLowerCase(Locale.ROOT).endsWith(suffix.toLowerCase(Locale.ROOT));
    }

    public static int indexOfIgnoreCase(String str, int find) {
        return str.toLowerCase(Locale.ROOT).indexOf(Character.toLowerCase((char)find));
    }

    public static int indexOfIgnoreCase(String str, int find, int start) {
        return str.toLowerCase(Locale.ROOT).indexOf(Character.toLowerCase((char)find), start);
    }

    public static int indexOfIgnoreCase(String str, String find) {
        return str.toLowerCase(Locale.ROOT).indexOf(find.toLowerCase(Locale.ROOT));
    }

    public static int indexOfIgnoreCase(String str, String find, int start) {
        return str.toLowerCase(Locale.ROOT).indexOf(find.toLowerCase(Locale.ROOT), start);
    }

    public static int lastIndexOfIgnoreCase(String str, int find) {
        return str.toLowerCase(Locale.ROOT).lastIndexOf(Character.toLowerCase((char)find));
    }

    public static int lastIndexOfIgnoreCase(String str, int find, int start) {
        return str.toLowerCase(Locale.ROOT).lastIndexOf(Character.toLowerCase((char)find), start);
    }

    public static int lastIndexOfIgnoreCase(String str, String find) {
        return str.toLowerCase(Locale.ROOT).lastIndexOf(find.toLowerCase(Locale.ROOT));
    }

    public static int lastIndexOfIgnoreCase(String str, String find, int start) {
        return str.toLowerCase(Locale.ROOT).lastIndexOf(find.toLowerCase(Locale.ROOT), start);
    }

    public static int occurencesOf(String str, char ch) {
        char[] chars = new char[str.length()];
        str.getChars(0, chars.length, chars, 0);
        int count = 0;
        for (int rowI = 0; rowI < chars.length; ++rowI) {
            if (chars[rowI] != ch) continue;
            ++count;
        }
        return count;
    }

    public static int occurencesOfIgnoreCase(String str, char ch) {
        return HRStringUtils.occurencesOf(str.toLowerCase(Locale.ROOT), Character.toLowerCase(ch));
    }

    public static final String replace(String chars, String oldChars, String newChars) {
        if (oldChars == null) {
            return null;
        }
        StringBuilder str = new StringBuilder(chars);
        int begin = chars.indexOf(oldChars);
        if (begin < 0) {
            return str.toString();
        }
        int end = begin + oldChars.length();
        str.replace(begin, end, newChars);
        return str.toString();
    }

    public static String replaceIgnoreCase(String chars, String oldChars, String newChars) {
        int pos;
        String lowerStr = chars.toLowerCase(Locale.ROOT);
        int len = newChars.length();
        int lastPos = pos = lowerStr.indexOf(oldChars);
        while (pos > -1) {
            String firstPart = chars.substring(0, pos);
            String lastPart = chars.substring(pos + oldChars.length(), chars.length());
            chars = firstPart + newChars + lastPart;
            lastPos = pos + len;
            pos = chars.indexOf(oldChars, lastPos);
        }
        return chars;
    }

    public static boolean startsWithIgnoreCase(String str, String prefix) {
        return str.toLowerCase(Locale.ROOT).startsWith(prefix.toLowerCase(Locale.ROOT));
    }

    public static boolean startsWithIgnoreCase(String str, String prefix, int start) {
        return str.toLowerCase(Locale.ROOT).startsWith(prefix.toLowerCase(Locale.ROOT), start);
    }

    public static String stackToString(Throwable throwable) {
        LOGGER.error(throwable);
        return throwable.getMessage();
    }

    public static String stackToString(Exception exception) {
        LOGGER.error((Throwable)exception);
        return exception.getMessage();
    }

    public static String byteArrayToString(byte[] ba) {
        int length = ba.length;
        char[] buf = new char[length * 2];
        int rowI = 0;
        int rowJ = 0;
        while (rowI < length) {
            byte rowK = ba[rowI++];
            buf[rowJ++] = HEX_DIGITS[rowK >>> 4 & 0xF];
            buf[rowJ++] = HEX_DIGITS[rowK & 0xF];
        }
        return Arrays.toString(buf);
    }

    public static byte[] hexFromString(String hex) {
        int len = hex.length();
        byte[] buf = new byte[(len + 1) / 2];
        int rowI = 0;
        int rowJ = 0;
        if (len % 2 == 1) {
            buf[rowJ++] = (byte)HRStringUtils.fromDigit(hex.charAt(rowI++));
        }
        while (rowI < len) {
            buf[rowJ++] = (byte)(HRStringUtils.fromDigit(hex.charAt(rowI++)) << 4 | HRStringUtils.fromDigit(hex.charAt(rowI++)));
        }
        return buf;
    }

    public static int fromDigit(char ch) {
        if (ch >= '0' && ch <= '9') {
            return ch - 48;
        }
        if (ch >= 'A' && ch <= 'F') {
            return ch - 65 + 10;
        }
        if (ch >= 'a' && ch <= 'f') {
            return ch - 97 + 10;
        }
        throw new IllegalArgumentException("invalid hex digit '" + ch + "'");
    }

    public static String escapeXMLstr(String input) {
        if (input == null) {
            return null;
        }
        StringBuilder outputStringBuilder = new StringBuilder();
        int len = input.length();
        for (int rowI = 0; rowI < len; ++rowI) {
            char ch = input.charAt(rowI);
            if (ch == '&') {
                outputStringBuilder.append("&amp;");
                continue;
            }
            if (ch == '<') {
                outputStringBuilder.append("&lt;");
                continue;
            }
            if (ch == '>') {
                outputStringBuilder.append("&gt;");
                continue;
            }
            if (ch == '\'') {
                outputStringBuilder.append("&apos;");
                continue;
            }
            if (ch == '\"') {
                outputStringBuilder.append("&quot;");
                continue;
            }
            outputStringBuilder.append(ch);
        }
        return outputStringBuilder.toString();
    }

    public static String escapeHTMLstr(String inputStr) {
        if (inputStr == null) {
            return null;
        }
        StringBuilder output = new StringBuilder();
        int len = inputStr.length();
        for (int rowI = 0; rowI < len; ++rowI) {
            char ch = inputStr.charAt(rowI);
            if (ch == '&') {
                output.append("&amp;");
                continue;
            }
            if (ch == '<') {
                output.append("&lt;");
                continue;
            }
            if (ch == '>') {
                output.append("&gt;");
                continue;
            }
            if (ch == '\"') {
                output.append("&quot;");
                continue;
            }
            output.append(ch);
        }
        return output.toString();
    }

    public static String headCharUpperCase(String str) {
        if (str == null || EMPTY.equals(str)) {
            return str;
        }
        String headChar = str.substring(0, 1).toUpperCase(Locale.ROOT);
        if (str.length() == 1) {
            return headChar;
        }
        return headChar + str.substring(1, str.length());
    }

    public static String headCharLowerCase(String str) {
        if (str == null || EMPTY.equals(str)) {
            return str;
        }
        String headChar = str.substring(0, 1).toLowerCase(Locale.ROOT);
        if (str.length() == 1) {
            return headChar;
        }
        return headChar + str.substring(1, str.length());
    }

    public static String left(String str, int num) {
        return str.substring(str.length() - num);
    }

    public static String right(String str, int num) {
        return str.substring(str.length() - num, str.length());
    }

    public static boolean isJavaIdentifier(String str) {
        if (HRStringUtils.isEmpty(str)) {
            return false;
        }
        char[] chars = str.toCharArray();
        for (int rowI = 0; rowI < chars.length; ++rowI) {
            if (Character.isJavaIdentifierPart(chars[rowI]) && (rowI != 0 || Character.isJavaIdentifierStart(chars[rowI]))) continue;
            return false;
        }
        return !Arrays.asList(JAVA_KEYWORDS).contains(str);
    }

    public static boolean isJavaClassName(String name) {
        if (HRStringUtils.isEmpty(name)) {
            return true;
        }
        if (name.startsWith(SPACE) || name.startsWith(".") || name.endsWith(SPACE) || name.endsWith(".")) {
            return false;
        }
        String[] pks = HRStringUtils.split(name, ".");
        for (int rowI = 0; rowI < pks.length; ++rowI) {
            if (HRStringUtils.isJavaIdentifier(pks[rowI])) continue;
            return false;
        }
        return true;
    }

    public static boolean isFileName(String name) {
        return !HRStringUtils.isEmpty(name) && name.indexOf(60) <= -1 && name.indexOf(42) <= -1 && name.indexOf(47) <= -1 && name.indexOf(58) <= -1 && name.indexOf(63) <= -1 && name.indexOf(92) <= -1 && name.indexOf(34) <= -1;
    }

    public static String arrayToString(Object[] objArray, String operator) {
        if (objArray != null && objArray.length > 0) {
            StringBuilder sb = new StringBuilder();
            for (int rowI = 0; rowI < objArray.length; ++rowI) {
                sb.append(objArray[rowI]);
                sb.append(operator);
            }
            if (operator != null && operator.length() > 0) {
                if (sb.indexOf(operator) == 0) {
                    sb.delete(0, operator.length());
                } else if (sb.lastIndexOf(operator) == sb.length() - operator.length()) {
                    sb.delete(sb.length() - operator.length(), sb.length());
                }
            }
            return sb.toString();
        }
        return null;
    }

    public static String[] stringArrayAppend(String[] array, String appendObj) {
        if (array == null) {
            array = new String[]{};
        }
        String[] newArray = new String[array.length + 1];
        System.arraycopy(array, 0, newArray, 0, array.length);
        newArray[newArray.length - 1] = appendObj;
        return newArray;
    }

    public static String trim(String str) {
        return str != null ? str.trim() : null;
    }

    public static String addBracket(String str) {
        if (HRStringUtils.isEmpty(str)) {
            return str;
        }
        return "(" + str + ")";
    }

    public static String abbreviate(String txt, int len) {
        StringBuilder result = new StringBuilder();
        String[] str = HRStringUtils.splitByUpperCaseChar(txt);
        if (str.length < len) {
            String abb = HRStringUtils.metaphone(str[0], len - str.length + 1);
            if (abb.length() == 0) {
                abb = str[0].substring(0, len - str.length + 1).toUpperCase(Locale.ROOT);
            }
            abb = abb.substring(0, 1) + abb.substring(1).toLowerCase(Locale.ROOT);
            result.append(abb);
            for (int rowI = 1; rowI < str.length; ++rowI) {
                result.append(str[rowI].charAt(0));
            }
        } else {
            for (int rowI = 0; rowI < len; ++rowI) {
                result.append(str[rowI].charAt(0));
            }
        }
        return result.toString();
    }

    private static String metaphone(String txt, int maxCodeLen) {
        if (txt == null || txt.length() == 0) {
            return EMPTY;
        }
        if (maxCodeLen <= 0) {
            return EMPTY;
        }
        if (maxCodeLen > txt.length()) {
            return txt;
        }
        if (txt.length() == 1) {
            return txt.toUpperCase(Locale.ROOT);
        }
        boolean hard = false;
        char[] inwd = txt.toUpperCase(Locale.ROOT).toCharArray();
        StringBuilder local = new StringBuilder();
        StringBuilder code = new StringBuilder();
        HRStringUtils.appendLocal(inwd, local);
        int wdsz = local.length();
        int nn = 0;
        while (code.length() < maxCodeLen && nn < wdsz) {
            char symb = local.charAt(nn);
            nn = symb != 'C' && HRStringUtils.isPreviousChar(local, nn, symb) ? ++nn : HRStringUtils.appendCode(local, code, wdsz, nn, symb);
            if (code.length() <= maxCodeLen) continue;
            code.setLength(maxCodeLen);
        }
        return code.toString();
    }

    private static int appendCode(StringBuilder local, StringBuilder code, int wdsz, int nn, char symb) {
        nn = HRStringUtils.appendCode1(local, code, wdsz, nn, symb);
        nn = HRStringUtils.appendCode2(local, code, wdsz, nn, symb);
        nn = HRStringUtils.appendCode3(local, code, wdsz, nn, symb);
        return ++nn;
    }

    private static int appendCode1(StringBuilder local, StringBuilder code, int wdsz, int nn, char symb) {
        switch (symb) {
            case 'A': 
            case 'E': 
            case 'I': 
            case 'O': 
            case 'U': {
                if (nn != 0) break;
                code.append(symb);
                break;
            }
            case 'B': {
                HRStringUtils.handleB(local, code, wdsz, nn, symb);
                break;
            }
            case 'C': {
                HRStringUtils.codeByC(local, code, wdsz, nn);
                break;
            }
            case 'D': {
                nn = HRStringUtils.appendCodeD(local, code, wdsz, nn);
                break;
            }
            case 'G': {
                HRStringUtils.codeByD(local, code, wdsz, nn);
                break;
            }
            case 'H': {
                HRStringUtils.codeByH(local, code, wdsz, nn);
                break;
            }
        }
        return nn;
    }

    private static int appendCode2(StringBuilder local, StringBuilder code, int wdsz, int nn, char symb) {
        switch (symb) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': 
            case 'F': 
            case 'J': 
            case 'L': 
            case 'M': 
            case 'N': 
            case 'R': {
                code.append(symb);
                break;
            }
        }
        return nn;
    }

    private static int appendCode3(StringBuilder local, StringBuilder code, int wdsz, int nn, char symb) {
        switch (symb) {
            case 'K': {
                HRStringUtils.appendCodeK(local, code, nn, symb);
                break;
            }
            case 'P': {
                code.append(symb);
                break;
            }
            case 'Q': {
                code.append('Q');
                break;
            }
            case 'S': {
                HRStringUtils.appendCodeS(local, code, nn);
                break;
            }
            case 'T': {
                HRStringUtils.codeByT(local, code, nn);
                break;
            }
            case 'V': {
                code.append('V');
                break;
            }
            case 'W': 
            case 'Y': {
                if (HRStringUtils.isLastChar(wdsz, nn) || !HRStringUtils.isVowel(local, nn + 1)) break;
                code.append(symb);
                break;
            }
            case 'X': {
                code.append('X');
                break;
            }
            case 'Z': {
                code.append('Z');
                break;
            }
        }
        return nn;
    }

    private static void handleB(StringBuilder local, StringBuilder code, int wdsz, int nn, char symb) {
        if (HRStringUtils.isPreviousChar(local, nn, 'M') && HRStringUtils.isLastChar(wdsz, nn)) {
            return;
        }
        code.append(symb);
    }

    private static void codeByT(StringBuilder local, StringBuilder code, int nn) {
        if (HRStringUtils.regionMatch(local, nn, "TIA") || HRStringUtils.regionMatch(local, nn, "TIO")) {
            code.append('X');
            return;
        }
        if (HRStringUtils.regionMatch(local, nn, "TCH")) {
            return;
        }
        if (!HRStringUtils.regionMatch(local, nn, "TH")) {
            code.append('T');
        }
    }

    private static void codeByH(StringBuilder local, StringBuilder code, int wdsz, int nn) {
        if (HRStringUtils.isLastChar(wdsz, nn)) {
            return;
        }
        if (nn > 0 && VARSON.indexOf(local.charAt(nn - 1)) >= 0) {
            return;
        }
        if (HRStringUtils.isVowel(local, nn + 1)) {
            code.append('H');
        }
    }

    private static void codeByD(StringBuilder local, StringBuilder code, int wdsz, int nn) {
        if (HRStringUtils.isLastChar(wdsz, nn + 1) && HRStringUtils.isNextChar(local, nn, 'H')) {
            return;
        }
        if (!HRStringUtils.isLastChar(wdsz, nn + 1) && HRStringUtils.isNextChar(local, nn, 'H') && !HRStringUtils.isVowel(local, nn + 2)) {
            return;
        }
        if (nn > 0 && (HRStringUtils.regionMatch(local, nn, "GN") || HRStringUtils.regionMatch(local, nn, "GNED"))) {
            return;
        }
        boolean hard = HRStringUtils.isPreviousChar(local, nn, 'G');
        if (!HRStringUtils.isLastChar(wdsz, nn) && FRONTV.indexOf(local.charAt(nn + 1)) >= 0 && !hard) {
            code.append('J');
        } else {
            code.append('G');
        }
    }

    private static void codeByC(StringBuilder local, StringBuilder code, int wdsz, int nn) {
        if (HRStringUtils.isPreviousChar(local, nn, 'S') && !HRStringUtils.isLastChar(wdsz, nn) && FRONTV.indexOf(local.charAt(nn + 1)) >= 0) {
            return;
        }
        if (HRStringUtils.regionMatch(local, nn, "CIA")) {
            code.append('X');
            return;
        }
        if (!HRStringUtils.isLastChar(wdsz, nn) && FRONTV.indexOf(local.charAt(nn + 1)) >= 0) {
            code.append('S');
            return;
        }
        if (HRStringUtils.isPreviousChar(local, nn, 'S') && HRStringUtils.isNextChar(local, nn, 'H')) {
            code.append('K');
            return;
        }
        HRStringUtils.codeBynextChar(local, code, wdsz, nn);
    }

    private static void appendCodeS(StringBuilder local, StringBuilder code, int nn) {
        if (HRStringUtils.regionMatch(local, nn, "SH") || HRStringUtils.regionMatch(local, nn, "SIO") || HRStringUtils.regionMatch(local, nn, "SIA")) {
            code.append('X');
        } else {
            code.append('S');
        }
    }

    private static void appendCodeK(StringBuilder local, StringBuilder code, int nn, char symb) {
        if (nn > 0) {
            if (!HRStringUtils.isPreviousChar(local, nn, 'C')) {
                code.append(symb);
            }
        } else {
            code.append(symb);
        }
    }

    private static int appendCodeD(StringBuilder local, StringBuilder code, int wdsz, int nn) {
        if (!HRStringUtils.isLastChar(wdsz, nn + 1) && HRStringUtils.isNextChar(local, nn, 'G') && FRONTV.indexOf(local.charAt(nn + 2)) >= 0) {
            code.append('J');
            nn += 2;
        } else {
            code.append('D');
        }
        return nn;
    }

    private static void codeBynextChar(StringBuilder local, StringBuilder code, int wdsz, int nn) {
        if (HRStringUtils.isNextChar(local, nn, 'H')) {
            if (nn == 0 && wdsz >= 3 && HRStringUtils.isVowel(local, 2)) {
                code.append('K');
            } else {
                code.append('X');
            }
        } else {
            code.append('C');
        }
    }

    private static void appendLocal(char[] inwd, StringBuilder local) {
        switch (inwd[0]) {
            case 'G': 
            case 'K': 
            case 'P': {
                if (inwd[1] == 'N') {
                    local.append(inwd, 1, inwd.length - 1);
                    break;
                }
                local.append(inwd);
                break;
            }
            case 'A': {
                if (inwd[1] == 'E') {
                    local.append(inwd, 1, inwd.length - 1);
                    break;
                }
                local.append(inwd);
                break;
            }
            case 'W': {
                if (inwd[1] == 'R') {
                    local.append(inwd, 1, inwd.length - 1);
                    break;
                }
                if (inwd[1] == 'H') {
                    local.append(inwd, 1, inwd.length - 1);
                    local.setCharAt(0, 'W');
                    break;
                }
                local.append(inwd);
                break;
            }
            case 'X': {
                inwd[0] = 83;
                local.append(inwd);
                break;
            }
            default: {
                local.append(inwd);
            }
        }
    }

    private static String[] splitByUpperCaseChar(String line) {
        if (line == null) {
            return null;
        }
        if ((line = line.trim()).length() == 0) {
            return new String[]{EMPTY};
        }
        ArrayList<String> list = new ArrayList<String>();
        int pos = 0;
        for (int rowI = 0; rowI < line.length(); ++rowI) {
            char ch = line.charAt(rowI);
            if ((ch < 'A' || ch > 'Z') && (ch < '0' || ch > '9')) continue;
            String str = line.substring(pos, rowI).trim();
            if (str.length() > 0) {
                list.add(str);
            }
            pos = rowI;
        }
        list.add(line.substring(pos).trim());
        return list.toArray(new String[list.size()]);
    }

    private static final boolean isVowel(StringBuilder string, int index) {
        return VOWELS.indexOf(string.charAt(index)) >= 0;
    }

    private static boolean isPreviousChar(StringBuilder string, int index, char ch) {
        boolean matches = false;
        if (index > 0 && index < string.length()) {
            matches = string.charAt(index - 1) == ch;
        }
        return matches;
    }

    private static boolean isNextChar(StringBuilder string, int index, char ch) {
        boolean matches = false;
        if (index >= 0 && index < string.length() - 1) {
            matches = string.charAt(index + 1) == ch;
        }
        return matches;
    }

    private static boolean regionMatch(StringBuilder string, int index, String test) {
        boolean matches = false;
        if (index >= 0 && index + test.length() - 1 < string.length()) {
            String substring = string.substring(index, index + test.length());
            matches = substring.equals(test);
        }
        return matches;
    }

    private static final boolean isLastChar(int wdsz, int nn) {
        return nn + 1 == wdsz;
    }

    public static String[] fastSplit(String line, int seperator) {
        if (line == null || line.length() == 0) {
            return null;
        }
        line = line.trim();
        int[] pos = new int[9];
        int iTimes = HRStringUtils.calcSeperatorTimes(line, seperator, pos);
        String[] arr = new String[iTimes + 1];
        if (iTimes <= 0) {
            arr[0] = line;
        } else if (iTimes > 9) {
            int rowJ;
            int times = 0;
            int rowI = 0;
            while ((rowJ = line.indexOf(seperator, rowI)) >= 0) {
                arr[times] = line.substring(rowI, rowJ).trim();
                rowI = rowJ + 1;
                ++times;
            }
            arr[times] = line.substring(rowI).trim();
        } else {
            arr[0] = line.substring(0, pos[0]).trim();
            for (int rowI = 0; rowI < iTimes - 1; ++rowI) {
                arr[rowI + 1] = line.substring(pos[rowI] + 1, pos[rowI + 1]).trim();
            }
            arr[iTimes] = line.substring(pos[iTimes - 1] + 1).trim();
        }
        return arr;
    }

    private static int calcSeperatorTimes(String src, int seperator, int[] pos) {
        int rowJ;
        if (src == null || src.equals(EMPTY)) {
            return 0;
        }
        int times = 0;
        int rowI = 0;
        while ((rowJ = src.indexOf(seperator, rowI)) >= 0) {
            if (times < 9) {
                pos[times] = rowJ;
            }
            rowI = rowJ + 1;
            ++times;
        }
        return times;
    }

    public static String[] fastSplit(String lineStr, String seperator) {
        if (lineStr == null || lineStr.length() == 0) {
            return null;
        }
        lineStr = lineStr.trim();
        int[] pos = new int[9];
        int iTimes = HRStringUtils.calcSeperatorTimes(lineStr, seperator, pos);
        String[] arrStr = new String[iTimes + 1];
        if (iTimes <= 0) {
            arrStr[0] = lineStr;
        } else if (iTimes > 9) {
            int rowJ;
            int times = 0;
            int rowI = 0;
            while ((rowJ = lineStr.indexOf(seperator, rowI)) >= 0) {
                arrStr[times] = lineStr.substring(rowI, rowJ).trim();
                rowI = rowJ + 1;
                ++times;
            }
            arrStr[times] = lineStr.substring(rowI).trim();
        } else {
            arrStr[0] = lineStr.substring(0, pos[0]).trim();
            for (int rowI = 0; rowI < iTimes - 1; ++rowI) {
                arrStr[rowI + 1] = lineStr.substring(pos[rowI] + 1, pos[rowI + 1]).trim();
            }
            arrStr[iTimes] = lineStr.substring(pos[iTimes - 1] + 1).trim();
        }
        return arrStr;
    }

    private static int calcSeperatorTimes(String srcStr, String seperator, int[] pos) {
        int rowJ;
        if (srcStr == null || srcStr.equals(EMPTY)) {
            return 0;
        }
        int times = 0;
        int rowI = 0;
        while ((rowJ = srcStr.indexOf(seperator, rowI)) >= 0) {
            if (times < 9) {
                pos[times] = rowJ;
            }
            rowI = rowJ + 1;
            ++times;
        }
        return times;
    }

    public static String substringBeforeLast(String str, String separator) {
        if (HRStringUtils.isEmpty(str) || HRStringUtils.isEmpty(separator)) {
            return str;
        }
        int pos = str.lastIndexOf(separator);
        if (pos == -1) {
            return str;
        }
        return str.substring(0, pos);
    }

    public static String replaceParamsOfMsg(String[] params, String strMsg) {
        for (int rowI = 0; rowI < params.length; ++rowI) {
            String replacement = params[rowI];
            if (null == replacement) {
                replacement = EMPTY;
            }
            strMsg = strMsg.replaceFirst("#" + rowI, replacement);
        }
        return strMsg;
    }

    public static String replaceOneParamOfString(String param, String strMsg) {
        String[] params = new String[]{param};
        strMsg = HRStringUtils.replaceParamsOfMsg(params, strMsg);
        return strMsg;
    }

    public static boolean isContainSpecialChar(String str) {
        if (str == null) {
            return false;
        }
        str = str.trim();
        boolean flag = false;
        for (String specialChar : SPECIAL_CHAR_LIST) {
            if (!str.contains(specialChar)) continue;
            flag = true;
            break;
        }
        return flag;
    }

    public static boolean isContainJavaVariableForbidChar(String str) {
        if (str == null) {
            return false;
        }
        str = str.trim();
        boolean flag = false;
        for (String specialChar : JAVA_VARIABLE_FORBID_CHAR_ARRAY) {
            if (!str.contains(specialChar)) continue;
            flag = true;
            break;
        }
        return flag;
    }

    public static boolean isEnglishChar(String str) {
        if (HRStringUtils.isEmpty(str)) {
            return false;
        }
        return str.matches("[a-zA-Z]+");
    }

    public static boolean equals(CharSequence str1, CharSequence str2, boolean ignoreCase) {
        if (null == str1) {
            return str2 == null;
        }
        if (null == str2) {
            return false;
        }
        if (ignoreCase) {
            return str1.toString().equalsIgnoreCase(str2.toString());
        }
        return str1.toString().contentEquals(str2);
    }

    public static boolean isBlank(CharSequence str) {
        int length;
        if (str == null || (length = str.length()) == 0) {
            return true;
        }
        for (int i = 0; i < length; ++i) {
            if (HRStringUtils.isBlankChar(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isBlankChar(char c) {
        return HRStringUtils.isBlankChar((int)c);
    }

    public static boolean isBlankChar(int c) {
        return Character.isWhitespace(c) || Character.isSpaceChar(c) || c == 65279 || c == 8234 || c == 0;
    }

    public static String format(CharSequence template, Map<?, ?> map) {
        return HRStringUtils.format(template, map, true);
    }

    public static String format(CharSequence template, Map<?, ?> map, boolean ignoreNull) {
        if (null == template) {
            return null;
        }
        if (null == map || map.isEmpty()) {
            return template.toString();
        }
        String template2 = template.toString();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            String value = HRStringUtils.utf8Str(entry.getValue());
            if (null == value && ignoreNull) continue;
            template2 = HRStringUtils.replace(template2, "{" + entry.getKey() + "}", value);
        }
        return template2;
    }

    public static String format(CharSequence template, Object ... params) {
        if (null == template) {
            return NULL;
        }
        if (HRArrayUtils.isEmpty(params) || HRStringUtils.isBlank(template)) {
            return template.toString();
        }
        return HRStringUtils.format(template.toString(), params);
    }

    public static String format(String strPattern, Object ... argArray) {
        if (HRStringUtils.isBlank(strPattern) || HRArrayUtils.isEmpty(argArray)) {
            return strPattern;
        }
        int strPatternLength = strPattern.length();
        StringBuilder sbuf = new StringBuilder(strPatternLength + 50);
        int handledPosition = 0;
        for (int argIndex = 0; argIndex < argArray.length; ++argIndex) {
            int delimIndex = strPattern.indexOf(EMPTY_JSON, handledPosition);
            if (delimIndex == -1) {
                if (handledPosition == 0) {
                    return strPattern;
                }
                sbuf.append(strPattern, handledPosition, strPatternLength);
                return sbuf.toString();
            }
            if (delimIndex > 0 && strPattern.charAt(delimIndex - 1) == '\\') {
                if (delimIndex > 1 && strPattern.charAt(delimIndex - 2) == '\\') {
                    sbuf.append(strPattern, handledPosition, delimIndex - 1);
                    sbuf.append(HRStringUtils.utf8Str(argArray[argIndex]));
                    handledPosition = delimIndex + 2;
                    continue;
                }
                --argIndex;
                sbuf.append(strPattern, handledPosition, delimIndex - 1);
                sbuf.append('{');
                handledPosition = delimIndex + 1;
                continue;
            }
            sbuf.append(strPattern, handledPosition, delimIndex);
            sbuf.append(HRStringUtils.utf8Str(argArray[argIndex]));
            handledPosition = delimIndex + 2;
        }
        sbuf.append(strPattern, handledPosition, strPattern.length());
        return sbuf.toString();
    }

    public static String str(Object obj, Charset charset) {
        if (null == obj) {
            return null;
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof byte[]) {
            return HRStringUtils.str((byte[])obj, charset);
        }
        if (obj instanceof Byte[]) {
            return HRStringUtils.str((Byte[])obj, charset);
        }
        if (obj instanceof ByteBuffer) {
            return HRStringUtils.str((ByteBuffer)obj, charset);
        }
        if (HRArrayUtils.isArray(obj)) {
            return HRArrayUtils.toString(obj);
        }
        return obj.toString();
    }

    public static String str(byte[] data, Charset charset) {
        if (data == null) {
            return null;
        }
        if (null == charset) {
            return new String(data);
        }
        return new String(data, charset);
    }

    public static String str(Byte[] data, Charset charset) {
        if (data == null) {
            return null;
        }
        byte[] bytes = new byte[data.length];
        for (int i = 0; i < data.length; ++i) {
            Byte dataByte = data[i];
            bytes[i] = null == dataByte ? -1 : (int)dataByte.byteValue();
        }
        return HRStringUtils.str(bytes, charset);
    }

    public static String str(ByteBuffer data, Charset charset) {
        if (null == charset) {
            charset = Charset.defaultCharset();
        }
        return charset.decode(data).toString();
    }

    public static String utf8Str(Object obj) {
        return HRStringUtils.str(obj, CharsetUtil.UTF_8);
    }
}

