/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.common.util;

import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.exception.KDBizException;
import kd.bos.instance.Instance;

public class HRTypesContainer {
    private static Map<String, Class<?>> typesDict = new ConcurrentHashMap();
    private static Map<Class<?>, Object> instancesDict = new ConcurrentHashMap();
    private static TypeCreator typeCreator = new TypeCreator(){

        @Override
        public <T> T createInstance(Class<T> cls) throws IllegalAccessException, InstantiationException {
            return cls.newInstance();
        }
    };

    public static Object getOrRegisterSingletonInstance(String type) {
        Class<?> orRegister = HRTypesContainer.getOrRegister(type);
        if (orRegister != null) {
            return instancesDict.computeIfAbsent(orRegister, cls -> HRTypesContainer.createInstance(cls));
        }
        return null;
    }

    public static Class<?> getOrRegister(String type) {
        if (type == null || type.isEmpty()) {
            throw new IllegalArgumentException("type");
        }
        return typesDict.computeIfAbsent(type, clsName -> {
            try {
                return Class.forName(clsName.trim());
            }
            catch (ClassNotFoundException e) {
                throw new KDBizException(String.format(Locale.ROOT, "%s: %s not find.", Instance.getAppName(), clsName));
            }
        });
    }

    public static void removeRegister(String type) {
        typesDict.remove(type);
    }

    public static <T> T createInstance(String className) {
        Class<?> type = HRTypesContainer.getOrRegister(className);
        if (type == null) {
            throw new KDBizException(String.format(Locale.ROOT, "%1$s failed to  Create Instance.", className));
        }
        return HRTypesContainer.createInstance(type);
    }

    public static <T> T createInstance(Class<?> cls) {
        if (cls == null) {
            throw new KDBizException(" failed to  Create Instance,Class is Null.");
        }
        try {
            return (T)typeCreator.createInstance(cls);
        }
        catch (Exception e) {
            throw new KDBizException(String.format(Locale.ROOT, "%1$s failed to  Create Instance:" + e.getMessage(), cls.getName()));
        }
    }

    public static void setTypeCreator(TypeCreator typeCreator) {
        HRTypesContainer.typeCreator = typeCreator;
    }

    public static interface TypeCreator {
        public <T> T createInstance(Class<T> var1) throws KDBizException, IllegalAccessException, InstantiationException;
    }
}

