/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.common.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;

public class LogPrivacyUtil {
    private static final Log logger = LogFactory.getLog(LogPrivacyUtil.class);
    private static final String REPLACE_STR = "*";
    private static final List<String> PRIVACY_PROPERTIES = Lists.newArrayList((Object[])new String[]{"phone", "email", "certificatenumber", "File", "file", "imageData", "phones", "lastname", "firstname", "fullname", "firstnameen", "lastnameen", "birthdate", "percardname", "PHOTO_JPG", "fileName", "major", "schoolrecord", "degreenumber", "graauthcode", "diplomanumber", "isforeignstudent", "PHOTO_NO", "DOCID"});

    private LogPrivacyUtil() {
    }

    public static String filterPrivacyProp(Map obj) {
        return LogPrivacyUtil.filterPrivacyProp(obj, null);
    }

    public static String filterPrivacyProp(Map obj, List<String> filterProperties) {
        if (obj == null) {
            return null;
        }
        HashMap<String, Object> outputMap = new HashMap<String, Object>(obj.size());
        LogPrivacyUtil.copyMapForLog(obj, outputMap);
        LogPrivacyUtil.filterPrivacyMapProp(outputMap, filterProperties);
        return SerializationUtils.toJsonString(outputMap);
    }

    public static String filterPrivacyPropForDynamicObj(DynamicObject obj) {
        return LogPrivacyUtil.filterPrivacyPropForDynamicObj(obj, null);
    }

    public static String filterPrivacyPropForDynamicObj(DynamicObject inputObj, List<String> filterProperties) {
        if (inputObj == null) {
            return null;
        }
        Map outputMap = HRDynamicObjectUtils.convertDynamicObjectToMap(inputObj);
        LogPrivacyUtil.filterPrivacyMapProp(outputMap, filterProperties);
        return SerializationUtils.toJsonString((Object)outputMap);
    }

    private static void filterPrivacyMapProp(Map<String, Object> obj, List<String> filterProperties) {
        obj.forEach((property, val) -> {
            if (val instanceof Map) {
                LogPrivacyUtil.filterPrivacyMapProp((Map)val, filterProperties);
            } else if (val instanceof List) {
                boolean isBaseEle;
                List valList = (List)val;
                if (valList.isEmpty()) {
                    return;
                }
                Object onoEle = valList.get(0);
                boolean bl = isBaseEle = onoEle instanceof String || onoEle instanceof Long || onoEle instanceof Integer || onoEle instanceof Boolean;
                if (isBaseEle) {
                    LogPrivacyUtil.filterListForBasic(property, filterProperties, valList);
                } else {
                    try {
                        valList.forEach(valMap -> LogPrivacyUtil.filterPrivacyMapProp((Map)valMap, filterProperties));
                    }
                    catch (Exception e) {
                        logger.warn("build list log for output error!", (Throwable)e);
                    }
                }
            } else if (val instanceof DynamicObject) {
                Map subMap = HRDynamicObjectUtils.convertDynamicObjectToMap((DynamicObject)val);
                LogPrivacyUtil.filterPrivacyMapProp(subMap, filterProperties);
                obj.put((String)property, subMap);
            } else if (val instanceof String) {
                boolean isContains;
                boolean bl = isContains = PRIVACY_PROPERTIES.contains(property) || filterProperties != null && filterProperties.contains(property);
                if (isContains) {
                    obj.put((String)property, REPLACE_STR);
                }
            }
        });
    }

    private static void filterListForBasic(String property, List<String> filterProperties, List valList) {
        if (PRIVACY_PROPERTIES.contains(property) || filterProperties != null && filterProperties.contains(property)) {
            int size = valList.size();
            valList.clear();
            for (int i = 0; i < size; ++i) {
                valList.add(REPLACE_STR);
            }
        }
    }

    private static void copyMapForLog(Map<String, Object> orignMap, Map<String, Object> descMap) {
        if (orignMap == null) {
            return;
        }
        orignMap.forEach((property, val) -> {
            if (val instanceof Map) {
                HashMap<String, Object> subMap = new HashMap<String, Object>(16);
                LogPrivacyUtil.copyMapForLog((Map)val, subMap);
                descMap.put((String)property, subMap);
            } else if (val instanceof List) {
                try {
                    List valList = (List)val;
                    ArrayList descList = new ArrayList();
                    valList.forEach(subVal -> {
                        if (subVal instanceof Map) {
                            HashMap<String, Object> subMap2 = new HashMap<String, Object>(16);
                            LogPrivacyUtil.copyMapForLog((Map)subVal, subMap2);
                            descList.add(subMap2);
                        } else if (subVal instanceof String || subVal instanceof Long || subVal instanceof Integer || subVal instanceof Boolean) {
                            descList.add(subVal);
                        } else {
                            throw new KDBizException("unsupport data in list");
                        }
                    });
                    descMap.put((String)property, descList);
                }
                catch (Exception e) {
                    logger.warn("build list log for map copy error!", (Throwable)e);
                }
            } else {
                descMap.put((String)property, val);
            }
        });
    }
}

