/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.common.util;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import kd.hr.hbp.common.cache.HRAppCache;

public class NumberGenerater {
    private NumberGenerater() {
    }

    public static NumberGenerater getInstance() {
        return NumberGeneraterHolder.numberGenerater;
    }

    public synchronized String generaterNextNumber(Date date, String prefix) {
        int code = UUID.randomUUID().toString().hashCode();
        if (code < 0) {
            code = -code;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        String number = prefix + sdf.format(date) + String.format(Locale.ROOT, "%05d", code % 100000);
        ArrayList<String> numberList = (ArrayList<String>)HRAppCache.get("hbss").get(prefix, List.class);
        if (numberList == null) {
            numberList = new ArrayList<String>();
        }
        if (numberList.contains(number)) {
            code = UUID.randomUUID().toString().hashCode();
            number = prefix + sdf.format(date) + String.format(Locale.ROOT, "%05d", code % 100000);
        }
        numberList.add(number);
        HRAppCache.get("hbss").put(prefix, numberList);
        return number;
    }

    private static class NumberGeneraterHolder {
        private static NumberGenerater numberGenerater = new NumberGenerater();

        private NumberGeneraterHolder() {
        }
    }
}

