/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.common.util;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.hr.hbp.common.util.HRStringUtils;

public class PermCustomParamUtil {
    private static final String CUSTOM_PARAM_MAP_CACHE_KEY = "datarule_customparams";

    private static void setPermCustomPerm(IFormView view, String key, Object value) {
        FormShowParameter fsp = view.getFormShowParameter();
        fsp.setCustomParam(key, value);
        view.cacheFormShowParameter();
        IPageCache pageCache = view.getPageCache();
        String customParamStr = pageCache.get(CUSTOM_PARAM_MAP_CACHE_KEY);
        Map paramMap = null;
        paramMap = HRStringUtils.isEmpty(customParamStr) ? Maps.newHashMapWithExpectedSize((int)16) : (Map)SerializationUtils.fromJsonString((String)customParamStr, Map.class);
        paramMap.put(key, value);
        pageCache.put(CUSTOM_PARAM_MAP_CACHE_KEY, SerializationUtils.toJsonString((Object)paramMap));
    }

    public static void setHasAllPermParam(IFormView view, Boolean hasAll) {
        if (hasAll.booleanValue()) {
            PermCustomParamUtil.setPermCustomPerm(view, "hr_dataperm_hasall", "true");
        } else {
            PermCustomParamUtil.setPermCustomPerm(view, "hr_dataperm_hasall", "false");
        }
    }

    public static void setStructProjectParam(IFormView view, List<Long> structProjectIds) {
        String structProjectIdStr = SerializationUtils.toJsonString(structProjectIds);
        PermCustomParamUtil.setPermCustomPerm(view, "hr_dataperm_structprojectid", structProjectIdStr);
    }

    public static void setStructProjectParam(IFormView view, String propKey, List<Long> structProjectIds) {
        String structProjectIdStr = SerializationUtils.toJsonString(structProjectIds);
        PermCustomParamUtil.setPermCustomPerm(view, "hr_dataperm_structprojectid_prop_" + propKey, structProjectIdStr);
    }
}

