/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.common.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.IComplexProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.list.JoinEntity;
import kd.bos.entity.mulentities.QSConditionRow;
import kd.bos.entity.mulentities.QuerySelectField;
import kd.bos.entity.mulentities.QuerySourceJoinRelation;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.MulComboProp;
import kd.bos.entity.property.RefBillProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.model.complexobj.DataTypeEnum;
import kd.hr.hbp.common.model.complexobj.HRComplexObjConditionRow;
import kd.hr.hbp.common.model.complexobj.HRComplexObjContext;
import kd.hr.hbp.common.model.complexobj.HRComplexObjFieldInfo;
import kd.hr.hbp.common.model.complexobj.HRComplexObjJoinRelation;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.ReportTimeZoneUtil;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class QueryEntityUtil {
    private static final Log LOGGER = LogFactory.getLog(QueryEntityUtil.class);

    public static String getQueryFieldEntityNum(QueryEntityType queryEntityType, String fullPropertyName) {
        String[] nameKeys = fullPropertyName.split("\\.");
        String firstStr = nameKeys[0];
        for (JoinEntity joinEntity : queryEntityType.getJoinEntitys()) {
            if (!firstStr.equalsIgnoreCase(joinEntity.getEntityName())) continue;
            return firstStr;
        }
        return queryEntityType.getEntityName();
    }

    public static IDataEntityProperty getFieldProperty(String entityNumber, String propertyName) {
        MainEntityType curEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        return QueryEntityUtil.getFieldProperty(curEntityType, propertyName);
    }

    public static IDataEntityProperty getFieldProperty(MainEntityType mainEntityType, String propertyName) {
        String[] nameKeys;
        String realPropName = propertyName;
        if (propertyName.startsWith(mainEntityType.getName() + ".")) {
            realPropName = propertyName.replace(mainEntityType.getName() + ".", "");
        }
        if ((nameKeys = realPropName.split("\\.")).length == 1) {
            return mainEntityType.getProperty(nameKeys[0]);
        }
        if (nameKeys.length > 1) {
            DynamicProperty property = mainEntityType.getProperty(nameKeys[0]);
            if (property instanceof BasedataProp) {
                BasedataProp bdProp = (BasedataProp)property;
                MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)bdProp.getBaseEntityId());
                return QueryEntityUtil.getFieldProperty(dataEntityType, realPropName.replace(nameKeys[0] + ".", ""));
            }
            return property;
        }
        return null;
    }

    public static IDataEntityProperty findProperty(MainEntityType relationEntityType, String propertyName) {
        DynamicProperty dataEntityProperty = null;
        String[] nameKeys = propertyName.split("\\.");
        for (int i = 0; i < nameKeys.length && null == (dataEntityProperty = relationEntityType.getProperty(nameKeys[i])); ++i) {
        }
        return dataEntityProperty;
    }

    public static IDataEntityProperty getSimpleProperty(DynamicObjectType dynamicObjectType, String fieldName) {
        String[] fieldNameArr = fieldName.split("\\.");
        DynamicProperty property = dynamicObjectType.getProperty(fieldNameArr[0]);
        if (!(property instanceof IComplexProperty)) {
            return property;
        }
        if (fieldNameArr.length != 1) {
            if (fieldNameArr.length == 2 || fieldNameArr.length == 3) {
                BasedataProp basedataProp = (BasedataProp)property;
                MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)basedataProp.getBaseEntityId());
                return QueryEntityUtil.getSimpleProperty((DynamicObjectType)dataEntityType, fieldName.replaceFirst(fieldNameArr[0] + ".", ""));
            }
            return null;
        }
        property = ((IComplexProperty)property).getComplexType().getPrimaryKey();
        return property;
    }

    public static Object getEntityProp(Object entityProp, Object value, TimeZone timeZone, HRComplexObjContext context) {
        Object newValue = value;
        if (newValue == null) {
            return null;
        }
        String originalValue = value.toString();
        try {
            if (entityProp instanceof MulComboProp) {
                newValue = ((MulComboProp)entityProp).getItemByName(originalValue);
            } else if (entityProp instanceof ComboProp) {
                newValue = ((ComboProp)entityProp).getItemByName(originalValue);
            } else if (entityProp instanceof BooleanProp) {
                newValue = Boolean.parseBoolean(originalValue) || "1".equalsIgnoreCase(originalValue) ? ResManager.loadKDString((String)"\u662f", (String)"HRObjectUtils_0", (String)"hrmp-hbp-common", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"HRObjectUtils_1", (String)"hrmp-hbp-common", (Object[])new Object[0]);
            } else if (entityProp instanceof DateProp) {
                if (!(value instanceof Date)) {
                    value = HRDateTimeUtils.parseDate(originalValue, "yyyy-MM-dd HH:mm:ss", timeZone);
                }
                newValue = ReportTimeZoneUtil.formatDate(context.getCurrentUserDateFormat(), timeZone, value);
            } else if (entityProp instanceof DateTimeProp) {
                if (!(value instanceof Date)) {
                    value = ReportTimeZoneUtil.parseDateTime(context.getCurrentUserDateTimeFormat(), timeZone, originalValue);
                }
                newValue = ReportTimeZoneUtil.formatDateTime(context.getCurrentUserDateTimeFormat(), timeZone, value);
            }
        }
        catch (Exception e) {
            newValue = null;
            LOGGER.error("getEntityProp_error_{}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
        }
        return newValue;
    }

    public static boolean checkEntityEnumProp(Object entityProp) {
        if (entityProp instanceof ComboProp || entityProp instanceof BooleanProp || entityProp instanceof DateTimeProp) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static Object convertDataValueType(DataTypeEnum fieldDataType, Object originalValue, TimeZone timeZone, HRComplexObjContext context) {
        DataTypeEnum valueDataTypeEnum = QueryEntityUtil.getValueDataTypeEnum(originalValue);
        if (valueDataTypeEnum != null && fieldDataType != valueDataTypeEnum) {
            DateProp entityProp = null;
            if (DataTypeEnum.DATETIME == valueDataTypeEnum) {
                entityProp = new DateProp();
            } else if (DataTypeEnum.BOOLEAN == valueDataTypeEnum) {
                entityProp = new BooleanProp();
            }
            if (entityProp != null) {
                return QueryEntityUtil.getEntityProp(entityProp, originalValue, timeZone, context);
            }
        }
        return originalValue;
    }

    public static String getEntityNameByAlias(String entityAlias, QueryEntityType entityType) {
        String entityName = null;
        for (JoinEntity joinEntity : entityType.getJoinEntitys()) {
            if (!entityAlias.equals(joinEntity.getAlias())) continue;
            entityName = joinEntity.getEntityName();
            break;
        }
        return entityName;
    }

    public static String getFieldEntityAlias(String fullPropertyName, QueryEntityType entityType) {
        String[] nameKeys = fullPropertyName.split("\\.");
        String subEntityAlias = fullPropertyName;
        if (nameKeys.length > 0) {
            subEntityAlias = nameKeys[0];
        }
        Set relEntityAlias = entityType.getJoinEntitys().stream().map(JoinEntity::getAlias).collect(Collectors.toSet());
        String entityAlias = entityType.getEditEntityAliasName();
        if (relEntityAlias.contains(subEntityAlias)) {
            entityAlias = subEntityAlias;
        }
        return entityAlias;
    }

    public static HRComplexObjContext genComplexObjContext(QueryEntityType queryEntityType, String queryFields, QFilter[] qFilters, String orderBys, Map<String, List<QFilter>> relationMap, long reportId) {
        HRComplexObjContext complexObjContext = new HRComplexObjContext();
        String mainEntityNumber = queryEntityType.getEditEntityName();
        complexObjContext.setEntityNumber(mainEntityNumber);
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)mainEntityNumber);
        complexObjContext.setEntityTable(dataEntityType.getAlias());
        List<HRComplexObjJoinRelation> complexObjJoinRelationList = QueryEntityUtil.genHRComplexObjJoinRelations(queryEntityType);
        complexObjContext.setJoinRelationList(complexObjJoinRelationList);
        List selectFields = queryEntityType.getSelectFields();
        ArrayList<HRComplexObjFieldInfo> complexObjFieldInfoList = new ArrayList<HRComplexObjFieldInfo>(selectFields.size());
        for (QuerySelectField selectField : selectFields) {
            DynamicProperty property = queryEntityType.getProperty(selectField.getAlias());
            property.getPropertyType();
        }
        complexObjContext.setComplexObjFieldInfoList(complexObjFieldInfoList);
        return complexObjContext;
    }

    public static List<HRComplexObjJoinRelation> genHRComplexObjJoinRelations(QueryEntityType queryEntityType) {
        String mainEntityNumber = queryEntityType.getEditEntityName();
        List joinRelationList = queryEntityType.getJoinRelations();
        ArrayList<HRComplexObjJoinRelation> complexObjJoinRelationList = new ArrayList<HRComplexObjJoinRelation>(joinRelationList.size());
        for (QuerySourceJoinRelation joinRelation : joinRelationList) {
            HRComplexObjJoinRelation complexObjJoinRelation = new HRComplexObjJoinRelation();
            complexObjJoinRelation.setEntityNumber(mainEntityNumber);
            complexObjJoinRelation.setEntityAlias(mainEntityNumber);
            String relEntityAlias = joinRelation.getRelEntityNumber();
            String relEntityNumber = QueryEntityUtil.getEntityNameByAlias(relEntityAlias, queryEntityType);
            complexObjJoinRelation.setRelEntityNumber(relEntityNumber);
            complexObjJoinRelation.setRelEntityAlias(relEntityAlias);
            complexObjJoinRelation.setJoinType(joinRelation.getJoinType());
            List conditionRowList = joinRelation.getCondition();
            ArrayList<HRComplexObjConditionRow> complexObjConditionRowList = new ArrayList<HRComplexObjConditionRow>(conditionRowList.size());
            for (QSConditionRow qsConditionRow : conditionRowList) {
                HRComplexObjConditionRow conditionRow = new HRComplexObjConditionRow(qsConditionRow.getLeftItem().toString(), qsConditionRow.getRightItem().toString());
                conditionRow.setCompareOp(qsConditionRow.getCompareOp());
                conditionRow.setLogicOp(qsConditionRow.getLogicOp());
                complexObjConditionRowList.add(conditionRow);
            }
            complexObjJoinRelation.setCondition(complexObjConditionRowList);
            complexObjJoinRelationList.add(complexObjJoinRelation);
        }
        return complexObjJoinRelationList;
    }

    public static DataTypeEnum tranPropType(IDataEntityProperty property) {
        Class propertyType = property.getPropertyType();
        if (propertyType == null) {
            return DataTypeEnum.STRING;
        }
        if (propertyType.equals(DynamicObject.class)) {
            if (property instanceof BasedataProp) {
                propertyType = ((BasedataProp)property).getComplexType().getPrimaryKey().getPropertyType();
            } else if (property instanceof RefBillProp) {
                propertyType = ((RefBillProp)property).getComplexType().getPrimaryKey().getPropertyType();
            }
        }
        if (propertyType.equals(Integer.class) || propertyType.equals(Integer.TYPE)) {
            return DataTypeEnum.INTEGER;
        }
        if (propertyType.equals(Long.class) || propertyType.equals(Long.TYPE)) {
            return DataTypeEnum.LONG;
        }
        if (propertyType.equals(BigDecimal.class)) {
            return DataTypeEnum.BIGDECIMAL;
        }
        if (propertyType.equals(String.class)) {
            return DataTypeEnum.STRING;
        }
        if (propertyType.equals(Date.class)) {
            return DataTypeEnum.DATETIME;
        }
        if (propertyType.equals(Boolean.class) || propertyType.equals(Boolean.TYPE)) {
            return DataTypeEnum.BOOLEAN;
        }
        if (propertyType.equals(ILocaleString.class)) {
            return DataTypeEnum.STRING;
        }
        return DataTypeEnum.STRING;
    }

    private static DataTypeEnum getValueDataTypeEnum(Object value) {
        if (value instanceof Date) {
            return DataTypeEnum.DATETIME;
        }
        if (value instanceof String) {
            return DataTypeEnum.STRING;
        }
        if (value instanceof Long) {
            return DataTypeEnum.LONG;
        }
        if (value instanceof Integer) {
            return DataTypeEnum.INTEGER;
        }
        if (value instanceof BigDecimal) {
            return DataTypeEnum.BIGDECIMAL;
        }
        if (value instanceof Boolean) {
            return DataTypeEnum.BOOLEAN;
        }
        return null;
    }
}

