/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.common.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TimeZone;
import kd.bos.context.RequestContext;
import kd.bos.inte.api.IInteService;
import kd.bos.service.ServiceFactory;
import kd.hr.hbp.common.model.complexobj.HRComplexObjFieldInfo;
import kd.hr.hbp.common.model.complexobj.TimeZoneInfo;
import kd.hr.hbp.common.util.HRStringUtils;

public class ReportTimeZoneUtil {
    public static TimeZone transferDateTimeFieldTimeZone(List<HRComplexObjFieldInfo> allFieldList, String fieldAlias) {
        TimeZoneInfo timeZoneInfo;
        Optional<HRComplexObjFieldInfo> fieldInfoOp = allFieldList.stream().filter(fieldInfo -> HRStringUtils.equals(fieldAlias, fieldInfo.getAlias())).findAny();
        if (fieldInfoOp.isPresent() && (timeZoneInfo = fieldInfoOp.get().getTimeZoneInfo()) != null && HRStringUtils.isNotEmpty(timeZoneInfo.getTimeZone())) {
            return TimeZone.getTimeZone(timeZoneInfo.getTimeZone());
        }
        return null;
    }

    public static DateFormat getUserDateFormat() {
        IInteService service = (IInteService)ServiceFactory.getService(IInteService.class);
        String dateFormatStr = service.getDateFormat(Long.valueOf(RequestContext.get().getCurrUserId()));
        return new SimpleDateFormat(dateFormatStr);
    }

    public static DateFormat getUserDateFormat(TimeZone timeZone) {
        IInteService service = (IInteService)ServiceFactory.getService(IInteService.class);
        String dateFormatStr = service.getDateFormat(Long.valueOf(RequestContext.get().getCurrUserId()));
        SimpleDateFormat dateFormat = new SimpleDateFormat(dateFormatStr);
        if (timeZone != null) {
            dateFormat.setTimeZone(timeZone);
        }
        return dateFormat;
    }

    public static DateFormat getUserDateFormat(String userDateFormatStr, TimeZone timeZone) {
        if (HRStringUtils.isEmpty(userDateFormatStr)) {
            return ReportTimeZoneUtil.getUserDateFormat(timeZone);
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(userDateFormatStr);
        if (timeZone != null) {
            dateFormat.setTimeZone(timeZone);
        }
        return dateFormat;
    }

    public static DateFormat getUserDateTimeFormat(TimeZone timeZone) {
        IInteService service = (IInteService)ServiceFactory.getService(IInteService.class);
        String dateFormatStr = service.getDateFormat(Long.valueOf(RequestContext.get().getCurrUserId()));
        Map timeFormatMap = service.getTimeFormat(Long.valueOf(RequestContext.get().getCurrUserId()));
        SimpleDateFormat dateFormat = new SimpleDateFormat(dateFormatStr + " " + (String)timeFormatMap.get("timeFormat"));
        if (timeZone != null) {
            dateFormat.setTimeZone(timeZone);
        }
        return dateFormat;
    }

    public static DateFormat getUserDateTimeFormat(String userDateTimeFormatStr, TimeZone timeZone) {
        if (HRStringUtils.isEmpty(userDateTimeFormatStr)) {
            return ReportTimeZoneUtil.getUserDateTimeFormat(timeZone);
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(userDateTimeFormatStr);
        if (timeZone != null) {
            dateFormat.setTimeZone(timeZone);
        }
        return dateFormat;
    }

    public static DateFormat getUserDateTimeFormat() {
        IInteService service = (IInteService)ServiceFactory.getService(IInteService.class);
        String dateFormatStr = service.getDateFormat(Long.valueOf(RequestContext.get().getCurrUserId()));
        Map timeFormatMap = service.getTimeFormat(Long.valueOf(RequestContext.get().getCurrUserId()));
        return new SimpleDateFormat(dateFormatStr + " " + (String)timeFormatMap.get("timeFormat"));
    }

    public static Date transferUserDateTimeFormat(TimeZone timeZone, Date date, DateFormat dateTimeFormat) throws ParseException {
        if (dateTimeFormat == null) {
            dateTimeFormat = ReportTimeZoneUtil.getUserDateTimeFormat();
        }
        if (timeZone != null) {
            dateTimeFormat.setTimeZone(timeZone);
        }
        String formatDate = dateTimeFormat.format(date);
        dateTimeFormat.setTimeZone(TimeZone.getDefault());
        return dateTimeFormat.parse(formatDate);
    }

    public static String transferUserDateTimeFormat(TimeZone timeZone, String date) throws ParseException {
        IInteService service = (IInteService)ServiceFactory.getService(IInteService.class);
        String dateFormatStr = service.getDateFormat(Long.valueOf(RequestContext.get().getCurrUserId()));
        Map timeFormatMap = service.getTimeFormat(Long.valueOf(RequestContext.get().getCurrUserId()));
        SimpleDateFormat dateFormat = new SimpleDateFormat(dateFormatStr + " " + (String)timeFormatMap.get("timeFormat"));
        Date parseDate = dateFormat.parse(date);
        if (timeZone != null) {
            dateFormat.setTimeZone(timeZone);
        }
        return dateFormat.format(parseDate);
    }

    public static Date parseDate(DateFormat dateFormat, TimeZone timeZone, String value) throws ParseException {
        if (dateFormat == null) {
            dateFormat = ReportTimeZoneUtil.getUserDateFormat(timeZone);
        }
        if (timeZone != null) {
            dateFormat.setTimeZone(timeZone);
        }
        return dateFormat.parse(value);
    }

    public static Date parseDateTime(DateFormat dateFormat, TimeZone timeZone, String value) throws ParseException {
        if (dateFormat == null) {
            dateFormat = ReportTimeZoneUtil.getUserDateTimeFormat(timeZone);
        }
        if (timeZone != null) {
            dateFormat.setTimeZone(timeZone);
        }
        return dateFormat.parse(value);
    }

    public static String formatDate(DateFormat dateFormat, TimeZone timeZone, Object value) {
        if (dateFormat == null) {
            dateFormat = ReportTimeZoneUtil.getUserDateFormat(timeZone);
        }
        if (timeZone != null) {
            dateFormat.setTimeZone(timeZone);
        }
        return dateFormat.format(value);
    }

    public static String formatDateTime(DateFormat dateFormat, TimeZone timeZone, Object value) {
        if (dateFormat == null) {
            dateFormat = ReportTimeZoneUtil.getUserDateTimeFormat(timeZone);
        }
        if (timeZone != null) {
            dateFormat.setTimeZone(timeZone);
        }
        return dateFormat.format(value);
    }
}

