/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.common.util;

import com.google.common.hash.Hashing;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.function.Function;
import javax.xml.bind.DatatypeConverter;
import kd.hr.hbp.common.util.HRStringUtils;

public class ShaUtils {
    public static final int SALT_SIZE = 16;

    public static String hashingBySha256(String input, String salt) {
        return ShaUtils.hashing(input, salt, str -> Hashing.sha256().hashString((CharSequence)str, StandardCharsets.UTF_8).toString());
    }

    public static String hashingBySha512(String input, String salt) {
        return ShaUtils.hashing(input, salt, str -> Hashing.sha512().hashString((CharSequence)str, StandardCharsets.UTF_8).toString());
    }

    private static <R> R hashing(String input, String salt, Function<String, R> hashFunc) {
        if (HRStringUtils.isEmpty(input)) {
            throw new NullPointerException("the string to be decrypted is empty!");
        }
        if (!HRStringUtils.isEmpty(salt)) {
            input = input + ":" + salt;
        }
        return hashFunc.apply(input);
    }

    public static String getSalt() throws NoSuchAlgorithmException {
        SecureRandom random = new SecureRandom();
        byte[] bytes = new byte[16];
        random.nextBytes(bytes);
        String salt = DatatypeConverter.printHexBinary((byte[])bytes);
        return salt;
    }
}

