/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.application.impl.common;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.application.common.IHRLongValueParseService;
import org.apache.commons.lang3.ObjectUtils;

public class HRLongValueParseService
implements IHRLongValueParseService {
    private static volatile HRLongValueParseService service = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HRLongValueParseService getInstance() {
        if (service != null) return service;
        Class<HRLongValueParseService> clazz = HRLongValueParseService.class;
        synchronized (HRLongValueParseService.class) {
            if (service != null) return service;
            service = new HRLongValueParseService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return service;
        }
    }

    @Override
    public Long parseLong(Object obj) {
        if (ObjectUtils.isEmpty((Object)obj)) {
            return 0L;
        }
        if (obj instanceof Integer) {
            return (long)((Integer)obj);
        }
        if (obj instanceof Long) {
            return (Long)obj;
        }
        try {
            return Long.valueOf(String.valueOf(obj));
        }
        catch (Exception exception) {
            String message = exception.getMessage();
            throw new KDBizException(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u503c\u8f6cLong\u7c7b\u578b\u9519\u8bef\uff0c\u503c\uff1a%1$s\uff0c\u9519\u8bef\u4fe1\u606f\uff1a%2$s\u3002", (String)"HRFormShowParameterService_1", (String)"hrmp-hbp-business", (Object[])new Object[0]), obj.toString(), message));
        }
    }

    @Override
    public Long getLongValueFromMap(Map<String, Object> map, String key) {
        if (StringUtils.isEmpty((String)key) || map == null || map.isEmpty()) {
            return 0L;
        }
        Object objParam = map.get(key);
        return this.parseLong(objParam);
    }

    @Override
    public List<Long> parseLongForList(List<Object> list) {
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        ArrayList result = Lists.newArrayListWithCapacity((int)list.size());
        for (Object obj : list) {
            result.add(this.parseLong(obj));
        }
        return result;
    }
}

