/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.domain.odc.service;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class BizMserviceInvokeService {
    private static final Log LOG = LogFactory.getLog(BizMserviceInvokeService.class);
    private static final String DATA = "data";

    private BizMserviceInvokeService() {
    }

    public static BizMserviceInvokeService getInstance() {
        return BizMserviceInvokeServiceInstance.INSTANCE;
    }

    public Map<Long, List<DynamicObject>> queryStdPositionByOrg(List<Long> orgIds) {
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)orgIds.size());
        Map responseMap = (Map)HRMServiceHelper.invokeHRMPService("hbpm", "IStandardPositionQueryService", "queryStandardPositionContainsVersionsByOrg", orgIds);
        if (!HRStringUtils.equals((String)"200", (String)responseMap.get("code").toString())) {
            return resultMap;
        }
        List dataList = (List)responseMap.get(DATA);
        if (dataList == null || dataList.size() == 0) {
            return resultMap;
        }
        for (Map data : dataList) {
            if (!Boolean.parseBoolean(data.get("exist").toString())) continue;
            Long orgId = this.getLongValOfCustomParam(data.get("orgId"));
            List standardPositions = (List)data.get("standardPositions");
            resultMap.put(orgId, standardPositions);
        }
        return resultMap;
    }

    private long getLongValOfCustomParam(Object object) {
        if (object == null) {
            return 0L;
        }
        if (object instanceof Long) {
            return (Long)object;
        }
        if (object instanceof DynamicObject) {
            return ((DynamicObject)object).getLong("id");
        }
        return Long.parseLong(object.toString());
    }

    public List<Map<String, Object>> getHrPosition(List<Long> ids) {
        try {
            Map result = (Map)HRMServiceHelper.invokeHRMPService("hbpm", "IPositionService", "queryPositionById", ids);
            ArrayList list = (ArrayList)result.get(DATA);
            return list;
        }
        catch (Exception e) {
            LOG.error("invoke getHrIposition failed!", (Throwable)e);
            return new ArrayList<Map<String, Object>>();
        }
    }

    public Map<String, Object> getHrPositionSingle(Long id) {
        try {
            return this.getHrPosition((List<Long>)ImmutableList.of((Object)id)).get(0);
        }
        catch (Exception e) {
            LOG.error("invoke getHrIposition failed!", (Throwable)e);
            return new HashMap<String, Object>();
        }
    }

    public List<Map<String, Object>> getStandardPosition(List<Long> ids) {
        try {
            ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
            List list = Lists.partition(ids, (int)500);
            for (List idList : list) {
                Map result = (Map)HRMServiceHelper.invokeHRMPService("hbpm", "IStandardPositionQueryService", "queryStandardPositionById", idList);
                ArrayList listsub = (ArrayList)result.get(DATA);
                resultList.addAll(listsub);
            }
            return resultList;
        }
        catch (Exception e) {
            LOG.error("invoke getStandardIposition failed!", (Throwable)e);
            return new ArrayList<Map<String, Object>>();
        }
    }

    public Map<String, Object> getStandardIpositionSingle(Long id) {
        try {
            return this.getStandardPosition((List<Long>)ImmutableList.of((Object)id)).get(0);
        }
        catch (Exception e) {
            LOG.error("invoke getStandardIposition failed!", (Throwable)e);
            return new HashMap<String, Object>();
        }
    }

    public Map<Long, Object> queryJobLevelAndJobGradeByStdPositionIds(List<Long> ids) {
        HashMap<Long, Object> resultMap = new HashMap<Long, Object>();
        try {
            List list = Lists.partition(ids, (int)2000);
            for (List idList : list) {
                Map result = (Map)HRMServiceHelper.invokeHRMPService("hbpm", "IStandardPositionService", "queryJobLevelAndJobGradeByStdPositionIds", idList);
                if (HRObjectUtils.isEmpty((Object)result)) continue;
                HashMap resultMapSub = (HashMap)result.get(DATA);
                if (HRObjectUtils.isEmpty(result.get(DATA))) continue;
                resultMap.putAll(resultMapSub);
            }
            return resultMap;
        }
        catch (Exception e) {
            LOG.error("invoke queryJobLevelAndJobGradeByStdPositionIds failed!", (Throwable)e);
            return resultMap;
        }
    }

    public Map<Long, Object> queryJobLevelAndJobGradeByPositionIds(List<Long> ids) {
        HashMap<Long, Object> resultMap = new HashMap<Long, Object>();
        try {
            List list = Lists.partition(ids, (int)2000);
            for (List idList : list) {
                Map result = (Map)HRMServiceHelper.invokeHRMPService("hbpm", "IPositionService", "queryJobLevelAndJobGradeByPositionIds", idList);
                if (HRObjectUtils.isEmpty((Object)result)) continue;
                HashMap resultMapSub = (HashMap)result.get(DATA);
                if (HRObjectUtils.isEmpty(result.get(DATA))) continue;
                resultMap.putAll(resultMapSub);
            }
            return resultMap;
        }
        catch (Exception e) {
            LOG.error("invoke queryJobLevelAndJobGradeByPositionIds failed!", (Throwable)e);
            return resultMap;
        }
    }

    public List<Long> getJobGradeScmIdsByUseorgIdList(List<Long> useorgIdList) {
        return (List)HRMServiceHelper.invokeHRMPService("hbjm", "IHBJMJobGradeScmService", "getJobGradeScmIdsByUseorgIdList", useorgIdList);
    }

    public List<Long> getJobLevelScmIdsByUseorgIdList(List<Long> useorgIdList) {
        return (List)HRMServiceHelper.invokeHRMPService("hbjm", "IHBJMJobLevelScmService", "getJobLevelScmIdsByUseorgIdList", useorgIdList);
    }

    public List<Long> getJobIdsByUseorgIdList(List<Long> useorgIdList) {
        return (List)HRMServiceHelper.invokeHRMPService("hbjm", "IHBJMService", "getJobIdsByUseorgIdList", useorgIdList);
    }

    public List<Long> getStdPosIdsByUseorgIdList(List<Long> useorgIdList) {
        return (List)HRMServiceHelper.invokeHRMPService("hbpm", "IStandardPositionQueryService", "getStdPosIdsByUseorgIdList", useorgIdList);
    }

    public Map<Long, Map<String, Object>> getJobLevelGradeRangeInfoByJobIds(List<Long> jobBoids) {
        if (CollectionUtils.isEmpty(jobBoids)) {
            return new HashMap<Long, Map<String, Object>>();
        }
        LOG.info("jobBoids.size():{}", (Object)jobBoids.size());
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)jobBoids.size());
        int partitionLenght = 500;
        List jobIdParts = new ArrayList<List<Long>>(16);
        if (jobBoids.size() > partitionLenght) {
            jobIdParts = Lists.partition(jobBoids, (int)partitionLenght);
        } else {
            jobIdParts.add(jobBoids);
        }
        for (List jobIds : jobIdParts) {
            Map responseMap = (Map)HRMServiceHelper.invokeHRMPService("hbjm", "IHBJMJobLevelGradeService", "getAllJobLevelGradeRangeInfoByJobVersionId", jobIds);
            if (!HRStringUtils.equals((String)"200", (String)responseMap.get("code").toString())) {
                LOG.error("getJobLevelGradeRangeInfoByJobIds fail! {}", (Object)JSONObject.toJSONString((Object)responseMap));
                continue;
            }
            List dataList = (List)responseMap.get(DATA);
            if (dataList == null || dataList.size() == 0) {
                LOG.error("getJobLevelGradeRangeInfoByJobIds data is empty! {}", (Object)JSONObject.toJSONString((Object)responseMap));
                continue;
            }
            for (Map data : dataList) {
                if (!Boolean.parseBoolean(data.get("success").toString()) || !Boolean.parseBoolean(data.get("exist").toString())) {
                    LOG.error("cannot find data: {}", (Object)JSONObject.toJSONString((Object)data));
                    continue;
                }
                HashMap jobinfoMap = Maps.newHashMapWithExpectedSize((int)12);
                jobinfoMap.put("jobNumber", data.get("jobNumber"));
                jobinfoMap.put("jobName", data.get("jobName"));
                jobinfoMap.put("createOrg", data.get("createOrg"));
                jobinfoMap.put("jobscm", data.get("jobscm"));
                jobinfoMap.put("jobseq", data.get("jobseq"));
                jobinfoMap.put("jobfamily", data.get("jobfamily"));
                jobinfoMap.put("jobclass", data.get("jobclass"));
                long jobId = Long.parseLong(data.get("jobId").toString());
                this.putJoblevelgradeRangesAndScmToMap(data, jobinfoMap);
                resultMap.put(jobId, jobinfoMap);
            }
        }
        return resultMap;
    }

    private void putJoblevelgradeRangesAndScmToMap(Map<String, Object> rpcQueryDataMap, Map<String, Object> jobinfoMap) {
        Long joblevelScmid = 0L;
        Map job_joblevel = (Map)rpcQueryDataMap.get("job_joblevel");
        Map jobfamily_joblevel = (Map)rpcQueryDataMap.get("jobfamily_joblevel");
        Map jobclass_joblevel = (Map)rpcQueryDataMap.get("jobclass_joblevel");
        Map jobscm_joblevel = (Map)rpcQueryDataMap.get("jobscm_joblevel");
        if (job_joblevel != null && (Long)job_joblevel.get("id") != 0L) {
            joblevelScmid = job_joblevel.get("id");
        } else if (jobclass_joblevel != null && (Long)jobclass_joblevel.get("id") != 0L) {
            joblevelScmid = jobclass_joblevel.get("id");
        } else if (jobfamily_joblevel != null && (Long)jobfamily_joblevel.get("id") != 0L) {
            joblevelScmid = jobfamily_joblevel.get("id");
        } else if (jobscm_joblevel != null && (Long)jobscm_joblevel.get("id") != 0L) {
            joblevelScmid = jobscm_joblevel.get("id");
        }
        jobinfoMap.put("joblevelScmid", joblevelScmid);
        List joblevelRanges = new ArrayList();
        if (job_joblevel != null && !CollectionUtils.isEmpty((Collection)((List)job_joblevel.get("ranges")))) {
            joblevelRanges = (List)job_joblevel.get("ranges");
        } else if (jobclass_joblevel != null && !CollectionUtils.isEmpty((Collection)((List)jobclass_joblevel.get("ranges")))) {
            joblevelRanges = (List)jobclass_joblevel.get("ranges");
        } else if (jobfamily_joblevel != null && !CollectionUtils.isEmpty((Collection)((List)jobfamily_joblevel.get("ranges")))) {
            joblevelRanges = (List)jobfamily_joblevel.get("ranges");
        } else if (jobscm_joblevel != null && !CollectionUtils.isEmpty((Collection)((List)jobscm_joblevel.get("ranges")))) {
            joblevelRanges = (List)jobscm_joblevel.get("ranges");
        }
        jobinfoMap.put("joblevelRanges", joblevelRanges);
        Long jobgradeScmid = 0L;
        Map job_jobgrade = (Map)rpcQueryDataMap.get("job_jobgrade");
        Map jobfamily_jobgrade = (Map)rpcQueryDataMap.get("jobfamily_jobgrade");
        Map jobclass_jobgrade = (Map)rpcQueryDataMap.get("jobclass_jobgrade");
        Map jobscm_jobgrade = (Map)rpcQueryDataMap.get("jobscm_jobgrade");
        if (job_jobgrade != null && (Long)job_jobgrade.get("id") != 0L) {
            jobgradeScmid = job_jobgrade.get("id");
        } else if (jobclass_jobgrade != null && (Long)jobclass_jobgrade.get("id") != 0L) {
            jobgradeScmid = jobclass_jobgrade.get("id");
        } else if (jobfamily_jobgrade != null && (Long)jobfamily_jobgrade.get("id") != 0L) {
            jobgradeScmid = jobfamily_jobgrade.get("id");
        } else if (jobscm_jobgrade != null && (Long)jobscm_jobgrade.get("id") != 0L) {
            jobgradeScmid = jobscm_jobgrade.get("id");
        }
        jobinfoMap.put("jobgradeScmid", jobgradeScmid);
        List jobgradeRanges = new ArrayList();
        if (job_jobgrade != null && !CollectionUtils.isEmpty((Collection)((List)job_jobgrade.get("ranges")))) {
            jobgradeRanges = (List)job_jobgrade.get("ranges");
        } else if (jobclass_jobgrade != null && !CollectionUtils.isEmpty((Collection)((List)jobclass_jobgrade.get("ranges")))) {
            jobgradeRanges = (List)jobclass_jobgrade.get("ranges");
        } else if (jobfamily_jobgrade != null && !CollectionUtils.isEmpty((Collection)((List)jobfamily_jobgrade.get("ranges")))) {
            jobgradeRanges = (List)jobfamily_jobgrade.get("ranges");
        } else if (jobscm_jobgrade != null && !CollectionUtils.isEmpty((Collection)((List)jobscm_jobgrade.get("ranges")))) {
            jobgradeRanges = (List)jobscm_jobgrade.get("ranges");
        }
        jobinfoMap.put("jobgradeRanges", jobgradeRanges);
    }

    public Map<Long, Long> getJobLevelScmIdByLevelIds(List<Long> levelIds) {
        return (Map)HRMServiceHelper.invokeHRMPService("hbjm", "IHBJMJobLevelGradeService", "getJobLevelScmIdById", levelIds);
    }

    public Map<Long, Long> getJobGradeScmIdByGradeIds(List<Long> gradeIds) {
        return (Map)HRMServiceHelper.invokeHRMPService("hbjm", "IHBJMJobLevelGradeService", "getJobGradeScmIdById", gradeIds);
    }

    public List<Long> queryAdminBoIdByIds(List<Long> ids) {
        return (List)HRMServiceHelper.invokeHRMPService("haos", "IHAOSBatchAdminOrgInfoQueryService", "queryAdminBoIdByIds", ids);
    }

    private static class BizMserviceInvokeServiceInstance {
        private static BizMserviceInvokeService INSTANCE = new BizMserviceInvokeService();

        private BizMserviceInvokeServiceInstance() {
        }
    }
}

