/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.domain.odc.util;

import java.lang.reflect.Field;
import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.domain.odc.repository.ODCFieldPermRepository;
import kd.hr.hbp.common.odc.FieldNameInfo;

public class FieldConfigMap {
    private static final Log LOG = LogFactory.getLog(FieldConfigMap.class);
    private static final Map<String, FieldNameInfo> CONFIG_MAP = new LinkedHashMap<String, FieldNameInfo>();

    public static FieldNameInfo getFieldName(String pageKey) {
        FieldNameInfo info = CONFIG_MAP.get(pageKey);
        if (info == null) {
            return new FieldNameInfo();
        }
        return info.copy();
    }

    private static FieldNameInfo getFieldNameInfo(DynamicObject dy) {
        try {
            Field[] declaredFields;
            Class<FieldNameInfo> cls = FieldNameInfo.class;
            FieldNameInfo fieldNameInfo = (FieldNameInfo)cls.newInstance();
            for (Field field : declaredFields = cls.getDeclaredFields()) {
                if (!dy.containsProperty(field.getName().toLowerCase())) continue;
                field.set(fieldNameInfo, dy.get(field.getName().toLowerCase()));
            }
            return fieldNameInfo;
        }
        catch (Exception e) {
            LOG.error("FieldNameInfo getInstance error", (Throwable)e);
            return new FieldNameInfo();
        }
    }

    static {
        DynamicObject[] dys = ODCFieldPermRepository.getInstance().load(null);
        if (dys != null && dys.length > 0) {
            for (DynamicObject dy : dys) {
                CONFIG_MAP.put(dy.getString("entitynum"), FieldConfigMap.getFieldNameInfo(dy));
            }
        }
    }
}

