/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.domain.repository;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.domain.model.newhismodel.EffStartEndDateBo;
import kd.hr.hbp.business.domain.model.newhismodel.HisUniqueValidatorBo;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisCommonService;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisEffDateCommonService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.constants.newhismodel.EnumHisDataVersionStatus;
import kd.hr.hbp.common.constants.newhismodel.EventOperateEnums;
import kd.hr.hbp.common.util.HRStringUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class HisCommonEntityRepository {
    private static final Log LOGGER = LogFactory.getLog(HisCommonEntityRepository.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<Long, List<EffStartEndDateBo>> getOldEffVersionsByBoId(HRBaseServiceHelper serviceHelper, Set<Long> boIdSet) {
        if (serviceHelper == null) {
            return null;
        }
        QFilter boIDFilter = new QFilter("boid", "in", boIdSet);
        QFilter isCurrentFilter = new QFilter("iscurrentversion", "=", (Object)Character.valueOf('0'));
        QFilter statusFilter = new QFilter("datastatus", "in", Arrays.asList(EnumHisDataVersionStatus.TO_BE_EFFECT.getStatus(), EnumHisDataVersionStatus.EFFECTING.getStatus(), EnumHisDataVersionStatus.INVALIDED.getStatus()));
        HashMap<Long, List<EffStartEndDateBo>> mapEffStartEndDateBo = new HashMap<Long, List<EffStartEndDateBo>>(boIdSet.size());
        try (DataSet dataSet = null;){
            dataSet = serviceHelper.queryDataSet(HisCommonEntityRepository.class.getName() + ".getOldEffVersionsByBoId", "boid,bsed,bsled", new QFilter[]{boIDFilter, isCurrentFilter, statusFilter});
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                Long boId = row.getLong("boid");
                EffStartEndDateBo effStartEndDateBo = new EffStartEndDateBo();
                effStartEndDateBo.setEffectStartDate(row.getDate("bsed"));
                effStartEndDateBo.setEffectEndDate(row.getDate("bsled"));
                ArrayList<EffStartEndDateBo> effStartEndDateBoList = (ArrayList<EffStartEndDateBo>)mapEffStartEndDateBo.get(boId);
                if (effStartEndDateBoList == null) {
                    effStartEndDateBoList = new ArrayList<EffStartEndDateBo>(16);
                    mapEffStartEndDateBo.put(boId, effStartEndDateBoList);
                }
                effStartEndDateBoList.add(effStartEndDateBo);
            }
        }
        return mapEffStartEndDateBo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<Long, List<String>> getVersionNumber(HRBaseServiceHelper serviceHelper, Set<Long> boIdSet) {
        if (serviceHelper == null) {
            return null;
        }
        QFilter boIDFilter = new QFilter("boid", "in", boIdSet);
        QFilter isCurrentFilter = new QFilter("iscurrentversion", "=", (Object)Character.valueOf('0'));
        QFilter statusFilter = new QFilter("datastatus", "!=", (Object)EnumHisDataVersionStatus.TEMP.getStatus());
        HashMap<Long, List<String>> mapVersionNumber = new HashMap<Long, List<String>>(boIdSet.size());
        try (DataSet dataSet = null;){
            dataSet = serviceHelper.queryDataSet(HisCommonEntityRepository.class.getName() + ".getVersionNumber", "boid,hisversion", new QFilter[]{boIDFilter, isCurrentFilter, statusFilter});
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                Long boId = row.getLong("boid");
                String versionNumber = row.getString("hisversion");
                ArrayList<String> listVersionNumber = (ArrayList<String>)mapVersionNumber.get(boId);
                if (listVersionNumber == null) {
                    listVersionNumber = new ArrayList<String>(16);
                    mapVersionNumber.put(boId, listVersionNumber);
                }
                listVersionNumber.add(versionNumber);
            }
        }
        return mapVersionNumber;
    }

    public static DynamicObject[] loadOldEffVersionByBoIds(HRBaseServiceHelper serviceHelper, Set<Long> boIds) {
        if (serviceHelper == null) {
            return new DynamicObject[0];
        }
        QFilter boIDFilter = new QFilter("boid", "in", boIds);
        QFilter isCurrentFilter = new QFilter("iscurrentversion", "=", (Object)Character.valueOf('0'));
        QFilter statusFilter = new QFilter("datastatus", "in", Arrays.asList(EnumHisDataVersionStatus.TO_BE_EFFECT.getStatus(), EnumHisDataVersionStatus.EFFECTING.getStatus(), EnumHisDataVersionStatus.INVALIDED.getStatus()));
        return serviceHelper.loadDynamicObjectArray(new QFilter[]{boIDFilter, isCurrentFilter, statusFilter});
    }

    @ExcludeFromJacocoGeneratedReport
    public static DynamicObject[] loadOldEffVersionByBoIdsWithoutNoInit(HRBaseServiceHelper serviceHelper, Set<Long> boIds) {
        if (serviceHelper == null) {
            return new DynamicObject[0];
        }
        QFilter boIDFilter = new QFilter("boid", "in", boIds);
        QFilter isCurrentFilter = new QFilter("iscurrentversion", "=", (Object)Character.valueOf('0'));
        QFilter statusFilter = new QFilter("datastatus", "in", Arrays.asList(EnumHisDataVersionStatus.TO_BE_EFFECT.getStatus(), EnumHisDataVersionStatus.EFFECTING.getStatus(), EnumHisDataVersionStatus.INVALIDED.getStatus()));
        boolean hasInitStatus = HisCommonService.getInstance().hasInitStatusFiled(null, serviceHelper.getEntityName());
        QFilter qFilterInitComplete = null;
        if (hasInitStatus) {
            qFilterInitComplete = new QFilter("initstatus", "not in", Arrays.asList("0", "1"));
        }
        if (hasInitStatus && qFilterInitComplete != null) {
            return serviceHelper.loadDynamicObjectArray(new QFilter[]{boIDFilter, isCurrentFilter, statusFilter, qFilterInitComplete});
        }
        return serviceHelper.loadDynamicObjectArray(new QFilter[]{boIDFilter, isCurrentFilter, statusFilter});
    }

    @ExcludeFromJacocoGeneratedReport
    public static DynamicObject[] loadOldEffVersionByBoIdWithoutNoInit(HRBaseServiceHelper serviceHelper, Long boId) {
        if (serviceHelper == null) {
            return new DynamicObject[0];
        }
        QFilter boIDFilter = new QFilter("boid", "=", (Object)boId);
        QFilter isCurrentFilter = new QFilter("iscurrentversion", "=", (Object)Character.valueOf('0'));
        QFilter statusFilter = new QFilter("datastatus", "in", Arrays.asList(EnumHisDataVersionStatus.TO_BE_EFFECT.getStatus(), EnumHisDataVersionStatus.EFFECTING.getStatus(), EnumHisDataVersionStatus.INVALIDED.getStatus()));
        boolean hasInitStatus = HisCommonService.getInstance().hasInitStatusFiled(null, serviceHelper.getEntityName());
        QFilter qFilterInitComplete = null;
        if (hasInitStatus) {
            qFilterInitComplete = new QFilter("initstatus", "not in", Arrays.asList("0", "1"));
        }
        if (hasInitStatus && qFilterInitComplete != null) {
            return serviceHelper.loadDynamicObjectArray(new QFilter[]{boIDFilter, isCurrentFilter, statusFilter, qFilterInitComplete});
        }
        return serviceHelper.loadDynamicObjectArray(new QFilter[]{boIDFilter, isCurrentFilter, statusFilter});
    }

    @ExcludeFromJacocoGeneratedReport
    public static DynamicObject[] loadOldEffDataByBoIds(HRBaseServiceHelper serviceHelper, Set<Long> boIds) {
        QFilter boIDFilter = new QFilter("boid", "in", boIds);
        QFilter statusFilter = new QFilter("datastatus", "in", Arrays.asList(EnumHisDataVersionStatus.TO_BE_EFFECT.getStatus(), EnumHisDataVersionStatus.EFFECTING.getStatus(), EnumHisDataVersionStatus.INVALIDED.getStatus()));
        if (serviceHelper == null) {
            return new DynamicObject[0];
        }
        return serviceHelper.loadDynamicObjectArray(new QFilter[]{boIDFilter, statusFilter});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, EffStartEndDateBo> queryOldEffVersionEffDateByBoId(HRBaseServiceHelper serviceHelper, Long boId) {
        QFilter boIDFilter = new QFilter("boid", "=", (Object)boId);
        QFilter isCurrentFilter = new QFilter("iscurrentversion", "=", (Object)Character.valueOf('0'));
        QFilter statusFilter = new QFilter("datastatus", "in", Arrays.asList(EnumHisDataVersionStatus.TO_BE_EFFECT.getStatus(), EnumHisDataVersionStatus.EFFECTING.getStatus(), EnumHisDataVersionStatus.INVALIDED.getStatus()));
        HashMap<String, EffStartEndDateBo> mapOldVersionEffDate = new HashMap<String, EffStartEndDateBo>(8);
        try (DataSet dataSet = null;){
            dataSet = serviceHelper.queryDataSet(HisCommonEntityRepository.class.getName() + ".queryOldEffVersionEffDateByBoId", "id,hisversion,bsed,bsled", new QFilter[]{boIDFilter, isCurrentFilter, statusFilter});
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                EffStartEndDateBo effStartEndDateBo = new EffStartEndDateBo();
                effStartEndDateBo.setEffectStartDate(row.getDate("bsed"));
                effStartEndDateBo.setEffectEndDate(row.getDate("bsled"));
                effStartEndDateBo.setId(row.getLong("id"));
                mapOldVersionEffDate.put(row.getString("hisversion"), effStartEndDateBo);
            }
        }
        return mapOldVersionEffDate;
    }

    public static DynamicObject[] queryCurrentDataForEffDate(HRBaseServiceHelper serviceHelper, Collection<Long> ids) {
        return serviceHelper.query("id, datastatus, bsed", new QFilter[]{new QFilter("id", "in", ids)});
    }

    @ExcludeFromJacocoGeneratedReport
    public static Set<Long> getAllToBeEffectBoIdByBoId(HRBaseServiceHelper serviceHelper, DynamicObject[] dys) {
        Map<Long, DynamicObject> boMap = Arrays.stream(dys).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy));
        QFilter boIDFilter = new QFilter("boid", "in", boMap.keySet());
        QFilter isCurrentFilter = new QFilter("iscurrentversion", "=", (Object)Character.valueOf('0'));
        QFilter statusFilter = new QFilter("datastatus", "=", (Object)EnumHisDataVersionStatus.TO_BE_EFFECT.getStatus());
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)16);
        long current = System.currentTimeMillis();
        long dayTime = current - (current + (long)TimeZone.getDefault().getRawOffset()) % 86400000L;
        Date today = new Date(dayTime);
        DynamicObjectCollection dataCol = serviceHelper.queryOriginalCollection("id, boid, bsed", new QFilter[]{boIDFilter, statusFilter, isCurrentFilter});
        for (DynamicObject dy2 : dataCol) {
            long boId2 = dy2.getLong("boid");
            List versions = resultMap.getOrDefault(boId2, Lists.newArrayListWithCapacity((int)10));
            Date disableDate = HRStringUtils.equals((String)boMap.get(boId2).getString("datastatus"), (String)EnumHisDataVersionStatus.EFFECTING.getStatus()) ? today : boMap.get(boId2).getDate("bsed");
            if (dy2.getDate("bsed").getTime() >= disableDate.getTime()) {
                versions.add(dy2);
            }
            resultMap.putIfAbsent(dy2.getLong("boid"), versions);
        }
        HashMap resultIdMap = Maps.newHashMapWithExpectedSize((int)resultMap.size());
        resultMap.forEach((boId, versionDys) -> resultIdMap.put(boId, versionDys.stream().map(dy -> dy.getLong("id")).collect(Collectors.toList())));
        return HisCommonEntityRepository.filterToBeConfirmBoIds(resultIdMap, serviceHelper);
    }

    @ExcludeFromJacocoGeneratedReport
    public static Set<Long> getAllToBeEffectBoIdByBoId(HRBaseServiceHelper serviceHelper, Collection<Long> boIds, Date disableDate) {
        QFilter boIDFilter = new QFilter("boid", "in", boIds);
        QFilter isCurrentFilter = new QFilter("iscurrentversion", "=", (Object)Character.valueOf('0'));
        QFilter statusFilter = new QFilter("datastatus", "=", (Object)EnumHisDataVersionStatus.TO_BE_EFFECT.getStatus());
        QFilter disableDateFilter = new QFilter("bsed", ">=", (Object)disableDate);
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)16);
        try (DataSet dataSet = serviceHelper.queryDataSet(HisCommonEntityRepository.class.getName() + ".getAllToBeEffectBoIdByBoId", "id, boid", new QFilter[]{boIDFilter, statusFilter, isCurrentFilter, disableDateFilter});){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                List idList = resultMap.getOrDefault(row.getLong("boid"), Lists.newArrayListWithCapacity((int)10));
                idList.add(row.getLong("id"));
                resultMap.putIfAbsent(row.getLong("boid"), idList);
            }
        }
        return HisCommonEntityRepository.filterToBeConfirmBoIds(resultMap, serviceHelper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<Long, EffStartEndDateBo> getVersionEffEndDate(HRBaseServiceHelper serviceHelper, List<Long> boIds, Date effDate) {
        QFilter boIDFilter = new QFilter("boid", "in", boIds);
        QFilter isCurrentFilter = new QFilter("iscurrentversion", "=", (Object)Character.valueOf('0'));
        QFilter statusFilter = new QFilter("datastatus", "in", Arrays.asList(EnumHisDataVersionStatus.TO_BE_EFFECT.getStatus(), EnumHisDataVersionStatus.EFFECTING.getStatus(), EnumHisDataVersionStatus.INVALIDED.getStatus()));
        QFilter effEndDateFilter = new QFilter("bsled", ">=", (Object)effDate);
        String orderby = "boid asc,bsled asc";
        HashMap<Long, EffStartEndDateBo> mapBoIdEffStartEndDateBo = new HashMap<Long, EffStartEndDateBo>(16);
        try (DataSet dataSet = null;){
            dataSet = serviceHelper.queryDataSet(HisCommonEntityRepository.class.getName() + ".getVersionEffEndDate", "boid,bsed,bsled", new QFilter[]{boIDFilter, statusFilter, isCurrentFilter, effEndDateFilter}, orderby);
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                Long boid = row.getLong("boid");
                if (mapBoIdEffStartEndDateBo.containsKey(boid)) continue;
                EffStartEndDateBo effStartEndDateBo = new EffStartEndDateBo();
                effStartEndDateBo.setEffectStartDate(row.getDate("bsed"));
                effStartEndDateBo.setEffectEndDate(row.getDate("bsled"));
                mapBoIdEffStartEndDateBo.put(boid, effStartEndDateBo);
            }
        }
        return mapBoIdEffStartEndDateBo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getTempVersionEffEndDate(HRBaseServiceHelper serviceHelper, List<Long> pkIds, Map<Long, List<EffStartEndDateBo>> mapBoIdGroupData) {
        if (mapBoIdGroupData == null || mapBoIdGroupData.size() == 0) {
            return;
        }
        Set<Long> boIds = mapBoIdGroupData.keySet();
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(4);
        qFilterList.add(new QFilter("boid", "in", boIds));
        qFilterList.add(new QFilter("datastatus", "=", (Object)EnumHisDataVersionStatus.TEMP.getStatus()));
        qFilterList.add(new QFilter("bsed", "is not null", null));
        if (pkIds.size() > 0) {
            qFilterList.add(new QFilter("id", "not in", pkIds));
        }
        try (DataSet dataSet = null;){
            String selectFields = "boid,bsed,bsled";
            dataSet = serviceHelper.queryDataSet(HisCommonEntityRepository.class.getName() + ".getEffectVersionBoId", selectFields, qFilterList.toArray(new QFilter[qFilterList.size()]));
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                Long boId = row.getLong("boid");
                List<EffStartEndDateBo> effStartEndDateBoList = mapBoIdGroupData.get(boId);
                if (effStartEndDateBoList == null) {
                    effStartEndDateBoList = new ArrayList<EffStartEndDateBo>(8);
                    mapBoIdGroupData.put(boId, effStartEndDateBoList);
                }
                EffStartEndDateBo effStartEndDateBo = new EffStartEndDateBo();
                effStartEndDateBo.setEffectStartDate(row.getDate("bsed"));
                Date effEndDate = row.getDate("bsled");
                if (effEndDate == null) {
                    effEndDate = HisEffDateCommonService.getInstance().getDate2999(null);
                }
                effStartEndDateBo.setEffectEndDate(effEndDate);
                effStartEndDateBoList.add(effStartEndDateBo);
            }
        }
    }

    public static DynamicObject[] getAllCurrentValidDataByBoId(HRBaseServiceHelper serviceHelper, List<Long> boIds) {
        if (serviceHelper == null) {
            return new DynamicObject[0];
        }
        QFilter boIdFilter = new QFilter("id", "in", boIds);
        QFilter statusFilter = new QFilter("datastatus", "in", Arrays.asList(EnumHisDataVersionStatus.TO_BE_EFFECT.getStatus(), EnumHisDataVersionStatus.EFFECTING.getStatus(), EnumHisDataVersionStatus.TEMP.getStatus(), EnumHisDataVersionStatus.INVALIDED.getStatus()));
        DynamicObject[] dynamicObjects = serviceHelper.loadDynamicObjectArray(new QFilter[]{boIdFilter, statusFilter});
        return dynamicObjects;
    }

    public static DynamicObject[] getValidDataVersionByDate(HRBaseServiceHelper serviceHelper, List<Long> boIds, Date date) {
        if (serviceHelper == null) {
            return new DynamicObject[0];
        }
        QFilter boIdFilter = new QFilter("boid", "in", boIds);
        QFilter statusFilter = new QFilter("datastatus", "in", Arrays.asList(EnumHisDataVersionStatus.TO_BE_EFFECT.getStatus(), EnumHisDataVersionStatus.EFFECTING.getStatus(), EnumHisDataVersionStatus.INVALIDED.getStatus()));
        QFilter dateBeforeFilter = new QFilter("bsed", "<=", (Object)date);
        QFilter dateAfterFilter = new QFilter("bsled", ">=", (Object)date);
        QFilter isCurrentFilter = new QFilter("iscurrentversion", "=", (Object)Character.valueOf('0'));
        DynamicObject[] dynamicObjects = serviceHelper.loadDynamicObjectArray(new QFilter[]{boIdFilter, statusFilter, dateBeforeFilter, dateAfterFilter, isCurrentFilter});
        return dynamicObjects;
    }

    public static boolean exitsOldCurrentData(HRBaseServiceHelper serviceHelper, Long boId) {
        QFilter boIDFilter = new QFilter("id", "=", (Object)boId);
        QFilter statusFilter = new QFilter("datastatus", "in", Arrays.asList(EnumHisDataVersionStatus.TO_BE_EFFECT.getStatus(), EnumHisDataVersionStatus.EFFECTING.getStatus(), EnumHisDataVersionStatus.INVALIDED.getStatus()));
        return serviceHelper.isExists(new QFilter[]{boIDFilter, statusFilter});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<Long> getEffectVersionBoId(HRBaseServiceHelper serviceHelper, Set<Long> idSet) {
        QFilter boIDFilter = new QFilter("id", "in", idSet);
        QFilter statusFilter = new QFilter("datastatus", "in", Arrays.asList(EnumHisDataVersionStatus.TO_BE_EFFECT.getStatus(), EnumHisDataVersionStatus.EFFECTING.getStatus(), EnumHisDataVersionStatus.INVALIDED.getStatus()));
        HashSet<Long> oldIdSet = new HashSet<Long>(16);
        try (DataSet dataSet = null;){
            dataSet = serviceHelper.queryDataSet(HisCommonEntityRepository.class.getName() + ".getEffectVersionBoId", "id", new QFilter[]{boIDFilter, statusFilter});
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                oldIdSet.add(row.getLong("id"));
            }
        }
        return oldIdSet;
    }

    public static DynamicObject[] getOldCurrentDataArray(HRBaseServiceHelper serviceHelper, Set<Long> boIds) {
        if (boIds == null || boIds.size() == 0) {
            return null;
        }
        QFilter boIDFilter = new QFilter("id", "in", boIds);
        QFilter statusFilter = new QFilter("datastatus", "in", Arrays.asList(EnumHisDataVersionStatus.TO_BE_EFFECT.getStatus(), EnumHisDataVersionStatus.EFFECTING.getStatus(), EnumHisDataVersionStatus.INVALIDED.getStatus()));
        DynamicObject[] dynamicObjects = serviceHelper.loadDynamicObjectArray(new QFilter[]{boIDFilter, statusFilter});
        return dynamicObjects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<Long> getRestTempData(HRBaseServiceHelper serviceHelper, List<Long> idList, Set<Long> boIds) {
        QFilter idsFilter = new QFilter("id", "not in", idList);
        QFilter boIDFilter = new QFilter("boid", "in", boIds);
        QFilter statusFilter = new QFilter("datastatus", "=", (Object)EnumHisDataVersionStatus.TEMP.getStatus());
        QFilter isCurrentFilter = new QFilter("iscurrentversion", "=", (Object)Character.valueOf('0'));
        HashSet<Long> boIdSet = new HashSet<Long>(16);
        try (DataSet dataSet = null;){
            dataSet = serviceHelper.queryDataSet(HisCommonEntityRepository.class.getName() + ".getRestTempData", "boid", new QFilter[]{idsFilter, boIDFilter, statusFilter, isCurrentFilter});
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                boIdSet.add(row.getLong("boid"));
            }
        }
        return boIdSet;
    }

    public static DynamicObject getNonLineTimeTempByBoid(HRBaseServiceHelper serviceHelper, Long boId) {
        QFilter boidFilter = new QFilter("boid", "=", (Object)boId);
        QFilter dataStatusQfiter = new QFilter("datastatus", "=", (Object)EnumHisDataVersionStatus.TEMP.getStatus());
        return serviceHelper.queryOne("id,datastatus,modifytime,modifier,ismodify,iscurrentversion", boidFilter.and(dataStatusQfiter));
    }

    public static DynamicObject[] getNonLineTimeByBoid(HRBaseServiceHelper serviceHelper, List<Long> boId) {
        QFilter boidFilter = new QFilter("boid", "in", boId);
        return serviceHelper.query("id,datastatus,modifytime,modifier,ismodify,iscurrentversion,boid", new QFilter[]{boidFilter});
    }

    public static DynamicObject getNonLineDy(HRBaseServiceHelper busiServiceHelper, long id) {
        QFilter filter = new QFilter("id", "=", (Object)id);
        return busiServiceHelper.queryOne("id,datastatus,modifytime,modifier,ismodify,sourcevid,boid,hisversion", filter);
    }

    public static DynamicObject[] getNonLineRelEffectingDy(HRBaseServiceHelper busiServiceHelper, List<Long> boidList) {
        QFilter filter = new QFilter("id", "in", boidList);
        return busiServiceHelper.query("id,datastatus,sourcevid,modifytime,modifier,ismodify,boid", filter.toArray());
    }

    public static DynamicObject getNonLineRelCurEffectingDy(HRBaseServiceHelper busiServiceHelper, Long boid) {
        QFilter idFilter = new QFilter("id", "=", (Object)boid);
        QFilter dataStatusQfiter = new QFilter("datastatus", "=", (Object)EnumHisDataVersionStatus.EFFECTING.getStatus());
        idFilter.and(dataStatusQfiter);
        return busiServiceHelper.queryOne("id,datastatus,sourcevid,modifytime,modifier,ismodify,enable,masterid", idFilter);
    }

    public static DynamicObject getCurrentDy(HRBaseServiceHelper busiServiceHelper, Long boid) {
        return busiServiceHelper.queryOne("id, masterid", boid);
    }

    public static DynamicObject getCurrentDyName(HRBaseServiceHelper serviceHelper, Long boid) {
        return serviceHelper.queryOne("name", boid);
    }

    @ExcludeFromJacocoGeneratedReport
    public static DynamicObject[] getNonLineRelCurEffectingDy(HRBaseServiceHelper busiServiceHelper, Set<Long> boids) {
        QFilter idFilter = new QFilter("id", "in", boids);
        QFilter dataStatusQfiter = new QFilter("datastatus", "=", (Object)EnumHisDataVersionStatus.EFFECTING.getStatus());
        QFilter isModifyFilter = new QFilter("ismodify", "=", (Object)Character.valueOf('0'));
        return busiServiceHelper.query("id,datastatus,sourcevid,modifytime,modifier,ismodify,boid,enable", new QFilter[]{idFilter, dataStatusQfiter, isModifyFilter});
    }

    public static DynamicObject getAllFieldsDy(HRBaseServiceHelper busiServiceHelper, long id) {
        return busiServiceHelper.queryOne(id);
    }

    public static DynamicObject queryHisLineDy(String entityNum, Object id) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper(entityNum);
        return helper.loadSingle(id);
    }

    public static DynamicObject queryHisLineDy(String entityNum, Object id, String selectedProps) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper(entityNum);
        return helper.queryOne(selectedProps, id);
    }

    @ExcludeFromJacocoGeneratedReport
    public static Date getCurrentRowBsled(String entityNum, Object pkId) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper(entityNum);
        DynamicObject dy = helper.queryOriginalOne("bsed", pkId);
        return dy.getDate("bsed");
    }

    @ExcludeFromJacocoGeneratedReport
    public static boolean getEffectVersionAfterDate(String entityNum, Object boId, Date date) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper(entityNum);
        return helper.isExists(new QFilter[]{new QFilter("boid", "=", boId), new QFilter("datastatus", "not in", (Object)new String[]{"-2", "-1"}), new QFilter("bsed", ">", (Object)date)});
    }

    public static boolean getAllowMultiToBeEffData(String entityNum) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrcs_entityevent");
        DynamicObject entityConfigDy = helper.queryOriginalOne("effectdataversion", new QFilter[]{new QFilter("entity", "=", (Object)entityNum)});
        if (entityConfigDy == null) {
            return true;
        }
        return "2".equals(entityConfigDy.getString("effectdataversion"));
    }

    @ExcludeFromJacocoGeneratedReport
    public static HashMap<String, String> getNameByIdentify(ArrayList<HisUniqueValidatorBo> uniqueValidatorBos, String entity) {
        ArrayList fields = Lists.newArrayListWithExpectedSize((int)16);
        HashMap fieldNamesMap = Maps.newHashMapWithExpectedSize((int)16);
        Map allFields = EntityMetadataCache.getDataEntityType((String)entity).getAllFields();
        uniqueValidatorBos.forEach(bo -> fields.addAll(bo.getValidation()));
        Iterator iterator = fields.iterator();
        while (iterator.hasNext()) {
            String field;
            String finalField = field = (String)iterator.next();
            if (field.contains(".")) {
                field = field.split("\\.")[0];
            }
            String fieldName = ((IDataEntityProperty)allFields.get(field)).getDisplayName().getLocaleValue();
            fieldNamesMap.put(finalField, fieldName);
        }
        return fieldNamesMap;
    }

    public static DynamicObject[] queryOriginalArray(String entity, QFilter qFilter, String selectProperties) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entity);
        return serviceHelper.queryOriginalArray(selectProperties, qFilter.toArray());
    }

    @ExcludeFromJacocoGeneratedReport
    public static DynamicObject[] queryOriginalArray(String entity, QFilter qFilter, List<String> validation) {
        String selectProperties = StringUtils.strip((String)validation.toString(), (String)"[]");
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entity);
        return serviceHelper.queryOriginalArray("id," + selectProperties, qFilter.toArray());
    }

    @ExcludeFromJacocoGeneratedReport
    public static DynamicObject[] queryOriginalArray(String entity, List<QFilter> qFilters, String selectProperties) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entity);
        return serviceHelper.query(selectProperties, qFilters.toArray(new QFilter[0]), "", 20);
    }

    public static DynamicObject[] loadDynamicObjectArray(String entity, QFilter qFilter) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entity);
        return serviceHelper.loadDynamicObjectArray(qFilter.toArray());
    }

    public static DynamicObject queryOriginalOne(String entity, QFilter qFilter, String selectProperties) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entity);
        return serviceHelper.queryOriginalOne(selectProperties, qFilter.toArray());
    }

    @ExcludeFromJacocoGeneratedReport
    public static HashMap<String, String> getTypeByIdentify(ArrayList<HisUniqueValidatorBo> uniqueValidatorBos, String entity) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)16);
        ArrayList identifies = Lists.newArrayListWithExpectedSize((int)16);
        uniqueValidatorBos.forEach(bo -> identifies.addAll(bo.getValidation()));
        Map allFields = EntityMetadataCache.getDataEntityType((String)entity).getAllFields();
        Iterator iterator = identifies.iterator();
        while (iterator.hasNext()) {
            String identify;
            String finalIdentify = identify = (String)iterator.next();
            if (identify.contains(".")) {
                identify = identify.split("\\.")[0];
            }
            IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)allFields.get(identify);
            map.put(finalIdentify, iDataEntityProperty.getPropertyType().getSimpleName());
        }
        return map;
    }

    public static DynamicObject[] getEntityToEventDys(List<String> entityNumberList) {
        HRBaseServiceHelper hisModelRegHelper = new HRBaseServiceHelper("hrcs_entityevent");
        LOGGER.info("hismodelImport_getEntityToEventDys entityNumberList: {}", entityNumberList);
        QFilter qFilters = new QFilter("entity.id", "in", entityNumberList);
        return hisModelRegHelper.query("entity,evententity", qFilters.toArray());
    }

    public static DynamicObject getEntityToEventDy(String entityNumber) {
        HRBaseServiceHelper hisModelRegHelper = new HRBaseServiceHelper("hrcs_entityevent");
        LOGGER.info("hismodelImport_getEntityToEventDys getEntityToEventDy: {}", (Object)entityNumber);
        QFilter qFilters = new QFilter("entity.id", "=", (Object)entityNumber);
        return hisModelRegHelper.queryOne("entity,evententity", qFilters.toArray());
    }

    public static DynamicObject[] getEntityToAppDys(List<String> entityNumberList) {
        HRBaseServiceHelper entityobjectHelper = new HRBaseServiceHelper("bos_entityobject");
        QFilter qFilter = new QFilter("id", "in", entityNumberList);
        return entityobjectHelper.query("id,bizappid.id", qFilter.toArray());
    }

    public static DynamicObject getEntityToAppDy(String entityNumber) {
        HRBaseServiceHelper entityobjectHelper = new HRBaseServiceHelper("bos_entityobject");
        QFilter qFilter = new QFilter("id", "=", (Object)entityNumber);
        return entityobjectHelper.queryOne("id,bizappid.id", qFilter.toArray());
    }

    public static DynamicObject[] getAppDefaultEventDys(String[] appIds) {
        HRBaseServiceHelper appDefaultEventHelper = new HRBaseServiceHelper("hrcs_appdefaultevent");
        QFilter qFilter = new QFilter("actionapp.id", "in", (Object)appIds);
        return appDefaultEventHelper.query("actionapp,evententity", qFilter.toArray());
    }

    public static DynamicObject getAppDefaultEventDy(String appId) {
        HRBaseServiceHelper appDefaultEventHelper = new HRBaseServiceHelper("hrcs_appdefaultevent");
        QFilter qFilter = new QFilter("actionapp.id", "=", (Object)appId);
        return appDefaultEventHelper.queryOne("actionapp,evententity", qFilter.toArray());
    }

    public static DynamicObject[] getBusEventByEventId(HRBaseServiceHelper serviceHelper, Long eventId) {
        if (serviceHelper == null || eventId == null) {
            return null;
        }
        return serviceHelper.query("sourceentity,boid", new QFilter[]{new QFilter("event", "=", (Object)eventId)});
    }

    public static DynamicObject[] getVersionIdsByBoId(HRBaseServiceHelper serviceHelper, Long[] boIds) {
        if (serviceHelper == null) {
            return null;
        }
        return serviceHelper.query("id,boid", new QFilter[]{new QFilter("boid", "in", (Object)boIds), new QFilter("iscurrentversion", "=", (Object)Character.valueOf('0'))});
    }

    public static DynamicObject getEventById(HRBaseServiceHelper eventHelper, Long eventId) {
        QFilter eventQfilter = new QFilter("id", "=", (Object)eventId);
        return eventHelper.queryOne("id,eventtype,executeway,eventbatchtype,status,operateuser,operatedate,modifier,modifytime,createtime", eventQfilter);
    }

    public static DynamicObject[] getEventByIds(HRBaseServiceHelper eventHelper, Set<Long> eventIds) {
        QFilter eventQfilter = new QFilter("id", "in", eventIds);
        return eventHelper.query("id,eventtype,executeway,eventbatchtype,status,operatedate", new QFilter[]{eventQfilter}, "operatedate desc");
    }

    public static DynamicObject[] getBusiEventDys(HRBaseServiceHelper busiEventHelper, Long eventId, String entityNumber, List<Long> boIdList) {
        QFilter busiEventQfilter = new QFilter("event", "=", (Object)eventId).and(new QFilter("sourceentity", "=", (Object)entityNumber)).and(new QFilter("status", "=", (Object)EventOperateEnums.EVENT_STATUS_ALREADY_EXEC.getValue()));
        if (CollectionUtils.isNotEmpty(boIdList)) {
            List distinctBoIdList = boIdList.stream().distinct().collect(Collectors.toList());
            busiEventQfilter.and(new QFilter("boid", "in", distinctBoIdList));
        }
        return busiEventHelper.query("id,sourceentity,boid,isbusinesseventbo,status,canceledeventid,operateuser,operatedate,modifier,modifytime,event", busiEventQfilter.toArray());
    }

    public static DynamicObject[] getHisEventDys(HRBaseServiceHelper hisEventHelper, List<Long> busiEventIds) {
        QFilter hisEventQfilter = new QFilter("busievent", "in", busiEventIds);
        return hisEventHelper.query("vid,busievent,prestatus,prebsed,prebsled", hisEventQfilter.toArray());
    }

    @ExcludeFromJacocoGeneratedReport
    public static DynamicObject[] getAttachments(HRBaseServiceHelper serviceHelper, long id) {
        QFilter qfilter = new QFilter("finterid", "=", (Object)String.valueOf(id));
        return serviceHelper.query("id,fdescription,fnumber,finterid", qfilter.toArray());
    }

    public static DynamicObject[] getBusiDysByBoid(HRBaseServiceHelper serviceHelper, List<Long> boids) {
        QFilter boidFilter = new QFilter("boid", "in", boids);
        QFilter dataStatusQfiter = new QFilter("datastatus", "=", (Object)EnumHisDataVersionStatus.EFFECTING.getStatus());
        return serviceHelper.query("id,datastatus,boid,iscurrentversion,masterid", new QFilter[]{boidFilter, dataStatusQfiter});
    }

    public static DynamicObject[] byIdsAllFieldDys(HRBaseServiceHelper helper, DynamicObject[] dataEntities) {
        return helper.loadDynamicObjectArray(Arrays.stream(dataEntities).map(entity -> entity.get("id")).toArray(Object[]::new));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<Long> getExistsBoId(HRBaseServiceHelper serviceHelper, Set<Long> boIds) {
        QFilter boIDFilter = new QFilter("boid", "in", boIds);
        HashSet<Long> existSboId = new HashSet<Long>(16);
        try (DataSet dataSet = null;){
            dataSet = serviceHelper.queryDataSet(HisCommonEntityRepository.class.getName() + ".getExistsBoId", "boid", new QFilter[]{boIDFilter});
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                existSboId.add(row.getLong("boid"));
            }
        }
        return existSboId;
    }

    private static Set<Long> filterToBeConfirmBoIds(Map<Long, List<Long>> resultMap, HRBaseServiceHelper serviceHelper) {
        HashSet boIds = Sets.newHashSetWithExpectedSize((int)16);
        QFilter boIDFilter = new QFilter("id", "in", resultMap.keySet());
        QFilter statusFilter = new QFilter("datastatus", "=", (Object)EnumHisDataVersionStatus.TO_BE_EFFECT.getStatus());
        DynamicObjectCollection boCol = serviceHelper.queryOriginalCollection("id", new QFilter[]{boIDFilter, statusFilter});
        Set boIdSet = boCol.stream().map(bo -> bo.getLong("id")).collect(Collectors.toSet());
        resultMap.forEach((boId, idList) -> {
            if (idList.size() > 0) {
                if (boIdSet.contains(boId) && idList.size() > 1) {
                    boIds.add(boId);
                } else if (!boIdSet.contains(boId)) {
                    boIds.add(boId);
                }
            }
        });
        return boIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExcludeFromJacocoGeneratedReport
    public static Date getCurrentVersionEffStartDate(HRBaseServiceHelper serviceHelper, Long boId) {
        QFilter boIDFilter = new QFilter("boid", "=", (Object)boId);
        QFilter isCurrentFilter = new QFilter("iscurrentversion", "=", (Object)Character.valueOf('1'));
        try (DataSet dataSet = null;){
            dataSet = serviceHelper.queryDataSet(HisCommonEntityRepository.class.getName() + ".getCurrentVersionEffStartDate", "bsed", new QFilter[]{boIDFilter, isCurrentFilter});
            if (dataSet.hasNext()) {
                Row row = dataSet.next();
                Date date = row.getDate("bsed");
                return date;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<Long, Date> getEffEndDateByIds(HRBaseServiceHelper serviceHelper, Set<Long> idSet) {
        if (serviceHelper == null) {
            return null;
        }
        HashMap<Long, Date> mapEffEndDate = new HashMap<Long, Date>(idSet.size());
        try (DataSet dataSet = null;){
            dataSet = serviceHelper.queryDataSet(HisCommonEntityRepository.class.getName() + ".getEffEndDate", "id,bsled", new QFilter[]{new QFilter("id", "in", idSet)});
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                Long Id = row.getLong("id");
                Date effEndDate = row.getDate("bsled");
                mapEffEndDate.put(Id, effEndDate);
            }
        }
        return mapEffEndDate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<Long, Date> getEffStartDateByIds(HRBaseServiceHelper serviceHelper, Set<Long> idSet) {
        if (serviceHelper == null || idSet == null || idSet.isEmpty()) {
            return null;
        }
        HashMap<Long, Date> mapEffStartDate = new HashMap<Long, Date>(idSet.size());
        try (DataSet dataSet = null;){
            dataSet = serviceHelper.queryDataSet(HisCommonEntityRepository.class.getName() + ".getEffStartDate", "id,bsed", new QFilter[]{new QFilter("id", "in", idSet), new QFilter("datastatus", "=", (Object)EnumHisDataVersionStatus.TEMP.getStatus())});
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                Long Id = row.getLong("id");
                Date effEndDate = row.getDate("bsed");
                mapEffStartDate.put(Id, effEndDate);
            }
        }
        return mapEffStartDate;
    }
}

