/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.domain.repository;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kingdee.bos.qing.util.MapUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.constants.newhismodel.EventOperateEnums;
import org.apache.commons.collections.CollectionUtils;

public class HisEventEntityRepository {
    public static DynamicObject[] queryBussEventByBoIds(HRBaseServiceHelper serviceHelper, Long[] boIds) {
        return serviceHelper.query("id,event", new QFilter[]{new QFilter("boid", "in", (Object)boIds)});
    }

    public static DynamicObject[] queryBussEventByEventIds(HRBaseServiceHelper serviceHelper, Long[] boIds, Long[] eventIds) {
        return serviceHelper.query("event", new QFilter[]{new QFilter("boid", "not in", (Object)boIds), new QFilter("event", "in", (Object)eventIds)});
    }

    public static void deleteBussEvent(HRBaseServiceHelper serviceHelper, Long[] boIds) {
        serviceHelper.deleteByFilter(new QFilter[]{new QFilter("boid", "in", (Object)boIds)});
    }

    public static void deleteVersionEvent(HRBaseServiceHelper serviceHelper, Long[] bussEventId) {
        serviceHelper.deleteByFilter(new QFilter[]{new QFilter("busievent", "in", (Object)bussEventId)});
    }

    public static void deleteEvent(HRBaseServiceHelper serviceHelper, Long[] eventId) {
        serviceHelper.deleteByFilter(new QFilter[]{new QFilter("id", "in", (Object)eventId)});
    }

    @ExcludeFromJacocoGeneratedReport
    public static boolean existsLaterEvent(HRBaseServiceHelper busiEventHelper, String entityNumber, List<Long> boIds, Date operateDate) {
        if (CollectionUtils.isEmpty(boIds)) {
            return false;
        }
        QFilter[] qFilters = new QFilter[]{new QFilter("sourceentity", "=", (Object)entityNumber), new QFilter("status", "=", (Object)EventOperateEnums.EVENT_STATUS_ALREADY_EXEC.getValue()), new QFilter("canceledeventid", "=", (Object)0L), new QFilter("boid", "in", boIds), new QFilter("operatedate", ">", (Object)operateDate)};
        return busiEventHelper.isExists(qFilters);
    }

    @ExcludeFromJacocoGeneratedReport
    private static QFilter[] getQueryLaterEventQFilter(Map<String, Set<Long>> entityBoIdMap, Date operateDate) {
        if (MapUtils.isEmpty(entityBoIdMap) || operateDate == null) {
            return null;
        }
        ArrayList qFilterList = Lists.newArrayListWithExpectedSize((int)10);
        qFilterList.add(new QFilter("status", "=", (Object)EventOperateEnums.EVENT_STATUS_ALREADY_EXEC.getValue()));
        qFilterList.add(new QFilter("canceledeventid", "=", (Object)0L));
        qFilterList.add(new QFilter("operatedate", ">", (Object)operateDate));
        QFilter qFilterEntityNumberAndBoId = null;
        for (Map.Entry<String, Set<Long>> entry : entityBoIdMap.entrySet()) {
            if (qFilterEntityNumberAndBoId == null) {
                qFilterEntityNumberAndBoId = new QFilter("sourceentity", "=", (Object)entry.getKey()).and(new QFilter("boid", "in", entry.getValue()));
                continue;
            }
            qFilterEntityNumberAndBoId.or(new QFilter("sourceentity", "=", (Object)entry.getKey()).and(new QFilter("boid", "in", entry.getValue())));
        }
        qFilterList.add(qFilterEntityNumberAndBoId);
        return qFilterList.toArray(new QFilter[qFilterList.size()]);
    }

    @ExcludeFromJacocoGeneratedReport
    public static int queryLaterEventCount(HRBaseServiceHelper busiEventHelper, Map<String, Set<Long>> entityBoIdMap, Date operateDate) {
        QFilter[] qFilters = HisEventEntityRepository.getQueryLaterEventQFilter(entityBoIdMap, operateDate);
        if (qFilters == null || qFilters.length == 0) {
            return 0;
        }
        return busiEventHelper.count(busiEventHelper.getEntityName(), qFilters);
    }

    @ExcludeFromJacocoGeneratedReport
    public static DynamicObject[] queryLaterEvent(HRBaseServiceHelper busiEventHelper, Map<String, Set<Long>> entityBoIdMap, Date operateDate) {
        QFilter[] qFilters = HisEventEntityRepository.getQueryLaterEventQFilter(entityBoIdMap, operateDate);
        if (qFilters == null || qFilters.length == 0) {
            return null;
        }
        String queryFields = "id,event,sourceentity,boid,operatedate";
        return busiEventHelper.query(queryFields, qFilters);
    }

    @ExcludeFromJacocoGeneratedReport
    private static QFilter[] queryLaterEventByMultiEventQFilter(HRBaseServiceHelper busiEventHelper, DynamicObject[] dynamicObjectsOther) {
        if (dynamicObjectsOther == null || dynamicObjectsOther.length == 0) {
            return null;
        }
        ArrayList qFilterList = Lists.newArrayListWithExpectedSize((int)10);
        qFilterList.add(new QFilter("status", "=", (Object)EventOperateEnums.EVENT_STATUS_ALREADY_EXEC.getValue()));
        qFilterList.add(new QFilter("canceledeventid", "=", (Object)0L));
        QFilter qFilterEntityNumberAndBoId = null;
        for (DynamicObject dynamicObject : dynamicObjectsOther) {
            Date date;
            Long boId;
            String entityNumber = dynamicObject.getString("sourceentity");
            if (entityNumber == null || (boId = Long.valueOf(dynamicObject.getLong("boid"))) == null || boId == 0L || (date = dynamicObject.getDate("operatedate")) == null) continue;
            if (qFilterEntityNumberAndBoId == null) {
                qFilterEntityNumberAndBoId = new QFilter("sourceentity", "=", (Object)entityNumber).and(new QFilter("boid", "=", (Object)boId)).and(new QFilter("operatedate", ">", (Object)date));
                continue;
            }
            qFilterEntityNumberAndBoId.or(new QFilter("sourceentity", "=", (Object)entityNumber).and(new QFilter("boid", "in", (Object)boId)).and(new QFilter("operatedate", ">", (Object)date)));
        }
        qFilterList.add(qFilterEntityNumberAndBoId);
        return qFilterList.toArray(new QFilter[qFilterList.size()]);
    }

    @ExcludeFromJacocoGeneratedReport
    public static int queryLaterEventByMultiEventCount(HRBaseServiceHelper busiEventHelper, DynamicObject[] dynamicObjectsOther) {
        QFilter[] qFilters = HisEventEntityRepository.queryLaterEventByMultiEventQFilter(busiEventHelper, dynamicObjectsOther);
        if (qFilters == null) {
            return 0;
        }
        return busiEventHelper.count(busiEventHelper.getEntityName(), qFilters);
    }

    @ExcludeFromJacocoGeneratedReport
    public static DynamicObject[] queryLaterEventByMultiEvent(HRBaseServiceHelper busiEventHelper, DynamicObject[] dynamicObjectsOther) {
        QFilter[] qFilters = HisEventEntityRepository.queryLaterEventByMultiEventQFilter(busiEventHelper, dynamicObjectsOther);
        if (qFilters == null) {
            return null;
        }
        String queryFields = "event,sourceentity,boid,operatedate";
        return busiEventHelper.query(queryFields, qFilters);
    }

    @ExcludeFromJacocoGeneratedReport
    public static boolean existsPersonalLaterEvent(HRBaseServiceHelper hisEventHelper, HRBaseServiceHelper busiEventHelper, String entityNumber, List<Long> boIds, Date operateDate) {
        if (CollectionUtils.isEmpty(boIds)) {
            return false;
        }
        QFilter[] qFilters = new QFilter[]{new QFilter("sourceentity", "=", (Object)entityNumber), new QFilter("status", "=", (Object)EventOperateEnums.EVENT_STATUS_ALREADY_EXEC.getValue()), new QFilter("canceledeventid", "=", (Object)0L), new QFilter("boid", "in", boIds), new QFilter("operatedate", ">", (Object)operateDate)};
        DynamicObject[] dynamicObjects = busiEventHelper.query("event", qFilters);
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            return false;
        }
        Set eventIdSet = Arrays.stream(dynamicObjects).map(dy -> dy.getLong("event")).collect(Collectors.toSet());
        QFilter[] qFilters2 = new QFilter[]{new QFilter("id", "in", eventIdSet), new QFilter("eventtype", "!=", (Object)EventOperateEnums.EVENT_TYPE_ORIGIN_ONLY_SINK.getValue())};
        return hisEventHelper.isExists(qFilters2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExcludeFromJacocoGeneratedReport
    public static Set<String> getBusiEventSourceEntites(HRBaseServiceHelper busiEventHelper, Long eventId) {
        QFilter qFilters = new QFilter("event", "=", (Object)eventId).and(new QFilter("status", "=", (Object)EventOperateEnums.EVENT_STATUS_ALREADY_EXEC.getValue()));
        HashSet<String> entityNumberList = null;
        try (DataSet dataSet = null;){
            dataSet = busiEventHelper.queryDataSet(HisEventEntityRepository.class.getName() + ".getBusiEventEntitys", "sourceentity", new QFilter[]{qFilters});
            while (dataSet.hasNext()) {
                String entityNumber;
                Row row = dataSet.next();
                if (entityNumberList == null) {
                    entityNumberList = new HashSet<String>(16);
                }
                if ((entityNumber = (String)row.get("sourceentity")) == null) continue;
                entityNumberList.add(entityNumber);
            }
        }
        return entityNumberList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExcludeFromJacocoGeneratedReport
    public static Map<String, Set<Long>> getBsEventSourceEntityAndBoIds(HRBaseServiceHelper busiEventHelper, Long eventId) {
        QFilter qFilters = new QFilter("event", "=", (Object)eventId).and(new QFilter("status", "=", (Object)EventOperateEnums.EVENT_STATUS_ALREADY_EXEC.getValue()));
        HashMap entityBoIdMap = null;
        try (DataSet dataSet = null;){
            dataSet = busiEventHelper.queryDataSet(HisEventEntityRepository.class.getName() + ".getBsEventSourceEntityAndBoIds", "sourceentity,boid", new QFilter[]{qFilters});
            while (dataSet.hasNext()) {
                Long boId;
                String entityNumber;
                Row row = dataSet.next();
                if (entityBoIdMap == null) {
                    entityBoIdMap = Maps.newHashMapWithExpectedSize((int)16);
                }
                if ((entityNumber = (String)row.get("sourceentity")) == null || (boId = (Long)row.get("boid")) == null || boId == 0L) continue;
                Set boIdSet = (Set)entityBoIdMap.get(entityNumber);
                if (boIdSet == null) {
                    boIdSet = Sets.newHashSetWithExpectedSize((int)16);
                    entityBoIdMap.put(entityNumber, boIdSet);
                }
                boIdSet.add(boId);
            }
        }
        return entityBoIdMap;
    }

    @ExcludeFromJacocoGeneratedReport
    public static int getOtherBsEventSourceEntityAndBoIdsCount(HRBaseServiceHelper busiEventHelper, Set<Long> excludeIdSet, Set<Long> idSet) {
        QFilter qFilters = new QFilter("event", "in", excludeIdSet).and(new QFilter("status", "=", (Object)EventOperateEnums.EVENT_STATUS_ALREADY_EXEC.getValue()).and(new QFilter("id", "not in", idSet)));
        return busiEventHelper.count(busiEventHelper.getEntityName(), new QFilter[]{qFilters});
    }

    @ExcludeFromJacocoGeneratedReport
    public static DynamicObject[] getOtherBsEventSourceEntityAndBoIds(HRBaseServiceHelper busiEventHelper, Set<Long> excludeIdSet, Set<Long> idSet) {
        QFilter qFilters = new QFilter("event", "in", excludeIdSet).and(new QFilter("status", "=", (Object)EventOperateEnums.EVENT_STATUS_ALREADY_EXEC.getValue()).and(new QFilter("id", "not in", idSet)));
        String queryFields = "id,event,sourceentity,boid,operatedate";
        DynamicObject[] dynamicObjects = busiEventHelper.query(queryFields, new QFilter[]{qFilters});
        return dynamicObjects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExcludeFromJacocoGeneratedReport
    public static List<Long> filterPersonalBoIds(HRBaseServiceHelper serviceHelper, List<Long> boIds) {
        if (CollectionUtils.isEmpty(boIds)) {
            return null;
        }
        QFilter[] qFilters = new QFilter[]{new QFilter("iscurrentversion", "=", (Object)Character.valueOf('1')), new QFilter("boid", "in", boIds)};
        ArrayList<Long> boIdList = null;
        try (DataSet dataSet = null;){
            dataSet = serviceHelper.queryDataSet(HisEventEntityRepository.class.getName() + ".filterPersonalBoIds", "boid,masterid", qFilters);
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                if (boIdList == null) {
                    boIdList = new ArrayList<Long>(10);
                }
                Long boId = row.getLong("boid");
                Long masterId = row.getLong("masterid");
                if (boId == null || boId == 0L || masterId == null || masterId == 0L || boId.longValue() == masterId.longValue()) continue;
                boIdList.add(row.getLong("boid"));
            }
        }
        return boIdList;
    }

    public static DynamicObject getEventTableByNumber(String eventGroupNumber) {
        HRBaseServiceHelper hisModelRegHelper = new HRBaseServiceHelper("hrcs_entityevent");
        QFilter qFilters = new QFilter("number", "=", (Object)eventGroupNumber);
        return hisModelRegHelper.queryOne("entity,evententity", qFilters.toArray());
    }

    public static DynamicObject getEventGroupByNumber(String eventGroupNumber) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_evententityreg");
        QFilter qFilters = new QFilter("number", "=", (Object)eventGroupNumber);
        return serviceHelper.queryOne("number,evententity,busevententity,hisevententity", qFilters);
    }
}

