/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.domain.repository;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.domain.model.newhismodel.calc.HisVersionCalcNoInitResult;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.constants.newhismodel.EnumHisDataVersionStatus;
import kd.hr.hbp.common.util.HRStringUtils;

public class HisLineTimeDao {
    private static volatile HisLineTimeDao dao = null;

    private HisLineTimeDao() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HisLineTimeDao getInstance() {
        if (dao != null) return dao;
        Class<HisLineTimeDao> clazz = HisLineTimeDao.class;
        synchronized (HisLineTimeDao.class) {
            if (dao != null) return dao;
            dao = new HisLineTimeDao();
            // ** MonitorExit[var0] (shouldn't be in output)
            return dao;
        }
    }

    public boolean hasTempVersion(String entityId, Object pkId) {
        String isModify;
        HRBaseServiceHelper helper = new HRBaseServiceHelper(entityId);
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "=", pkId)};
        try (DataSet dataSet = helper.queryDataSet(HisLineTimeDao.class.getName() + ".hasTempVersion", "ismodify", qFilters);){
            isModify = dataSet.next().getString("ismodify");
        }
        return HRStringUtils.equals((String)isModify, (String)"true");
    }

    public DynamicObjectCollection queryAllTempVersions(String entityId, Object pkId) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper(entityId);
        QFilter[] qFilters = new QFilter[]{new QFilter("boid", "=", pkId), new QFilter("datastatus", "=", (Object)EnumHisDataVersionStatus.TEMP.getStatus())};
        return helper.queryOriginalCollection("id, name, number, modifier, modifytime", qFilters);
    }

    @ExcludeFromJacocoGeneratedReport
    public Map<Object, String> queryEnables(String entityId, Set<Object> pkIds) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper(entityId);
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "in", pkIds)};
        HashMap enableMap = Maps.newHashMapWithExpectedSize((int)pkIds.size());
        try (DataSet dataSet = helper.queryDataSet(HisLineTimeDao.class.getName() + ".queryAllTempVersions", "id, enable", qFilters);){
            for (Row row : dataSet) {
                Object pk = row.get("id");
                String enable = row.getString("enable");
                enableMap.put(pk, enable);
            }
        }
        return enableMap;
    }

    public Object queryCurrentDataIsSysPreset(String entityId, Object boId) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper(entityId);
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "=", boId)};
        DynamicObject dy = helper.queryOriginalOne("issyspreset", qFilters);
        return dy.get("issyspreset");
    }

    public HisVersionCalcNoInitResult getNotInitStatus(String entityNumber, Object boId) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper(entityNumber);
        QFilter qFilterInitVersion = new QFilter("iscurrentversion", "=", (Object)Character.valueOf('0')).and(new QFilter("initstatus", "in", Arrays.asList("0", "1")));
        QFilter qFilterCurrentVersion = new QFilter("iscurrentversion", "=", (Object)Character.valueOf('1'));
        QFilter qFilterBoId = new QFilter("boid", "=", boId);
        QFilter qFilterAll = qFilterBoId.and(qFilterInitVersion.or(qFilterCurrentVersion));
        QFilter[] qFilters = new QFilter[]{qFilterAll};
        HashSet resultList = Sets.newHashSetWithExpectedSize((int)2);
        Date firstEffDate = null;
        try (DataSet dataSet = helper.queryDataSet(HisLineTimeDao.class.getName() + ".getNotInitStatus", "initstatus,iscurrentversion,firstbsed", qFilters);){
            for (Row row : dataSet) {
                Boolean isCurrentVersion = row.getBoolean("iscurrentversion");
                if (isCurrentVersion.booleanValue() && firstEffDate == null) {
                    firstEffDate = row.getDate("firstbsed");
                    continue;
                }
                String initstatus = row.getString("initstatus");
                if (!"0".equals(initstatus) && !"1".equals(initstatus)) continue;
                resultList.add(initstatus);
            }
        }
        if (firstEffDate == null) {
            return null;
        }
        HisVersionCalcNoInitResult hisVersionCalcNoInitResult = new HisVersionCalcNoInitResult();
        hisVersionCalcNoInitResult.setSetResult(resultList);
        hisVersionCalcNoInitResult.setFirstEffDate(firstEffDate);
        return hisVersionCalcNoInitResult;
    }
}

