/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.domain.repository;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.hbp.business.domain.repository.HisCommonEntityRepository;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisCommonService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.constants.newhismodel.EnumHisDataVersionStatus;
import kd.hr.hbp.common.constants.newhismodel.EnumHisVersionSource;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import org.apache.commons.collections.CollectionUtils;

public class HisPersonalDataRepository {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<Long, Long> getMasterIdBoIds(HRBaseServiceHelper serviceHelper, Set<Long> boIds) {
        QFilter boIDFilter = new QFilter("boid", "in", boIds);
        QFilter isCurrentFilter = new QFilter("iscurrentversion", "=", (Object)Character.valueOf('1'));
        HashMap<Long, Long> mapBoIdAndMasterId = new HashMap<Long, Long>(16);
        try (DataSet dataSet = null;){
            dataSet = serviceHelper.queryDataSet(HisPersonalDataRepository.class.getName() + ".getPersonalBoIdByBoIds", "boid,masterid", new QFilter[]{boIDFilter, isCurrentFilter});
            if (dataSet != null) {
                while (dataSet.hasNext()) {
                    Row row = dataSet.next();
                    Long boId = row.getLong("boid");
                    Long masterId = row.getLong("masterid");
                    mapBoIdAndMasterId.put(boId, masterId);
                }
            }
        }
        return mapBoIdAndMasterId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExcludeFromJacocoGeneratedReport
    public static Map<Long, Long> getCurrentBoIdsByMasterId(HRBaseServiceHelper serviceHelper, Set<Long> masterIds) {
        QFilter boIDFilter = new QFilter("boid", "not in", masterIds);
        QFilter masterIdFilter = new QFilter("masterid", "in", masterIds);
        QFilter isCurrentFilter = new QFilter("iscurrentversion", "=", (Object)Character.valueOf('1'));
        HashMap<Long, Long> mapBoIdAndMasterId = new HashMap<Long, Long>(16);
        try (DataSet dataSet = null;){
            dataSet = serviceHelper.queryDataSet(HisPersonalDataRepository.class.getName() + ".getCurrentBoIdsByMasterId", "masterid,boid", new QFilter[]{boIDFilter, masterIdFilter, isCurrentFilter});
            if (dataSet != null) {
                while (dataSet.hasNext()) {
                    Row row = dataSet.next();
                    Long boId = row.getLong("boid");
                    Long masterId = row.getLong("masterid");
                    if (boId == null || boId == 0L || masterId == null || masterId == 0L) continue;
                    mapBoIdAndMasterId.put(boId, masterId);
                }
            }
        }
        return mapBoIdAndMasterId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Long> getBoIdListByMasterId(HRBaseServiceHelper serviceHelper, List<Long> masterIds) {
        QFilter boIDFilter = new QFilter("boid", "not in", masterIds);
        QFilter masterIdFilter = new QFilter("masterid", "in", masterIds);
        QFilter isCurrentFilter = new QFilter("iscurrentversion", "=", (Object)Character.valueOf('1'));
        ArrayList<Long> setBoIdAndMasterId = new ArrayList<Long>(16);
        try (DataSet dataSet = null;){
            dataSet = serviceHelper.queryDataSet(HisPersonalDataRepository.class.getName() + ".getCurrentBoIdsByMasterId", "boid", new QFilter[]{boIDFilter, masterIdFilter, isCurrentFilter});
            if (dataSet != null) {
                while (dataSet.hasNext()) {
                    Row row = dataSet.next();
                    Long boId = row.getLong("boid");
                    if (boId == null || boId == 0L) continue;
                    setBoIdAndMasterId.add(boId);
                }
            }
        }
        return setBoIdAndMasterId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExcludeFromJacocoGeneratedReport
    public static Map<Long, Long> getCurrentMasterIdsByBoIds(HRBaseServiceHelper serviceHelper, Set<Long> boIdSet) {
        QFilter boIDFilter = new QFilter("id", "in", boIdSet);
        HashMap<Long, Long> mapBoIdAndMasterId = new HashMap<Long, Long>(16);
        try (DataSet dataSet = null;){
            dataSet = serviceHelper.queryDataSet(HisPersonalDataRepository.class.getName() + ".getCurrentBoIdsByMasterId", "masterid,boid", new QFilter[]{boIDFilter});
            if (dataSet != null) {
                while (dataSet.hasNext()) {
                    Row row = dataSet.next();
                    Long boId = row.getLong("boid");
                    Long masterId = row.getLong("masterid");
                    if (boId == null || boId == 0L || masterId == null || masterId == 0L) continue;
                    mapBoIdAndMasterId.put(masterId, boId);
                }
            }
        }
        return mapBoIdAndMasterId;
    }

    @ExcludeFromJacocoGeneratedReport
    public static DynamicObject[] loadSinkPersonalEffVersionByBoIds(HRBaseServiceHelper serviceHelper, Set<Long> boIds, boolean needSyncData) {
        if (serviceHelper == null) {
            return new DynamicObject[0];
        }
        String entityNumber = serviceHelper.getEntityName();
        if (StringUtils.isEmpty((CharSequence)entityNumber)) {
            return new DynamicObject[0];
        }
        QFilter boIDFilter = new QFilter("boid", "in", boIds);
        QFilter isCurrentFilter = new QFilter("iscurrentversion", "=", (Object)Character.valueOf('0'));
        QFilter statusFilter = new QFilter("datastatus", "in", Arrays.asList(EnumHisDataVersionStatus.TO_BE_EFFECT.getStatus(), EnumHisDataVersionStatus.EFFECTING.getStatus(), EnumHisDataVersionStatus.INVALIDED.getStatus()));
        boolean hasInitStatus = HisCommonService.getInstance().hasInitStatusFiled(null, serviceHelper.getEntityName());
        QFilter qFilterInitComplete = null;
        if (hasInitStatus) {
            qFilterInitComplete = new QFilter("initstatus", "not in", Arrays.asList("0", "1"));
        }
        if (needSyncData) {
            if (hasInitStatus && qFilterInitComplete != null) {
                return serviceHelper.loadDynamicObjectArray(new QFilter[]{boIDFilter, isCurrentFilter, statusFilter, qFilterInitComplete});
            }
            return serviceHelper.loadDynamicObjectArray(new QFilter[]{boIDFilter, isCurrentFilter, statusFilter});
        }
        QFilter onlySinkDataFilter = new QFilter("versionsource", "=", (Object)EnumHisVersionSource.ORIGIN_DATA_SINK.getType());
        if (hasInitStatus && qFilterInitComplete != null) {
            return serviceHelper.loadDynamicObjectArray(new QFilter[]{boIDFilter, isCurrentFilter, statusFilter, onlySinkDataFilter, qFilterInitComplete});
        }
        return serviceHelper.loadDynamicObjectArray(new QFilter[]{boIDFilter, isCurrentFilter, statusFilter, onlySinkDataFilter});
    }

    @ExcludeFromJacocoGeneratedReport
    public static DynamicObject[] loadNoSinkPersonalEffVersionByBoIds(HRBaseServiceHelper serviceHelper, Set<Long> boIds) {
        if (serviceHelper == null) {
            return new DynamicObject[0];
        }
        QFilter boIDFilter = new QFilter("boid", "in", boIds);
        QFilter isCurrentFilter = new QFilter("iscurrentversion", "=", (Object)Character.valueOf('0'));
        QFilter statusFilter = new QFilter("datastatus", "in", Arrays.asList(EnumHisDataVersionStatus.TO_BE_EFFECT.getStatus(), EnumHisDataVersionStatus.EFFECTING.getStatus(), EnumHisDataVersionStatus.INVALIDED.getStatus()));
        QFilter onlySinkDataFilter = new QFilter("versionsource", "!=", (Object)EnumHisVersionSource.ORIGIN_DATA_SINK.getType());
        return serviceHelper.loadDynamicObjectArray(new QFilter[]{boIDFilter, isCurrentFilter, statusFilter, onlySinkDataFilter});
    }

    @ExcludeFromJacocoGeneratedReport
    public static Long getOrgParentId(long orgId, String treeType) {
        QFilter fTreetype = new QFilter("view.number", "=", (Object)treeType);
        QFilter fOrg = new QFilter("org", "=", (Object)orgId);
        QFilter[] qFilters = new QFilter[]{fTreetype, fOrg};
        DynamicObject[] dosAlls = BusinessDataServiceHelper.load((String)"bos_org_structure", (String)"id,parent,parent.id,patent.name", (QFilter[])qFilters);
        if (dosAlls != null && dosAlls.length > 0) {
            DynamicObject obj = dosAlls[0];
            return obj.getLong("parent.id");
        }
        return null;
    }

    @ExcludeFromJacocoGeneratedReport
    public static Long getView(String entityNumber) {
        QFilter qFilter = new QFilter("basedataid_id", "=", (Object)entityNumber);
        QFilter[] qFilters = new QFilter[]{qFilter};
        DynamicObject[] dosAlls = BusinessDataServiceHelper.load((String)"bd_bddefctrlstrtgy", (String)"ctrlview_id", (QFilter[])qFilters);
        if (dosAlls != null && dosAlls.length > 0) {
            DynamicObject obj = dosAlls[0];
            return obj.getLong("ctrlview_id");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExcludeFromJacocoGeneratedReport
    public static Long getParentUseDataId(String entityNumber, Long orgId, Long masterId) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        if (dataEntityType == null) {
            return masterId;
        }
        String dbRouteKey = dataEntityType.getDBRouteKey();
        if (HRStringUtils.isEmpty((String)dbRouteKey)) {
            return masterId;
        }
        String table_u = dataEntityType.getAlias() + "_U";
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT fdataid from ");
        sql.append(table_u);
        sql.append(" WHERE fuseorgid = ? and fdataid in (SELECT fid from ");
        sql.append(dataEntityType.getAlias());
        sql.append(" WHERE fmasterid = ? )");
        ArrayList<Long> paramList = new ArrayList<Long>(1);
        paramList.add(orgId);
        paramList.add(masterId);
        try (DataSet dataSet = null;){
            dataSet = HRDBUtil.queryDataSet((String)"HisPersonalDataRepository.getParentUseDataId", (DBRoute)new DBRoute(dbRouteKey), (String)sql.toString(), (Object[])paramList.toArray(new Object[]{paramList.size()}));
            if (dataSet.hasNext()) {
                Row row = dataSet.next();
                Long l = row.getLong("fdataid");
                return l;
            }
        }
        return masterId;
    }

    @ExcludeFromJacocoGeneratedReport
    public static int updateUseDataId(String entityNumber, long orgId, Long oldDataId, Long newDataId) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        if (dataEntityType == null) {
            return 0;
        }
        String dbRouteKey = dataEntityType.getDBRouteKey();
        if (HRStringUtils.isEmpty((String)dbRouteKey)) {
            return 0;
        }
        String table_u = dataEntityType.getAlias() + "_U";
        StringBuilder sql = new StringBuilder();
        sql.append("update ");
        sql.append(table_u);
        sql.append(" set fdataid = ?  ");
        sql.append(" WHERE fuseorgid = ? and fdataid = ?");
        ArrayList<Long> paramList = new ArrayList<Long>(1);
        paramList.add(newDataId);
        paramList.add(orgId);
        paramList.add(oldDataId);
        int size = HRDBUtil.update((DBRoute)new DBRoute(dbRouteKey), (String)sql.toString(), (Object[])paramList.toArray(new Object[]{paramList.size()}));
        return size;
    }

    public static boolean exitsOriginSyncData(HRBaseServiceHelper helper, Long boId) {
        QFilter boIDFilter = new QFilter("boid", "=", (Object)boId);
        QFilter statusFilter = new QFilter("datastatus", "in", Arrays.asList(EnumHisDataVersionStatus.TO_BE_EFFECT.getStatus(), EnumHisDataVersionStatus.EFFECTING.getStatus(), EnumHisDataVersionStatus.INVALIDED.getStatus()));
        QFilter versionSourceFilter = new QFilter("versionsource", "in", Arrays.asList(EnumHisVersionSource.ORIGIN_DATA_SYNC.getType(), EnumHisVersionSource.ORIGIN_DATA_SINK.getType()));
        return helper.isExists(new QFilter[]{boIDFilter, statusFilter, versionSourceFilter});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExcludeFromJacocoGeneratedReport
    public static Map<Long, Date> batchQueryPersonalDate(HRBaseServiceHelper serviceHelper, List<Long> boIdSet) {
        HashMap mapBoIdPersonalDate = null;
        if (serviceHelper == null || CollectionUtils.isEmpty(boIdSet)) {
            return null;
        }
        QFilter[] qFilters = new QFilter[]{new QFilter("boid", "in", boIdSet), new QFilter("iscurrentversion", "=", (Object)Character.valueOf('0')), new QFilter("versionsource", "!=", (Object)EnumHisVersionSource.ORIGIN_DATA_SINK.getType()), new QFilter("datastatus", "in", Arrays.asList(EnumHisDataVersionStatus.TO_BE_EFFECT.getStatus(), EnumHisDataVersionStatus.EFFECTING.getStatus(), EnumHisDataVersionStatus.INVALIDED.getStatus()))};
        try (DataSet dataSet = null;){
            dataSet = serviceHelper.queryDataSet(HisCommonEntityRepository.class.getName() + ".batchQueryPersonalDate", "boid,bsed", qFilters).groupBy(new String[]{"boid"}).min("bsed").finish();
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                if (mapBoIdPersonalDate == null) {
                    mapBoIdPersonalDate = Maps.newHashMapWithExpectedSize((int)boIdSet.size());
                }
                Long boId = row.getLong("boid");
                Date personalDate = row.getDate("bsed");
                if (boId == null || boId == 0L || personalDate == null) continue;
                mapBoIdPersonalDate.put(boId, personalDate);
            }
        }
        return mapBoIdPersonalDate;
    }
}

