/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.domain.repository;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.constants.newhismodel.EnumHisDataVersionStatus;
import kd.hr.hbp.common.util.HRDateTimeUtils;

public class HisSyncDataStatusRepository {
    private static volatile HisSyncDataStatusRepository hisSyncDataStatusRepository = null;
    private static final Log LOGGER = LogFactory.getLog(HisSyncDataStatusRepository.class);

    private HisSyncDataStatusRepository() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HisSyncDataStatusRepository getInstance() {
        if (hisSyncDataStatusRepository != null) return hisSyncDataStatusRepository;
        Class<HisSyncDataStatusRepository> clazz = HisSyncDataStatusRepository.class;
        synchronized (HisSyncDataStatusRepository.class) {
            if (hisSyncDataStatusRepository != null) return hisSyncDataStatusRepository;
            hisSyncDataStatusRepository = new HisSyncDataStatusRepository();
            // ** MonitorExit[var0] (shouldn't be in output)
            return hisSyncDataStatusRepository;
        }
    }

    @ExcludeFromJacocoGeneratedReport
    public List<Long> getNeedSyncVersion(HRBaseServiceHelper serviceHelper) {
        QFilter qf = this.getQFilter();
        HashSet<Long> setNeedSyncBoId = new HashSet<Long>(16);
        try (DataSet dataSet = this.getDataSet(serviceHelper, qf, "boid");){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                setNeedSyncBoId.add(row.getLong("boid"));
            }
        }
        if (setNeedSyncBoId.size() == 0) {
            return new ArrayList<Long>();
        }
        return new ArrayList<Long>(setNeedSyncBoId);
    }

    @ExcludeFromJacocoGeneratedReport
    public DataSet getNeedSyncVersionDataSet(HRBaseServiceHelper serviceHelper) {
        QFilter qf = this.getQFilter();
        return this.getDataSet(serviceHelper, qf, "boid");
    }

    public Map<Long, List<Map<String, Object>>> getJoinEntityStatus(DataSet dataSet, DataSet joinDataSet, Map<String, Set<String>> conditionMap, boolean isVersion) {
        HashMap<Long, List<Map<String, Object>>> joinEntityStatus = new HashMap<Long, List<Map<String, Object>>>(16);
        JoinDataSet join = dataSet.join(joinDataSet);
        conditionMap.forEach((key, value) -> {
            for (String rightProp : value) {
                join.on(key, rightProp);
            }
        });
        if (isVersion) {
            join.select(new String[]{"id", "boid", "datastatus", "hisversion"});
        } else {
            join.select(new String[]{"id", "boid", "datastatus"});
        }
        DataSet finish = join.finish();
        while (finish.hasNext()) {
            Row row = finish.next();
            HashMap statusMap = Maps.newHashMapWithExpectedSize((int)16);
            statusMap.put("datastatus", row.getString("datastatus"));
            if (isVersion) {
                statusMap.put("hisversion", row.getString("hisversion"));
            }
            statusMap.put("id", row.getLong("id"));
            Long boId = row.getLong("boid");
            List<Map<String, Object>> rowList = joinEntityStatus.getOrDefault(boId, Lists.newArrayListWithExpectedSize((int)10));
            rowList.add(statusMap);
            joinEntityStatus.put(boId, rowList);
        }
        return joinEntityStatus;
    }

    @ExcludeFromJacocoGeneratedReport
    public DynamicObject[] getEntityMata(HRBaseServiceHelper metaHelper, List<String> appIds, QFilter parentFilter) {
        DynamicObject parentMeta = metaHelper.queryOne(new QFilter[]{parentFilter});
        String parentId = parentMeta.getString("id");
        QFilter sonFilter = new QFilter("inheritPath", "like", (Object)("%" + parentId + "%"));
        sonFilter.and(new QFilter("bizapp", "in", appIds));
        sonFilter.and(new QFilter("modeltype", "=", (Object)"BaseFormModel"));
        return metaHelper.query(new QFilter[]{sonFilter});
    }

    @ExcludeFromJacocoGeneratedReport
    private QFilter getQFilter() {
        Date now = HRDateTimeUtils.getNowDateTime();
        QFilter qf = new QFilter("iscurrentversion", "=", (Object)"0");
        QFilter beEffect = new QFilter("bsed", "<", (Object)now).and(new QFilter("datastatus", "=", (Object)EnumHisDataVersionStatus.TO_BE_EFFECT.getStatus()));
        QFilter planBeEffect = new QFilter("changebsed", "<", (Object)now).and(new QFilter("datastatus", "=", (Object)EnumHisDataVersionStatus.TO_BE_EFFECT.getStatus()));
        QFilter qFilter = beEffect.or(planBeEffect);
        qf.and(qFilter);
        return qf;
    }

    public DataSet getDataSet(HRBaseServiceHelper serviceHelper, QFilter qf, String selectFields) {
        QFilter[] qFilterArray;
        if (qf == null) {
            qFilterArray = new QFilter[]{};
        } else {
            QFilter[] qFilterArray2 = new QFilter[1];
            qFilterArray = qFilterArray2;
            qFilterArray2[0] = qf;
        }
        QFilter[] qFilters = qFilterArray;
        DataSet dataSet = serviceHelper.queryDataSet(HisSyncDataStatusRepository.class.getName() + ".getNeedSyncVersion", selectFields, qFilters, null);
        LOGGER.info("queryDyns:entityNumber\uff1a{}\uff0cqf\uff1a{}", (Object)serviceHelper.getEntityName(), (Object)qf);
        return dataSet;
    }

    public DataSet getJoinDataSet(HRBaseServiceHelper serviceHelper, String selectFields) {
        DataSet dataSet = serviceHelper.queryDataSet(HisSyncDataStatusRepository.class.getName() + ".getNeedSyncVersion2", selectFields, null, null);
        LOGGER.info("getJoinDataSet:entityNumber\uff1a{}", (Object)serviceHelper.getEntityName());
        return dataSet;
    }
}

