/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.domain.service.attachment;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.hr.hbp.business.domain.model.newhismodel.HisResponse;
import kd.hr.hbp.business.domain.model.newhismodel.api.attachment.HisAttachmentDataBo;
import kd.hr.hbp.business.domain.model.newhismodel.api.attachment.HisAttachmentParamBo;
import kd.hr.hbp.business.domain.model.newhismodel.attachment.HisAttachmentSourceIdBo;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.model.hismodel.HisAttachmentBo;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;

public class HisAttachmentService {
    private static final Log LOGGER = LogFactory.getLog(HisAttachmentService.class);

    public static void saveHisLineAttachmentsForOp(DynamicObject dy, OperateOption option) {
        String attachmentInfoStr = option.getVariableValue("opHisTempAttachments", null);
        if (HRStringUtils.isEmpty((String)attachmentInfoStr)) {
            return;
        }
        Map attachmentInfo = (Map)SerializationUtils.fromJsonString((String)attachmentInfoStr, Map.class);
        attachmentInfo.forEach((attachmentpanel, attachmentInfos) -> {
            List list = (List)attachmentInfos;
            for (Map mapData : list) {
                String relativeUrl = (String)mapData.get("relativeUrl");
                String url = (String)mapData.get("url");
                if (StringUtils.isEmpty((Object)relativeUrl) || StringUtils.isEmpty((Object)url) || relativeUrl.equals(url)) continue;
                mapData.put("url", relativeUrl);
            }
        });
        String formId = dy.getDataEntityType().getName();
        String appId = EntityMetadataCache.getDataEntityType((String)formId).getAppId();
        AttachmentServiceHelper.saveTempAttachments((String)dy.getDataEntityType().getName(), (Object)dy.getPkValue(), (String)appId, (Map)attachmentInfo);
        attachmentInfo.forEach((attachmentpanel, attachmentInfos) -> AttachmentServiceHelper.upload((String)formId, (Object)dy.get("id"), (String)attachmentpanel, (List)((List)attachmentInfos)));
        HisAttachmentService.getAttachmentsInfo(new DynamicObject[]{dy}, option);
    }

    public static void getAttachmentsInfo(DynamicObject[] dataCol, OperateOption option) {
        if (option.containsVariable("importtype")) {
            return;
        }
        if (dataCol == null || dataCol.length == 0) {
            return;
        }
        String entityNumber = dataCol[0].getDataEntityType().getName();
        List<Map<String, Object>> attachMapList = HisAttachmentService.generateAttachmentMap(dataCol);
        if (attachMapList == null) {
            return;
        }
        Map<String, HisAttachmentBo> hisAttachBoMap = HisAttachmentService.transAttachmentsInfo(attachMapList, entityNumber);
        List uids = attachMapList.stream().map(eachMap -> eachMap.get("uid").toString()).collect(Collectors.toList());
        String changePageAttachStr = option.getVariableValue("opHisAttachments", null);
        if (HRStringUtils.isNotEmpty((String)changePageAttachStr)) {
            long id = dataCol[0].getLong("id");
            Map changePageAttachMap = (Map)SerializationUtils.fromJsonString((String)changePageAttachStr, Map.class);
            changePageAttachMap.forEach((attachKey, attach) -> {
                ArrayList newAttach = Lists.newArrayListWithCapacity((int)16);
                attach.forEach(attachMap -> {
                    String uid = attachMap.get("uid").toString();
                    if (!uids.contains(uid)) {
                        newAttach.add(attachMap);
                    }
                });
                if (newAttach.size() > 0) {
                    HisAttachmentService.generateAttachmentBo(attachKey, entityNumber, id, newAttach, hisAttachBoMap);
                }
            });
        }
        Map<Long, List<HisAttachmentBo>> boMap = hisAttachBoMap.values().stream().collect(Collectors.groupingBy(HisAttachmentBo::getId));
        if (!hisAttachBoMap.isEmpty()) {
            option.setVariableValue("opHisAttachments", SerializationUtils.toJsonString(boMap));
        }
    }

    public static Map<String, HisAttachmentBo> transAttachmentsInfo(List<Map<String, Object>> attachMapList, String entityNUmber) {
        Map<String, List<Map>> attachMap = attachMapList.stream().collect(Collectors.groupingBy(attach -> attach.get("fattachmentpanel") + "-" + attach.get("pk")));
        HashMap hisAttachBoMap = Maps.newHashMapWithExpectedSize((int)16);
        attachMap.forEach((attachKey, attach) -> HisAttachmentService.generateAttachmentBo(attachKey, entityNUmber, Long.parseLong((String)((Map)attach.get(0)).get("pk")), attach, hisAttachBoMap));
        return hisAttachBoMap;
    }

    public static HisResponse<HisAttachmentDataBo> generateAttachmentMap(HisAttachmentParamBo hisAttachmentParamBo) {
        Set<Long> idSet = hisAttachmentParamBo.getIdSet();
        String entityNumber = hisAttachmentParamBo.getEntityNumber();
        if (CollectionUtils.isEmpty(idSet) || StringUtils.isEmpty((Object)entityNumber)) {
            return null;
        }
        List<Map<String, Object>> attachMapList = HisAttachmentService.generateAttachmentMapByIdString(idSet, entityNumber);
        HashMap mapHisAttachmentBos = Maps.newHashMapWithExpectedSize((int)16);
        for (Long id : idSet) {
            List<HisAttachmentBo> hisAttachmentBoList = HisAttachmentService.transAttachmentsInfoToList(attachMapList, entityNumber, String.valueOf(id));
            mapHisAttachmentBos.put(id, hisAttachmentBoList);
        }
        HisResponse<HisAttachmentDataBo> hisResponse = new HisResponse<HisAttachmentDataBo>();
        HisAttachmentDataBo hisAttachmentDataBo = new HisAttachmentDataBo();
        hisAttachmentDataBo.setEntityNumber(entityNumber);
        hisAttachmentDataBo.setMapHisAttachmentBos(mapHisAttachmentBos);
        hisResponse.setData(hisAttachmentDataBo);
        return hisResponse;
    }

    public static List<HisAttachmentBo> transAttachmentsInfoToList(List<Map<String, Object>> attachMapList, String entityNUmber, String strSourceId) {
        Map<String, HisAttachmentBo> hisAttachmentBoMap = HisAttachmentService.transAttachmentsInfo(attachMapList, entityNUmber);
        if (MapUtils.isEmpty(hisAttachmentBoMap)) {
            return Collections.emptyList();
        }
        ArrayList<HisAttachmentBo> hisAttachmentBoList = new ArrayList<HisAttachmentBo>(8);
        for (Map.Entry<String, HisAttachmentBo> entry : hisAttachmentBoMap.entrySet()) {
            if (!StringUtils.endsWithIgnoreCase((String)entry.getKey(), (String)strSourceId)) continue;
            hisAttachmentBoList.add(entry.getValue());
        }
        return hisAttachmentBoList;
    }

    public static void generateAttachmentBo(String attachKey, String formId, Long pkId, List<Map<String, Object>> attach, Map<String, HisAttachmentBo> hisAttachBoMap) {
        HisAttachmentBo hisAttachmentBo = hisAttachBoMap.get(attachKey);
        if (hisAttachmentBo == null) {
            hisAttachmentBo = new HisAttachmentBo();
            hisAttachmentBo.setAttachKey(attachKey.contains("-") ? attachKey.split("-")[0] : attachKey);
            hisAttachmentBo.setId(pkId);
            hisAttachmentBo.setEntityNumber(formId);
            hisAttachmentBo.setAttachments(attach);
        } else {
            hisAttachmentBo.getAttachments().addAll(attach);
        }
        hisAttachBoMap.putIfAbsent(attachKey, hisAttachmentBo);
    }

    public static List<Map<String, Object>> generateAttachmentMap(DynamicObject[] dataCol) {
        HashSet dataIds = Sets.newHashSetWithExpectedSize((int)16);
        for (DynamicObject dynamicObject : dataCol) {
            if (Objects.isNull(dynamicObject) || Objects.isNull(dynamicObject.getPkValue())) continue;
            dataIds.add(dynamicObject.getPkValue().toString());
        }
        return HisAttachmentService.generateAttachmentMapById(dataIds, dataCol[0].getDataEntityType().getName());
    }

    public static List<Map<String, Object>> generateAttachmentMapByIdString(Set<Long> dataIds, String entityNumber) {
        HashSet setIds = Sets.newHashSetWithExpectedSize((int)dataIds.size());
        for (Long id : dataIds) {
            if (id == null || id == 0L) continue;
            setIds.add(String.valueOf(id));
        }
        return HisAttachmentService.generateAttachmentMapById(setIds, entityNumber);
    }

    private static DynamicObject[] queryAttachmentByIds(Set<Object> dataIds, String entityNumber) {
        QFilter[] filters = new QFilter[]{new QFilter("FInterID", "in", dataIds), new QFilter("FBillType", "=", (Object)entityNumber)};
        HRBaseServiceHelper helper = new HRBaseServiceHelper("bos_attachment");
        String fieldStr = "id, FNUMBER, FInterID, FFileId, fcreatetime, FCREATEMEN, fattachmentpanel, FModifyTime, FAttachmentName, FATTACHMENTSIZE, FEXTNAME, fdescription";
        return helper.query(fieldStr, filters, "FNUMBER ASC");
    }

    public static List<Map<String, Object>> generateAttachmentMapById(Set<Object> dataIds, String entityNumber) {
        DynamicObject[] dynColl = HisAttachmentService.queryAttachmentByIds(dataIds, entityNumber);
        ArrayList<Map<String, Object>> data = new ArrayList<Map<String, Object>>(10);
        for (DynamicObject obj : dynColl) {
            DynamicObject creator;
            HashMap<String, Object> map = new HashMap<String, Object>(16);
            map.put("name", obj.get("FAttachmentName"));
            map.put("size", Long.parseLong((String)obj.get("FATTACHMENTSIZE")));
            map.put("uid", obj.get("FNUMBER"));
            map.put("url", obj.get("FFileId"));
            map.put("type", obj.get("FEXTNAME"));
            map.put("description", obj.get("fdescription"));
            map.put("status", "success");
            map.put("fattachmentpanel", obj.get("fattachmentpanel"));
            map.put("pk", obj.get("FInterID"));
            Timestamp createdate = (Timestamp)obj.get("fcreatetime");
            if (createdate != null) {
                map.put("createdate", createdate.getTime());
            }
            if ((creator = (DynamicObject)obj.get("FCREATEMEN")) != null) {
                map.put("creator", creator.get(((BasedataEntityType)creator.getDataEntityType()).getNameProperty()));
            }
            data.add(map);
        }
        return data;
    }

    public static Map<String, List<Map<String, Object>>> generateAttachmentListMapById(Set<Object> dataIds, String entityNumber) {
        DynamicObject[] dynColl = HisAttachmentService.queryAttachmentByIds(dataIds, entityNumber);
        HashMap<String, List<Map<String, Object>>> resultMap = new HashMap<String, List<Map<String, Object>>>(16);
        for (DynamicObject obj : dynColl) {
            DynamicObject creator;
            String interId = obj.getString("FInterID");
            ArrayList data = (ArrayList)resultMap.get(interId);
            if (CollectionUtils.isEmpty((Collection)data)) {
                data = new ArrayList(10);
                resultMap.put(interId, data);
            }
            HashMap<String, Object> map = new HashMap<String, Object>(16);
            map.put("name", obj.get("FAttachmentName"));
            map.put("size", Long.parseLong((String)obj.get("FATTACHMENTSIZE")));
            map.put("uid", obj.get("FNUMBER"));
            map.put("url", obj.get("FFileId"));
            map.put("type", obj.get("FEXTNAME"));
            map.put("description", obj.get("fdescription"));
            map.put("status", "success");
            map.put("fattachmentpanel", obj.get("fattachmentpanel"));
            map.put("pk", obj.get("FInterID"));
            Timestamp createdate = (Timestamp)obj.get("fcreatetime");
            if (createdate != null) {
                map.put("createdate", createdate.getTime());
            }
            if ((creator = (DynamicObject)obj.get("FCREATEMEN")) != null) {
                map.put("creator", creator.get(((BasedataEntityType)creator.getDataEntityType()).getNameProperty()));
            }
            data.add(map);
        }
        return resultMap;
    }

    public static void saveTempAttachments(DynamicObject dy, OperateOption option) {
        HisAttachmentService.saveTempAttachments(dy, option, false);
    }

    public static void saveTempAttachments(DynamicObject dy, OperateOption option, boolean remove) {
        String attachmentInfoStr = option.getVariableValue("opHisTempAttachments", null);
        if (HRStringUtils.isEmpty((String)attachmentInfoStr)) {
            return;
        }
        Map attachmentInfo = (Map)SerializationUtils.fromJsonString((String)attachmentInfoStr, Map.class);
        String formId = dy.getDataEntityType().getName();
        String appId = EntityMetadataCache.getDataEntityType((String)formId).getAppId();
        if (remove) {
            attachmentInfo.forEach((attachmentpanel, attachmentInfos) -> {
                List oldAttachments = AttachmentServiceHelper.getAttachments((String)formId, (Object)dy.getPkValue(), (String)attachmentpanel);
                oldAttachments.forEach(attachmentMaps -> oldAttachments.forEach(oldAttachment -> AttachmentServiceHelper.remove((String)formId, (Object)dy.getPkValue(), oldAttachment.get("uid"))));
            });
        }
        HisAttachmentService.setSize(attachmentInfo);
        HashMap changePageAttachMap = Maps.newHashMapWithExpectedSize((int)16);
        attachmentInfo.forEach((attachKey, obj) -> {
            List attachMapList = (List)obj;
            attachMapList.forEach(attachMap -> {
                String url = (String)attachMap.get("url");
                if (HRStringUtils.isNotEmpty((String)url) && !url.contains("tempfile/download.do?configKey")) {
                    List attachList = changePageAttachMap.getOrDefault(attachKey, new ArrayList(10));
                    attachList.add(attachMap);
                    changePageAttachMap.putIfAbsent(attachKey, attachList);
                }
            });
        });
        AttachmentServiceHelper.saveTempAttachments((String)dy.getDataEntityType().getName(), (Object)dy.getPkValue(), (String)appId, (Map)attachmentInfo);
        option.setVariableValue("opHisAttachments", SerializationUtils.toJsonString((Object)changePageAttachMap));
    }

    private static void setSize(Map<String, Object> attachmentInfo) {
        attachmentInfo.forEach((attachKey, obj) -> {
            List attachMapList = (List)obj;
            attachMapList.forEach(attachMap -> {
                if (attachMap.get("size") != null) {
                    Long size = Long.parseLong(attachMap.get("size").toString());
                    attachMap.put("size", size);
                }
            });
        });
    }

    public static List<HisAttachmentBo> copyAttachments(Long copyObjId, String entityNum, List<HisAttachmentBo> boList) {
        return HisAttachmentService.copyAttachments(copyObjId, entityNum, boList, false);
    }

    public static List<HisAttachmentBo> copyAttachments(Long copyObjId, String entityNum, List<HisAttachmentBo> boList, boolean remove) {
        HashMap cloneListMap = Maps.newHashMapWithExpectedSize((int)16);
        if (CollectionUtils.isEmpty(boList)) {
            return null;
        }
        boList.forEach(bo -> bo.getAttachments().forEach(attachment -> {
            String cloneMapStr = SerializationUtils.toJsonString((Object)attachment);
            Map cloneMap = (Map)SerializationUtils.fromJsonString((String)cloneMapStr, Map.class);
            HisAttachmentService.modifyAttachmentUid(cloneMap);
            String attachKey = (String)cloneMap.get("fattachmentpanel");
            List cloneList = cloneListMap.getOrDefault(attachKey, new ArrayList(10));
            cloneList.add(cloneMap);
            cloneListMap.putIfAbsent(attachKey, cloneList);
        }));
        ArrayList copyAttachBos = Lists.newArrayListWithCapacity((int)cloneListMap.size());
        cloneListMap.forEach((attachKey, map) -> {
            HisAttachmentBo cloneBo = new HisAttachmentBo();
            cloneBo.setId(copyObjId);
            cloneBo.setEntityNumber(entityNum);
            cloneBo.setAttachKey(attachKey);
            cloneBo.setAttachments(map);
            cloneBo.setRemove(remove);
            copyAttachBos.add(cloneBo);
        });
        return copyAttachBos;
    }

    private static void modifyAttachmentUid(Map<String, Object> attach) {
        String originUid = (String)attach.get("uid");
        String uid = "rc-upload-" + UUID.randomUUID().toString().replace("-", "") + originUid.substring(originUid.lastIndexOf(45));
        attach.put("uid", uid);
        attach.remove("lastModified");
    }

    public static void handleTempAttachments(DynamicObject[] dataCol, OperateOption operateOption) {
        String fromFormEdit = operateOption.getVariableValue("opFromFormEdit", "false");
        if (HRStringUtils.equals((String)fromFormEdit, (String)"true")) {
            DynamicObject dy = dataCol[0];
            if (dy.getPkValue() == null || dy.getLong("id") == 0L) {
                dy.set("id", (Object)ORM.create().genLongId(dy.getDataEntityType().getName()));
            }
            HisAttachmentService.saveTempAttachments(dy, operateOption);
        }
    }

    public static List<HisAttachmentBo> getHisAttachmentBoListFromOpParam(OperateOption operateOption) {
        String jsonString = operateOption.getVariableValue("opHisAttachments", null);
        ArrayList realHisAttachmentBoList = null;
        if (jsonString != null) {
            realHisAttachmentBoList = Lists.newArrayListWithCapacity((int)10);
            List hisAttachmentBoList = (List)SerializationUtils.fromJsonString((String)jsonString, List.class);
            try {
                for (Map map : hisAttachmentBoList) {
                    HisAttachmentBo bo = new HisAttachmentBo();
                    HRObjectUtils.transMapBean((Map)map, (Object)bo);
                    realHisAttachmentBoList.add(bo);
                }
            }
            catch (Exception e) {
                LOGGER.error((Throwable)e);
            }
        }
        return realHisAttachmentBoList;
    }

    public static Map<Long, List<HisAttachmentBo>> buildHisAttachmentBoList(String jsonString) {
        if (HRStringUtils.isEmpty((String)jsonString)) {
            return null;
        }
        Map hisAttachmentBoMap = (Map)SerializationUtils.fromJsonString((String)jsonString, Map.class);
        HashMap<Long, List<HisAttachmentBo>> mapHisAttachment = new HashMap<Long, List<HisAttachmentBo>>(16);
        try {
            for (Map.Entry hisAttachmentBoEntry : hisAttachmentBoMap.entrySet()) {
                if (hisAttachmentBoEntry.getValue() != null) {
                    for (Map map : (List)hisAttachmentBoEntry.getValue()) {
                        HisAttachmentBo hisAttachmentBo = new HisAttachmentBo();
                        HRObjectUtils.transMapBean((Map)map, (Object)hisAttachmentBo);
                        ArrayList<HisAttachmentBo> realHisAttachmentBoList = (ArrayList<HisAttachmentBo>)mapHisAttachment.get(hisAttachmentBo.getId());
                        if (CollectionUtils.isEmpty((Collection)realHisAttachmentBoList)) {
                            realHisAttachmentBoList = new ArrayList<HisAttachmentBo>(16);
                            mapHisAttachment.put(hisAttachmentBo.getId(), realHisAttachmentBoList);
                        }
                        realHisAttachmentBoList.add(hisAttachmentBo);
                    }
                    continue;
                }
                if (hisAttachmentBoEntry.getKey() == null) continue;
                Long key = Long.valueOf((String)hisAttachmentBoEntry.getKey());
                mapHisAttachment.put(key, null);
            }
        }
        catch (Exception ex) {
            LOGGER.error((Throwable)ex);
        }
        return mapHisAttachment;
    }

    public static void deleteCurDyAttachments(DynamicObject dataEntity) {
        if (dataEntity == null) {
            return;
        }
        DynamicObject[] curDataCol = new DynamicObject[]{dataEntity};
        List<Map<String, Object>> oldAttachments = HisAttachmentService.generateAttachmentMap(curDataCol);
        if (oldAttachments == null) {
            return;
        }
        oldAttachments.forEach(attachmentMaps -> oldAttachments.forEach(oldAttachment -> AttachmentServiceHelper.remove((String)dataEntity.getDataEntityType().getName(), (Object)dataEntity.getPkValue(), oldAttachment.get("uid"))));
    }

    public static void addDyAttachments(String jsonString, long existId, long copyId, String formId) {
        List<HisAttachmentBo> relHisAttachmentBos;
        Map<Long, List<HisAttachmentBo>> attachmentListMap = HisAttachmentService.buildHisAttachmentBoList(jsonString);
        if (attachmentListMap == null) {
            return;
        }
        List<HisAttachmentBo> hisAttachmentBos = attachmentListMap.get(existId);
        if (hisAttachmentBos != null && !hisAttachmentBos.isEmpty() && !CollectionUtils.isEmpty(relHisAttachmentBos = HisAttachmentService.copyAttachments(copyId, formId, hisAttachmentBos))) {
            attachmentListMap.put(copyId, relHisAttachmentBos);
        }
        attachmentListMap.forEach((id, hisAttachmentBoList) -> hisAttachmentBoList.forEach(bo -> AttachmentServiceHelper.upload((String)bo.getEntityNumber(), (Object)id, (String)bo.getAttachKey(), (List)bo.getAttachments())));
    }

    public static Map<Long, List<HisAttachmentBo>> processAttachment(List<HisAttachmentSourceIdBo> hisAttachmentSourceIdBoList, Map<Long, List<HisAttachmentBo>> mapHisAttachmentBos, String entityNumber) {
        if (hisAttachmentSourceIdBoList == null) {
            return null;
        }
        if (mapHisAttachmentBos == null) {
            mapHisAttachmentBos = new HashMap<Long, List<HisAttachmentBo>>(8);
        }
        HashSet needQuerySourceIdSet = Sets.newHashSetWithExpectedSize((int)hisAttachmentSourceIdBoList.size());
        for (HisAttachmentSourceIdBo hisAttachmentSourceIdBo : hisAttachmentSourceIdBoList) {
            Long sourceId = hisAttachmentSourceIdBo.getSourceId();
            String strSourceId = String.valueOf(sourceId);
            boolean isFirstVersion = hisAttachmentSourceIdBo.isFirstVersion();
            List<HisAttachmentBo> hisAttachmentBoList = mapHisAttachmentBos.get(sourceId);
            if (!CollectionUtils.isEmpty(hisAttachmentBoList) || isFirstVersion) continue;
            needQuerySourceIdSet.add(strSourceId);
        }
        Map<Object, Object> mapAttDataFromDb = Maps.newHashMapWithExpectedSize((int)16);
        if (CollectionUtils.isNotEmpty((Collection)needQuerySourceIdSet)) {
            mapAttDataFromDb = HisAttachmentService.generateAttachmentListMapById(needQuerySourceIdSet, entityNumber);
        }
        HashSet sourceIdSet = Sets.newHashSetWithExpectedSize((int)hisAttachmentSourceIdBoList.size());
        for (HisAttachmentSourceIdBo hisAttachmentSourceIdBo : hisAttachmentSourceIdBoList) {
            Long id = hisAttachmentSourceIdBo.getId();
            Long sourceId = hisAttachmentSourceIdBo.getSourceId();
            sourceIdSet.add(sourceId);
            boolean isFirstVersion = hisAttachmentSourceIdBo.isFirstVersion();
            List<HisAttachmentBo> hisAttachmentBoList = mapHisAttachmentBos.get(sourceId);
            if (!CollectionUtils.isEmpty(hisAttachmentBoList)) {
                List<HisAttachmentBo> copyAttachBos = HisAttachmentService.copyAttachments(id, entityNumber, hisAttachmentBoList, true);
                mapHisAttachmentBos.put(id, copyAttachBos);
                continue;
            }
            if (isFirstVersion) continue;
            String strSourceId = String.valueOf(sourceId);
            List attachMapList = (List)mapAttDataFromDb.get(strSourceId);
            if (CollectionUtils.isEmpty((Collection)attachMapList)) {
                mapHisAttachmentBos.put(id, null);
                continue;
            }
            hisAttachmentBoList = HisAttachmentService.transAttachmentsInfoToList(attachMapList, entityNumber, strSourceId);
            if (CollectionUtils.isEmpty(hisAttachmentBoList)) continue;
            List<HisAttachmentBo> copyAttachBos = HisAttachmentService.copyAttachments(id, entityNumber, hisAttachmentBoList, true);
            mapHisAttachmentBos.put(id, copyAttachBos);
        }
        for (Long sourceId : sourceIdSet) {
            mapHisAttachmentBos.remove(sourceId);
        }
        return mapHisAttachmentBos;
    }

    public static Map<Long, List<HisAttachmentBo>> processAttachment(List<HisAttachmentSourceIdBo> hisAttachmentSourceIdBoList, String entityNumber) {
        return HisAttachmentService.processAttachment(hisAttachmentSourceIdBoList, null, entityNumber);
    }

    public static void afterOpHandleAttachment(String entityId, OperateOption operateOption) {
        String opHisAttachmentStr = operateOption.getVariableValue("opHisAttachments", null);
        if (HRStringUtils.isEmpty((String)opHisAttachmentStr)) {
            return;
        }
        Map<Long, List<HisAttachmentBo>> mapHisAttachmentBos = HisAttachmentService.buildHisAttachmentBoList(opHisAttachmentStr);
        if (mapHisAttachmentBos == null) {
            return;
        }
        String attachDeleteFlagStr = operateOption.getVariableValue("attachDeleteFlag", null);
        if (HRStringUtils.isNotEmpty((String)attachDeleteFlagStr)) {
            mapHisAttachmentBos.forEach((id, hisAttachmentBos) -> {
                if (hisAttachmentBos == null) {
                    AttachmentServiceHelper.remove((String)entityId, (Object)id);
                }
            });
        }
        mapHisAttachmentBos.entrySet().removeIf(entry -> entry.getValue() == null);
        mapHisAttachmentBos.forEach((id, hisAttachmentBos) -> hisAttachmentBos.forEach(bo -> {
            if (bo.isRemove()) {
                List oldAttachments = AttachmentServiceHelper.getAttachments((String)bo.getEntityNumber(), (Object)id, (String)bo.getAttachKey());
                oldAttachments.forEach(attachmentMaps -> oldAttachments.forEach(oldAttachment -> AttachmentServiceHelper.remove((String)bo.getEntityNumber(), (Object)bo.getId(), oldAttachment.get("uid"))));
            }
            AttachmentServiceHelper.upload((String)bo.getEntityNumber(), (Object)id, (String)bo.getAttachKey(), (List)bo.getAttachments());
        }));
    }

    public static void uploadReviseAttachment(OperateOption operateOption) {
        String entityNumber = operateOption.getVariableValue("entityNumber", null);
        String attachmentStr = operateOption.getVariableValue("revise_attachmentInfo", null);
        String persionalAttachmentStr = operateOption.getVariableValue("revise_persional_attachmentInfo", null);
        HisAttachmentService.deleteAndUpload(entityNumber, attachmentStr);
        HisAttachmentService.deleteAndUpload(entityNumber, persionalAttachmentStr);
    }

    private static void deleteAndUpload(String entityNumber, String attachmentStr) {
        if (HRStringUtils.isEmpty((String)attachmentStr) || HRStringUtils.equals((String)"null", (String)attachmentStr)) {
            return;
        }
        Map<Long, List<HisAttachmentBo>> mapHisAttachmentBos = HisAttachmentService.buildHisAttachmentBoList(attachmentStr);
        if (mapHisAttachmentBos == null) {
            return;
        }
        mapHisAttachmentBos.entrySet().removeIf(entry -> entry.getValue() == null);
        mapHisAttachmentBos.forEach((id, hisAttachmentBos) -> hisAttachmentBos.forEach(bo -> {
            if (bo.isRemove()) {
                List oldAttachments = AttachmentServiceHelper.getAttachments((String)bo.getEntityNumber(), (Object)id, (String)bo.getAttachKey());
                oldAttachments.forEach(attachmentMaps -> oldAttachments.forEach(oldAttachment -> AttachmentServiceHelper.remove((String)bo.getEntityNumber(), (Object)bo.getId(), oldAttachment.get("uid"))));
            }
            AttachmentServiceHelper.upload((String)bo.getEntityNumber(), (Object)id, (String)bo.getAttachKey(), (List)bo.getAttachments());
        }));
    }

    public static void uploadAttachmentMap(HisAttachmentDataBo hisAttachmentDataBo) {
        if (hisAttachmentDataBo == null) {
            return;
        }
        Map<Long, List<HisAttachmentBo>> mapHisAttachmentBos = hisAttachmentDataBo.getMapHisAttachmentBos();
        if (mapHisAttachmentBos == null) {
            return;
        }
        String entityNumber = hisAttachmentDataBo.getEntityNumber();
        if (StringUtils.isEmpty((Object)entityNumber)) {
            return;
        }
        mapHisAttachmentBos.forEach((id, hisAttachmentBos) -> {
            if (hisAttachmentBos == null) {
                AttachmentServiceHelper.remove((String)entityNumber, (Object)id);
            }
        });
        mapHisAttachmentBos.entrySet().removeIf(entry -> entry.getValue() == null);
        mapHisAttachmentBos.forEach((id, hisAttachmentBos) -> hisAttachmentBos.forEach(bo -> {
            if (bo.isRemove()) {
                List oldAttachments = AttachmentServiceHelper.getAttachments((String)bo.getEntityNumber(), (Object)id, (String)bo.getAttachKey());
                oldAttachments.forEach(attachmentMaps -> oldAttachments.forEach(oldAttachment -> AttachmentServiceHelper.remove((String)bo.getEntityNumber(), (Object)bo.getId(), oldAttachment.get("uid"))));
            }
            AttachmentServiceHelper.upload((String)bo.getEntityNumber(), (Object)id, (String)bo.getAttachKey(), (List)bo.getAttachments());
        }));
    }
}

