/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.domain.service.impl.clearevent;

import com.google.common.collect.Sets;
import java.text.ParseException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.domain.repository.HisEventEntityRepository;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.constants.newhismodel.EventOperateEnums;
import kd.hr.hbp.common.util.HRDateTimeUtils;

public class HisClearErrorEventDataService {
    private static final Log LOGGER = LogFactory.getLog(HisClearErrorEventDataService.class);
    private static volatile HisClearErrorEventDataService service = null;
    private static int MAX_DELETE_COUNT = 10000;
    private static int MIN_THRESHOLD = 5000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HisClearErrorEventDataService getInstance() {
        if (service != null) return service;
        Class<HisClearErrorEventDataService> clazz = HisClearErrorEventDataService.class;
        synchronized (HisClearErrorEventDataService.class) {
            if (service != null) return service;
            service = new HisClearErrorEventDataService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return service;
        }
    }

    public void clearEventData(String eventGroupNumber, String strParamStartDate, String strParamEndDate, String maxCount) throws ParseException {
        DynamicObject dynamicObject;
        int maxCountParam;
        LocalDate localEndDate;
        LocalDate localStartDate;
        if (StringUtils.isEmpty((String)eventGroupNumber)) {
            LOGGER.info("HisClearErrorEventDataService paramter cannot be null ,'eventGroupNumber'");
            return;
        }
        if (StringUtils.isEmpty((String)strParamStartDate)) {
            localStartDate = LocalDate.of(2023, 3, 1);
        } else {
            Date paramStartDate = HRDateTimeUtils.parseDate((String)strParamStartDate);
            Instant instantStart = paramStartDate.toInstant();
            localStartDate = ZonedDateTime.ofInstant(instantStart, ZoneId.systemDefault()).toLocalDate();
        }
        if (StringUtils.isEmpty((String)strParamEndDate)) {
            localEndDate = LocalDate.of(2024, 7, 1);
        } else {
            Date paramEndDate = HRDateTimeUtils.parseDate((String)strParamEndDate);
            Instant instantEnd = paramEndDate.toInstant();
            localEndDate = ZonedDateTime.ofInstant(instantEnd, ZoneId.systemDefault()).toLocalDate();
        }
        if (localStartDate.isAfter(localEndDate)) {
            LOGGER.error("clearEventData error, start date can not be large than end date");
            return;
        }
        int iMaxCount = MIN_THRESHOLD;
        if (StringUtils.isNotEmpty((String)maxCount) && (maxCountParam = Integer.parseInt(maxCount)) <= MIN_THRESHOLD) {
            iMaxCount = maxCountParam;
        }
        if ((dynamicObject = HisEventEntityRepository.getEventGroupByNumber(eventGroupNumber)) == null) {
            return;
        }
        DynamicObject dyEvent = dynamicObject.getDynamicObject("evententity");
        if (dyEvent == null) {
            return;
        }
        DynamicObject dyBusEvent = dynamicObject.getDynamicObject("busevententity");
        if (dyBusEvent == null) {
            return;
        }
        String eventEntity = dyEvent.getString("number");
        if (StringUtils.isEmpty((String)eventEntity)) {
            return;
        }
        String busEventEntity = dyBusEvent.getString("number");
        if (StringUtils.isEmpty((String)busEventEntity)) {
            return;
        }
        HRBaseServiceHelper busServiceHelper = new HRBaseServiceHelper(busEventEntity);
        HRBaseServiceHelper eventServiceHelper = new HRBaseServiceHelper(eventEntity);
        int daysToAdd = 1;
        while (!localStartDate.isAfter(localEndDate)) {
            LocalDate nextDate = localStartDate.plusDays(daysToAdd);
            DataSet dataSet = this.getEventIdSetByDay(localStartDate, nextDate, eventServiceHelper);
            if (dataSet == null) continue;
            HashSet idSet = Sets.newHashSetWithExpectedSize((int)16);
            boolean isDeletedOnce = false;
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                idSet.add(row.getLong("id"));
                if (idSet.size() != MAX_DELETE_COUNT) continue;
                this.deleteEventData(busServiceHelper, eventServiceHelper, idSet);
                isDeletedOnce = true;
                idSet = Sets.newHashSetWithExpectedSize((int)16);
            }
            if (CollectionUtils.isNotEmpty((Collection)idSet) && (idSet.size() >= iMaxCount || isDeletedOnce)) {
                this.deleteEventData(busServiceHelper, eventServiceHelper, idSet);
            }
            localStartDate = nextDate;
        }
    }

    private void deleteEventData(HRBaseServiceHelper busServiceHelper, HRBaseServiceHelper eventServiceHelper, Set<Long> idSet) {
        try (TXHandle txHandle = TX.required();){
            try {
                this.clearBusEventData(busServiceHelper, idSet);
                this.clearEventData(eventServiceHelper, idSet);
            }
            catch (Exception ex) {
                LOGGER.error("clearEventData error,message:{}", (Object)ex.toString());
                txHandle.markRollback();
            }
        }
    }

    private void clearBusEventData(HRBaseServiceHelper busEventServiceHelper, Set<Long> eventIdSet) {
        QFilter[] busQFilters = new QFilter[]{new QFilter("event", "in", eventIdSet)};
        int count = busEventServiceHelper.deleteByFilter(busQFilters);
        if (count > 0) {
            LOGGER.info("clearBusEventData count : {}", (Object)count);
        }
    }

    private void clearEventData(HRBaseServiceHelper eventServiceHelper, Set<Long> eventIdSet) {
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "in", eventIdSet)};
        int count = eventServiceHelper.deleteByFilter(qFilters);
        if (count > 0) {
            LOGGER.info("clearEventData : count : {}", (Object)count);
        }
    }

    private DataSet getEventIdSetByDay(LocalDate localStartDay, LocalDate localEndDay, HRBaseServiceHelper eventServiceHelper) {
        Date startDay = Date.from(localStartDay.atStartOfDay(ZoneId.systemDefault()).toInstant());
        Date endDay = Date.from(localEndDay.atStartOfDay(ZoneId.systemDefault()).toInstant());
        QFilter[] qFilters = new QFilter[]{new QFilter("operatedate", ">=", (Object)startDay), new QFilter("operatedate", "<", (Object)endDay), new QFilter("executeway", "=", (Object)EventOperateEnums.EVENT_EXECUTE_AUTO.getValue())};
        return eventServiceHelper.queryDataSet("HisClearErrorEventDataService.getEventIdSetByDay", "id", qFilters, "operatedate");
    }
}

