/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.domain.service.impl.newhismodel;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.domain.model.newhismodel.BatchVersionChangeRespData;
import kd.hr.hbp.business.domain.model.newhismodel.HisResponse;
import kd.hr.hbp.business.domain.model.newhismodel.HisTransBo;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionParamBo;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionParamListBo;
import kd.hr.hbp.business.domain.model.newhismodel.VersionChangeRespData;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisCommonService;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisModelEventService;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisValidateService;
import kd.hr.hbp.business.domain.service.impl.newhismodel.NoLineTimeHisVersionChangeService;
import kd.hr.hbp.business.domain.service.impl.newhismodel.hisversion.HisVersionNumberService;
import kd.hr.hbp.business.domain.service.newhismodel.HisModelServiceFactory;
import kd.hr.hbp.business.domain.service.newhismodel.IHisBatchSaveVersion;
import kd.hr.hbp.business.domain.service.newhismodel.IHisSaveVersion;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.constants.newhismodel.EnumEntityTpl;
import kd.hr.hbp.common.constants.newhismodel.EventOperateEnums;

public class HisBatchSaveVersion
implements IHisBatchSaveVersion {
    private static final Log LOGGER = LogFactory.getLog(HisBatchSaveVersion.class);
    private static volatile HisBatchSaveVersion hisBatchSaveVersion = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HisBatchSaveVersion getInstance() {
        if (hisBatchSaveVersion != null) return hisBatchSaveVersion;
        Class<HisBatchSaveVersion> clazz = HisBatchSaveVersion.class;
        synchronized (HisBatchSaveVersion.class) {
            if (hisBatchSaveVersion != null) return hisBatchSaveVersion;
            hisBatchSaveVersion = new HisBatchSaveVersion();
            // ** MonitorExit[var0] (shouldn't be in output)
            return hisBatchSaveVersion;
        }
    }

    @Override
    public HisResponse<BatchVersionChangeRespData> batchSaveEffVersion(HisVersionParamListBo hisVersionParamListBo) {
        HisResponse<BatchVersionChangeRespData> hisResponse = new HisResponse<BatchVersionChangeRespData>();
        if (hisVersionParamListBo == null) {
            return hisResponse;
        }
        List<HisVersionParamBo> hisVersionParamBoList = hisVersionParamListBo.getListHisVersionParamBo();
        if (CollectionUtils.isEmpty(hisVersionParamBoList)) {
            return hisResponse;
        }
        HisTransBo hisTransBo = this.buildHisTransBo(hisVersionParamListBo);
        if (hisVersionParamListBo.isEffImmediately()) {
            ArrayList<VersionChangeRespData> versionChangeRespDataList = new ArrayList<VersionChangeRespData>(8);
            String entityNumber = null;
            try {
                for (HisVersionParamBo hisVersionParamBo : hisVersionParamBoList) {
                    VersionChangeRespData versionChangeRespData;
                    entityNumber = hisVersionParamBo.getEntityNumber();
                    if (StringUtils.isEmpty((String)entityNumber)) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u5b9e\u4f53\u7f16\u7801\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"HisBatchSaveVersion_1", (String)"hrmp-hbp-business", (Object[])new Object[0]));
                    }
                    HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityNumber);
                    String entityType = HisCommonService.getInstance().entityInhRelation(entityNumber);
                    if (EnumEntityTpl.LINETIMESEQ_TPL.getNumber().equals(entityType)) {
                        HisValidateService.getInstance().validateEffVersion(hisVersionParamBo);
                        IHisSaveVersion hisSaveVersion = HisModelServiceFactory.getHisSaveVersionInstance(hisVersionParamBo.getEntityNumber());
                        versionChangeRespData = new VersionChangeRespData();
                        versionChangeRespData.setEntityNumber(entityNumber);
                        DynamicObject[] dynamicObjects = hisSaveVersion.saveEffVersion(hisVersionParamBo, hisTransBo, serviceHelper, true);
                        if (dynamicObjects == null || dynamicObjects.length <= 0) continue;
                        HisVersionNumberService.getInstance().calcVersionNumber(hisVersionParamBo.getEntityNumber(), dynamicObjects);
                        serviceHelper.save(dynamicObjects);
                        versionChangeRespData.setNewDynamicObjects(dynamicObjects);
                        versionChangeRespDataList.add(versionChangeRespData);
                        continue;
                    }
                    if (!EnumEntityTpl.NONLINETIMESEQ_TPL.getNumber().equals(entityType)) continue;
                    hisVersionParamBo.setEffImmediately(true);
                    hisVersionParamBo.setEventId(hisVersionParamListBo.getEventId());
                    DynamicObject[] newDynamicObjects = NoLineTimeHisVersionChangeService.getInstance().handleNoLineData(hisVersionParamBo);
                    if (newDynamicObjects == null || newDynamicObjects.length <= 0) continue;
                    versionChangeRespData = new VersionChangeRespData();
                    versionChangeRespData.setEntityNumber(entityNumber);
                    versionChangeRespData.setNewDynamicObjects(newDynamicObjects);
                    versionChangeRespDataList.add(versionChangeRespData);
                }
            }
            catch (Exception ex) {
                if (ex instanceof KDBizException) {
                    LOGGER.error("HISMODEL_batchSaveEffVersion_ERROR: ", (Throwable)ex);
                    throw ex;
                }
                String errorMsg = String.format(ResManager.loadKDString((String)"\u6279\u91cf\u4fdd\u5b58\u751f\u6548\u7248\u672c\u5931\u8d25\uff0c \u5b9e\u4f53\u7f16\u7801\uff1a%s\u3002", (String)"HisBatchSaveVersion_3", (String)"hrmp-hbp-business", (Object[])new Object[0]), entityNumber);
                LOGGER.error("HISMODEL_batchSaveEffVersion_ERROR: ", (Throwable)ex);
                throw new KDBizException((Throwable)ex, new ErrorCode("500", errorMsg), new Object[0]);
            }
            if (hisTransBo != null) {
                BatchVersionChangeRespData batchVersionChangeRespData = new BatchVersionChangeRespData();
                batchVersionChangeRespData.setVersionChangeRespDataList(versionChangeRespDataList);
                hisResponse.setData(batchVersionChangeRespData);
                HisModelEventService hisModelEventService = new HisModelEventService();
                hisModelEventService.saveEvent(hisTransBo);
                batchVersionChangeRespData.setEventId(hisTransBo.getEventId());
            }
        }
        return hisResponse;
    }

    private HisTransBo buildHisTransBo(HisVersionParamListBo hisVersionParamListBo) {
        List<HisVersionParamBo> hisVersionParamBoList = hisVersionParamListBo.getListHisVersionParamBo();
        if (CollectionUtils.isEmpty(hisVersionParamBoList)) {
            return null;
        }
        HisTransBo hisTransBo = new HisTransBo();
        if (hisVersionParamListBo.getEventId() != null) {
            hisTransBo.setEventId(hisVersionParamListBo.getEventId());
        }
        boolean atomicTrans = hisVersionParamListBo.isAtomicTrans();
        if (hisVersionParamBoList.size() == 1) {
            DynamicObject[] dynamicObjects = hisVersionParamBoList.get(0).getHisDyns();
            if (dynamicObjects == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5b9e\u4f53\u7f16\u7801\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"HisBatchSaveVersion_2", (String)"hrmp-hbp-business", (Object[])new Object[0]));
            }
            if (dynamicObjects.length == 1) {
                hisTransBo.setTransBatchType(EventOperateEnums.EVENT_PATCH_TYPE_SINGLE.getValue());
            } else {
                this.setBatchTrans(hisTransBo, atomicTrans);
            }
        } else {
            this.setBatchTrans(hisTransBo, atomicTrans);
        }
        return hisTransBo;
    }

    private void setBatchTrans(HisTransBo hisTransBo, boolean atomicTrans) {
        if (atomicTrans) {
            hisTransBo.setTransBatchType(EventOperateEnums.EVENT_PATCH_TYPE_ATOM.getValue());
        } else {
            hisTransBo.setTransBatchType(EventOperateEnums.EVENT_PATCH_TYPE_NOTATOM.getValue());
        }
    }
}

