/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.domain.service.impl.newhismodel;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.domain.model.newhismodel.HisBaseBo;
import kd.hr.hbp.business.domain.repository.HisEventEntityRepository;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisCommonService;
import kd.hr.hbp.business.domain.service.impl.newhismodel.revocation.HisModelEventDataService;
import kd.hr.hbp.business.domain.service.newhismodel.IHisDeleteService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;

public class HisDeleteService
implements IHisDeleteService {
    private static volatile HisDeleteService hisDeleteService = null;
    private static final Log LOGGER = LogFactory.getLog(HisDeleteService.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HisDeleteService getInstance() {
        if (hisDeleteService != null) return hisDeleteService;
        Class<HisDeleteService> clazz = HisDeleteService.class;
        synchronized (HisDeleteService.class) {
            if (hisDeleteService != null) return hisDeleteService;
            hisDeleteService = new HisDeleteService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return hisDeleteService;
        }
    }

    @Override
    public void deleteBoEventData(HisBaseBo hisBaseBo) {
        Long[] boIds = hisBaseBo.getBoIdList().toArray(new Long[hisBaseBo.getBoIdList().size()]);
        String entityNumber = hisBaseBo.getEntityNumber();
        LOGGER.info("entityNumber : ----->{}", (Object)entityNumber);
        DynamicObject dyEventGroup = HisModelEventDataService.getInstance().getEventGroupDyByEntity(entityNumber);
        if (dyEventGroup == null) {
            return;
        }
        DynamicObject dyEvent = dyEventGroup.getDynamicObject("evententity");
        DynamicObject dyBsEvent = dyEventGroup.getDynamicObject("busevententity");
        DynamicObject dyVersionEvent = dyEventGroup.getDynamicObject("hisevententity");
        String eventEntityNumber = dyEvent.getString("number");
        String bussEventEntityNumber = dyBsEvent.getString("number");
        String versionEventEntityNumber = dyVersionEvent.getString("number");
        LOGGER.info("eventEntityNumber ----->: {}", (Object)eventEntityNumber);
        LOGGER.info("bussEventEntityNumber ----->: {}", (Object)bussEventEntityNumber);
        LOGGER.info("versionEventEntityNumber ----->: {}", (Object)versionEventEntityNumber);
        HRBaseServiceHelper eventServiceHelper = new HRBaseServiceHelper(eventEntityNumber);
        HRBaseServiceHelper bussEventServiceHelper = new HRBaseServiceHelper(bussEventEntityNumber);
        HRBaseServiceHelper versionEventServiceHelper = new HRBaseServiceHelper(versionEventEntityNumber);
        DynamicObject[] dyBussEvents = HisEventEntityRepository.queryBussEventByBoIds(bussEventServiceHelper, boIds);
        if (dyBussEvents == null) {
            return;
        }
        LOGGER.info("dyBussEvents.length ----->: {}", (Object)dyBussEvents.length);
        HashSet<Long> bussEventIdSet = new HashSet<Long>(dyBussEvents.length);
        LOGGER.info("bussEventIdSet ----->: {}", (Object)bussEventIdSet.size());
        HashSet<Long> eventIdSet = new HashSet<Long>(dyBussEvents.length);
        for (DynamicObject dynamicObject : dyBussEvents) {
            Long id = dynamicObject.getLong("id");
            bussEventIdSet.add(id);
            LOGGER.info("id ----->: {}", (Object)id.toString());
            Long eventId = dynamicObject.getLong("event");
            LOGGER.info("eventId ----->: {}", (Object)eventId.toString());
            eventIdSet.add(eventId);
        }
        HisEventEntityRepository.deleteVersionEvent(versionEventServiceHelper, bussEventIdSet.toArray(new Long[bussEventIdSet.size()]));
        HisEventEntityRepository.deleteBussEvent(bussEventServiceHelper, boIds);
        DynamicObject[] dyRestEvent = HisEventEntityRepository.queryBussEventByEventIds(bussEventServiceHelper, boIds, eventIdSet.toArray(new Long[eventIdSet.size()]));
        Set restEventId = Arrays.stream(dyRestEvent).map(dy -> dy.getLong("event")).collect(Collectors.toSet());
        eventIdSet.removeAll(restEventId);
        if (eventIdSet.size() > 0) {
            HisEventEntityRepository.deleteEvent(eventServiceHelper, eventIdSet.toArray(new Long[eventIdSet.size()]));
        }
    }

    @Override
    public void deleteBo(HisBaseBo hisBaseBo) {
        this.validateParam(hisBaseBo);
        this.deleteBoEventData(hisBaseBo);
        this.deleteBoData(hisBaseBo);
    }

    private void deleteBoData(HisBaseBo hisBaseBo) {
        QFilter[] qFilter;
        String entityNumber = hisBaseBo.getEntityNumber();
        List<Long> boIds = hisBaseBo.getBoIdList();
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityNumber);
        if (HisCommonService.getInstance().isBuBaseData(entityNumber)) {
            qFilter = new QFilter[]{new QFilter("boid", "in", boIds)};
            DynamicObject[] dynamicObjects = serviceHelper.loadDynamicObjectArray(qFilter);
            BaseDataServiceHelper.baseDataDeleteHandler((DynamicObject[])dynamicObjects);
        }
        qFilter = new QFilter[]{new QFilter("boid", "in", boIds)};
        serviceHelper.deleteByFilter(qFilter);
    }

    private void validateParam(HisBaseBo hisBaseBo) {
        if (hisBaseBo == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5220\u9664\u53c2\u6570\u4e3a\u7a7a", (String)"HisDeleteService_1", (String)"hrmp-hbp-business", (Object[])new Object[0]));
        }
        String entityNumber = hisBaseBo.getEntityNumber();
        if (StringUtils.isEmpty((String)entityNumber)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5b9e\u4f53\u7f16\u7801\u4e3a\u7a7a", (String)"HisDeleteService_2", (String)"hrmp-hbp-business", (Object[])new Object[0]));
        }
        if (CollectionUtils.isEmpty(hisBaseBo.getBoIdList())) {
            throw new KDBizException(ResManager.loadKDString((String)"boid\u6570\u636e\u4e3a\u7a7a", (String)"HisDeleteService_3", (String)"hrmp-hbp-business", (Object[])new Object[0]));
        }
    }
}

