/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.domain.service.impl.newhismodel;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.domain.model.newhismodel.HisImportBo;
import kd.hr.hbp.business.domain.model.newhismodel.HisResponse;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionParamBo;
import kd.hr.hbp.business.domain.model.newhismodel.ImportRespData;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisVersionChangeService;
import kd.hr.hbp.business.domain.service.impl.newhismodel.hisversion.HisVersionNumberService;
import kd.hr.hbp.business.domain.util.HisLineOpUtil;
import kd.hr.hbp.business.domain.util.HisModelEditAuditTool;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;

public class HisLineImportService {
    private static final Log LOGGER = LogFactory.getLog(HisLineImportService.class);
    private static volatile HisLineImportService service = null;

    private HisLineImportService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HisLineImportService getInstance() {
        if (service != null) return service;
        Class<HisLineImportService> clazz = HisLineImportService.class;
        synchronized (HisLineImportService.class) {
            if (service != null) return service;
            service = new HisLineImportService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return service;
        }
    }

    public HisResponse<ImportRespData> hisLineImportData(HisImportBo hisImportBo) {
        String importType = hisImportBo.getImportType();
        DynamicObject[] dataCol = hisImportBo.getDataEntities();
        String entityNum = dataCol[0].getDataEntityType().getName();
        DynamicObject[] allDataCol = this.doImport(dataCol, importType, entityNum);
        HRBaseServiceHelper helper = new HRBaseServiceHelper(entityNum);
        Object[] ids = helper.save(allDataCol);
        HisResponse<ImportRespData> response = new HisResponse<ImportRespData>();
        ImportRespData returnData = new ImportRespData();
        returnData.setEntityNumber(entityNum);
        returnData.setImportType(importType);
        returnData.setPkIds(Arrays.asList(ids));
        returnData.setEventId(HisLineOpUtil.getEventIdForImport(entityNum));
        response.setData(returnData);
        return response;
    }

    private DynamicObject[] doImport(DynamicObject[] dataCol, String importType, String entityNum) {
        boolean containsStatus = dataCol[0].getDataEntityType().getProperties().get((Object)"status") != null;
        DynamicObjectCollection tempDataCol = new DynamicObjectCollection();
        if ("new".equals(importType)) {
            dataCol = this.save(dataCol);
        } else if ("override".equals(importType)) {
            ArrayList newVersionDyCol = Lists.newArrayListWithExpectedSize((int)dataCol.length);
            for (DynamicObject dy2 : dataCol) {
                if (containsStatus && HRStringUtils.equals((String)"A", (String)dy2.getString("status"))) {
                    tempDataCol.add((Object)dy2);
                    continue;
                }
                newVersionDyCol.add(HisLineOpUtil.copyTempVersionDy(entityNum, dy2, Collections.emptySet()));
            }
            if (newVersionDyCol.size() > 0) {
                DynamicObject[] saveEntityArray = newVersionDyCol.toArray(new DynamicObject[0]);
                dataCol = this.save(saveEntityArray);
            }
        } else {
            ArrayList saveEntityCol = Lists.newArrayListWithExpectedSize((int)dataCol.length);
            Set ids = Arrays.stream(dataCol).map(dy -> dy.get("id")).collect(Collectors.toSet());
            HRBaseServiceHelper helper = new HRBaseServiceHelper(entityNum);
            DynamicObjectCollection existDys = helper.queryOriginalCollection("id", new QFilter[]{new QFilter("id", "in", ids)});
            Set existIds = existDys.stream().map(dy -> dy.get("id")).collect(Collectors.toSet());
            for (DynamicObject dy3 : dataCol) {
                if (existIds.contains(dy3.get("id"))) {
                    if (containsStatus && HRStringUtils.equals((String)"A", (String)dy3.getString("status"))) {
                        tempDataCol.add((Object)dy3);
                        continue;
                    }
                    saveEntityCol.add(HisLineOpUtil.copyTempVersionDy(entityNum, dy3, Collections.emptySet()));
                    continue;
                }
                saveEntityCol.add(dy3);
            }
            if (saveEntityCol.size() > 0) {
                DynamicObject[] saveEntityArray = saveEntityCol.toArray(new DynamicObject[0]);
                dataCol = this.save(saveEntityArray);
            }
        }
        DynamicObject[] allDataCol = Arrays.copyOf(dataCol, dataCol.length + tempDataCol.size());
        for (int i = dataCol.length; i < allDataCol.length; ++i) {
            allDataCol[i] = (DynamicObject)tempDataCol.get(i - dataCol.length);
        }
        return allDataCol;
    }

    private DynamicObject[] save(DynamicObject[] dataCol) {
        if (HisModelEditAuditTool.getNeedAuditForOp(dataCol[0].getDataEntityType())) {
            HisVersionParamBo hisVersionParamBo = new HisVersionParamBo();
            hisVersionParamBo.setEntityNumber(dataCol[0].getDataEntityType().getName());
            hisVersionParamBo.setHisDyns(dataCol);
            HisVersionChangeService.getInstance().saveTempVersion(hisVersionParamBo);
        } else {
            HisVersionParamBo hisVersionParamBo = HisLineOpUtil.saveEffect(dataCol, null);
            HisLineOpUtil.handleImportEventBefore(true, hisVersionParamBo);
            dataCol = HisVersionChangeService.getInstance().saveEffVersion(hisVersionParamBo);
            HisLineOpUtil.handleImportEventAfter(true, hisVersionParamBo);
            String entityNum = dataCol[0].getDataEntityType().getName();
            HisVersionNumberService.getInstance().calcVersionNumber(entityNum, dataCol);
        }
        return dataCol;
    }
}

