/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.domain.service.impl.newhismodel;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.hr.hbp.business.application.impl.common.DynamicObjectCommonService;
import kd.hr.hbp.business.domain.model.newhismodel.HisTransBo;
import kd.hr.hbp.business.domain.model.newhismodel.HisTransBusinessBo;
import kd.hr.hbp.business.domain.model.newhismodel.HisTransRevocationBo;
import kd.hr.hbp.business.domain.model.newhismodel.HisTransRevocationListBo;
import kd.hr.hbp.business.domain.model.newhismodel.HisTransVersionBo;
import kd.hr.hbp.business.domain.model.newhismodel.writeback.HisWriteBackCurrentBo;
import kd.hr.hbp.business.domain.repository.HisCommonEntityRepository;
import kd.hr.hbp.business.domain.repository.HisEventEntityRepository;
import kd.hr.hbp.business.domain.repository.HisPersonalDataRepository;
import kd.hr.hbp.business.domain.service.attachment.HisAttachmentService;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisCommonService;
import kd.hr.hbp.business.domain.service.impl.newhismodel.personal.HisPersonalDataService;
import kd.hr.hbp.business.domain.service.impl.newhismodel.revocation.EventGroupService;
import kd.hr.hbp.business.domain.service.impl.newhismodel.revocation.HisModelEventDataService;
import kd.hr.hbp.business.domain.service.impl.newhismodel.writeback.HisWriteBackCurrentService;
import kd.hr.hbp.business.domain.service.newhismodel.IHisModelEventService;
import kd.hr.hbp.business.domain.util.HisNonLineSyncUtil;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.constants.newhismodel.EnumEntityTpl;
import kd.hr.hbp.common.constants.newhismodel.EnumHisDataVersionStatus;
import kd.hr.hbp.common.constants.newhismodel.EventOperateEnums;
import kd.hr.hbp.common.model.hismodel.HisAttachmentBo;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.ListUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;

public class HisModelEventService
implements IHisModelEventService {
    private static final Log LOGGER = LogFactory.getLog(HisModelEventService.class);
    private static volatile HisModelEventService hisModelEventService = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HisModelEventService getInstance() {
        if (hisModelEventService != null) return hisModelEventService;
        Class<HisModelEventService> clazz = HisModelEventService.class;
        synchronized (HisModelEventService.class) {
            if (hisModelEventService != null) return hisModelEventService;
            hisModelEventService = new HisModelEventService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return hisModelEventService;
        }
    }

    @Override
    public void saveEvent(HisTransBo hisTransBo) {
        if (Objects.isNull(hisTransBo)) {
            return;
        }
        List<HisTransBusinessBo> listHisTransBusinessBo = hisTransBo.getListHisTransBusinessBo();
        if (Objects.isNull(listHisTransBusinessBo) || listHisTransBusinessBo.size() < 1) {
            return;
        }
        List<String> entityNumberList = this.getEntityNumber(hisTransBo);
        Map<String, DynamicObject> entityEventMap = EventGroupService.getInstance().getEntityToEventMap(entityNumberList);
        Map<String, String> entityAppMap = EventGroupService.getInstance().getEntityToAppMap(entityNumberList);
        Map<String, DynamicObject> appDefaultEventMap = EventGroupService.getInstance().getAppDefaultEventMap(entityAppMap);
        this.validateParamBo(hisTransBo, entityEventMap, appDefaultEventMap, entityAppMap);
        this.handleEventObject(hisTransBo, entityEventMap, appDefaultEventMap, entityAppMap);
    }

    @Override
    public void revocationEvent(HisTransRevocationListBo hisTransRevocationListBo) {
        this.revocationPartOrAllEvent(hisTransRevocationListBo);
    }

    private void revocationPartOrAllEvent(HisTransRevocationListBo hisTransRevocationListBo) {
        try {
            String entityNumber;
            if (Objects.isNull(hisTransRevocationListBo)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4e8b\u52a1\u64a4\u9500\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (String)"HisModelEvent_10", (String)"hrmp-hbp-business", (Object[])new Object[0]));
            }
            this.validateParams(hisTransRevocationListBo);
            DynamicObject eventGroupConfigDy = EventGroupService.getInstance().getEventTableByNumber(hisTransRevocationListBo);
            if (eventGroupConfigDy == null) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u901a\u8fc7\u4f20\u53c2\u627e\u4e0d\u5230\u4e8b\u52a1\u7ec4\u6570\u636e\u3002", (String)"HisModelEvent_21", (String)"hrmp-hbp-business", (Object[])new Object[0]), new Object[0]));
            }
            Long eventId = EventGroupService.getInstance().getEventId(hisTransRevocationListBo);
            DynamicObject eventTableConfigDy = eventGroupConfigDy.getDynamicObject("evententity");
            HashMap<String, List<Long>> entityNumberToBoidListMaps = new HashMap<String, List<Long>>(16);
            String eventTableNumber = eventTableConfigDy.getString("number");
            HRBaseServiceHelper eventHelper = new HRBaseServiceHelper(eventTableNumber);
            DynamicObject eventDy = HisCommonEntityRepository.getEventById(eventHelper, eventId);
            if (eventDy == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u6b64\u4e8b\u52a1ID\u3002", (String)"HisModelEvent_24", (String)"hrmp-hbp-business", (Object[])new Object[0]));
            }
            if (EventOperateEnums.EVENT_STATUS_ALREADY_REVOCATION.getValue().equals(eventDy.get("status"))) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u4e8b\u52a1\u5df2\u88ab\u64a4\u9500", (String)"HisModelEvent_26", (String)"hrmp-hbp-business", (Object[])new Object[0]));
            }
            Long newEventId = ORM.create().genLongId(eventTableNumber);
            DynamicObject busiEventTableConfigDy = eventGroupConfigDy.getDynamicObject("busevententity");
            String busiEventTableNumber = busiEventTableConfigDy.getString("number");
            HRBaseServiceHelper busiEventHelper = new HRBaseServiceHelper(busiEventTableNumber);
            Date operationDate = new Date();
            Set<String> entityNumberSet = HisEventEntityRepository.getBusiEventSourceEntites(busiEventHelper, eventId);
            if (CollectionUtils.isEmpty(entityNumberSet)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u8be5\u4e8b\u52a1\u66f4\u65b0\u7684\u5b9e\u4f53\u6570\u636e", (String)"HisModelEvent_25", (String)"hrmp-hbp-business", (Object[])new Object[0]));
            }
            HisModelEventDataService.getInstance().buildHisTransRevocationBoList(hisTransRevocationListBo, entityNumberSet);
            List<HisTransRevocationBo> listHisTransRevocationBo = hisTransRevocationListBo.getListHisTransRevocationBo();
            HashMap<String, DynamicObject[]> busiEventDysMap = new HashMap<String, DynamicObject[]>(16);
            for (HisTransRevocationBo hisTransRevocationBo : listHisTransRevocationBo) {
                entityNumber = hisTransRevocationBo.getEntityNumber();
                DynamicObject[] busiEventDys = this.validateRevocationEventGroup(eventDy, eventHelper, hisTransRevocationBo, eventId, entityNumber, entityNumberToBoidListMaps, busiEventHelper);
                busiEventDysMap.put(entityNumber, busiEventDys);
            }
            for (HisTransRevocationBo hisTransRevocationBo : listHisTransRevocationBo) {
                entityNumber = hisTransRevocationBo.getEntityNumber();
                this.handleRevocationEventGroup(eventGroupConfigDy, eventDy, entityNumber, operationDate, newEventId, (DynamicObject[])busiEventDysMap.get(entityNumber));
            }
            boolean isPartRevocation = EventGroupService.getInstance().isPartRevocation(busiEventHelper, eventId);
            HisModelEventDataService.getInstance().processEventData(eventHelper, eventDy, newEventId, operationDate, isPartRevocation, busiEventHelper);
            this.handleAttachments(hisTransRevocationListBo, entityNumberToBoidListMaps);
        }
        catch (Exception ex) {
            LOGGER.error("revocation-part-event-error:", (Throwable)ex);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4e8b\u52a1\u64a4\u9500\u5931\u8d25:%s", (String)"HisModelEvent_12", (String)"hrmp-hbp-business", (Object[])new Object[0]), ex.getMessage()));
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private void handleAttachments(HisTransRevocationListBo hisTransRevocationListBo, Map<String, List<Long>> entityNumberToBoidListMaps) {
        hisTransRevocationListBo.getListHisTransRevocationBo().forEach(hisTransRevocationBo -> {
            String entityNumber = hisTransRevocationBo.getEntityNumber();
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityNumber);
            List boidList = (List)entityNumberToBoidListMaps.get(entityNumber);
            if (CollectionUtils.isEmpty((Collection)boidList)) {
                return;
            }
            Object[] boidToDys = HisCommonEntityRepository.getBusiDysByBoid(serviceHelper, boidList);
            if (ArrayUtils.isEmpty((Object[])boidToDys)) {
                return;
            }
            Map idToDys = Arrays.stream(boidToDys).collect(Collectors.toMap(dy -> dy.getLong("id"), Function.identity()));
            List<DynamicObject> isNotCurVersionDys = Arrays.stream(boidToDys).filter(dy -> !dy.getBoolean("iscurrentversion")).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(isNotCurVersionDys)) {
                return;
            }
            isNotCurVersionDys.forEach(dy -> {
                DynamicObject curBusiDy = (DynamicObject)idToDys.get(dy.getLong("boid"));
                LOGGER.info("handleAttachments-curBusiDy : {}", (Object)curBusiDy);
                this.handleCurDyAttachments(curBusiDy, (DynamicObject)dy, serviceHelper);
            });
        });
    }

    private void validateParams(HisTransRevocationListBo hisTransRevocationListBo) {
        List<HisTransRevocationBo> listHisTransRevocationBo = hisTransRevocationListBo.getListHisTransRevocationBo();
        Long eventId = EventGroupService.getInstance().getEventId(hisTransRevocationListBo);
        if (Objects.isNull(eventId) || eventId == 0L) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e8b\u52a1ID\u4e3a\u7a7a", (String)"HisModelEvent_5", (String)"hrmp-hbp-business", (Object[])new Object[0]));
        }
        String eventGroupNumber = hisTransRevocationListBo.getEventGroupNumber();
        String resisterEventGroupAppId = hisTransRevocationListBo.getResisterEventGroupAppId();
        String resisterEventGroupEntityNumber = hisTransRevocationListBo.getResisterEventGroupEntityNumber();
        String entityNumber = null;
        if (!CollectionUtils.isEmpty(listHisTransRevocationBo)) {
            entityNumber = listHisTransRevocationBo.get(0).getEntityNumber();
        }
        if (StringUtils.isEmpty((String)eventGroupNumber) && StringUtils.isEmpty((String)resisterEventGroupAppId) && StringUtils.isEmpty((String)resisterEventGroupEntityNumber) && StringUtils.isEmpty((String)entityNumber)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e8b\u52a1\u7ec4\u7f16\u7801(eventGroupNumber)\u3001\u6ce8\u518c\u4e86\u4e8b\u52a1\u7ec4\u7684\u5e94\u7528ID(resisterEventGroupAppId)\u3001\u6ce8\u518c\u4e86\u4e8b\u52a1\u7ec4\u7684\u5b9e\u4f53\u7f16\u7801(resisterEventGroupEntityNumber)\u3001\u5217\u8868\u4e2d\u7684\u5b9e\u4f53\u7f16\u7801(entityNumber)\uff0c\u81f3\u5c11\u4e00\u4e2a\u503c\u4e0d\u4e3a\u7a7a", (String)"HisModelEvent_23", (String)"hrmp-hbp-business", (Object[])new Object[0]));
        }
        if (listHisTransRevocationBo == null) {
            return;
        }
        for (HisTransRevocationBo hisTransRevocationBo : listHisTransRevocationBo) {
            List<Long> boIdList = hisTransRevocationBo.getBoId();
            if (!CollectionUtils.isNotEmpty(boIdList)) continue;
            String entityNumber0 = hisTransRevocationBo.getEntityNumber();
            if (HRStringUtils.isEmpty((String)entityNumber0)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4f20\u503c\u4e86BOID, \u4f46\u5b9e\u4f53\u4e3a\u7a7a", (String)"HisModelEvent_22", (String)"hrmp-hbp-business", (Object[])new Object[0]));
            }
            boIdList.forEach(boId -> {
                if (Objects.isNull(boId) || boId == 0L) {
                    throw new KDBizException(ResManager.loadKDString((String)"boid\u96c6\u5408\u5b58\u5728\u7a7a\u503c", (String)"HisModelEvent_8", (String)"hrmp-hbp-business", (Object[])new Object[0]));
                }
            });
        }
    }

    private DynamicObject[] validateRevocationEventGroup(DynamicObject eventDy, HRBaseServiceHelper eventHelper, HisTransRevocationBo hisTransRevocationBo, Long eventId, String entityNumber, Map<String, List<Long>> entityNumberToBoidListMaps, HRBaseServiceHelper busiEventHelper) {
        List<Long> allBoIdList;
        List<Long> paramBoIdList = hisTransRevocationBo.getBoId();
        this.checkEventDy(eventDy, paramBoIdList);
        if (CollectionUtils.isNotEmpty(paramBoIdList)) {
            allBoIdList = paramBoIdList;
        } else {
            DynamicObject[] busiEventDys = HisCommonEntityRepository.getBusiEventDys(busiEventHelper, eventId, entityNumber, paramBoIdList);
            if (busiEventDys == null || busiEventDys.length == 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u8be5\u4e8b\u52a1\u7684\u4e1a\u52a1\u4e8b\u52a1\u6570\u636e\uff0c\u539f\u56e0\u53ef\u80fd\u662f\u5b9e\u4f53\u7f16\u7801\u4e0e\u4e8b\u52a1ID\u4e0d\u5339\u914d\u3002", (String)"HisModelEvent_20", (String)"hrmp-hbp-business", (Object[])new Object[0]));
            }
            allBoIdList = Arrays.stream(busiEventDys).filter(dy -> Objects.nonNull(dy) && dy.getLong("boid") != 0L).map(dy -> dy.getLong("boid")).collect(Collectors.toList());
        }
        entityNumberToBoidListMaps.put(entityNumber, allBoIdList);
        String eventType = eventDy.getString("eventtype");
        Date operateDate = eventDy.getDate("operatedate");
        this.checkLaterEvent(entityNumber, eventHelper, busiEventHelper, eventType, operateDate, allBoIdList);
        Object[] busiEventDys = HisCommonEntityRepository.getBusiEventDys(busiEventHelper, eventId, entityNumber, allBoIdList);
        if (ArrayUtils.isEmpty((Object[])busiEventDys)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u4e8b\u52a1\u4e0d\u5b58\u5728\u4e1a\u52a1\u4e8b\u52a1\u5173\u7cfb\u5bf9\u8c61", (String)"HisModelEvent_14", (String)"hrmp-hbp-business", (Object[])new Object[0]));
        }
        return busiEventDys;
    }

    private void handleRevocationEventGroup(DynamicObject eventGroupConfigDy, DynamicObject eventDy, String entityNumber, Date operationDate, Long newEventId, DynamicObject[] busiEventDys) {
        List<Long> busiEventIds;
        DynamicObject hisEventEntityDy = eventGroupConfigDy.getDynamicObject("hisevententity");
        String hisVersionNuber = hisEventEntityDy.getString("number");
        HRBaseServiceHelper hisEventHelper = new HRBaseServiceHelper(hisVersionNuber);
        Object[] hisEventDys = HisCommonEntityRepository.getHisEventDys(hisEventHelper, busiEventIds = Arrays.stream(busiEventDys).map(dy -> dy.getLong("id")).collect(Collectors.toList()));
        if (ArrayUtils.isEmpty((Object[])hisEventDys)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u4e8b\u52a1\u4e0d\u5b58\u5728\u5386\u53f2\u7248\u672c\uff0c\u65e0\u6cd5\u64a4\u9500", (String)"HisModelEvent_15", (String)"hrmp-hbp-business", (Object[])new Object[0]));
        }
        List<Map<String, Object>> beforeRevocationBusiMaps = this.updateBusiDys((DynamicObject[])hisEventDys, entityNumber);
        this.insertEventGroupData(eventDy, busiEventDys, beforeRevocationBusiMaps, hisEventHelper, newEventId, operationDate);
    }

    private void insertEventGroupData(DynamicObject eventDy, DynamicObject[] busiEventDys, List<Map<String, Object>> beforeRevocationBusiMaps, HRBaseServiceHelper hisEventHelper, long newEventId, Date operationDate) {
        HRBaseServiceHelper busiEventHelper = new HRBaseServiceHelper(busiEventDys[0].getDynamicObjectType().getName());
        DynamicObjectCollection newBusiEventDyCol = new DynamicObjectCollection();
        Arrays.stream(busiEventDys).forEach(dy -> {
            dy.set("status", (Object)EventOperateEnums.EVENT_STATUS_ALREADY_REVOCATION.getValue());
            DynamicObjectCommonService.getInstance().setSimpleOperateInfoByTime((DynamicObject)dy, operationDate);
            DynamicObjectCommonService.getInstance().setSimpleModifyInfo((DynamicObject)dy);
            DynamicObject newBusiEventDy = busiEventHelper.generateEmptyDynamicObject();
            HRDynamicObjectUtils.copy((DynamicObject)dy, (DynamicObject)newBusiEventDy, (boolean)true);
            newBusiEventDy.set("status", (Object)EventOperateEnums.EVENT_STATUS_ALREADY_EXEC.getValue());
            newBusiEventDy.set("event", (Object)newEventId);
            newBusiEventDy.set("canceledeventid", (Object)eventDy.getLong("id"));
            DynamicObjectCommonService.getInstance().setSimpleOperateInfoByTime(newBusiEventDy, operationDate);
            DynamicObjectCommonService.getInstance().setSimpleNewInfoByTime(newBusiEventDy, operationDate);
            newBusiEventDyCol.add((Object)newBusiEventDy);
        });
        busiEventHelper.update(busiEventDys);
        busiEventHelper.save(newBusiEventDyCol);
        Map<Long, DynamicObject> newBusiEventMap = newBusiEventDyCol.stream().collect(Collectors.toMap(dy -> dy.getLong("boid"), Function.identity()));
        this.insertBeforeRevocationHisData(beforeRevocationBusiMaps, newBusiEventMap, hisEventHelper, operationDate);
    }

    private void insertBeforeRevocationHisData(List<Map<String, Object>> beforeRevocationBusiMaps, Map<Long, DynamicObject> newBusiEventMap, HRBaseServiceHelper hisEventHelper, Date operationDate) {
        DynamicObjectCollection newHisEventCol = new DynamicObjectCollection();
        beforeRevocationBusiMaps.forEach(beforeRevocationBusiMap -> {
            DynamicObject newHisEventDy = hisEventHelper.generateEmptyDynamicObject();
            long boid = (Long)beforeRevocationBusiMap.get("boid");
            DynamicObject newBusiEventDy = (DynamicObject)newBusiEventMap.get(boid);
            newHisEventDy.set("busievent", (Object)newBusiEventDy.getLong("id"));
            newHisEventDy.set("vid", beforeRevocationBusiMap.get("vid"));
            newHisEventDy.set("prestatus", beforeRevocationBusiMap.get("prestatus"));
            newHisEventDy.set("prebsed", beforeRevocationBusiMap.get("prebsed"));
            newHisEventDy.set("prebsled", beforeRevocationBusiMap.get("prebsled"));
            DynamicObjectCommonService.getInstance().setSimpleNewInfoByTime(newHisEventDy, operationDate);
            newHisEventCol.add((Object)newHisEventDy);
        });
        hisEventHelper.save(newHisEventCol);
    }

    private List<Map<String, Object>> updateBusiDys(DynamicObject[] hisEventDys, String entityNumber) {
        HRBaseServiceHelper busiHelper = new HRBaseServiceHelper(entityNumber);
        HashMap hisEventMaps = Maps.newHashMapWithExpectedSize((int)hisEventDys.length);
        for (DynamicObject dy2 : hisEventDys) {
            Long vid = dy2.getLong("vid");
            hisEventMaps.put(vid, dy2);
        }
        DynamicObject[] businessDys = busiHelper.loadDynamicObjectArray(hisEventMaps.keySet().toArray());
        DynamicObjectCollection newBusinessDys = new DynamicObjectCollection();
        List<Map<String, Object>> beforeRevocationBusiMaps = this.processBusinessDys(businessDys, hisEventMaps, newBusinessDys);
        busiHelper.save(newBusinessDys);
        Set boidSet = Arrays.stream(businessDys).map(dy -> dy.getLong("boid")).collect(Collectors.toSet());
        QFilter boidFilter = new QFilter("boid", "in", boidSet);
        QFilter versionFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        DynamicObject[] curBusinessDys = busiHelper.loadDynamicObjectArray(new QFilter[]{boidFilter, versionFilter});
        Set<Long> boIdSet = Stream.of(curBusinessDys).map(dy -> dy.getLong("boid")).collect(Collectors.toSet());
        DynamicObject[] dyAllVersions = HisCommonEntityRepository.loadOldEffVersionByBoIds(busiHelper, boIdSet);
        Map<Long, List<DynamicObject>> mapBoIdGroupAllVersion = Stream.of(dyAllVersions).collect(Collectors.groupingBy(dynamicObject -> dynamicObject.getLong("boid")));
        HisWriteBackCurrentBo hisWriteBackCurrentBo = new HisWriteBackCurrentBo(entityNumber, mapBoIdGroupAllVersion, Arrays.asList(curBusinessDys), null);
        String entityType = HisCommonService.getInstance().entityInhRelation(entityNumber);
        List<DynamicObject> curDynamicObjectList = null;
        if (EnumEntityTpl.LINETIMESEQ_TPL.getNumber().equals(entityType)) {
            HisWriteBackCurrentService.getInstance().WriteBackCurrentVersion(hisWriteBackCurrentBo);
            curDynamicObjectList = hisWriteBackCurrentBo.getCurrentDynamicObjectList();
            if (!CollectionUtils.isEmpty(curDynamicObjectList)) {
                if (dyAllVersions == null || dyAllVersions.length == 0) {
                    curDynamicObjectList.forEach(curBusiDy -> curBusiDy.set("datastatus", (Object)EnumHisDataVersionStatus.DISCARDED.getStatus()));
                } else {
                    curDynamicObjectList.forEach(curBusiDy -> {
                        Long boId = curBusiDy.getLong("boid");
                        List versionDyList = (List)mapBoIdGroupAllVersion.get(boId);
                        if (versionDyList == null || versionDyList.size() == 0) {
                            curBusiDy.set("datastatus", (Object)EnumHisDataVersionStatus.DISCARDED.getStatus());
                        }
                    });
                }
            }
        } else if (EnumEntityTpl.NONLINETIMESEQ_TPL.getNumber().equals(entityType)) {
            curDynamicObjectList = new ArrayList<DynamicObject>(10);
            this.setCurBusidys(curBusinessDys, businessDys, busiHelper, curDynamicObjectList);
        }
        this.handlePersonalDatas(curDynamicObjectList, entityNumber);
        if (curDynamicObjectList != null) {
            busiHelper.save(curDynamicObjectList.toArray(new DynamicObject[curDynamicObjectList.size()]));
        }
        return beforeRevocationBusiMaps;
    }

    private void setCurBusidys(DynamicObject[] curBusinessDys, DynamicObject[] businessDys, HRBaseServiceHelper busiHelper, List<DynamicObject> curDynamicObjectList) {
        Arrays.stream(curBusinessDys).forEach(curBusiDy -> {
            List noCurEffectDys = Arrays.stream(businessDys).filter(dy -> curBusiDy.getLong("boid") == dy.getLong("boid") && HRStringUtils.equals((String)dy.getString("datastatus"), (String)EnumHisDataVersionStatus.EFFECTING.getStatus()) && !dy.getBoolean("iscurrentversion")).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(noCurEffectDys)) {
                DynamicObject noCurEffectDy = (DynamicObject)noCurEffectDys.get(0);
                this.updateCurBusiDy(noCurEffectDy, (DynamicObject)curBusiDy);
                curDynamicObjectList.add((DynamicObject)curBusiDy);
                return;
            }
            if (businessDys.length != 1 || businessDys[0].get("datastatus") != EnumHisDataVersionStatus.DISCARDED.getStatus() || curBusiDy.getLong("sourcevid") == businessDys[0].getLong("id")) {
                curBusiDy.set("datastatus", (Object)EnumHisDataVersionStatus.DISCARDED.getStatus());
            }
            curBusiDy.set("ismodify", (Object)"0");
            QFilter deleteQfilter = new QFilter("datastatus", "=", (Object)EnumHisDataVersionStatus.TEMP.getStatus());
            QFilter boidsFilter = new QFilter("boid", "=", (Object)curBusiDy.getLong("boid"));
            busiHelper.deleteByFilter(deleteQfilter.and(boidsFilter).toArray());
            DynamicObjectCommonService.getInstance().setSimpleModifyInfo((DynamicObject)curBusiDy);
            curDynamicObjectList.add((DynamicObject)curBusiDy);
        });
    }

    @ExcludeFromJacocoGeneratedReport
    private void handleCurDyAttachments(DynamicObject curBusiDy, DynamicObject noCurEffectDy, HRBaseServiceHelper busiHelper) {
        HisAttachmentService.deleteCurDyAttachments(curBusiDy);
        List<Map<String, Object>> attachMapList = HisAttachmentService.generateAttachmentMap(new DynamicObject[]{noCurEffectDy});
        if (CollectionUtils.isEmpty(attachMapList)) {
            return;
        }
        Map<String, List<Map>> attachMap = attachMapList.stream().collect(Collectors.groupingBy(attach -> attach.get("fattachmentpanel") + "-" + attach.get("pk")));
        HashMap hisAttachBoMap = Maps.newHashMapWithExpectedSize((int)16);
        String formId = busiHelper.getEntityName();
        attachMap.forEach((attachKey, attach) -> HisAttachmentService.generateAttachmentBo(attachKey, formId, Long.parseLong((String)((Map)attach.get(0)).get("pk")), attach, hisAttachBoMap));
        Map<Long, List<HisAttachmentBo>> boMap = hisAttachBoMap.values().stream().collect(Collectors.groupingBy(HisAttachmentBo::getId));
        List<HisAttachmentBo> relAttachmentBos = HisAttachmentService.copyAttachments(curBusiDy.getLong("id"), formId, boMap.get(noCurEffectDy.getLong("id")));
        HashMap attachmentListMap = Maps.newHashMapWithExpectedSize((int)16);
        attachmentListMap.put(curBusiDy.getLong("id"), relAttachmentBos);
        attachmentListMap.forEach((id, hisAttachmentBos) -> hisAttachmentBos.forEach(bo -> {
            List attachments = bo.getAttachments();
            AttachmentServiceHelper.upload((String)bo.getEntityNumber(), (Object)id, (String)bo.getAttachKey(), (List)attachments);
        }));
    }

    private List<Map<String, Object>> processBusinessDys(DynamicObject[] businessDys, Map<Long, DynamicObject> hisEventMaps, DynamicObjectCollection newBusinessDys) {
        ArrayList beforeRevocationBusiMaps = Lists.newArrayListWithExpectedSize((int)16);
        HRBaseServiceHelper businessHelper = new HRBaseServiceHelper(businessDys[0].getDynamicObjectType().getName());
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)businessHelper.getEntityName());
        Map allFields = dataEntityType.getAllFields();
        Arrays.stream(businessDys).forEach(businessDy -> {
            DynamicObject hisEventDy = (DynamicObject)hisEventMaps.get(businessDy.getLong("id"));
            if (!HRObjectUtils.isEmpty((Object)hisEventDy)) {
                HashMap beforeRevocationBusiMap = Maps.newHashMapWithExpectedSize((int)16);
                beforeRevocationBusiMap.put("vid", businessDy.getLong("id"));
                beforeRevocationBusiMap.put("boid", businessDy.getLong("boid"));
                beforeRevocationBusiMap.put("prestatus", businessDy.getString("datastatus"));
                if (allFields.containsKey("bsed")) {
                    beforeRevocationBusiMap.put("prebsed", businessDy.getDate("bsed"));
                }
                if (allFields.containsKey("bsled")) {
                    beforeRevocationBusiMap.put("prebsled", businessDy.getDate("bsled"));
                }
                beforeRevocationBusiMaps.add(beforeRevocationBusiMap);
                if (HRStringUtils.isEmpty((String)hisEventDy.getString("prestatus")) || HRStringUtils.equals((String)hisEventDy.getString("prestatus"), (String)EventOperateEnums.CHANGE_BEFORE_STATUS_TEMP.getValue())) {
                    businessDy.set("datastatus", (Object)EnumHisDataVersionStatus.DISCARDED.getStatus());
                } else {
                    businessDy.set("datastatus", (Object)hisEventDy.getString("prestatus"));
                }
                Date preBsedDate = hisEventDy.getDate("prebsed");
                Date preBsledDate = hisEventDy.getDate("prebsled");
                if (Objects.nonNull(preBsedDate)) {
                    businessDy.set("bsed", (Object)preBsedDate);
                }
                if (Objects.nonNull(preBsledDate)) {
                    businessDy.set("bsled", (Object)preBsledDate);
                }
                DynamicObjectCommonService.getInstance().setSimpleModifyInfo((DynamicObject)businessDy);
                newBusinessDys.add(businessDy);
            }
        });
        return beforeRevocationBusiMaps;
    }

    private void updateCurBusiDy(DynamicObject fromDy, DynamicObject curBusiDy) {
        HashSet<String> excludeFields = new HashSet<String>();
        excludeFields.add("id");
        excludeFields.add("iscurrentversion");
        excludeFields.add("ismodify");
        excludeFields.add("hisversion");
        excludeFields.add("masterid");
        excludeFields.add("sourcevid");
        excludeFields.add("creator");
        excludeFields.add("creator_id");
        excludeFields.add("createtime");
        HRDynamicObjectUtils.copy((DynamicObject)fromDy, (DynamicObject)curBusiDy, excludeFields, (boolean)true);
        curBusiDy.set("sourcevid", (Object)fromDy.getLong("id"));
        DynamicObjectCommonService.getInstance().setSimpleModifyInfo(curBusiDy);
    }

    private void checkEventDy(DynamicObject eventDy, List<Long> boIdList) {
        if (HRObjectUtils.isEmpty((Object)eventDy)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u4e8b\u52a1\u8868\u5bf9\u8c61\u4e0d\u5b58\u5728", (String)"HisModelEvent_13", (String)"hrmp-hbp-business", (Object[])new Object[0]));
        }
        String eventType = eventDy.getString("eventtype");
        String executeWay = eventDy.getString("executeway");
        String batchType = eventDy.getString("eventbatchtype");
        String eventStatus = eventDy.getString("status");
        if (HRStringUtils.equals((String)eventType, (String)EventOperateEnums.EVENT_TYPE_REVOCATION.getValue())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u4e8b\u52a1\u7c7b\u522b\u4e3a\u64a4\u9500\uff0c\u4e0d\u5141\u8bb8\u88ab\u64a4\u9500", (String)"HisModelEvent_4", (String)"hrmp-hbp-business", (Object[])new Object[0]));
        }
        if (HRStringUtils.equals((String)executeWay, (String)EventOperateEnums.EVENT_EXECUTE_AUTO.getValue())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u4e8b\u52a1\u6267\u884c\u65b9\u5f0f\u4e3a\u81ea\u52a8\u6267\u884c\uff0c\u4e0d\u5141\u8bb8\u88ab\u64a4\u9500", (String)"HisModelEvent_6", (String)"hrmp-hbp-business", (Object[])new Object[0]));
        }
        if (!HRStringUtils.equals((String)eventStatus, (String)EventOperateEnums.EVENT_STATUS_ALREADY_EXEC.getValue()) && !HRStringUtils.equals((String)eventStatus, (String)EventOperateEnums.EVENT_STATUS_PART_REVOCATION.getValue())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u4e8b\u52a1\u72b6\u6001\u4e0d\u662f'\u5df2\u6267\u884c'\u6216'\u90e8\u5206\u64a4\u9500'\uff0c\u5219\u4e0d\u5141\u8bb8\u88ab\u64a4\u9500", (String)"HisModelEvent_11", (String)"hrmp-hbp-business", (Object[])new Object[0]));
        }
        if (HRStringUtils.equals((String)batchType, (String)EventOperateEnums.EVENT_PATCH_TYPE_ATOM.getValue()) && CollectionUtils.isNotEmpty(boIdList)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u4e8b\u52a1\u6279\u6b21\u7c7b\u522b\u4e3a\u539f\u5b50\u4e8b\u52a1\uff0c\u4e0d\u5141\u8bb8\u4f20boid\u96c6\u5408\u3002", (String)"HisModelEvent_17", (String)"hrmp-hbp-business", (Object[])new Object[0]));
        }
    }

    private void handleEventObject(HisTransBo hisTransBo, Map<String, DynamicObject> entityEventMap, Map<String, DynamicObject> appDefaultEventMap, Map<String, String> entityAppMap) {
        Date operationDate = new Date();
        try {
            long startTime = System.currentTimeMillis();
            List<HisTransBusinessBo> listHisTransBusinessBo = hisTransBo.getListHisTransBusinessBo();
            HashMap saveEntityEventMap = Maps.newHashMapWithExpectedSize((int)16);
            HashMap saveAppEventMap = Maps.newHashMapWithExpectedSize((int)16);
            HashMap allEntityDataMaps = Maps.newHashMapWithExpectedSize((int)16);
            listHisTransBusinessBo.forEach(hisTransBusinessBo -> {
                String entityNumber = hisTransBusinessBo.getEntityNumber();
                DynamicObject entityEventGroupDy = (DynamicObject)entityEventMap.get(entityNumber);
                if (entityEventMap.containsKey(entityNumber) && !HRObjectUtils.isEmpty((Object)entityEventGroupDy)) {
                    DynamicObject eventDy = entityEventGroupDy.getDynamicObject("evententity");
                    if (!saveEntityEventMap.containsKey(entityNumber)) {
                        DynamicObject saveEventDy = this.saveEventDy(eventDy, hisTransBo, allEntityDataMaps, operationDate);
                        saveEntityEventMap.put(entityNumber, saveEventDy);
                    }
                    this.saveEventGroup(entityEventGroupDy, (HisTransBusinessBo)hisTransBusinessBo, (DynamicObject)saveEntityEventMap.get(entityNumber), allEntityDataMaps, operationDate);
                } else {
                    String appid = (String)entityAppMap.get(entityNumber);
                    DynamicObject appEventGroup = (DynamicObject)appDefaultEventMap.get(appid);
                    if (HRObjectUtils.isEmpty((Object)appEventGroup)) {
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u6ce8\u518c\u5b9e\u4f53%1$s\u6216\u5e94\u7528%2$s\u7684\u4e8b\u52a1\u7ec4\u3002", (String)"HisModelEvent_1", (String)"hrmp-hbp-business", (Object[])new Object[0]), entityNumber, appid));
                    }
                    DynamicObject appEventDy = appEventGroup.getDynamicObject("evententity");
                    if (!saveAppEventMap.containsKey(appid)) {
                        DynamicObject saveEventDy = this.saveEventDy(appEventDy, hisTransBo, allEntityDataMaps, operationDate);
                        saveAppEventMap.put(appid, saveEventDy);
                    }
                    this.saveEventGroup(appEventGroup, (HisTransBusinessBo)hisTransBusinessBo, (DynamicObject)saveAppEventMap.get(appid), allEntityDataMaps, operationDate);
                }
            });
            allEntityDataMaps.forEach((entityNumber, dyCol) -> {
                HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper((String)entityNumber);
                hrBaseServiceHelper.save((DynamicObjectCollection)dyCol);
            });
            long l = System.currentTimeMillis();
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
            throw new KDBizException((Throwable)e, new ErrorCode("500", "handleEventObject error"), new Object[0]);
        }
    }

    private void saveEventGroup(DynamicObject eventGroupDy, HisTransBusinessBo hisTransBusinessBo, DynamicObject saveEventDy, Map<String, DynamicObjectCollection> allEntityDataMaps, Date operationDate) {
        DynamicObject busiEventDy = eventGroupDy.getDynamicObject("busevententity");
        DynamicObject saveBusiEventDy = this.saveBusiEventDy(busiEventDy, hisTransBusinessBo, saveEventDy, allEntityDataMaps, operationDate);
        DynamicObject hisEventDy = eventGroupDy.getDynamicObject("hisevententity");
        this.saveHisEventTableDy(hisEventDy, hisTransBusinessBo, saveBusiEventDy, allEntityDataMaps, operationDate);
    }

    private void saveHisEventTableDy(DynamicObject hisEventDy, HisTransBusinessBo hisTransBusinessBo, DynamicObject saveBusiEventDy, Map<String, DynamicObjectCollection> allEntityDataMaps, Date operationDate) {
        List<HisTransVersionBo> listHisTransVersionBo = hisTransBusinessBo.getListHisTransVersionBo();
        if (CollectionUtils.isEmpty(listHisTransVersionBo)) {
            return;
        }
        String entityObjectNumber = hisEventDy.getString("number");
        HRBaseServiceHelper hisEventHelper = new HRBaseServiceHelper(entityObjectNumber);
        DynamicObjectCollection saveHiseventtableDyCol = allEntityDataMaps.get(entityObjectNumber);
        if (CollectionUtils.isEmpty((Collection)saveHiseventtableDyCol)) {
            saveHiseventtableDyCol = new DynamicObjectCollection();
        }
        long[] ids = ORM.create().genLongIds(entityObjectNumber, listHisTransVersionBo.size());
        for (int i = 0; i < listHisTransVersionBo.size(); ++i) {
            HisTransVersionBo hisTransVersionBo = listHisTransVersionBo.get(i);
            DynamicObject saveHisEventDy = hisEventHelper.generateEmptyDynamicObject();
            saveHisEventDy.set("id", (Object)ids[i]);
            saveHisEventDy.set("vid", (Object)hisTransVersionBo.getVersionId());
            saveHisEventDy.set("busievent", (Object)saveBusiEventDy.getLong("id"));
            saveHisEventDy.set("prestatus", (Object)hisTransVersionBo.getBeforeStatus());
            saveHisEventDy.set("prebsed", (Object)hisTransVersionBo.getBeforeEffStartDate());
            saveHisEventDy.set("prebsled", (Object)hisTransVersionBo.getBeforeEffEndDate());
            DynamicObjectCommonService.getInstance().setSimpleNewInfoByTime(saveHisEventDy, operationDate);
            saveHiseventtableDyCol.add((Object)saveHisEventDy);
        }
        allEntityDataMaps.put(entityObjectNumber, saveHiseventtableDyCol);
    }

    private DynamicObject saveBusiEventDy(DynamicObject busiEventDy, HisTransBusinessBo hisTransBusinessBo, DynamicObject saveEventDy, Map<String, DynamicObjectCollection> allEntityDataMaps, Date operationDate) {
        String entityObjectNumber = busiEventDy.getString("number");
        HRBaseServiceHelper busiEventHelper = new HRBaseServiceHelper(entityObjectNumber);
        DynamicObject saveBusiEventDy = busiEventHelper.generateEmptyDynamicObject();
        saveBusiEventDy.set("id", (Object)ORM.create().genLongId(entityObjectNumber));
        saveBusiEventDy.set("sourceentity", (Object)hisTransBusinessBo.getEntityNumber());
        saveBusiEventDy.set("boid", (Object)hisTransBusinessBo.getBoId());
        saveBusiEventDy.set("isbusinesseventbo", (Object)(hisTransBusinessBo.isMainBo() ? "1" : "2"));
        saveBusiEventDy.set("event", (Object)saveEventDy.getLong("id"));
        saveBusiEventDy.set("status", (Object)hisTransBusinessBo.getTransStatus());
        DynamicObjectCommonService.getInstance().setSimpleNewInfoByTime(saveBusiEventDy, operationDate);
        DynamicObjectCommonService.getInstance().setSimpleOperateInfoByTime(saveBusiEventDy, operationDate);
        DynamicObjectCollection saveBusiEventDyCol = allEntityDataMaps.get(entityObjectNumber);
        if (CollectionUtils.isEmpty((Collection)saveBusiEventDyCol)) {
            saveBusiEventDyCol = new DynamicObjectCollection();
        }
        saveBusiEventDyCol.add((Object)saveBusiEventDy);
        allEntityDataMaps.put(entityObjectNumber, saveBusiEventDyCol);
        return saveBusiEventDy;
    }

    private DynamicObject saveEventDy(DynamicObject eventDy, HisTransBo hisTransBo, Map<String, DynamicObjectCollection> allEntityDataMaps, Date operationDate) {
        DynamicObject saveEventDy;
        Long eventId;
        String entityObjectNumber = eventDy.getString("number");
        HRBaseServiceHelper eventHelper = new HRBaseServiceHelper(entityObjectNumber);
        DynamicObjectCollection eventDyCol = allEntityDataMaps.get(entityObjectNumber);
        if (CollectionUtils.isEmpty((Collection)eventDyCol)) {
            eventDyCol = new DynamicObjectCollection();
        }
        if (Objects.isNull(eventId = hisTransBo.getEventId()) || eventId == 0L) {
            long[] eventIds = ORM.create().genLongIds(entityObjectNumber, 1);
            if (eventIds != null && eventIds.length == 1) {
                eventId = eventIds[0];
                hisTransBo.setEventId(eventId);
            }
        } else {
            if (CollectionUtils.isNotEmpty((Collection)eventDyCol)) {
                DynamicObject saveEventDy2 = (DynamicObject)eventDyCol.get(0);
                DynamicObjectCommonService.getInstance().setSimpleOperateInfoByTime(saveEventDy2, operationDate);
                DynamicObjectCommonService.getInstance().setSimpleModifyInfo(saveEventDy2);
                return saveEventDy2;
            }
            QFilter qFilter = new QFilter("id", "=", (Object)eventId);
            saveEventDy = eventHelper.loadDynamicObject(qFilter);
            if (!HRObjectUtils.isEmpty((Object)saveEventDy)) {
                DynamicObjectCommonService.getInstance().setSimpleOperateInfoByTime(saveEventDy, operationDate);
                DynamicObjectCommonService.getInstance().setSimpleModifyInfo(saveEventDy);
                eventDyCol.add((Object)saveEventDy);
                allEntityDataMaps.put(entityObjectNumber, eventDyCol);
                return saveEventDy;
            }
        }
        saveEventDy = eventHelper.generateEmptyDynamicObject();
        saveEventDy.set("id", (Object)eventId);
        saveEventDy.set("eventtype", (Object)hisTransBo.getTransType());
        saveEventDy.set("executeway", (Object)hisTransBo.getTransExecuteMode());
        saveEventDy.set("status", (Object)hisTransBo.getTransStatus());
        saveEventDy.set("eventbatchtype", (Object)hisTransBo.getTransBatchType());
        DynamicObjectCommonService.getInstance().setSimpleNewInfoByTime(saveEventDy, operationDate);
        DynamicObjectCommonService.getInstance().setSimpleOperateInfoByTime(saveEventDy, operationDate);
        eventDyCol.add((Object)saveEventDy);
        allEntityDataMaps.put(entityObjectNumber, eventDyCol);
        return saveEventDy;
    }

    private void validateParamBo(HisTransBo hisTransBo, Map<String, DynamicObject> entityEventMap, Map<String, DynamicObject> appDefaultEventMap, Map<String, String> entityAppMap) {
        Long eventId = hisTransBo.getEventId();
        List<HisTransBusinessBo> listHisTransBusinessBo = hisTransBo.getListHisTransBusinessBo();
        if (listHisTransBusinessBo == null || listHisTransBusinessBo.size() == 0) {
            return;
        }
        for (HisTransBusinessBo hisTransBusinessBo : listHisTransBusinessBo) {
            String entityNumber = hisTransBusinessBo.getEntityNumber();
            if (HRStringUtils.isEmpty((String)entityNumber)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5b9e\u4f53\u4e3a\u7a7a", (String)"HisModelEvent_0", (String)"hrmp-hbp-business", (Object[])new Object[0]));
            }
            String appId = MapUtils.getString(entityAppMap, (Object)entityNumber);
            DynamicObject eventDy = entityEventMap.get(entityNumber);
            if (HRObjectUtils.isEmpty((Object)eventDy)) {
                eventDy = appDefaultEventMap.get(appId);
            }
            if (!HRObjectUtils.isEmpty((Object)eventDy)) continue;
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u6ce8\u518c\u5b9e\u4f53%1$s\u6216\u5e94\u7528%2$s\u7684\u4e8b\u52a1\u7ec4\u3002", (String)"HisModelEvent_1", (String)"hrmp-hbp-business", (Object[])new Object[0]), entityNumber, appId));
        }
        this.checkRepeatBoId(eventId, listHisTransBusinessBo, entityEventMap, appDefaultEventMap, entityAppMap);
    }

    private void checkRepeatBoId(Long eventId, List<HisTransBusinessBo> listHisTransBusinessBo, Map<String, DynamicObject> entityEventMap, Map<String, DynamicObject> appDefaultEventMap, Map<String, String> entityAppMap) {
        DynamicObject busEventEntity;
        HRBaseServiceHelper shBusEventEntity;
        DynamicObject[] dynamicObjects;
        if (eventId != null && eventId != 0L) {
            return;
        }
        String entityNumber = listHisTransBusinessBo.get(0).getEntityNumber();
        DynamicObject eventDy = entityEventMap.get(entityNumber);
        if (HRObjectUtils.isEmpty((Object)eventDy)) {
            String appId = MapUtils.getString(entityAppMap, (Object)entityNumber);
            eventDy = appDefaultEventMap.get(appId);
        }
        if ((dynamicObjects = HisCommonEntityRepository.getBusEventByEventId(shBusEventEntity = new HRBaseServiceHelper((busEventEntity = eventDy.getDynamicObject("busevententity")).getString("number")), eventId)) == null || dynamicObjects.length == 0) {
            return;
        }
        HashMap entityBoIdMap = Maps.newHashMapWithExpectedSize((int)16);
        for (DynamicObject dynamicObject : dynamicObjects) {
            String sourceEntityNumber = dynamicObject.getString("sourceentity");
            Long boId = dynamicObject.getLong("boid");
            Set boIdSet = (Set)entityBoIdMap.get(sourceEntityNumber);
            if (boIdSet == null) {
                boIdSet = Sets.newHashSetWithExpectedSize((int)16);
                entityBoIdMap.put(sourceEntityNumber, boIdSet);
            }
            boIdSet.add(boId);
        }
        if (entityBoIdMap.size() == 0) {
            return;
        }
        for (HisTransBusinessBo hisTransBusinessBo : listHisTransBusinessBo) {
            Long boId;
            String transEntityNumber = hisTransBusinessBo.getEntityNumber();
            Set boIdSet = (Set)entityBoIdMap.get(transEntityNumber);
            if (CollectionUtils.isEmpty((Collection)boIdSet) || (boId = hisTransBusinessBo.getBoId()) == null || boId == 0L || !boIdSet.contains(boId)) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u4f20\u9012\u5df2\u5b58\u5728\u7684\u4e8b\u52a1ID\u518d\u6b21\u4fdd\u5b58\u7248\u672c\u65f6\uff0c\u4e0d\u5141\u8bb8\u518d\u6b21\u51fa\u73b0\u76f8\u540cBOID\u7684\u5b9e\u4f53\u6570\u636e", (String)"HisModelEvent_9", (String)"hrmp-hbp-business", (Object[])new Object[0]));
        }
    }

    private List<String> getEntityNumber(HisTransBo hisTransBo) {
        return hisTransBo.getListHisTransBusinessBo().stream().filter(hisTransBusinessBo -> HRStringUtils.isNotEmpty((String)hisTransBusinessBo.getEntityNumber())).map(HisTransBusinessBo::getEntityNumber).collect(Collectors.toList()).stream().distinct().collect(Collectors.toList());
    }

    @ExcludeFromJacocoGeneratedReport
    private void checkLaterEvent(String entityNumber, HRBaseServiceHelper hisEventHelper, HRBaseServiceHelper busiEventHelper, String eventType, Date operateDate, List<Long> allBoIdList) {
        Boolean isBaseDataCtrl = BaseDataServiceHelper.checkBaseDataCtrl((String)entityNumber);
        if (isBaseDataCtrl.booleanValue()) {
            HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper(entityNumber);
            List<Long> personalDataBoIds = HisEventEntityRepository.filterPersonalBoIds(hrBaseServiceHelper, allBoIdList);
            List originalBoIds = ListUtils.subtract(allBoIdList, personalDataBoIds);
            if (HRStringUtils.equals((String)eventType, (String)EventOperateEnums.EVENT_TYPE_ORIGIN_REVISE.getValue()) || HRStringUtils.equals((String)eventType, (String)EventOperateEnums.EVENT_TYPE_ORIGIN_CHANGE.getValue())) {
                if (CollectionUtils.isEmpty(personalDataBoIds)) {
                    return;
                }
                boolean existsLaterEvent = HisEventEntityRepository.existsLaterEvent(busiEventHelper, entityNumber, personalDataBoIds, operateDate);
                if (existsLaterEvent) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u6b64\u6b21\u53d8\u66f4\u5df2\u540c\u6b65\u4e2a\u6027\u5316\u6570\u636e\uff0c\u4e2a\u6027\u5316\u6570\u636e\u5728\u6b64\u6b21\u540c\u6b65\u4e4b\u540e\u8fdb\u884c\u4e86\u53d8\u66f4\uff0c\u4e0d\u5141\u8bb8\u64a4\u9500\u3002", (String)"HisModelEvent_18", (String)"hrmp-hbp-business", (Object[])new Object[0]));
                }
                if (CollectionUtils.isEmpty((Collection)originalBoIds)) {
                    return;
                }
                this.validateLaterEvent(busiEventHelper, entityNumber, originalBoIds, operateDate);
            } else {
                if (HRStringUtils.equals((String)eventType, (String)EventOperateEnums.EVENT_TYPE_ORIGIN_ONLY_SINK.getValue())) {
                    if (CollectionUtils.isEmpty((Collection)originalBoIds)) {
                        return;
                    }
                    this.validateLaterEvent(busiEventHelper, entityNumber, originalBoIds, operateDate);
                    return;
                }
                if (CollectionUtils.isEmpty((Collection)originalBoIds)) {
                    this.validatePersonalLLaterEvent(hisEventHelper, busiEventHelper, entityNumber, allBoIdList, operateDate);
                    return;
                }
            }
        }
        this.validateLaterEvent(busiEventHelper, entityNumber, allBoIdList, operateDate);
    }

    private void validateLaterEvent(HRBaseServiceHelper busiEventHelper, String entityNumber, List<Long> boIds, Date operateDate) {
        boolean existsLaterEvent = HisEventEntityRepository.existsLaterEvent(busiEventHelper, entityNumber, boIds, operateDate);
        if (existsLaterEvent) {
            throw new KDBizException(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u8be5\u4e8b\u52a1\u4e0d\u662f\u6700\u65b0\u4e8b\u52a1\u3002", (String)"HisModelEvent_16", (String)"hrmp-hbp-business", (Object[])new Object[0]), new Object[0]));
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private void validatePersonalLLaterEvent(HRBaseServiceHelper hisEventHelper, HRBaseServiceHelper busiEventHelper, String entityNumber, List<Long> boIds, Date operateDate) {
        boolean existsLaterEvent = HisEventEntityRepository.existsPersonalLaterEvent(hisEventHelper, busiEventHelper, entityNumber, boIds, operateDate);
        if (existsLaterEvent) {
            throw new KDBizException(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u8be5\u4e8b\u52a1\u4e0d\u662f\u6700\u65b0\u4e8b\u52a1\u3002", (String)"HisModelEvent_16", (String)"hrmp-hbp-business", (Object[])new Object[0]), new Object[0]));
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private void handlePersonalDatas(List<DynamicObject> curDynamicObjectList, String entityNumber) {
        Boolean isBaseDataCtrl = BaseDataServiceHelper.checkBaseDataCtrl((String)entityNumber);
        if (!isBaseDataCtrl.booleanValue()) {
            return;
        }
        HashSet boidSet = new HashSet(16);
        for (DynamicObject curDy : curDynamicObjectList) {
            String dataStatus = curDy.getString("datastatus");
            if (!HRStringUtils.equals((String)dataStatus, (String)EnumHisDataVersionStatus.DISCARDED.getStatus())) {
                return;
            }
            Long masterId = curDy.getLong("masterid");
            Object[] subCustomDatas = HisNonLineSyncUtil.getSubCustomData(entityNumber, masterId);
            if (ArrayUtils.isEmpty((Object[])subCustomDatas)) {
                return;
            }
            Arrays.stream(subCustomDatas).filter(dy -> !HRStringUtils.equals((String)EnumHisDataVersionStatus.DISCARDED.getStatus(), (String)dy.getString("datastatus"))).forEach(dy -> boidSet.add(dy.getLong("id")));
        }
        if (CollectionUtils.isEmpty(boidSet)) {
            return;
        }
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper(entityNumber);
        QFilter[] qFilters = new QFilter[]{new QFilter("boid", "in", boidSet), new QFilter("datastatus", "in", Arrays.asList(EnumHisDataVersionStatus.TO_BE_EFFECT.getStatus(), EnumHisDataVersionStatus.EFFECTING.getStatus(), EnumHisDataVersionStatus.INVALIDED.getStatus()))};
        DynamicObject[] dynamicObjects = hrBaseServiceHelper.loadDynamicObjectArray(qFilters);
        DynamicObject dyCurrent = null;
        for (DynamicObject dynamicObject : dynamicObjects) {
            dynamicObject.set("datastatus", (Object)EnumHisDataVersionStatus.DISCARDED.getStatus());
            if (!dynamicObject.getBoolean("iscurrentversion")) continue;
            dyCurrent = dynamicObject;
        }
        if (dyCurrent == null) {
            return;
        }
        DynamicObject dyOrg = (DynamicObject)dyCurrent.get("org");
        long orgId = dyOrg.getLong("id");
        Long parentUseId = HisPersonalDataService.getInstance().getParentUseDataId(dyCurrent);
        if (parentUseId == null) {
            return;
        }
        HisPersonalDataRepository.updateUseDataId(entityNumber, orgId, dyCurrent.getLong("id"), parentUseId);
        hrBaseServiceHelper.save(dynamicObjects);
    }
}

