/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.domain.service.impl.newhismodel;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.bd.service.BaseDataCommonService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.form.plugin.bdctrl.BdCtrlStrtgyUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.hr.hbp.business.application.impl.common.DynamicObjectCommonService;
import kd.hr.hbp.business.domain.model.newhismodel.HisBaseBo;
import kd.hr.hbp.business.domain.model.newhismodel.HisImportBo;
import kd.hr.hbp.business.domain.model.newhismodel.HisResponse;
import kd.hr.hbp.business.domain.model.newhismodel.ImportRespData;
import kd.hr.hbp.business.domain.repository.HisCommonEntityRepository;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisDeleteService;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisValidateService;
import kd.hr.hbp.business.domain.service.impl.newhismodel.hisversion.HisVersionNumberService;
import kd.hr.hbp.business.domain.service.newhismodel.IHisNonLineTimeService;
import kd.hr.hbp.business.domain.util.HisModelImportUtil;
import kd.hr.hbp.business.domain.util.HisModelNonEventUtil;
import kd.hr.hbp.business.domain.util.HisNonLineSyncUtil;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.hr.hbp.common.cache.IHRAppCache;
import kd.hr.hbp.common.constants.HRBaseConstants;
import kd.hr.hbp.common.constants.newhismodel.EnumHisDataVersionStatus;
import kd.hr.hbp.common.constants.newhismodel.EventOperateEnums;
import kd.hr.hbp.common.constants.newhismodel.HisFieldNameConstants;
import kd.hr.hbp.common.constants.newhismodel.HisSysConstants;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.ArrayUtils;

@ExcludeFromJacocoGeneratedReport
public class HisNonLineTimeService
implements IHisNonLineTimeService,
HRBaseConstants,
HisFieldNameConstants,
HisSysConstants {
    private static final Log LOGGER = LogFactory.getLog(HisNonLineTimeService.class);
    private static volatile HisNonLineTimeService hisNonLineTimeService = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HisNonLineTimeService getInstance() {
        if (hisNonLineTimeService != null) return hisNonLineTimeService;
        Class<HisNonLineTimeService> clazz = HisNonLineTimeService.class;
        synchronized (HisNonLineTimeService.class) {
            if (hisNonLineTimeService != null) return hisNonLineTimeService;
            hisNonLineTimeService = new HisNonLineTimeService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return hisNonLineTimeService;
        }
    }

    @Override
    public void handleAuditDatas(DynamicObject[] dynamicObjects) {
        try {
            String entityNumber = dynamicObjects[0].getDynamicObjectType().getName();
            HRBaseServiceHelper busiServiceHelper = new HRBaseServiceHelper(entityNumber);
            Map<Object, Object> effectRelMap = this.saveAuditBusiDys(busiServiceHelper, dynamicObjects);
            if (MapUtils.isNotEmpty(effectRelMap)) {
                if (effectRelMap.size() > 1) {
                    effectRelMap.put("eventbatchtype", "2");
                } else {
                    effectRelMap.put("eventbatchtype", "1");
                }
                HisModelNonEventUtil.saveNonDatasEvent(entityNumber, dynamicObjects, effectRelMap);
            }
        }
        catch (Exception ex) {
            LOGGER.error("handle-audit-data-error:", (Throwable)ex);
            throw new KDBizException(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5ba1\u6838\u5931\u8d25\uff1a%s\u3002", (String)"HisNonLineTimeService_02", (String)"hrmp-hbp-business", (Object[])new Object[0]), ex.getMessage()));
        }
    }

    @Override
    @ExcludeFromJacocoGeneratedReport
    public void handleSaveDatas(DynamicObject[] dynamicObjects, String importType) {
        try {
            String entityNumber = dynamicObjects[0].getDynamicObjectType().getName();
            MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)entityNumber);
            Map allFields = dataEntityType.getAllFields();
            HRBaseServiceHelper busiServiceHelper = new HRBaseServiceHelper(entityNumber);
            if (!allFields.containsKey("status")) {
                Map<Object, Object> effectRelMap = this.saveBusiDys(busiServiceHelper, dynamicObjects);
                effectRelMap.put("eventbatchtype", "1");
                HisModelNonEventUtil.saveNonDatasEvent(entityNumber, dynamicObjects, effectRelMap);
                return;
            }
            if (HRStringUtils.isEmpty((String)importType)) {
                Map<Object, Object> effectRelMap = this.saveAuditBusiDys(busiServiceHelper, dynamicObjects);
                if (MapUtils.isNotEmpty(effectRelMap)) {
                    HisModelNonEventUtil.saveNonDatasEvent(entityNumber, dynamicObjects, effectRelMap);
                }
                return;
            }
            if (HisModelImportUtil.isNew(importType)) {
                Map<Object, Object> effectRelMap = this.saveAuditBusiDys(busiServiceHelper, dynamicObjects);
                if (MapUtils.isNotEmpty(effectRelMap)) {
                    Long eventId = this.setEffectRelMap(effectRelMap, entityNumber);
                    HisModelNonEventUtil.saveNonDatasEvent(entityNumber, dynamicObjects, effectRelMap, eventId);
                }
            } else if (HisModelImportUtil.isOverride(importType) || HisModelImportUtil.isOverrideNew(importType)) {
                List<DynamicObject> tempDys;
                Map<Object, Object> effectRelMap;
                List<DynamicObject> newDys = Arrays.stream(dynamicObjects).filter(dy -> dy.getBoolean("iscurrentversion")).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(newDys) && MapUtils.isNotEmpty(effectRelMap = this.saveAuditBusiDys(busiServiceHelper, newDys.toArray(new DynamicObject[0])))) {
                    Long eventId = this.setEffectRelMap(effectRelMap, entityNumber);
                    HisModelNonEventUtil.saveNonDatasEvent(entityNumber, newDys.toArray(new DynamicObject[0]), effectRelMap, eventId);
                }
                if (CollectionUtils.isEmpty(tempDys = Arrays.stream(dynamicObjects).filter(dy -> !dy.getBoolean("iscurrentversion") && HRStringUtils.equals((String)EnumHisDataVersionStatus.TEMP.getStatus(), (String)dy.getString("datastatus"))).collect(Collectors.toList()))) {
                    return;
                }
                tempDys.forEach(tempDy -> tempDy.set("hisversion", (Object)"Z0001"));
                Set<Long> boidSet = tempDys.stream().map(dy -> dy.getLong("boid")).collect(Collectors.toSet());
                DynamicObject[] curEffectingDys = HisCommonEntityRepository.getNonLineRelCurEffectingDy(busiServiceHelper, boidSet);
                Arrays.stream(curEffectingDys).forEach(curEffectingDy -> {
                    curEffectingDy.set("ismodify", (Object)Boolean.TRUE);
                    DynamicObjectCommonService.getInstance().setSimpleModifyInfo((DynamicObject)curEffectingDy);
                });
                busiServiceHelper.update(curEffectingDys);
            }
        }
        catch (Exception ex) {
            LOGGER.error("handle-save-data-error:", (Throwable)ex);
            throw new KDBizException(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u4fdd\u5b58\u6570\u636e\u5931\u8d25\uff1a%s", (String)"HisNonLineTimeService_01", (String)"hrmp-hbp-business", (Object[])new Object[0]), ex.getMessage()));
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private Long setEffectRelMap(Map<Object, Object> effectRelMap, String entityNumber) {
        Long eventId;
        IHRAppCache ihrAppCache = HRAppCache.get((String)"hbp");
        String importLogIdCacheKey = String.format("HisImportLogId_%s_%s", entityNumber, HisModelImportUtil.getImportCacheKeySuffix());
        String fromCacheImportLogId = (String)ihrAppCache.get(importLogIdCacheKey, String.class);
        String nonImportLogIdKey = String.format("HismodelImportLogId_%s_%s", entityNumber, HisModelImportUtil.getImportCacheKeySuffix());
        String nonImportLogId = (String)ihrAppCache.get(nonImportLogIdKey, String.class);
        String nonEventIdKey = String.format("HismodelEventId_%s_%s", entityNumber, HisModelImportUtil.getImportCacheKeySuffix());
        if (!HRStringUtils.equals((String)nonImportLogId, (String)fromCacheImportLogId)) {
            ihrAppCache.put(nonImportLogIdKey, (Object)fromCacheImportLogId);
            ihrAppCache.remove(nonEventIdKey);
        }
        if (Objects.nonNull(eventId = (Long)ihrAppCache.get(nonEventIdKey, Long.class)) && eventId != 0L) {
            effectRelMap.put("eventbatchtype", "3");
        } else if (effectRelMap.size() > 1) {
            effectRelMap.put("eventbatchtype", "3");
        } else {
            effectRelMap.put("eventbatchtype", "1");
        }
        return eventId;
    }

    @Override
    @ExcludeFromJacocoGeneratedReport
    public void handleChangeSaveData(DynamicObject[] dataEntities) {
        try {
            HisValidateService.getInstance().saveValidate(dataEntities);
            DynamicObject changeSaveDy = dataEntities[0];
            String entityNumber = changeSaveDy.getDynamicObjectType().getName();
            Map allFields = MetadataServiceHelper.getDataEntityType((String)entityNumber).getAllFields();
            if (allFields.containsKey("status")) {
                changeSaveDy.set("status", (Object)"A");
            }
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityNumber);
            if (!HRStringUtils.equals((String)changeSaveDy.getString("datastatus"), (String)EnumHisDataVersionStatus.TEMP.getStatus())) {
                DynamicObject nonLineTimeTempDy = HisCommonEntityRepository.getNonLineTimeTempByBoid(serviceHelper, changeSaveDy.getLong("boid"));
                if (HRObjectUtils.isEmpty((Object)nonLineTimeTempDy)) {
                    this.addNewTempData(serviceHelper, changeSaveDy);
                } else {
                    this.updateTempData(serviceHelper, changeSaveDy, nonLineTimeTempDy);
                }
                return;
            }
            DynamicObject allFieldsTempDy = HisCommonEntityRepository.getAllFieldsDy(serviceHelper, changeSaveDy.getLong("id"));
            HashSet excludeFields = Sets.newHashSetWithExpectedSize((int)16);
            excludeFields.add("id");
            HRDynamicObjectUtils.copy((DynamicObject)changeSaveDy, (DynamicObject)allFieldsTempDy, (Set)excludeFields, (boolean)true);
            allFieldsTempDy.set("hisversion", (Object)"Z0001");
            DynamicObjectCommonService.getInstance().setSimpleModifyInfo(allFieldsTempDy);
            serviceHelper.updateOne(allFieldsTempDy);
        }
        catch (Exception ex) {
            LOGGER.error("handle-change-save-data-error:", (Throwable)ex);
            throw new KDBizException(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u53d8\u66f4\u4fdd\u5b58\u5931\u8d25\uff1a%s", (String)"HisNonLineTimeService_04", (String)"hrmp-hbp-business", (Object[])new Object[0]), ex.getMessage()));
        }
    }

    @Override
    @ExcludeFromJacocoGeneratedReport
    public void handleConfirmChangeData(DynamicObject[] dataEntities, String importType) {
        try {
            HisValidateService.getInstance().saveValidate(dataEntities);
            DynamicObject changeSaveDy = dataEntities[0];
            String entityNumber = changeSaveDy.getDynamicObjectType().getName();
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityNumber);
            if (HRStringUtils.isEmpty((String)importType)) {
                Map allFields = MetadataServiceHelper.getDataEntityType((String)entityNumber).getAllFields();
                if (allFields.containsKey("status")) {
                    changeSaveDy.set("status", (Object)"C");
                }
                if (!HRStringUtils.equals((String)changeSaveDy.getString("datastatus"), (String)EnumHisDataVersionStatus.TEMP.getStatus())) {
                    DynamicObject tempByBoidDy = HisCommonEntityRepository.getNonLineTimeTempByBoid(serviceHelper, changeSaveDy.getLong("boid"));
                    if (!HRObjectUtils.isEmpty((Object)tempByBoidDy)) {
                        Map<Object, Object> effectRelMap = this.updateTempToEffectData(serviceHelper, changeSaveDy, tempByBoidDy);
                        Map<String, Object> returnMap = HisModelNonEventUtil.saveNonDatasEvent(entityNumber, dataEntities, effectRelMap);
                        this.handlePersonalDataSync(changeSaveDy, returnMap);
                        return;
                    }
                    Map<Object, Object> effectRelMap = this.immediateConfirmChangeNoTempData(serviceHelper, changeSaveDy);
                    Arrays.stream(dataEntities).forEach(dataEntity -> dataEntity.set("id", (Object)dataEntity.getLong("boid")));
                    Map<String, Object> returnMap = HisModelNonEventUtil.saveNonDatasEvent(entityNumber, dataEntities, effectRelMap);
                    this.handlePersonalDataSync(changeSaveDy, returnMap);
                    return;
                }
                Map<Object, Object> effectRelMap = this.udpateExistTempToEffectData(serviceHelper, changeSaveDy);
                Map<String, Object> returnMap = HisModelNonEventUtil.saveNonDatasEvent(entityNumber, dataEntities, effectRelMap);
                this.handlePersonalDataSync(changeSaveDy, returnMap);
            } else if (HisModelImportUtil.isOverride(importType) || HisModelImportUtil.isOverrideNew(importType)) {
                this.handleImportConfirmChangeDys(dataEntities, serviceHelper);
            }
        }
        catch (Exception ex) {
            LOGGER.error("handle-confirm-change-data-error:", (Throwable)ex);
            throw new KDBizException(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u786e\u8ba4\u53d8\u66f4\u5931\u8d25\uff1a%s", (String)"HisNonLineTimeService_05", (String)"hrmp-hbp-business", (Object[])new Object[0]), ex.getMessage()));
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private void handleImportConfirmChangeDys(DynamicObject[] dataEntities, HRBaseServiceHelper serviceHelper) {
        if (dataEntities == null || dataEntities.length == 0) {
            return;
        }
        String entityNumber = serviceHelper.getEntityName();
        List boidList = Arrays.stream(dataEntities).map(dy -> dy.getLong("boid")).collect(Collectors.toList());
        DynamicObject[] curDys = HisCommonEntityRepository.loadDynamicObjectArray(entityNumber, new QFilter("id", "in", boidList));
        List<Long> sourceIdList = Arrays.stream(curDys).map(dy -> dy.getLong("sourcevid")).collect(Collectors.toList());
        DynamicObject[] relEffectingDys = HisCommonEntityRepository.getNonLineRelEffectingDy(serviceHelper, sourceIdList);
        final HashMap effectRelMap = Maps.newHashMapWithExpectedSize((int)16);
        final ArrayList effectRelHisEventLists = Lists.newArrayListWithExpectedSize((int)16);
        Arrays.stream(relEffectingDys).forEach(new Consumer<DynamicObject>(){

            @Override
            @ExcludeFromJacocoGeneratedReport
            public void accept(DynamicObject dy) {
                Map<String, Object> relHisMap = HisModelNonEventUtil.getRelToEventMap(dy);
                effectRelHisEventLists.add(relHisMap);
                dy.set("datastatus", (Object)EnumHisDataVersionStatus.DELETED.getStatus());
                DynamicObjectCommonService.getInstance().setSimpleModifyInfo(dy);
            }
        });
        final Map curDyToMaps = Arrays.stream(curDys).collect(Collectors.toMap(dy -> dy.getLong("id"), Function.identity()));
        final HashSet ignoreKeys = Sets.newHashSetWithExpectedSize((int)16);
        ignoreKeys.add("id");
        ignoreKeys.add("creator");
        ignoreKeys.add("createtime");
        ignoreKeys.add("iscurrentversion");
        ignoreKeys.add("masterid");
        Arrays.stream(dataEntities).forEach(new Consumer<DynamicObject>(){

            @Override
            @ExcludeFromJacocoGeneratedReport
            public void accept(DynamicObject newRelDy) {
                newRelDy.set("datastatus", null);
                Map<String, Object> newRelMap = HisModelNonEventUtil.getRelToEventMap(newRelDy);
                effectRelHisEventLists.add(newRelMap);
                newRelDy.set("datastatus", (Object)EnumHisDataVersionStatus.EFFECTING.getStatus());
                DynamicObject curDy = (DynamicObject)curDyToMaps.get(newRelDy.getLong("boid"));
                HRDynamicObjectUtils.copy((DynamicObject)newRelDy, (DynamicObject)curDy, (Set)ignoreKeys, (boolean)true);
                curDy.set("sourcevid", (Object)newRelDy.getLong("id"));
                DynamicObjectCommonService.getInstance().setSimpleModifyInfo(curDy);
                DynamicObjectCommonService.getInstance().setSimpleNewInfo(newRelDy);
                effectRelMap.put(newRelDy.getLong("id"), effectRelHisEventLists);
            }
        });
        HisVersionNumberService.getInstance().calcVersionNumber(serviceHelper.getEntityName(), dataEntities);
        serviceHelper.update(relEffectingDys);
        serviceHelper.save(dataEntities);
        serviceHelper.update(curDys);
        if (MapUtils.isNotEmpty((Map)effectRelMap)) {
            Long eventId = this.setEffectRelMap(effectRelMap, entityNumber);
            HisModelNonEventUtil.saveNonDatasEvent(entityNumber, dataEntities, effectRelMap, eventId);
        }
    }

    @Override
    @ExcludeFromJacocoGeneratedReport
    public void handleDeleteHisData(DynamicObject[] dataEntities) {
        try {
            Object[] ids = Arrays.stream(dataEntities).filter(dy -> dy.getLong("id") != 0L).map(dy -> dy.getLong("id")).toArray();
            String entityNumber = dataEntities[0].getDynamicObjectType().getName();
            HRBaseServiceHelper busiServiceHelper = new HRBaseServiceHelper(entityNumber);
            busiServiceHelper.delete(ids);
            List<Long> boidList = Arrays.stream(dataEntities).filter(dy -> dy.getLong("boid") != 0L).map(dy -> dy.getLong("boid")).collect(Collectors.toList());
            DynamicObject[] effectingDys = HisCommonEntityRepository.getNonLineRelEffectingDy(busiServiceHelper, boidList);
            Arrays.stream(effectingDys).forEach(dy -> dy.set("ismodify", (Object)"0"));
            busiServiceHelper.update(effectingDys);
        }
        catch (Exception ex) {
            LOGGER.error("handle-delete-his-data-error:", (Throwable)ex);
            throw new KDBizException(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5220\u9664\u5386\u53f2\u6570\u636e\u5931\u8d25\uff1a%s", (String)"HisNonLineTimeService_06", (String)"hrmp-hbp-business", (Object[])new Object[0]), ex.getMessage()));
        }
    }

    @Override
    @ExcludeFromJacocoGeneratedReport
    public void handleDeleteCurData(DynamicObject[] dataEntities) {
        try {
            String entityNumber = dataEntities[0].getDynamicObjectType().getName();
            HRBaseServiceHelper busiServiceHelper = new HRBaseServiceHelper(entityNumber);
            List<Long> boidList = Arrays.stream(dataEntities).filter(dy -> dy.getLong("boid") != 0L).map(dy -> dy.getLong("boid")).collect(Collectors.toList());
            HisBaseBo hisBaseBo = new HisBaseBo();
            hisBaseBo.setEntityNumber(entityNumber);
            hisBaseBo.setBoIdList(boidList);
            HisDeleteService.getInstance().deleteBoEventData(hisBaseBo);
            DynamicObject[] allBoDys = HisCommonEntityRepository.getNonLineTimeByBoid(busiServiceHelper, boidList);
            List noCurDys = Arrays.stream(allBoDys).filter(dy -> !dy.getBoolean("iscurrentversion")).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(noCurDys)) {
                List ids = noCurDys.stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
                busiServiceHelper.delete(ids.toArray());
            }
        }
        catch (Exception ex) {
            LOGGER.error("handle-business-his-data-error:", (Throwable)ex);
            throw new KDBizException(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5220\u9664\u4e1a\u52a1\u6570\u636e\u5931\u8d25\uff1a%s", (String)"HisNonLineTimeService_07", (String)"hrmp-hbp-business", (Object[])new Object[0]), ex.getMessage()));
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private void updateTempData(HRBaseServiceHelper serviceHelper, DynamicObject changeSaveDy, DynamicObject nonLineTimeTempDy) {
        DynamicObject allFieldsTempDy = HisCommonEntityRepository.getAllFieldsDy(serviceHelper, nonLineTimeTempDy.getLong("id"));
        Set<String> excludeFields = this.getUpdateEffectExcludeFields();
        excludeFields.add("ismodify");
        excludeFields.add("datastatus");
        excludeFields.add("masterid");
        excludeFields.add("creator");
        excludeFields.add("creator_id");
        excludeFields.add("modifier");
        excludeFields.add("modifier_id");
        HRDynamicObjectUtils.copy((DynamicObject)changeSaveDy, (DynamicObject)allFieldsTempDy, excludeFields, (boolean)true);
        allFieldsTempDy.set("hisversion", (Object)"Z0001");
        DynamicObjectCommonService.getInstance().setSimpleModifyInfo(allFieldsTempDy);
        serviceHelper.saveOne(allFieldsTempDy);
    }

    @ExcludeFromJacocoGeneratedReport
    private Map<Object, Object> updateTempToEffectData(HRBaseServiceHelper serviceHelper, DynamicObject changeSaveDy, DynamicObject tempDy) {
        HashMap effectRelMap = Maps.newHashMapWithExpectedSize((int)16);
        ArrayList effectRelHisEventLists = Lists.newArrayListWithExpectedSize((int)16);
        Long curEffId = changeSaveDy.getLong("boid");
        DynamicObject newEffectingDy = HisCommonEntityRepository.getAllFieldsDy(serviceHelper, curEffId);
        DynamicObject nonLineRelHisDy = this.deleteRelDy(serviceHelper, newEffectingDy, effectRelHisEventLists);
        serviceHelper.updateOne(nonLineRelHisDy);
        DynamicObject newTempDy = HisCommonEntityRepository.getAllFieldsDy(serviceHelper, tempDy.getLong("id"));
        HashSet excludeFields = Sets.newHashSetWithExpectedSize((int)16);
        excludeFields.add("id");
        excludeFields.add("creator");
        excludeFields.add("createtime");
        excludeFields.add("masterid");
        excludeFields.add("enable");
        excludeFields.add("iscurrentversion");
        excludeFields.add("datastatus");
        excludeFields.add("sourcevid");
        HRDynamicObjectUtils.copy((DynamicObject)changeSaveDy, (DynamicObject)newTempDy, (Set)excludeFields, (boolean)true);
        DynamicObject[] dys = new DynamicObject[]{newTempDy};
        HisVersionNumberService.getInstance().calcVersionNumber(serviceHelper.getEntityName(), dys);
        this.toEffectTempDy(newTempDy, serviceHelper, effectRelHisEventLists);
        this.updateCurVersionDy(newTempDy, newEffectingDy);
        newEffectingDy.set("sourcevid", (Object)newTempDy.getLong("id"));
        newEffectingDy.set("hisversion", (Object)"");
        DynamicObjectCommonService.getInstance().setSimpleModifyInfo(newEffectingDy);
        serviceHelper.updateOne(newEffectingDy);
        effectRelMap.put(newTempDy.getLong("id"), effectRelHisEventLists);
        return effectRelMap;
    }

    @Override
    @ExcludeFromJacocoGeneratedReport
    public void handleDisableOrEnableData(DynamicObject[] dataEntities) {
        try {
            String entityNumber = dataEntities[0].getDynamicObjectType().getName();
            HRBaseServiceHelper busiServiceHelper = new HRBaseServiceHelper(entityNumber);
            DynamicObjectCollection relDysCol = new DynamicObjectCollection();
            DynamicObjectCollection newBusiDysCol = new DynamicObjectCollection();
            HashMap effectRelMap = Maps.newHashMapWithExpectedSize((int)16);
            Arrays.stream(dataEntities).forEach(dataEntity -> {
                if (HRStringUtils.equals((String)dataEntity.getString("status"), (String)"C")) {
                    ArrayList relMapLists = Lists.newArrayListWithExpectedSize((int)16);
                    if (dataEntity.getBoolean("iscurrentversion") && dataEntity.getLong("sourcevid") == 0L) {
                        dataEntity.set("datastatus", (Object)EnumHisDataVersionStatus.EFFECTING.getStatus());
                        DynamicObject newEffectDy = this.copyEffectDy(busiServiceHelper, (DynamicObject)dataEntity, relMapLists);
                        newEffectDy.set("iscurrentversion", (Object)"0");
                        DynamicObjectCommonService.getInstance().setMastId((DynamicObject)dataEntity);
                        dataEntity.set("sourcevid", (Object)newEffectDy.getLong("id"));
                        newBusiDysCol.add((Object)newEffectDy);
                        effectRelMap.put(dataEntity.getLong("id"), relMapLists);
                        return;
                    }
                    DynamicObject relHisDy = this.deleteRelDy(busiServiceHelper, (DynamicObject)dataEntity, relMapLists);
                    relDysCol.add((Object)relHisDy);
                    DynamicObject newEffectDy = this.copyEffectDy(busiServiceHelper, (DynamicObject)dataEntity, relMapLists);
                    newBusiDysCol.add((Object)newEffectDy);
                    dataEntity.set("sourcevid", (Object)newEffectDy.getLong("id"));
                    DynamicObjectCommonService.getInstance().setSimpleModifyInfo((DynamicObject)dataEntity);
                    effectRelMap.put(dataEntity.getLong("id"), relMapLists);
                }
            });
            if (relDysCol.size() > 0) {
                busiServiceHelper.save(relDysCol);
            }
            if (newBusiDysCol.size() > 0) {
                HisVersionNumberService.getInstance().calcVersionNumber(entityNumber, (DynamicObject[])newBusiDysCol.toArray((Object[])new DynamicObject[0]));
                busiServiceHelper.save(newBusiDysCol);
                busiServiceHelper.update(dataEntities);
            }
            if (MapUtils.isNotEmpty((Map)effectRelMap)) {
                if (effectRelMap.size() > 1) {
                    effectRelMap.put("eventbatchtype", "2");
                } else {
                    effectRelMap.put("eventbatchtype", "1");
                }
                List<DynamicObject> filterDys = Arrays.stream(dataEntities).filter(dy -> HRStringUtils.equals((String)dy.getString("status"), (String)"C")).collect(Collectors.toList());
                HisModelNonEventUtil.saveNonDatasEvent(entityNumber, filterDys.toArray(new DynamicObject[0]), effectRelMap);
            }
        }
        catch (Exception ex) {
            LOGGER.error("handle-save-data-error:", (Throwable)ex);
            throw new KDBizException(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u7981\u7528\u6216\u542f\u7528\u6570\u636e\u5931\u8d25\uff1a%s", (String)"HisNonLineTimeService_03", (String)"hrmp-hbp-business", (Object[])new Object[0]), ex.getMessage()));
        }
    }

    @Override
    @ExcludeFromJacocoGeneratedReport
    public HisResponse<ImportRespData> hisNonLineImportData(HisImportBo hisImportBo) {
        try {
            Map<Object, Object> effectRelMap;
            String importType = hisImportBo.getImportType();
            DynamicObject[] dataEntities = hisImportBo.getDataEntities();
            this.validateImportData(importType, dataEntities);
            String entityNumber = dataEntities[0].getDynamicObjectType().getName();
            Map allFields = MetadataServiceHelper.getDataEntityType((String)entityNumber).getAllFields();
            HRBaseServiceHelper busiServiceHelper = new HRBaseServiceHelper(entityNumber);
            if (HisModelImportUtil.isNew(importType)) {
                effectRelMap = allFields.containsKey("status") ? this.saveAuditBusiDys(busiServiceHelper, dataEntities) : this.saveBusiDys(busiServiceHelper, dataEntities);
                if (MapUtils.isNotEmpty(effectRelMap)) {
                    Long eventId = this.setEffectRelMap(effectRelMap, entityNumber);
                    HisModelNonEventUtil.saveNonDatasEvent(entityNumber, dataEntities, effectRelMap, eventId);
                }
                busiServiceHelper.save(dataEntities);
            } else {
                List<Long> sourceIdList = Arrays.stream(dataEntities).filter(dy -> dy.getLong("sourcevid") != 0L).map(dy -> dy.getLong("sourcevid")).collect(Collectors.toList());
                effectRelMap = allFields.containsKey("status") ? this.saveAuditBusiDys(busiServiceHelper, dataEntities) : this.saveBusiDys(busiServiceHelper, dataEntities);
                if (MapUtils.isNotEmpty(effectRelMap)) {
                    Long eventId = this.setEffectRelMap(effectRelMap, entityNumber);
                    this.updateImportData(busiServiceHelper, sourceIdList, entityNumber, effectRelMap, dataEntities, eventId);
                }
                busiServiceHelper.save(dataEntities);
            }
            HisResponse<ImportRespData> response = new HisResponse<ImportRespData>();
            ImportRespData returnData = new ImportRespData();
            returnData.setEntityNumber(entityNumber);
            returnData.setImportType(importType);
            Set<Object> idsSet = effectRelMap.keySet();
            ArrayList ids = Lists.newArrayListWithExpectedSize((int)16);
            ids.addAll(idsSet);
            ids.remove("eventbatchtype");
            returnData.setPkIds(ids);
            response.setData(returnData);
            return response;
        }
        catch (Exception ex) {
            LOGGER.error("handle-import-data-error:", (Throwable)ex);
            HisResponse<ImportRespData> response = new HisResponse<ImportRespData>();
            response.setCode("500");
            response.setErrorMessage(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5bfc\u5165\u6570\u636e\u5931\u8d25\uff1a%s", (String)"HisNonLineTimeService_09", (String)"hrmp-hbp-business", (Object[])new Object[0]), ex.getMessage()));
            return response;
        }
    }

    @Override
    public void handleSubmitData(DynamicObject[] dataEntities) {
        Arrays.stream(dataEntities).forEach(dy -> dy.set("boid", dy.get("id")));
    }

    @Override
    @ExcludeFromJacocoGeneratedReport
    public void handlePersonalSaveData(DynamicObject[] dataEntities) {
        try {
            DynamicObject curDy = dataEntities[0];
            String entityNumber = curDy.getDataEntityType().getName();
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityNumber);
            DynamicObject newCurDy = HisCommonEntityRepository.getAllFieldsDy(serviceHelper, curDy.getLong("id"));
            newCurDy.set("boid", (Object)newCurDy.getLong("id"));
            newCurDy.set("ismodify", (Object)"0");
            ArrayList relHisMaps = Lists.newArrayListWithExpectedSize((int)16);
            DynamicObject newEffectDy = this.copyEffectDy(serviceHelper, newCurDy, relHisMaps);
            HisVersionNumberService.getInstance().calcVersionNumber(entityNumber, new DynamicObject[]{newEffectDy});
            serviceHelper.saveOne(newEffectDy);
            newCurDy.set("sourcevid", (Object)newEffectDy.getLong("id"));
            DynamicObjectCommonService.getInstance().setSimpleModifyInfo(newCurDy);
            serviceHelper.updateOne(newCurDy);
            HashMap effectRelMap = Maps.newHashMapWithExpectedSize((int)16);
            effectRelMap.put("eventbatchtype", "1");
            effectRelMap.put(newCurDy.getLong("id"), relHisMaps);
            HisModelNonEventUtil.saveNonDatasEvent(entityNumber, new DynamicObject[]{newCurDy}, effectRelMap);
        }
        catch (Exception ex) {
            LOGGER.error("handle-personal-save-data-error:", (Throwable)ex);
            throw new KDBizException(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u4fdd\u5b58\u6570\u636e\u5931\u8d25\uff1a%s", (String)"HisNonLineTimeService_01", (String)"hrmp-hbp-business", (Object[])new Object[0]), ex.getMessage()));
        }
    }

    @Override
    @ExcludeFromJacocoGeneratedReport
    public void handlePersonalDisableData(DynamicObject[] dataEntities) {
        String entityNumber = dataEntities[0].getDataEntityType().getName();
        String masteridPropName = BaseDataServiceHelper.getMasterIdPropName((String)entityNumber);
        HashSet idSet = Sets.newHashSetWithExpectedSize((int)16);
        Arrays.stream(dataEntities).forEach(dy -> idSet.add(dy.getPkValue()));
        QFilter idFilter = new QFilter("id", "not in", (Object)idSet);
        QFilter masterIdFilter = new QFilter(masteridPropName, "in", (Object)idSet);
        QFilter versionFilter = new QFilter("iscurrentversion", "=", (Object)Character.valueOf('1'));
        Object[] personalCurDys = HisCommonEntityRepository.loadDynamicObjectArray(entityNumber, idFilter.and(masterIdFilter.and(versionFilter)));
        if (!ArrayUtils.isEmpty((Object[])personalCurDys)) {
            Set<Long> sourceIds = Arrays.stream(personalCurDys).map(dy -> dy.getLong("sourcevid")).collect(Collectors.toSet());
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityNumber);
            DynamicObject[] nonLineRelCurEffectingDys = HisCommonEntityRepository.getNonLineRelCurEffectingDy(serviceHelper, sourceIds);
            Map boidToEffectDyMap = Arrays.stream(nonLineRelCurEffectingDys).collect(Collectors.toMap(dy -> dy.getLong("boid"), Function.identity()));
            List<DynamicObject> newPersonalCurDys = Arrays.stream(personalCurDys).filter(dy -> HRStringUtils.equals((String)((DynamicObject)boidToEffectDyMap.get(dy.getLong("id"))).getString("enable"), (String)"1")).collect(Collectors.toList());
            if (newPersonalCurDys.size() > 0) {
                this.handleDisableOrEnableData(newPersonalCurDys.toArray(new DynamicObject[0]));
                serviceHelper.update((DynamicObject[])personalCurDys);
            }
        }
    }

    @Override
    public void handlePersonalChangeData(DynamicObject[] subCustomDatas, Map<String, Object> originalEventMap) {
        try {
            String entityNumber = subCustomDatas[0].getDataEntityType().getName();
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityNumber);
            Map allFields = MetadataServiceHelper.getDataEntityType((String)entityNumber).getAllFields();
            List<Long> idList = Arrays.stream(subCustomDatas).map(dy -> dy.getLong("sourcevid")).collect(Collectors.toList());
            DynamicObject[] nonLineRelEffectingDys = HisCommonEntityRepository.getNonLineRelEffectingDy(serviceHelper, idList);
            Map boidToRelDyMaps = Arrays.stream(nonLineRelEffectingDys).collect(Collectors.toMap(dy -> dy.getLong("boid"), Function.identity()));
            HashMap effectRelMap = Maps.newHashMapWithExpectedSize((int)16);
            ArrayList relHisMaps = Lists.newArrayListWithExpectedSize((int)16);
            DynamicObjectCollection dynamicObjectCollection = new DynamicObjectCollection();
            Arrays.stream(subCustomDatas).forEach(subCustomData -> {
                DynamicObject newEffectDy = this.copyEffectDy(serviceHelper, (DynamicObject)subCustomData, relHisMaps);
                subCustomData.set("sourcevid", (Object)newEffectDy.getLong("id"));
                if (allFields.containsKey("versionsource")) {
                    newEffectDy.set("versionsource", (Object)"2");
                }
                DynamicObjectCommonService.getInstance().setSimpleModifyInfo((DynamicObject)subCustomData);
                DynamicObject originalRelDy = (DynamicObject)boidToRelDyMaps.get(subCustomData.getLong("id"));
                Map<String, Object> relHisMap = HisModelNonEventUtil.getRelToEventMap(originalRelDy);
                relHisMaps.add(relHisMap);
                originalRelDy.set("datastatus", (Object)EnumHisDataVersionStatus.DELETED.getStatus());
                DynamicObjectCommonService.getInstance().setSimpleModifyInfo(originalRelDy);
                dynamicObjectCollection.add((Object)newEffectDy);
                dynamicObjectCollection.add(subCustomData);
                effectRelMap.put(subCustomData.getLong("id"), relHisMaps);
            });
            List<DynamicObject> relEffectDys = dynamicObjectCollection.stream().filter(dy -> !dy.getBoolean("iscurrentversion") && HRStringUtils.equals((String)dy.getString("datastatus"), (String)EnumHisDataVersionStatus.EFFECTING.getStatus())).collect(Collectors.toList());
            HisVersionNumberService.getInstance().calcVersionNumber(entityNumber, relEffectDys.toArray(new DynamicObject[0]));
            serviceHelper.save(dynamicObjectCollection);
            serviceHelper.update(nonLineRelEffectingDys);
            effectRelMap.put("eventbatchtype", EventOperateEnums.EVENT_PATCH_TYPE_ATOM.getValue());
            effectRelMap.put("executeway", EventOperateEnums.EVENT_EXECUTE_AUTO.getValue());
            effectRelMap.put("eventtype", Objects.nonNull(originalEventMap.get("eventtype")) ? originalEventMap.get("eventtype") : EventOperateEnums.EVENT_TYPE_ORIGIN_CHANGE.getValue());
            HisModelNonEventUtil.saveNonDatasEvent(entityNumber, subCustomDatas, effectRelMap, Long.parseLong(originalEventMap.get("eventId").toString()));
        }
        catch (Exception ex) {
            LOGGER.error("handle-personal-change-data-error:", (Throwable)ex);
            throw new KDBizException(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u4fdd\u5b58\u6570\u636e\u5931\u8d25\uff1a%s", (String)"HisNonLineTimeService_01", (String)"hrmp-hbp-business", (Object[])new Object[0]), ex.getMessage()));
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private void validateImportData(String importType, DynamicObject[] dataEntities) {
        if (HRStringUtils.isEmpty((String)importType)) {
            throw new KDBizException(ResManager.loadKDString((String)"importType\u4e3a\u7a7a", (String)"HisNonLineTimeService_10", (String)"hrmp-hbp-business", (Object[])new Object[0]));
        }
        if (ArrayUtils.isEmpty((Object[])dataEntities)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u5165\u6570\u636e\u96c6\u4e3a\u7a7a", (String)"HisNonLineTimeService_11", (String)"hrmp-hbp-business", (Object[])new Object[0]));
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private void updateImportData(HRBaseServiceHelper busiServiceHelper, List<Long> sourceIdList, String entityNumber, Map<Object, Object> effectRelMap, DynamicObject[] dataEntities, Long eventId) {
        DynamicObject[] relEffectingDys = HisCommonEntityRepository.getNonLineRelEffectingDy(busiServiceHelper, sourceIdList);
        DynamicObjectCollection delDys = new DynamicObjectCollection();
        Arrays.stream(relEffectingDys).forEach(dy -> {
            ArrayList<Map<String, Object>> relHisMapLists = (ArrayList<Map<String, Object>>)effectRelMap.get(dy.getLong("boid"));
            if (CollectionUtils.isEmpty((Collection)relHisMapLists)) {
                relHisMapLists = new ArrayList<Map<String, Object>>(16);
            }
            Map<String, Object> relHisMap = HisModelNonEventUtil.getRelToEventMap(dy);
            relHisMapLists.add(relHisMap);
            dy.set("datastatus", (Object)EnumHisDataVersionStatus.DELETED.getStatus());
            DynamicObjectCommonService.getInstance().setSimpleModifyInfo((DynamicObject)dy);
            delDys.add(dy);
            effectRelMap.put(dy.getLong("boid"), relHisMapLists);
        });
        if (delDys.size() > 0) {
            busiServiceHelper.save(delDys);
        }
        HisModelNonEventUtil.saveNonDatasEvent(entityNumber, dataEntities, effectRelMap, eventId);
    }

    private DynamicObject copyEffectDy(HRBaseServiceHelper busiServiceHelper, DynamicObject dataEntity, List<Map<String, Object>> relMapLists) {
        DynamicObject newEffectDy = this.createNewEffectDy(busiServiceHelper, relMapLists, dataEntity);
        if (newEffectDy.getDynamicObjectType().getProperties().containsKey((Object)"masterid")) {
            newEffectDy.set("masterid", (Object)newEffectDy.getLong("id"));
        }
        newEffectDy.set("ismodify", (Object)"0");
        this.updateRelationDy(newEffectDy);
        return newEffectDy;
    }

    private DynamicObject generateEmptyDy(HRBaseServiceHelper serviceHelper) {
        DynamicObject newEffectDy = serviceHelper.generateEmptyDynamicObject();
        newEffectDy.set("id", (Object)ORM.create().genLongId(serviceHelper.getEntityName()));
        return newEffectDy;
    }

    private void addNewTempData(HRBaseServiceHelper serviceHelper, DynamicObject changeSaveDy) {
        DynamicObject tempDy = serviceHelper.generateEmptyDynamicObject();
        HashSet ignoreKeys = Sets.newHashSetWithExpectedSize((int)16);
        ignoreKeys.add("creator");
        ignoreKeys.add("creator_id");
        ignoreKeys.add("modifier");
        ignoreKeys.add("modifier_id");
        HRDynamicObjectUtils.copy((DynamicObject)changeSaveDy, (DynamicObject)tempDy, (Set)ignoreKeys, (boolean)true);
        tempDy.set("id", (Object)ORM.create().genLongId(serviceHelper.getEntityName()));
        tempDy.set("sourcevid", (Object)0L);
        tempDy.set("masterid", (Object)tempDy.getLong("id"));
        tempDy.set("iscurrentversion", (Object)"0");
        tempDy.set("ismodify", (Object)"1");
        tempDy.set("datastatus", (Object)EnumHisDataVersionStatus.TEMP.getStatus());
        tempDy.set("hisversion", (Object)"Z0001");
        this.updateEnableInfo(serviceHelper, tempDy, changeSaveDy);
        DynamicObjectCommonService.getInstance().setSimpleNewInfo(tempDy);
        serviceHelper.saveOne(tempDy);
        ArrayList<Long> idList = new ArrayList<Long>();
        idList.add(changeSaveDy.getLong("boid"));
        DynamicObject[] effectingDys = HisCommonEntityRepository.getNonLineRelEffectingDy(serviceHelper, idList);
        Arrays.stream(effectingDys).forEach(dy -> {
            dy.set("ismodify", (Object)"1");
            DynamicObjectCommonService.getInstance().setSimpleModifyInfo((DynamicObject)dy);
        });
        serviceHelper.update(effectingDys);
    }

    private Set<String> getUpdateEffectExcludeFields() {
        HashSet excludeFields = Sets.newHashSetWithExpectedSize((int)16);
        excludeFields.add("id");
        excludeFields.add("iscurrentversion");
        excludeFields.add("sourcevid");
        excludeFields.add("creator");
        excludeFields.add("createtime");
        return excludeFields;
    }

    private Map<Object, Object> udpateExistTempToEffectData(HRBaseServiceHelper serviceHelper, DynamicObject tempDy) {
        HashMap effectRelMap = Maps.newHashMapWithExpectedSize((int)16);
        ArrayList effectRelHisEventLists = Lists.newArrayListWithExpectedSize((int)16);
        Long tempId = tempDy.getLong("id");
        DynamicObject newTempDy = HisCommonEntityRepository.getAllFieldsDy(serviceHelper, tempId);
        Set<String> excludeFields = this.getUpdateEffectExcludeFields();
        excludeFields.add("id");
        excludeFields.add("creator");
        excludeFields.add("creator_id");
        excludeFields.add("createtime");
        HRDynamicObjectUtils.copy((DynamicObject)tempDy, (DynamicObject)newTempDy, excludeFields, (boolean)true);
        DynamicObject[] dys = new DynamicObject[]{newTempDy};
        HisVersionNumberService.getInstance().calcVersionNumber(serviceHelper.getEntityName(), dys);
        this.updateEnableInfo(serviceHelper, newTempDy, newTempDy);
        this.toEffectTempDy(newTempDy, serviceHelper, effectRelHisEventLists);
        DynamicObject nonLineRelEffectingDy = HisCommonEntityRepository.getAllFieldsDy(serviceHelper, tempDy.getLong("boid"));
        DynamicObject nonLineRelHisDy = this.deleteRelDy(serviceHelper, nonLineRelEffectingDy, effectRelHisEventLists);
        serviceHelper.updateOne(nonLineRelHisDy);
        this.updateCurVersionDy(tempDy, nonLineRelEffectingDy);
        nonLineRelEffectingDy.set("datastatus", (Object)EnumHisDataVersionStatus.EFFECTING.getStatus());
        nonLineRelEffectingDy.set("ismodify", (Object)"0");
        nonLineRelEffectingDy.set("sourcevid", (Object)tempId);
        this.updateEnableInfo(serviceHelper, nonLineRelEffectingDy, tempDy);
        nonLineRelEffectingDy.set("hisversion", (Object)"");
        DynamicObjectCommonService.getInstance().setSimpleModifyInfo(nonLineRelEffectingDy);
        serviceHelper.updateOne(nonLineRelEffectingDy);
        effectRelMap.put(tempId, effectRelHisEventLists);
        return effectRelMap;
    }

    private void updateCurVersionDy(DynamicObject tempDy, DynamicObject nonLineRelEffectingDy) {
        Set<String> excludeFields = this.getUpdateEffectExcludeFields();
        excludeFields.add("masterid");
        excludeFields.add("creator");
        excludeFields.add("creator_id");
        excludeFields.add("modifier");
        excludeFields.add("modifier_id");
        HRDynamicObjectUtils.copy((DynamicObject)tempDy, (DynamicObject)nonLineRelEffectingDy, excludeFields, (boolean)true);
    }

    private Map<Object, Object> immediateConfirmChangeNoTempData(HRBaseServiceHelper serviceHelper, DynamicObject changeSaveDy) {
        HashMap effectRelMap = Maps.newHashMapWithExpectedSize((int)16);
        ArrayList effectRelHisEventLists = Lists.newArrayListWithExpectedSize((int)16);
        DynamicObject tempDy = this.createNewEffectDy(serviceHelper, effectRelHisEventLists, changeSaveDy);
        tempDy.set("sourcevid", (Object)0L);
        tempDy.set("iscurrentversion", (Object)"0");
        this.updateEnableInfo(serviceHelper, tempDy, changeSaveDy);
        DynamicObjectCommonService.getInstance().setSimpleNewInfo(tempDy);
        this.setDyMasterid(serviceHelper, tempDy);
        DynamicObject[] dys = new DynamicObject[]{tempDy};
        HisVersionNumberService.getInstance().calcVersionNumber(serviceHelper.getEntityName(), dys);
        serviceHelper.saveOne(tempDy);
        Long boId = changeSaveDy.getLong("boid");
        DynamicObject newCurrentVersion = HisCommonEntityRepository.getNonLineDy(serviceHelper, boId);
        Long newSourceId = newCurrentVersion.getLong("sourcevid");
        DynamicObject relHisDy = HisCommonEntityRepository.getNonLineDy(serviceHelper, newSourceId);
        if (!HRObjectUtils.isEmpty((Object)relHisDy)) {
            Map<String, Object> relHisMap = HisModelNonEventUtil.getRelToEventMap(relHisDy);
            effectRelHisEventLists.add(relHisMap);
            relHisDy.set("datastatus", (Object)EnumHisDataVersionStatus.DELETED.getStatus());
            DynamicObjectCommonService.getInstance().setSimpleModifyInfo(relHisDy);
            serviceHelper.updateOne(relHisDy);
        }
        Long curEffId = changeSaveDy.getLong("boid");
        DynamicObject newChangeDy = HisCommonEntityRepository.getAllFieldsDy(serviceHelper, curEffId);
        HashSet excludeFields = Sets.newHashSetWithExpectedSize((int)16);
        excludeFields.add("id");
        HRDynamicObjectUtils.copy((DynamicObject)changeSaveDy, (DynamicObject)newChangeDy, (Set)excludeFields, (boolean)true);
        newChangeDy.set("sourcevid", (Object)tempDy.getLong("id"));
        this.updateEnableInfo(serviceHelper, newChangeDy, changeSaveDy);
        DynamicObjectCommonService.getInstance().setSimpleModifyInfo(newChangeDy);
        serviceHelper.updateOne(newChangeDy);
        effectRelMap.put(curEffId, effectRelHisEventLists);
        return effectRelMap;
    }

    private void updateEnableInfo(HRBaseServiceHelper serviceHelper, DynamicObject dy, DynamicObject fromDy) {
        String entityNumber = serviceHelper.getEntityName();
        Map allFields = MetadataServiceHelper.getDataEntityType((String)entityNumber).getAllFields();
        if (allFields.containsKey("enable")) {
            dy.set("enable", (Object)(HRStringUtils.equals((String)fromDy.getString("enable"), (String)"0") ? "1" : fromDy.getString("enable")));
        }
    }

    private void toEffectTempDy(DynamicObject tempDy, HRBaseServiceHelper serviceHelper, List<Map<String, Object>> effectRelHisEventLists) {
        Map<String, Object> relEffMap = HisModelNonEventUtil.getRelToEventMap(tempDy);
        effectRelHisEventLists.add(relEffMap);
        tempDy.set("datastatus", (Object)EnumHisDataVersionStatus.EFFECTING.getStatus());
        tempDy.set("ismodify", (Object)"0");
        DynamicObjectCommonService.getInstance().setSimpleModifyInfo(tempDy);
        serviceHelper.updateOne(tempDy);
    }

    private DynamicObject deleteRelDy(HRBaseServiceHelper serviceHelper, DynamicObject effectingDy, List<Map<String, Object>> effectRelHisEventLists) {
        DynamicObject nonLineRelHisDy = HisCommonEntityRepository.getNonLineDy(serviceHelper, effectingDy.getLong("sourcevid"));
        Map<String, Object> relHisMap = HisModelNonEventUtil.getRelToEventMap(nonLineRelHisDy);
        effectRelHisEventLists.add(relHisMap);
        nonLineRelHisDy.set("datastatus", (Object)EnumHisDataVersionStatus.DELETED.getStatus());
        DynamicObjectCommonService.getInstance().setSimpleModifyInfo(nonLineRelHisDy);
        return nonLineRelHisDy;
    }

    private Map<Object, Object> saveAuditBusiDys(HRBaseServiceHelper busiServiceHelper, DynamicObject[] dynamicObjects) {
        DynamicObjectCollection newBusiDysCol = new DynamicObjectCollection();
        HashMap relMap = Maps.newHashMapWithExpectedSize((int)16);
        Arrays.stream(dynamicObjects).forEach(dy -> {
            if (HRStringUtils.equals((String)dy.getString("status"), (String)"C") && !HRStringUtils.equals((String)"10", (String)dy.getString("enable"))) {
                ArrayList relHisMaps = Lists.newArrayListWithExpectedSize((int)16);
                dy.set("boid", (Object)dy.getLong("id"));
                dy.set("datastatus", (Object)EnumHisDataVersionStatus.EFFECTING.getStatus());
                DynamicObject newEffectDy = this.copyEffectDy(busiServiceHelper, (DynamicObject)dy, relHisMaps);
                dy.set("sourcevid", (Object)newEffectDy.getLong("id"));
                DynamicObjectCommonService.getInstance().setSimpleModifyInfo((DynamicObject)dy);
                newBusiDysCol.add((Object)newEffectDy);
                relMap.put(dy.getLong("id"), relHisMaps);
            }
            dy.set("boid", (Object)dy.getLong("id"));
        });
        if (newBusiDysCol.size() > 0) {
            String entityNum = dynamicObjects[0].getDataEntityType().getName();
            HisVersionNumberService.getInstance().calcVersionNumber(entityNum, (DynamicObject[])newBusiDysCol.toArray((Object[])new DynamicObject[0]));
            busiServiceHelper.save(newBusiDysCol);
        }
        return relMap;
    }

    private Map<Object, Object> saveBusiDys(HRBaseServiceHelper busiServiceHelper, DynamicObject[] dynamicObjects) {
        DynamicObjectCollection newBusiDysCol = new DynamicObjectCollection();
        DynamicObjectCollection relHisDysCol = new DynamicObjectCollection();
        HashMap relMap = Maps.newHashMapWithExpectedSize((int)16);
        Arrays.stream(dynamicObjects).forEach(dy -> {
            ArrayList relMapLists = Lists.newArrayListWithExpectedSize((int)16);
            dy.set("datastatus", (Object)EnumHisDataVersionStatus.EFFECTING.getStatus());
            dy.set("boid", (Object)dy.getLong("id"));
            DynamicObject relationDy = this.createNewEffectDy(busiServiceHelper, relMapLists, (DynamicObject)dy);
            this.updateRelationDy(relationDy);
            dy.set("sourcevid", (Object)relationDy.getLong("id"));
            DynamicObjectCommonService.getInstance().setSimpleModifyInfo((DynamicObject)dy);
            newBusiDysCol.add((Object)relationDy);
            relMap.put(dy.getLong("id"), relMapLists);
        });
        String entityNum = dynamicObjects[0].getDataEntityType().getName();
        HisVersionNumberService.getInstance().calcVersionNumber(entityNum, (DynamicObject[])newBusiDysCol.toArray((Object[])new DynamicObject[0]));
        busiServiceHelper.save(newBusiDysCol);
        busiServiceHelper.save(relHisDysCol);
        return relMap;
    }

    private DynamicObject createNewEffectDy(HRBaseServiceHelper busiServiceHelper, List<Map<String, Object>> relMapLists, DynamicObject dy) {
        DynamicObject relationEffectDy = this.generateEmptyDy(busiServiceHelper);
        Map<String, Object> relEffDyMap = HisModelNonEventUtil.getRelToEventMap(relationEffectDy);
        relMapLists.add(relEffDyMap);
        HashSet ignoreKeys = Sets.newHashSetWithExpectedSize((int)16);
        ignoreKeys.add("id");
        ignoreKeys.add("creator");
        ignoreKeys.add("creator_id");
        ignoreKeys.add("modifier");
        ignoreKeys.add("modifier_id");
        HRDynamicObjectUtils.copy((DynamicObject)dy, (DynamicObject)relationEffectDy, (Set)ignoreKeys, (boolean)true);
        return relationEffectDy;
    }

    private void setDyMasterid(HRBaseServiceHelper serviceHelper, DynamicObject dy) {
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)serviceHelper.getEntityName());
        Map allFields = dataEntityType.getAllFields();
        if (allFields.containsKey("status")) {
            dy.set("masterid", (Object)dy.getLong("id"));
        }
    }

    private void updateRelationDy(DynamicObject relationDy) {
        DynamicObjectCommonService.getInstance().setSimpleNewInfo(relationDy);
        relationDy.set("sourcevid", (Object)0L);
        relationDy.set("iscurrentversion", (Object)"0");
    }

    @ExcludeFromJacocoGeneratedReport
    private void handlePersonalDataSync(DynamicObject originalDy, Map<String, Object> returnMap) {
        boolean notAssignStrategy;
        String entityId = originalDy.getDataEntityType().getName();
        Boolean isBaseDataCtrl = BaseDataServiceHelper.checkBaseDataCtrl((String)entityId);
        if (!isBaseDataCtrl.booleanValue()) {
            return;
        }
        boolean isSyncData = BaseDataCommonService.isSyncData((String)entityId);
        if (!isSyncData) {
            return;
        }
        String masterIdPropName = BaseDataServiceHelper.getMasterIdPropName((String)entityId);
        String ctrlstrategy = originalDy.getString("ctrlstrategy");
        boolean bl = notAssignStrategy = !"1".equals(ctrlstrategy) && !"2".equals(ctrlstrategy);
        if (notAssignStrategy) {
            return;
        }
        DynamicObject curDy = HisCommonEntityRepository.getNonLineRelCurEffectingDy(new HRBaseServiceHelper(entityId), originalDy.getLong("boid"));
        if (!curDy.get("id").equals(curDy.get(masterIdPropName))) {
            return;
        }
        Long createOrgId = BaseDataCommonService.getLongPropertyFromDynamicObject((DynamicObject)originalDy, (String)"createorg");
        HashMap<String, Boolean> mapUpdate = new HashMap<String, Boolean>(16);
        HashMap mapShare = new HashMap(16);
        BdCtrlStrtgyUtils.getShareInfoFromBdCtrlStrtgy((String)entityId, (Long)createOrgId, mapShare, mapUpdate);
        if (MapUtils.isEmpty(mapUpdate)) {
            return;
        }
        DynamicObject[] subCustomDatas = HisNonLineSyncUtil.getSubCustomData(entityId, originalDy.getLong("masterid"));
        if (Objects.isNull(subCustomDatas) || subCustomDatas.length == 0) {
            return;
        }
        DynamicObjectCollection subCustomDataCollection = HisNonLineSyncUtil.syncSubCustomDatas(subCustomDatas, originalDy, mapUpdate);
        if (subCustomDataCollection.size() > 0) {
            this.handlePersonalChangeData((DynamicObject[])subCustomDataCollection.toArray((Object[])new DynamicObject[0]), returnMap);
        }
    }
}

